/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingConfigurationException;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingElement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscoveryProposal;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.PackagingTypeMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ProjectLifecycleMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMappingConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LifecycleMappingConfiguration.class);
    private final Map<MavenProjectInfo, ProjectLifecycleMappingConfiguration> allprojects = new HashMap<MavenProjectInfo, ProjectLifecycleMappingConfiguration>();
    private Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> allproposals;
    private final Set<IMavenDiscoveryProposal> selectedProposals = new LinkedHashSet<IMavenDiscoveryProposal>();
    private final Set<ILifecycleMappingRequirement> installedProviders = new HashSet<ILifecycleMappingRequirement>();
    private Set<MavenProjectInfo> selectedProjects;
    private Map<MavenProjectInfo, Throwable> errors = new HashMap<MavenProjectInfo, Throwable>();

    private LifecycleMappingConfiguration() {
    }

    public List<ProjectLifecycleMappingConfiguration> getProjects() {
        ArrayList<ProjectLifecycleMappingConfiguration> projects = new ArrayList<ProjectLifecycleMappingConfiguration>();
        for (Map.Entry<MavenProjectInfo, ProjectLifecycleMappingConfiguration> project : this.allprojects.entrySet()) {
            if (!this.selectedProjects.contains(project.getKey())) continue;
            projects.add(project.getValue());
        }
        return projects;
    }

    private void addProject(MavenProjectInfo info, ProjectLifecycleMappingConfiguration project) {
        this.allprojects.put(info, project);
    }

    public void setProposals(Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> proposals) {
        this.allproposals = proposals;
    }

    public List<IMavenDiscoveryProposal> getProposals(ILifecycleMappingRequirement requirement) {
        if (this.allproposals == null || requirement == null) {
            return Collections.emptyList();
        }
        List<IMavenDiscoveryProposal> result = this.allproposals.get(requirement);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> getAllProposals() {
        if (this.allproposals == null) {
            return Collections.emptyMap();
        }
        return this.allproposals;
    }

    public void addSelectedProposal(IMavenDiscoveryProposal proposal) {
        this.selectedProposals.add(proposal);
    }

    public void removeSelectedProposal(IMavenDiscoveryProposal proposal) {
        this.selectedProposals.remove(proposal);
    }

    public boolean isRequirementSatisfied(ILifecycleMappingRequirement requirement) {
        return this.isRequirementSatisfied(requirement, false);
    }

    public boolean isRequirementSatisfied(ILifecycleMappingRequirement requirement, boolean installedOnly) {
        if (requirement == null) {
            return true;
        }
        if (this.installedProviders.contains(requirement)) {
            return true;
        }
        if (installedOnly || this.allproposals == null) {
            return false;
        }
        List<IMavenDiscoveryProposal> proposals = this.allproposals.get(requirement);
        if (proposals != null) {
            for (IMavenDiscoveryProposal proposal : proposals) {
                if (!this.selectedProposals.contains(proposal)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMappingComplete() {
        return this.isMappingComplete(false);
    }

    public boolean isMappingComplete(boolean installedOnly) {
        for (ProjectLifecycleMappingConfiguration project : this.getProjects()) {
            ILifecycleMappingRequirement packagingRequirement = project.getPackagingTypeMappingConfiguration().getLifecycleMappingRequirement();
            if (!(packagingRequirement instanceof PackagingTypeMappingConfiguration.PackagingTypeMappingRequirement) && !this.isRequirementSatisfied(packagingRequirement, installedOnly)) {
                return false;
            }
            for (MojoExecutionMappingConfiguration mojoExecutionConfiguration : project.getMojoExecutionConfigurations()) {
                ILifecycleMappingRequirement executionRequirement = mojoExecutionConfiguration.getLifecycleMappingRequirement();
                if (this.isRequirementSatisfied(executionRequirement, installedOnly) || !LifecycleMappingFactory.isInterestingPhase(mojoExecutionConfiguration.getMojoExecutionKey().getLifecyclePhase())) continue;
                return false;
            }
        }
        return true;
    }

    public void autoCompleteMapping() {
        LinkedHashSet<ILifecycleMappingRequirement> requirements = new LinkedHashSet<ILifecycleMappingRequirement>();
        for (ProjectLifecycleMappingConfiguration project : this.getProjects()) {
            ILifecycleMappingRequirement packagingRequirement = project.getPackagingTypeMappingConfiguration().getLifecycleMappingRequirement();
            if (packagingRequirement != null) {
                requirements.add(packagingRequirement);
            }
            for (MojoExecutionMappingConfiguration mojoExecutionConfiguration : project.getMojoExecutionConfigurations()) {
                ILifecycleMappingRequirement executionRequirement = mojoExecutionConfiguration.getLifecycleMappingRequirement();
                if (executionRequirement == null) continue;
                requirements.add(executionRequirement);
            }
        }
        for (ILifecycleMappingRequirement requirement : requirements) {
            List<IMavenDiscoveryProposal> proposals;
            if (this.installedProviders.contains(requirement) || (proposals = this.getProposals(requirement)).size() != 1) continue;
            this.addSelectedProposal(proposals.get(0));
        }
    }

    public IMavenDiscoveryProposal getSelectedProposal(ILifecycleMappingRequirement mojoExecutionKey) {
        if (this.allproposals == null) {
            return null;
        }
        List<IMavenDiscoveryProposal> proposals = this.allproposals.get(mojoExecutionKey);
        if (proposals == null) {
            return null;
        }
        for (IMavenDiscoveryProposal proposal : proposals) {
            if (!this.getSelectedProposals().contains(proposal)) continue;
            return proposal;
        }
        return null;
    }

    public List<IMavenDiscoveryProposal> getSelectedProposals() {
        return new ArrayList<IMavenDiscoveryProposal>(this.selectedProposals);
    }

    public void clearSelectedProposals() {
        this.selectedProposals.clear();
    }

    /*
     * Unable to fully structure code
     */
    public static LifecycleMappingConfiguration calculate(final Collection<MavenProjectInfo> projects, ProjectImportConfiguration importConfiguration, IProgressMonitor monitor) {
        try {
            context = MavenPlugin.getMaven().createExecutionContext();
            request = context.getExecutionRequest();
            request.addActiveProfiles(importConfiguration.getResolverConfiguration().getActiveProfileList());
            request.addInactiveProfiles(importConfiguration.getResolverConfiguration().getInactiveProfileList());
            return context.execute(new ICallable<LifecycleMappingConfiguration>(){

                @Override
                public LifecycleMappingConfiguration call(IMavenExecutionContext context, IProgressMonitor monitor) {
                    return LifecycleMappingConfiguration.calculate(projects, monitor);
                }
            }, monitor);
        }
        catch (CoreException ex) {
            result = new LifecycleMappingConfiguration();
            ** for (project : projects)
        }
lbl-1000:
        // 1 sources

        {
            result.addError(project, ex);
            continue;
        }
lbl14:
        // 1 sources

        return result;
    }

    static LifecycleMappingConfiguration calculate(Collection<MavenProjectInfo> projects, IProgressMonitor monitor) {
        monitor.beginTask("Analysing project execution plan", projects.size());
        LifecycleMappingConfiguration result = new LifecycleMappingConfiguration();
        ArrayList<MavenProjectInfo> nonErrorProjects = new ArrayList<MavenProjectInfo>();
        final IMaven maven = MavenPlugin.getMaven();
        for (final MavenProjectInfo projectInfo : projects) {
            MavenProject mavenProject;
            block20: {
                List<MappingMetadataSource> metadataSources;
                ArrayList<MojoExecution> mojoExecutions;
                SubMonitor subMmonitor;
                block21: {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    mavenProject = null;
                    subMmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Analysing {0}", (Object)projectInfo.getLabel()), (int)1);
                    MavenExecutionResult executionResult = maven.execute(new ICallable<MavenExecutionResult>(){

                        @Override
                        public MavenExecutionResult call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                            return maven.readMavenProject(projectInfo.getPomFile(), context.newProjectBuildingRequest());
                        }
                    }, (IProgressMonitor)subMmonitor);
                    mavenProject = executionResult.getProject();
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (mavenProject == null) break block20;
                    if (!"pom".equals(projectInfo.getModel().getPackaging())) break block21;
                    mojoExecutions = new ArrayList<MojoExecution>();
                    PackagingTypeMappingConfiguration pkgConfiguration = new PackagingTypeMappingConfiguration(mavenProject.getPackaging(), null);
                    ProjectLifecycleMappingConfiguration configuration = new ProjectLifecycleMappingConfiguration(projectInfo.getLabel(), mavenProject, mojoExecutions, pkgConfiguration);
                    result.addProject(projectInfo, configuration);
                    nonErrorProjects.add(projectInfo);
                    if (mavenProject == null) continue;
                    ((MavenImpl)maven).releaseExtensionsRealm(mavenProject);
                    continue;
                }
                mojoExecutions = new ArrayList();
                MavenExecutionPlan executionPlan = maven.calculateExecutionPlan(mavenProject, Arrays.asList("clean"), false, (IProgressMonitor)subMmonitor);
                mojoExecutions.addAll(executionPlan.getMojoExecutions());
                executionPlan = maven.calculateExecutionPlan(mavenProject, Arrays.asList("deploy"), false, (IProgressMonitor)subMmonitor);
                mojoExecutions.addAll(executionPlan.getMojoExecutions());
                executionPlan = maven.calculateExecutionPlan(mavenProject, Arrays.asList("site"), false, (IProgressMonitor)subMmonitor);
                mojoExecutions.addAll(executionPlan.getMojoExecutions());
                LifecycleMappingResult lifecycleResult = new LifecycleMappingResult();
                try {
                    metadataSources = LifecycleMappingFactory.getProjectMetadataSources(mavenProject, LifecycleMappingFactory.getBundleMetadataSources(), mojoExecutions, true, monitor);
                }
                catch (LifecycleMappingConfigurationException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    if (mavenProject == null) continue;
                    ((MavenImpl)maven).releaseExtensionsRealm(mavenProject);
                    continue;
                }
                try {
                    try {
                        LifecycleMappingFactory.calculateEffectiveLifecycleMappingMetadata(lifecycleResult, metadataSources, mavenProject, mojoExecutions, false, monitor);
                        LifecycleMappingFactory.instantiateLifecycleMapping(lifecycleResult, mavenProject, lifecycleResult.getLifecycleMappingId());
                        LifecycleMappingFactory.instantiateProjectConfigurators(mavenProject, lifecycleResult, lifecycleResult.getMojoExecutionMapping());
                        PackagingTypeMappingConfiguration pkgConfiguration = new PackagingTypeMappingConfiguration(mavenProject.getPackaging(), LifecycleMappingConfiguration.isProjectSource(lifecycleResult.getLifecycleMappingMetadata()) ? lifecycleResult.getLifecycleMappingId() : null);
                        ProjectLifecycleMappingConfiguration configuration = new ProjectLifecycleMappingConfiguration(projectInfo.getLabel(), mavenProject, mojoExecutions, pkgConfiguration);
                        if (lifecycleResult.getLifecycleMapping() != null) {
                            result.addInstalledProvider(configuration.getPackagingTypeMappingConfiguration().getLifecycleMappingRequirement());
                        }
                        block14: for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : lifecycleResult.getMojoExecutionMapping().entrySet()) {
                            MojoExecutionKey key = entry.getKey();
                            List<IPluginExecutionMetadata> mapppings = entry.getValue();
                            IPluginExecutionMetadata primaryMapping = null;
                            if (mapppings != null && !mapppings.isEmpty()) {
                                primaryMapping = mapppings.get(0);
                            }
                            MojoExecutionMappingConfiguration executionConfiguration = new MojoExecutionMappingConfiguration(key, LifecycleMappingConfiguration.isProjectSource(primaryMapping) ? primaryMapping : null);
                            configuration.addMojoExecution(executionConfiguration);
                            if (primaryMapping == null) continue;
                            switch (primaryMapping.getAction()) {
                                case configurator: {
                                    AbstractProjectConfigurator projectConfigurator = lifecycleResult.getProjectConfigurators().get(LifecycleMappingFactory.getProjectConfiguratorId(primaryMapping));
                                    if (projectConfigurator == null) continue block14;
                                    result.addInstalledProvider(executionConfiguration.getLifecycleMappingRequirement());
                                    break;
                                }
                                case ignore: 
                                case execute: 
                                case error: {
                                    result.addInstalledProvider(executionConfiguration.getLifecycleMappingRequirement());
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Missing handling for action=" + (Object)((Object)primaryMapping.getAction()));
                                }
                            }
                        }
                        result.addProject(projectInfo, configuration);
                        nonErrorProjects.add(projectInfo);
                    }
                    catch (OperationCanceledException ex) {
                        throw ex;
                    }
                    catch (Throwable th) {
                        result.addError(projectInfo, th);
                        if (mavenProject == null) continue;
                        ((MavenImpl)maven).releaseExtensionsRealm(mavenProject);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (mavenProject != null) {
                        ((MavenImpl)maven).releaseExtensionsRealm(mavenProject);
                    }
                    throw throwable;
                }
            }
            if (mavenProject == null) continue;
            ((MavenImpl)maven).releaseExtensionsRealm(mavenProject);
        }
        result.setSelectedProjects(nonErrorProjects);
        return result;
    }

    private static boolean isProjectSource(IPluginExecutionMetadata primaryMapping) {
        if (primaryMapping == null) {
            return false;
        }
        return LifecycleMappingConfiguration.isProjectSource(((PluginExecutionMetadata)primaryMapping).getSource());
    }

    private static boolean isProjectSource(LifecycleMappingMetadata mappingMetadata) {
        if (mappingMetadata == null) {
            return false;
        }
        return LifecycleMappingConfiguration.isProjectSource(mappingMetadata.getSource());
    }

    private static boolean isProjectSource(LifecycleMappingMetadataSource metadataSource) {
        if (metadataSource == null) {
            return false;
        }
        Object source = metadataSource.getSource();
        if (source instanceof MavenProject) {
            return true;
        }
        return source instanceof Artifact;
    }

    private void addInstalledProvider(ILifecycleMappingRequirement requirement) {
        this.installedProviders.add(requirement);
    }

    public List<ProjectLifecycleMappingConfiguration> getProjects(ILifecycleMappingElement configurationElement) {
        ArrayList<ProjectLifecycleMappingConfiguration> result = new ArrayList<ProjectLifecycleMappingConfiguration>();
        for (ProjectLifecycleMappingConfiguration project : this.getProjects()) {
            if (!project.getMojoExecutionConfigurations().equals(configurationElement) && !project.getMojoExecutionConfigurations().contains(configurationElement)) continue;
            result.add(project);
        }
        return result;
    }

    public void setSelectedProjects(Collection<MavenProjectInfo> projects) {
        this.selectedProjects = new HashSet<MavenProjectInfo>(projects);
    }

    public void addError(MavenProjectInfo info, Throwable th) {
        this.errors.put(info, th);
    }

    public Map<MavenProjectInfo, Throwable> getErrors() {
        return this.errors;
    }
}

