/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.NamedColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceNamedColumnAnnotation
extends SourceAnnotation
implements NamedColumnAnnotation {
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private AnnotationElementAdapter<String> nameAdapter = this.buildNameAdapter();
    private String name;
    private TextRange nameTextRange;
    private TextRange nameValidationTextRange;
    private DeclarationAnnotationElementAdapter<String> columnDefinitionDeclarationAdapter = this.buildColumnDefinitionDeclarationAdapter();
    private AnnotationElementAdapter<String> columnDefinitionAdapter = this.buildColumnDefinitionAdapter();
    private String columnDefinition;
    private TextRange columnDefinitionTextRange;

    protected SourceNamedColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceNamedColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.columnDefinition = this.buildColumnDefinition(astAnnotation);
        this.columnDefinitionTextRange = this.buildColumnDefinitionTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.syncColumnDefinition(this.buildColumnDefinition(astAnnotation));
        this.columnDefinitionTextRange = this.buildColumnDefinitionTextRange(astAnnotation);
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.nameValidationTextRange;
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNameValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    @Override
    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    @Override
    public boolean nameValidationTouches(int pos) {
        return this.textRangeTouches(this.nameValidationTextRange, pos);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getNameElementName());
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    protected abstract String getNameElementName();

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (this.attributeValueHasChanged(this.columnDefinition, columnDefinition)) {
            this.columnDefinition = columnDefinition;
            this.columnDefinitionAdapter.setValue((Object)columnDefinition);
        }
    }

    private void syncColumnDefinition(String astColumnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = astColumnDefinition;
        this.firePropertyChanged("columnDefinition", old, astColumnDefinition);
    }

    private String buildColumnDefinition(Annotation astAnnotation) {
        return (String)this.columnDefinitionAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getColumnDefinitionTextRange() {
        return this.columnDefinitionTextRange;
    }

    private TextRange buildColumnDefinitionTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.columnDefinitionDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildColumnDefinitionDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getColumnDefinitionElementName());
    }

    private AnnotationElementAdapter<String> buildColumnDefinitionAdapter() {
        return this.buildStringElementAdapter(this.columnDefinitionDeclarationAdapter);
    }

    protected abstract String getColumnDefinitionElementName();

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.columnDefinition == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

