/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DbGeneratorAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceDbGeneratorAnnotation
extends SourceGeneratorAnnotation
implements DbGeneratorAnnotation {
    final DeclarationAnnotationElementAdapter<Integer> initialValueDeclarationAdapter = this.getInitialValueAdapter();
    final AnnotationElementAdapter<Integer> initialValueAdapter = this.buildIntegerAdapter(this.initialValueDeclarationAdapter);
    Integer initialValue;
    TextRange initialValueTextRange;
    final DeclarationAnnotationElementAdapter<Integer> allocationSizeDeclarationAdapter = this.getAllocationSizeAdapter();
    final AnnotationElementAdapter<Integer> allocationSizeAdapter = this.buildIntegerAdapter(this.allocationSizeDeclarationAdapter);
    Integer allocationSize;
    TextRange allocationSizeTextRange;

    SourceDbGeneratorAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
    }

    protected AnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.initialValue = this.buildInitialValue(astAnnotation);
        this.initialValueTextRange = this.buildInitialValueTextRange(astAnnotation);
        this.allocationSize = this.buildAllocationSize(astAnnotation);
        this.allocationSizeTextRange = this.buildAllocationSizeTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncInitialValue(this.buildInitialValue(astAnnotation));
        this.initialValueTextRange = this.buildInitialValueTextRange(astAnnotation);
        this.syncAllocationSize(this.buildAllocationSize(astAnnotation));
        this.allocationSizeTextRange = this.buildAllocationSizeTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.initialValue == null && this.allocationSize == null;
    }

    @Override
    public Integer getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(Integer initialValue) {
        if (this.attributeValueHasChanged(this.initialValue, initialValue)) {
            this.initialValue = initialValue;
            this.initialValueAdapter.setValue((Object)initialValue);
        }
    }

    private void syncInitialValue(Integer astIinitialValue) {
        Integer old = this.initialValue;
        this.initialValue = astIinitialValue;
        this.firePropertyChanged("initialValue", old, astIinitialValue);
    }

    private Integer buildInitialValue(Annotation astAnnotation) {
        return (Integer)this.initialValueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getInitialValueTextRange() {
        return this.initialValueTextRange;
    }

    private TextRange buildInitialValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.initialValueDeclarationAdapter, astAnnotation);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter();

    @Override
    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    @Override
    public void setAllocationSize(Integer allocationSize) {
        if (this.attributeValueHasChanged(this.allocationSize, allocationSize)) {
            this.allocationSize = allocationSize;
            this.allocationSizeAdapter.setValue((Object)allocationSize);
        }
    }

    private void syncAllocationSize(Integer astAllocationSize) {
        Integer old = this.allocationSize;
        this.allocationSize = astAllocationSize;
        this.firePropertyChanged("allocationSize", old, astAllocationSize);
    }

    private Integer buildAllocationSize(Annotation astAnnotation) {
        return (Integer)this.allocationSizeAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getAllocationSizeTextRange() {
        return this.allocationSizeTextRange;
    }

    private TextRange buildAllocationSizeTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.allocationSizeDeclarationAdapter, astAnnotation);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter();

    static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, NumberIntegerExpressionConverter.instance());
    }
}

