/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericTypeMappingValidator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTypeMapping<X extends XmlTypeMapping>
extends AbstractOrmXmlContextModel<OrmPersistentType>
implements OrmTypeMapping {
    protected final X xmlTypeMapping;
    protected Boolean specifiedMetadataComplete;
    protected boolean overrideMetadataComplete;
    protected String specifiedParentClass;
    protected String defaultParentClass;
    protected String fullyQualifiedParentClass;

    protected AbstractOrmTypeMapping(OrmPersistentType parent, X xmlTypeMapping) {
        super(parent);
        this.xmlTypeMapping = xmlTypeMapping;
        this.specifiedMetadataComplete = xmlTypeMapping.getMetadataComplete();
        this.specifiedParentClass = this.buildSpecifiedParentClass();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedMetadataComplete_(this.xmlTypeMapping.getMetadataComplete());
        this.setSpecifiedParentClass_(this.buildSpecifiedParentClass());
    }

    @Override
    public void update() {
        super.update();
        this.setOverrideMetadataComplete(this.buildOverrideMetadataComplete());
        this.setDefaultParentClass(this.buildDefaultParentClass());
        this.setFullyQualifiedParentClass(this.buildFullyQualifiedParentClass());
    }

    @Override
    public boolean isMetadataComplete() {
        if (this.overrideMetadataComplete) {
            return true;
        }
        return this.specifiedMetadataComplete != null ? this.specifiedMetadataComplete : false;
    }

    @Override
    public Boolean getSpecifiedMetadataComplete() {
        return this.specifiedMetadataComplete;
    }

    @Override
    public void setSpecifiedMetadataComplete(Boolean metadataComplete) {
        this.setSpecifiedMetadataComplete_(metadataComplete);
        this.xmlTypeMapping.setMetadataComplete(metadataComplete);
    }

    protected void setSpecifiedMetadataComplete_(Boolean metadataComplete) {
        Boolean old = this.specifiedMetadataComplete;
        this.specifiedMetadataComplete = metadataComplete;
        this.firePropertyChanged("specifiedMetadataComplete", old, metadataComplete);
    }

    @Override
    public boolean isOverrideMetadataComplete() {
        return this.overrideMetadataComplete;
    }

    protected void setOverrideMetadataComplete(boolean metadataComplete) {
        boolean old = this.overrideMetadataComplete;
        this.overrideMetadataComplete = metadataComplete;
        this.firePropertyChanged("overrideMetadataComplete", old, metadataComplete);
    }

    protected boolean buildOverrideMetadataComplete() {
        return this.getPersistenceUnit().isXmlMappingMetadataComplete();
    }

    @Override
    public String getFullyQualifiedParentClass() {
        return this.fullyQualifiedParentClass;
    }

    protected void setFullyQualifiedParentClass(String parentClass) {
        String old = this.fullyQualifiedParentClass;
        this.fullyQualifiedParentClass = parentClass;
        this.firePropertyChanged("fullyQualifiedParentClass", old, parentClass);
    }

    protected String buildFullyQualifiedParentClass() {
        return this.specifiedParentClass == null ? this.defaultParentClass : this.getEntityMappings().qualify(this.specifiedParentClass);
    }

    @Override
    public String getParentClass() {
        return this.specifiedParentClass != null ? this.specifiedParentClass : this.defaultParentClass;
    }

    @Override
    public String getSpecifiedParentClass() {
        return this.specifiedParentClass;
    }

    @Override
    public void setSpecifiedParentClass(String parentClass) {
        this.setSpecifiedParentClass_(parentClass);
        this.setSpecifiedParentClassInXml(parentClass);
    }

    protected void setSpecifiedParentClass_(String parentClass) {
        String old = this.specifiedParentClass;
        this.specifiedParentClass = parentClass;
        this.firePropertyChanged("specifiedParentClass", old, parentClass);
    }

    protected void setSpecifiedParentClassInXml(String parentClass) {
    }

    protected String buildSpecifiedParentClass() {
        return null;
    }

    @Override
    public String getDefaultParentClass() {
        return this.defaultParentClass;
    }

    protected void setDefaultParentClass(String parentClass) {
        String old = this.defaultParentClass;
        this.defaultParentClass = parentClass;
        this.firePropertyChanged("defaultParentClass", old, parentClass);
    }

    protected String buildDefaultParentClass() {
        JavaResourceType javaResourceType = this.getJavaResourceType();
        return javaResourceType == null ? null : javaResourceType.getSuperclassQualifiedName();
    }

    protected PersistentType getResolvedParentClass() {
        if (this.fullyQualifiedParentClass == null) {
            return null;
        }
        return this.getPersistenceUnit().getPersistentType(this.fullyQualifiedParentClass);
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        JavaPersistentType javaType = this.getJavaPersistentType();
        if (javaType == null) {
            return null;
        }
        return javaType.getMappingKey() == this.getKey() ? javaType.getMapping() : null;
    }

    @Override
    public JavaTypeMapping getJavaTypeMappingForDefaults() {
        return this.isMetadataComplete() ? null : this.getJavaTypeMapping();
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return (OrmPersistentType)this.parent;
    }

    @Override
    public String getName() {
        return this.getPersistentType().getName();
    }

    protected JavaPersistentType getJavaPersistentType() {
        return this.getPersistentType().getJavaPersistentType();
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        JavaPersistentType javaType = this.getJavaPersistentType();
        return javaType == null ? null : javaType.getJavaResourceType();
    }

    protected EntityMappings getEntityMappings() {
        return this.getPersistentType().getParent();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public void initializeFrom(OrmTypeMapping oldMapping) {
        this.setSpecifiedMetadataComplete(oldMapping.getSpecifiedMetadataComplete());
        this.setOverrideMetadataComplete(oldMapping.isOverrideMetadataComplete());
    }

    public X getXmlTypeMapping() {
        return this.xmlTypeMapping;
    }

    @Override
    public boolean attributeIsDerivedId(String attributeName) {
        return TypeMappingTools.attributeIsDerivedId(this, attributeName);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    public Iterable<AttributeMapping> getAttributeMappings() {
        return IterableTools.transform(this.getPersistentType().getAttributes(), OrmPersistentAttribute.MAPPING_TRANSFORMER);
    }

    @Override
    public Iterable<AttributeMapping> getAllAttributeMappings() {
        return IterableTools.children(this.getInheritanceHierarchy(), TypeMappingTools.ATTRIBUTE_MAPPINGS_TRANSFORMER);
    }

    @Override
    public Iterable<String> getOverridableAttributeNames() {
        return IterableTools.children(this.getAttributeMappings(), AttributeMapping.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAttributeNames() {
        return IterableTools.children(this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER);
    }

    public Iterable<AttributeMapping> getAttributeMappings(String mappingKey) {
        return IterableTools.filter(this.getAttributeMappings(), (Predicate)new AttributeMapping.KeyEquals(mappingKey));
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(String mappingKey) {
        return IterableTools.filter(this.getAllAttributeMappings(), (Predicate)new AttributeMapping.KeyEquals(mappingKey));
    }

    @Override
    public Iterable<AttributeMapping> getNonTransientAttributeMappings() {
        return new FilteringIterable(this.getAllAttributeMappings(), AttributeMapping.IS_NOT_TRANSIENT);
    }

    @Override
    public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            SpecifiedColumn column = attributeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    @Override
    public Iterable<String> getOverridableAssociationNames() {
        return IterableTools.children(this.getAttributeMappings(), AttributeMapping.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAssociationNames() {
        return IterableTools.children(this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER);
    }

    @Override
    public SpecifiedRelationship resolveOverriddenRelationship(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            SpecifiedRelationship relationship = attributeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveOverriddenRelationship(attributeName);
        }
        return null;
    }

    @Override
    public TypeMapping getSuperTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public Iterable<TypeMapping> getInheritanceHierarchy() {
        return this.convertToMappings(this.getPersistentType().getInheritanceHierarchy());
    }

    protected Iterable<TypeMapping> getAncestors() {
        return this.convertToMappings(this.getPersistentType().getAncestors());
    }

    protected Iterable<TypeMapping> convertToMappings(Iterable<PersistentType> types) {
        return IterableTools.transform(types, PersistentType.MAPPING_TRANSFORMER);
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return false;
    }

    @Override
    public Entity getRootEntity() {
        return null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlTypeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getAttributesTextRange() {
        return this.getValidationTextRange(this.xmlTypeMapping.getAttributesTextRange());
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.emptyIterable();
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return IterableTools.children(this.getAttributeMappings(), AttributeMapping.GENERATORS_TRANSFORMER);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages, reporter);
    }

    protected void validateClass(List<IMessage> messages, IReporter reporter) {
        if (this.getJavaResourceType() != null) {
            this.buildTypeMappingValidator().validate(messages, reporter);
        }
    }

    protected JpaValidator buildTypeMappingValidator() {
        return new GenericTypeMappingValidator(this);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getPersistenceUnit().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getPersistentType().getValidationTextRange();
    }

    protected Iterable<String> getCandidateClassNames() {
        return JavaProjectTools.getJavaClassNames((IJavaProject)this.getJavaProject());
    }
}

