/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.NamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.SpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.jpa.core.context.orm.OrmOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualSecondaryTable;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.orm.GenericOrmIdClassReference;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideInverseJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.DiscriminatorColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityPrimaryKeyJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericEntityPrimaryKeyValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.JoinTableTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.MappedSuperclassOverrideDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.OverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.SecondaryTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.TableValidator;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmAssociationOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmEntity2_0;
import org.eclipse.jpt.jpa.core.resource.orm.Inheritance;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGeneratorContainer;
import org.eclipse.jpt.jpa.core.resource.orm.XmlIdClassContainer;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryContainer;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmEntity<X extends XmlEntity>
extends AbstractOrmTypeMapping<X>
implements OrmEntity2_0 {
    protected String specifiedName;
    protected String defaultName;
    protected Entity rootEntity;
    protected final Vector<Entity> descendants = new Vector();
    protected final OrmIdClassReference idClassReference;
    protected final OrmSpecifiedTable table;
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final SecondaryTableParentAdapter secondaryTableParentAdapter;
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedSecondaryTable, XmlSecondaryTable> specifiedSecondaryTableContainer;
    protected final AbstractJpaContextModel.ContextListContainer<OrmVirtualSecondaryTable, JavaSpecifiedSecondaryTable> virtualSecondaryTableContainer;
    protected final PrimaryKeyJoinColumnParentAdapter primaryKeyJoinColumnParentAdapter;
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedPrimaryKeyJoinColumn, XmlPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumnContainer;
    protected final Vector<OrmVirtualPrimaryKeyJoinColumn> virtualPrimaryKeyJoinColumns = new Vector();
    protected final VirtualPrimaryKeyJoinColumnContainerAdapter virtualPrimaryKeyJoinColumnContainerAdapter = new VirtualPrimaryKeyJoinColumnContainerAdapter();
    protected PrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String specifiedDiscriminatorValue;
    protected String defaultDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final OrmSpecifiedDiscriminatorColumn discriminatorColumn;
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected final OrmAttributeOverrideContainer attributeOverrideContainer;
    protected final OrmAssociationOverrideContainer associationOverrideContainer;
    protected final OrmGeneratorContainer generatorContainer;
    protected final OrmQueryContainer queryContainer;

    protected AbstractOrmEntity(OrmPersistentType parent, X xmlEntity) {
        super(parent, xmlEntity);
        this.specifiedName = ((XmlEntity)xmlEntity).getName();
        this.idClassReference = this.buildIdClassReference();
        this.table = this.buildTable();
        this.rootEntity = this;
        this.secondaryTableParentAdapter = this.buildSecondaryTableParentAdapter();
        this.specifiedSecondaryTableContainer = this.buildSpecifiedSecondaryTableContainer();
        this.virtualSecondaryTableContainer = this.buildVirtualSecondaryTableContainer();
        this.primaryKeyJoinColumnParentAdapter = this.buildPrimaryKeyJoinColumnParentAdapter();
        this.specifiedPrimaryKeyJoinColumnContainer = this.buildSpecifiedPrimaryKeyJoinColumnContainer();
        this.specifiedInheritanceStrategy = this.buildSpecifiedInheritanceStrategy();
        this.specifiedDiscriminatorValue = ((XmlEntity)xmlEntity).getDiscriminatorValue();
        this.discriminatorColumn = this.buildDiscriminatorColumn();
        this.attributeOverrideContainer = this.buildAttributeOverrideContainer();
        this.associationOverrideContainer = this.buildAssociationOverrideContainer();
        this.generatorContainer = this.buildGeneratorContainer();
        this.queryContainer = this.buildQueryContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(((XmlEntity)this.xmlTypeMapping).getName());
        this.idClassReference.synchronizeWithResourceModel();
        this.table.synchronizeWithResourceModel();
        this.syncSpecifiedSecondaryTables();
        this.syncSpecifiedPrimaryKeyJoinColumns();
        this.setSpecifiedInheritanceStrategy_(this.buildSpecifiedInheritanceStrategy());
        this.setSpecifiedDiscriminatorValue_(((XmlEntity)this.xmlTypeMapping).getDiscriminatorValue());
        this.discriminatorColumn.synchronizeWithResourceModel();
        this.attributeOverrideContainer.synchronizeWithResourceModel();
        this.associationOverrideContainer.synchronizeWithResourceModel();
        this.generatorContainer.synchronizeWithResourceModel();
        this.queryContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setRootEntity(this.buildRootEntity());
        this.updateDescendants();
        this.idClassReference.update();
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
        this.table.update();
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.updateVirtualSecondaryTables();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSecondaryTables());
        this.updateDefaultPrimaryKeyJoinColumns();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getPrimaryKeyJoinColumns());
        this.discriminatorColumn.update();
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.attributeOverrideContainer.update();
        this.associationOverrideContainer.update();
        this.generatorContainer.update();
        this.queryContainer.update();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        this.setSpecifiedName_(name);
        ((XmlEntity)this.xmlTypeMapping).setName(name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        if (javaEntity != null) {
            return javaEntity.getName();
        }
        String className = this.getPersistentType().getClass_();
        return StringTools.isBlank((String)className) ? null : ClassNameTools.simpleName((String)className);
    }

    @Override
    public Entity getRootEntity() {
        return this.rootEntity;
    }

    protected void setRootEntity(Entity entity) {
        Entity old = this.rootEntity;
        this.rootEntity = entity;
        this.firePropertyChanged("rootEntity", old, entity);
    }

    protected Entity buildRootEntity() {
        Entity result = this;
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            result = (Entity)typeMapping;
        }
        return result;
    }

    @Override
    public Iterable<Entity> getDescendants() {
        return IterableTools.cloneLive(this.descendants);
    }

    protected void updateDescendants() {
        this.synchronizeCollection(this.buildDescendants(), this.descendants, "descendants");
    }

    protected Iterable<Entity> buildDescendants() {
        return this.isRootEntity() ? IterableTools.filter(this.getPersistenceUnit().getEntities(), (Predicate)new Entity.IsDescendant(this)) : IterableTools.emptyIterable();
    }

    protected boolean entityIsDescendant(Entity entity) {
        String typeName = this.getPersistentType().getName();
        String entityTypeName = entity.getPersistentType().getName();
        String rootEntityTypeName = entity.getRootEntity().getPersistentType().getName();
        return ObjectTools.notEquals((Object)typeName, (Object)entityTypeName) && ObjectTools.equals((Object)typeName, (Object)rootEntityTypeName);
    }

    @Override
    public OrmIdClassReference getIdClassReference() {
        return this.idClassReference;
    }

    protected OrmIdClassReference buildIdClassReference() {
        return new GenericOrmIdClassReference(this);
    }

    @Override
    public XmlIdClassContainer getXmlIdClassContainer() {
        return (XmlIdClassContainer)this.getXmlTypeMapping();
    }

    @Override
    public JavaIdClassReference getJavaIdClassReferenceForDefaults() {
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        return javaEntity == null ? null : javaEntity.getIdClassReference();
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClassReference.getIdClass();
    }

    @Override
    public OrmSpecifiedTable getTable() {
        return this.table;
    }

    protected OrmSpecifiedTable buildTable() {
        return this.getContextModelFactory().buildOrmTable(this.buildTableParentAdapter());
    }

    protected OrmTable.ParentAdapter buildTableParentAdapter() {
        return new TableParentAdapter();
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    @Override
    public String getDefaultTableName() {
        String javaName;
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        if (javaEntity != null && (javaName = javaEntity.getTable().getSpecifiedName()) != null && !this.table.isSpecifiedInResource()) {
            return javaName;
        }
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        String javaSchema;
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        if (javaEntity != null && (javaSchema = javaEntity.getTable().getSpecifiedSchema()) != null && !this.table.isSpecifiedInResource()) {
            return javaSchema;
        }
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        String javaCatalog;
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        if (javaEntity != null && (javaCatalog = javaEntity.getTable().getSpecifiedCatalog()) != null && !this.table.isSpecifiedInResource()) {
            return javaCatalog;
        }
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    @Override
    public ListIterable<SecondaryTable> getSecondaryTables() {
        return this.getSpecifiedSecondaryTablesSize() == 0 ? this.getReadOnlyVirtualSecondaryTables() : this.getReadOnlySpecifiedSecondaryTables();
    }

    @Override
    public int getSecondaryTablesSize() {
        return this.getSpecifiedSecondaryTablesSize() == 0 ? this.getVirtualSecondaryTablesSize() : this.getSpecifiedSecondaryTablesSize();
    }

    @Override
    public ListIterable<OrmSpecifiedSecondaryTable> getSpecifiedSecondaryTables() {
        return this.specifiedSecondaryTableContainer;
    }

    protected ListIterable<SecondaryTable> getReadOnlySpecifiedSecondaryTables() {
        return new SuperListIterableWrapper(this.getSpecifiedSecondaryTables());
    }

    @Override
    public int getSpecifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTableContainer.size();
    }

    @Override
    public OrmSpecifiedSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.getSpecifiedSecondaryTablesSize());
    }

    protected OrmSpecifiedSecondaryTable addSpecifiedSecondaryTable_() {
        return this.addSpecifiedSecondaryTable_(this.getSpecifiedSecondaryTablesSize());
    }

    @Override
    public OrmSpecifiedSecondaryTable addSpecifiedSecondaryTable(int index) {
        if (!this.secondaryTablesAreDefinedInXml()) {
            throw new IllegalStateException("virtual secondary tables exist - call OrmEntity.setSecondaryTablesAreDefinedInXml(true) first");
        }
        return this.addSpecifiedSecondaryTable_(index);
    }

    protected OrmSpecifiedSecondaryTable addSpecifiedSecondaryTable_(int index) {
        XmlSecondaryTable xmlSecondaryTable = this.buildXmlSecondaryTable();
        OrmSpecifiedSecondaryTable secondaryTable = (OrmSpecifiedSecondaryTable)this.specifiedSecondaryTableContainer.addContextElement(index, xmlSecondaryTable);
        ((XmlEntity)this.xmlTypeMapping).getSecondaryTables().add(index, (Object)xmlSecondaryTable);
        return secondaryTable;
    }

    protected XmlSecondaryTable buildXmlSecondaryTable() {
        return OrmFactory.eINSTANCE.createXmlSecondaryTable();
    }

    @Override
    public void removeSpecifiedSecondaryTable(SpecifiedSecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTableContainer.indexOf((OrmSpecifiedSecondaryTable)secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        this.specifiedSecondaryTableContainer.remove(index);
        ((XmlEntity)this.xmlTypeMapping).getSecondaryTables().remove(index);
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        this.specifiedSecondaryTableContainer.move(targetIndex, sourceIndex);
        ((XmlEntity)this.xmlTypeMapping).getSecondaryTables().move(targetIndex, sourceIndex);
    }

    protected OrmSpecifiedSecondaryTable buildSpecifiedSecondaryTable(XmlSecondaryTable xmlSecondaryTable) {
        return this.getContextModelFactory().buildOrmSecondaryTable(this.secondaryTableParentAdapter, xmlSecondaryTable);
    }

    protected void clearSpecifiedSecondaryTables() {
        this.specifiedSecondaryTableContainer.clear();
        ((XmlEntity)this.xmlTypeMapping).getSecondaryTables().clear();
    }

    protected void syncSpecifiedSecondaryTables() {
        this.specifiedSecondaryTableContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlSecondaryTable> getXmlSecondaryTables() {
        return IterableTools.cloneLive(((XmlEntity)this.xmlTypeMapping).getSecondaryTables());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedSecondaryTable, XmlSecondaryTable> buildSpecifiedSecondaryTableContainer() {
        return this.buildSpecifiedContextListContainer("specifiedSecondaryTables", new SpecifiedSecondaryTableContainerAdapter());
    }

    @Override
    public ListIterable<OrmVirtualSecondaryTable> getVirtualSecondaryTables() {
        return this.virtualSecondaryTableContainer;
    }

    protected ListIterable<SecondaryTable> getReadOnlyVirtualSecondaryTables() {
        return new SuperListIterableWrapper(this.getVirtualSecondaryTables());
    }

    @Override
    public int getVirtualSecondaryTablesSize() {
        return this.virtualSecondaryTableContainer.size();
    }

    protected void clearVirtualSecondaryTables() {
        this.virtualSecondaryTableContainer.clear();
    }

    protected void updateVirtualSecondaryTables() {
        this.virtualSecondaryTableContainer.update();
    }

    protected ListIterable<JavaSpecifiedSecondaryTable> getJavaSecondaryTablesForVirtuals() {
        if (this.getSpecifiedSecondaryTablesSize() > 0) {
            return EmptyListIterable.instance();
        }
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        return javaEntity == null ? EmptyListIterable.instance() : javaEntity.getSecondaryTables();
    }

    protected void moveVirtualSecondaryTable(int index, OrmVirtualSecondaryTable secondaryTable) {
        this.virtualSecondaryTableContainer.move(index, secondaryTable);
    }

    protected OrmVirtualSecondaryTable addVirtualSecondaryTable(int index, JavaSpecifiedSecondaryTable javaSecondaryTable) {
        return (OrmVirtualSecondaryTable)this.virtualSecondaryTableContainer.addContextElement(index, javaSecondaryTable);
    }

    protected OrmVirtualSecondaryTable buildVirtualSecondaryTable(JavaSpecifiedSecondaryTable javaSecondaryTable) {
        return this.getContextModelFactory().buildOrmVirtualSecondaryTable(this.secondaryTableParentAdapter, javaSecondaryTable);
    }

    protected void removeVirtualSecondaryTable(OrmVirtualSecondaryTable secondaryTable) {
        this.virtualSecondaryTableContainer.remove(secondaryTable);
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmVirtualSecondaryTable, JavaSpecifiedSecondaryTable> buildVirtualSecondaryTableContainer() {
        return this.buildVirtualContextListContainer("virtualSecondaryTables", new VirtualSecondaryTableContainerAdapter());
    }

    @Override
    public boolean secondaryTablesAreDefinedInXml() {
        return this.getVirtualSecondaryTablesSize() == 0;
    }

    @Override
    public void setSecondaryTablesAreDefinedInXml(boolean defineInXml) {
        if (defineInXml != this.secondaryTablesAreDefinedInXml()) {
            this.setSecondaryTablesAreDefinedInXml_(defineInXml);
        }
    }

    protected void setSecondaryTablesAreDefinedInXml_(boolean defineInXml) {
        if (defineInXml) {
            this.specifySecondaryTablesInXml();
        } else {
            this.removeSecondaryTablesFromXml();
        }
    }

    protected void specifySecondaryTablesInXml() {
        for (OrmVirtualSecondaryTable oldVirtualSecondaryTable : this.getVirtualSecondaryTables()) {
            this.addSpecifiedSecondaryTable_().initializeFrom(oldVirtualSecondaryTable);
        }
    }

    protected void removeSecondaryTablesFromXml() {
        this.clearSpecifiedSecondaryTables();
    }

    protected SecondaryTableParentAdapter buildSecondaryTableParentAdapter() {
        return new SecondaryTableParentAdapter();
    }

    @Override
    public ListIterable<PrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        return this.getSpecifiedPrimaryKeyJoinColumnsSize() == 0 ? this.getDefaultPrimaryKeyJoinColumns() : this.getReadOnlySpecifiedPrimaryKeyJoinColumns();
    }

    @Override
    public int getPrimaryKeyJoinColumnsSize() {
        return this.getSpecifiedPrimaryKeyJoinColumnsSize() == 0 ? this.getDefaultPrimaryKeyJoinColumnsSize() : this.getSpecifiedPrimaryKeyJoinColumnsSize();
    }

    protected OrmSpecifiedPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn xmlPkJoinColumn) {
        return this.getContextModelFactory().buildOrmPrimaryKeyJoinColumn(this.primaryKeyJoinColumnParentAdapter, xmlPkJoinColumn);
    }

    @Override
    public ListIterable<OrmSpecifiedPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumnContainer;
    }

    @Override
    public SpecifiedPrimaryKeyJoinColumn getSpecifiedPrimaryKeyJoinColumn(int index) {
        return (SpecifiedPrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.get(index);
    }

    protected ListIterable<PrimaryKeyJoinColumn> getReadOnlySpecifiedPrimaryKeyJoinColumns() {
        return new SuperListIterableWrapper(this.getSpecifiedPrimaryKeyJoinColumns());
    }

    @Override
    public int getSpecifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumnContainer.size();
    }

    @Override
    public OrmSpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn() {
        return this.addSpecifiedPrimaryKeyJoinColumn(this.getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    @Override
    public OrmSpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        this.clearDefaultPrimaryKeyJoinColumns();
        XmlPrimaryKeyJoinColumn xmlPkJoinColumn = this.buildXmlPrimaryKeyJoinColumn();
        OrmSpecifiedPrimaryKeyJoinColumn pkJoinColumn = (OrmSpecifiedPrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.addContextElement(index, xmlPkJoinColumn);
        ((XmlEntity)this.xmlTypeMapping).getPrimaryKeyJoinColumns().add(index, (Object)xmlPkJoinColumn);
        return pkJoinColumn;
    }

    protected XmlPrimaryKeyJoinColumn buildXmlPrimaryKeyJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn();
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(SpecifiedPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnContainer.indexOf((OrmSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        this.specifiedPrimaryKeyJoinColumnContainer.remove(index);
        ((XmlEntity)this.xmlTypeMapping).getPrimaryKeyJoinColumns().remove(index);
    }

    @Override
    public void convertDefaultPrimaryKeyJoinColumnsToSpecified() {
        if (this.getPrimaryKeyJoinColumnsSize() == 0) {
            this.addSpecifiedPrimaryKeyJoinColumn();
        }
        for (PrimaryKeyJoinColumn defaultJoinColumn : this.getDefaultPrimaryKeyJoinColumns()) {
            String columnName = defaultJoinColumn.getName();
            String referencedColumnName = defaultJoinColumn.getReferencedColumnName();
            OrmSpecifiedPrimaryKeyJoinColumn pkJoinColumn = this.addSpecifiedPrimaryKeyJoinColumn();
            pkJoinColumn.setSpecifiedName(columnName);
            pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    @Override
    public void clearSpecifiedPrimaryKeyJoinColumns() {
        this.specifiedPrimaryKeyJoinColumnContainer.clear();
        ((XmlEntity)this.xmlTypeMapping).getPrimaryKeyJoinColumns().clear();
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedPrimaryKeyJoinColumnContainer.move(targetIndex, sourceIndex);
        ((XmlEntity)this.xmlTypeMapping).getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
    }

    protected PrimaryKeyJoinColumnParentAdapter buildPrimaryKeyJoinColumnParentAdapter() {
        return new PrimaryKeyJoinColumnParentAdapter();
    }

    protected void syncSpecifiedPrimaryKeyJoinColumns() {
        this.specifiedPrimaryKeyJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlPrimaryKeyJoinColumn> getXmlPrimaryKeyJoinColumns() {
        return IterableTools.cloneLive(((XmlEntity)this.xmlTypeMapping).getPrimaryKeyJoinColumns());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedPrimaryKeyJoinColumn, XmlPrimaryKeyJoinColumn> buildSpecifiedPrimaryKeyJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedPrimaryKeyJoinColumns", new SpecifiedPrimaryKeyJoinColumnContainerAdapter());
    }

    @Override
    public ListIterable<PrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns() {
        int virtualSize = this.virtualPrimaryKeyJoinColumns.size();
        return virtualSize != 0 ? this.getReadOnlyVirtualPrimaryKeyJoinColumns() : this.getReadOnlyDefaultPrimaryKeyJoinColumns();
    }

    @Override
    public int getDefaultPrimaryKeyJoinColumnsSize() {
        int virtualSize = this.virtualPrimaryKeyJoinColumns.size();
        return virtualSize != 0 ? virtualSize : (this.defaultPrimaryKeyJoinColumn != null ? 1 : 0);
    }

    protected void clearDefaultPrimaryKeyJoinColumns() {
        int virtualSize = this.virtualPrimaryKeyJoinColumns.size();
        if (virtualSize != 0) {
            this.clearVirtualPrimaryKeyJoinColumns();
        } else if (this.defaultPrimaryKeyJoinColumn != null) {
            this.removeDefaultPrimaryKeyJoinColumn();
        }
    }

    protected void updateDefaultPrimaryKeyJoinColumns() {
        if (this.getSpecifiedPrimaryKeyJoinColumnsSize() > 0) {
            this.clearDefaultPrimaryKeyJoinColumns();
        } else if (this.getDefaultPrimaryKeyJoinColumnsSize() == 0) {
            if (this.javaPrimaryKeyJoinColumnsWillBeDefaults()) {
                this.initializeVirtualPrimaryKeyJoinColumns();
            } else if (this.getParentEntity() != null) {
                this.addDefaultPrimaryKeyJoinColumn();
            }
        } else if (this.defaultPrimaryKeyJoinColumn != null) {
            if (this.javaPrimaryKeyJoinColumnsWillBeDefaults()) {
                this.removeDefaultPrimaryKeyJoinColumn();
                this.initializeVirtualPrimaryKeyJoinColumns();
            }
        } else if (this.javaPrimaryKeyJoinColumnsWillBeDefaults()) {
            this.updateVirtualPrimaryKeyJoinColumns();
        } else {
            this.clearVirtualPrimaryKeyJoinColumns();
            this.addDefaultPrimaryKeyJoinColumn();
        }
    }

    protected void updateVirtualPrimaryKeyJoinColumns() {
        ContextContainerTools.update(this.virtualPrimaryKeyJoinColumnContainerAdapter);
    }

    protected boolean javaPrimaryKeyJoinColumnsWillBeDefaults() {
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        return javaEntity != null && javaEntity.getPrimaryKeyJoinColumnsSize() > 0;
    }

    protected ListIterable<OrmVirtualPrimaryKeyJoinColumn> getVirtualPrimaryKeyJoinColumns() {
        return IterableTools.cloneLive(this.virtualPrimaryKeyJoinColumns);
    }

    protected ListIterable<PrimaryKeyJoinColumn> getReadOnlyVirtualPrimaryKeyJoinColumns() {
        return IterableTools.cloneLive(this.virtualPrimaryKeyJoinColumns);
    }

    protected void initializeVirtualPrimaryKeyJoinColumns() {
        for (JavaSpecifiedPrimaryKeyJoinColumn javaPkJoinColumn : this.getJavaPrimaryKeyJoinColumnsForVirtuals()) {
            this.addVirtualPrimaryKeyJoinColumn(this.buildVirtualPrimaryKeyJoinColumn(javaPkJoinColumn));
        }
    }

    protected void addVirtualPrimaryKeyJoinColumn(OrmVirtualPrimaryKeyJoinColumn pkJoinColumn) {
        this.addVirtualPrimaryKeyJoinColumn(this.virtualPrimaryKeyJoinColumns.size(), pkJoinColumn);
    }

    protected void addVirtualPrimaryKeyJoinColumn(int index, OrmVirtualPrimaryKeyJoinColumn pkJoinColumn) {
        this.addItemToList(index, pkJoinColumn, this.virtualPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    protected void clearVirtualPrimaryKeyJoinColumns() {
        this.clearList(this.virtualPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    protected Iterable<JavaSpecifiedPrimaryKeyJoinColumn> getJavaPrimaryKeyJoinColumnsForVirtuals() {
        return this.getJavaTypeMappingForDefaults().getPrimaryKeyJoinColumns();
    }

    protected void moveVirtualPrimaryKeyJoinColumn(int index, OrmVirtualPrimaryKeyJoinColumn pkJoinColumn) {
        this.moveItemInList(index, pkJoinColumn, this.virtualPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    protected OrmVirtualPrimaryKeyJoinColumn addVirtualPrimaryKeyJoinColumn(int index, JavaSpecifiedPrimaryKeyJoinColumn javaPrimaryKeyJoinColumn) {
        OrmVirtualPrimaryKeyJoinColumn pkJoinColumn = this.buildVirtualPrimaryKeyJoinColumn(javaPrimaryKeyJoinColumn);
        this.addVirtualPrimaryKeyJoinColumn(index, pkJoinColumn);
        return pkJoinColumn;
    }

    protected OrmVirtualPrimaryKeyJoinColumn buildVirtualPrimaryKeyJoinColumn(JavaSpecifiedPrimaryKeyJoinColumn javaPrimaryKeyJoinColumn) {
        return this.getContextModelFactory().buildOrmVirtualPrimaryKeyJoinColumn(this.primaryKeyJoinColumnParentAdapter, javaPrimaryKeyJoinColumn);
    }

    protected void removeVirtualPrimaryKeyJoinColumn(OrmVirtualPrimaryKeyJoinColumn pkJoinColumn) {
        this.removeItemFromList(pkJoinColumn, this.virtualPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    protected ListIterable<PrimaryKeyJoinColumn> getReadOnlyDefaultPrimaryKeyJoinColumns() {
        return this.defaultPrimaryKeyJoinColumn != null ? new SingleElementListIterable((Object)this.defaultPrimaryKeyJoinColumn) : EmptyListIterable.instance();
    }

    protected void addDefaultPrimaryKeyJoinColumn() {
        this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(null);
        this.fireItemAdded("defaultPrimaryKeyJoinColumns", 0, this.defaultPrimaryKeyJoinColumn);
    }

    protected void removeDefaultPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumn old = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = null;
        this.fireItemRemoved("defaultPrimaryKeyJoinColumns", 0, old);
    }

    protected PrimaryKeyJoinColumn buildDefaultPrimaryKeyJoinColumn() {
        return this.buildPrimaryKeyJoinColumn(null);
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.specifiedInheritanceStrategy != null ? this.specifiedInheritanceStrategy : this.defaultInheritanceStrategy;
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType inheritanceType) {
        if (this.valuesAreDifferent((Object)this.specifiedInheritanceStrategy, (Object)inheritanceType)) {
            Inheritance xmlInheritance = this.getXmlInheritanceForUpdate();
            this.setSpecifiedInheritanceStrategy_(inheritanceType);
            xmlInheritance.setStrategy(InheritanceType.toOrmResourceModel(inheritanceType));
            this.removeXmlInheritanceIfUnset();
        }
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType inheritanceType) {
        InheritanceType old = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildSpecifiedInheritanceStrategy() {
        Inheritance xmlInheritance = ((XmlEntity)this.xmlTypeMapping).getInheritance();
        return xmlInheritance == null ? null : InheritanceType.fromOrmResourceModel(xmlInheritance.getStrategy());
    }

    protected Inheritance getXmlInheritanceForUpdate() {
        Inheritance xmlInheritance = ((XmlEntity)this.xmlTypeMapping).getInheritance();
        return xmlInheritance != null ? xmlInheritance : this.buildXmlInheritance();
    }

    protected Inheritance buildXmlInheritance() {
        Inheritance xmlInheritance = OrmFactory.eINSTANCE.createInheritance();
        ((XmlEntity)this.xmlTypeMapping).setInheritance(xmlInheritance);
        return xmlInheritance;
    }

    protected void removeXmlInheritanceIfUnset() {
        if (((XmlEntity)this.xmlTypeMapping).getInheritance().isUnset()) {
            ((XmlEntity)this.xmlTypeMapping).setInheritance(null);
        }
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType inheritanceType) {
        InheritanceType old = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        if (javaEntity != null && ((XmlEntity)this.xmlTypeMapping).getInheritance() == null) {
            return javaEntity.getInheritanceStrategy();
        }
        return this.isRootEntity() ? InheritanceType.SINGLE_TABLE : this.rootEntity.getInheritanceStrategy();
    }

    @Override
    public String getDiscriminatorValue() {
        return this.specifiedDiscriminatorValue != null ? this.specifiedDiscriminatorValue : this.defaultDiscriminatorValue;
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String discriminatorValue) {
        this.setSpecifiedDiscriminatorValue_(discriminatorValue);
        ((XmlEntity)this.xmlTypeMapping).setDiscriminatorValue(discriminatorValue);
    }

    protected void setSpecifiedDiscriminatorValue_(String discriminatorValue) {
        String old = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("specifiedDiscriminatorValue", old, discriminatorValue);
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String discriminatorValue) {
        String old = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", old, discriminatorValue);
    }

    protected String buildDefaultDiscriminatorValue() {
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        if (javaEntity != null) {
            return javaEntity.getDiscriminatorValue();
        }
        if (this.discriminatorValueIsUndefined) {
            return null;
        }
        return this.getDiscriminatorType() == DiscriminatorType.STRING ? this.getName() : null;
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.discriminatorColumn.getDiscriminatorType();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = allowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean undefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = undefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    @Override
    public OrmSpecifiedDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    protected OrmSpecifiedDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getContextModelFactory().buildOrmDiscriminatorColumn(this.buildDiscriminatorColumnParentAdapter());
    }

    protected OrmSpecifiedDiscriminatorColumn.ParentAdapter buildDiscriminatorColumnParentAdapter() {
        return new DiscriminatorColumnParentAdapter();
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = allowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRootEntity();
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean undefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = undefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected JavaEntity getJavaOverrideContainerEntity() {
        if (this.isMetadataComplete()) {
            return null;
        }
        JavaPersistentType javaType = this.getJavaPersistentType();
        if (javaType == null) {
            return null;
        }
        JavaTypeMapping javaTypeMapping = javaType.getMapping();
        return javaTypeMapping instanceof JavaEntity ? (JavaEntity)javaTypeMapping : null;
    }

    @Override
    public OrmAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    protected OrmAttributeOverrideContainer buildAttributeOverrideContainer() {
        return this.getContextModelFactory().buildOrmAttributeOverrideContainer(new AttributeOverrideContainerParentAdapter());
    }

    protected TypeMapping getOverridableTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    protected Column resolveOverriddenColumnForAttributeOverride(String attributeName) {
        SpecifiedColumn column;
        JavaPersistentType javaType;
        if (!this.isMetadataComplete() && (javaType = this.getJavaPersistentType()) != null && (column = javaType.getMapping().resolveOverriddenColumn(attributeName)) != null) {
            return column;
        }
        return MappingTools.resolveOverriddenColumn(this.getOverridableTypeMapping(), attributeName);
    }

    protected AttributeOverride getJavaAttributeOverrideNamedForVirtual(String attributeName) {
        JavaEntity javaEntity = this.getJavaTypeMappingForDefaults();
        return javaEntity == null ? null : javaEntity.getAttributeOverrideContainer().getOverrideNamed(attributeName);
    }

    @Override
    public OrmAssociationOverrideContainer getAssociationOverrideContainer() {
        return this.associationOverrideContainer;
    }

    protected OrmAssociationOverrideContainer buildAssociationOverrideContainer() {
        return this.getContextModelFactory().buildOrmAssociationOverrideContainer(new AssociationOverrideContainerParentAdapter());
    }

    @Override
    public SpecifiedRelationship resolveOverriddenRelationship(String attributeName) {
        OrmSpecifiedAssociationOverride override;
        int dotIndex;
        if (this.isJpa2_0Compatible() && (dotIndex = attributeName.indexOf(46)) != -1 && (override = this.associationOverrideContainer.getSpecifiedOverrideNamed(attributeName.substring(dotIndex + 1))) != null) {
            return override.getRelationship();
        }
        return super.resolveOverriddenRelationship(attributeName);
    }

    protected Relationship resolveOverriddenRelationshipForAssociationOverride(String attributeName) {
        SpecifiedRelationship relationship;
        JavaPersistentType javaType;
        if (!this.isMetadataComplete() && (javaType = this.getJavaPersistentType()) != null && (relationship = javaType.getMapping().resolveOverriddenRelationship(attributeName)) != null) {
            return relationship;
        }
        return MappingTools.resolveOverriddenRelationship(this.getOverridableTypeMapping(), attributeName);
    }

    @Override
    public OrmGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected OrmGeneratorContainer buildGeneratorContainer() {
        return this.getContextModelFactory().buildOrmGeneratorContainer(this, (XmlGeneratorContainer)((Object)this.xmlTypeMapping));
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getGenerators(), this.generatorContainer.getGenerators()});
    }

    @Override
    public OrmQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected OrmQueryContainer buildQueryContainer() {
        return this.getContextModelFactory().buildOrmQueryContainer(this, (XmlQueryContainer)((Object)this.xmlTypeMapping));
    }

    @Override
    public Iterable<Query> getQueries() {
        return this.queryContainer.getQueries();
    }

    @Override
    public Iterable<Table> getAssociatedTables() {
        return IterableTools.insert((Object)this.table, this.getSecondaryTables());
    }

    @Override
    public Iterable<Table> getAllAssociatedTables() {
        return IterableTools.children(this.getInheritanceHierarchy(), TypeMappingTools.ASSOCIATED_TABLES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllAssociatedTableNames() {
        return this.convertToNames(this.getAllAssociatedTables());
    }

    protected Iterable<String> convertToNames(Iterable<Table> tables) {
        return IterableTools.removeNulls(this.convertToNames_(tables));
    }

    protected Iterable<String> convertToNames_(Iterable<Table> tables) {
        return new TransformationIterable(tables, Table.NAME_TRANSFORMER);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !this.tableNameIsValid(tableName);
    }

    protected boolean tableNameIsValid(String tableName) {
        return this.tableIsUndefined || this.tableNameIsValid_(tableName);
    }

    protected boolean tableNameIsValid_(String tableName) {
        return this.connectionProfileIsActive() ? this.resolveDbTable(tableName) != null : this.tableNameIsAssociatedTable(tableName);
    }

    protected boolean tableNameIsAssociatedTable(String tableName) {
        if (tableName != null && tableName.equals(this.getPrimaryTableName())) {
            return true;
        }
        return IterableTools.contains(this.getAllAssociatedTableNames(), (Object)tableName);
    }

    @Override
    public JavaEntity getJavaTypeMapping() {
        return (JavaEntity)super.getJavaTypeMapping();
    }

    @Override
    public JavaEntity getJavaTypeMappingForDefaults() {
        return (JavaEntity)super.getJavaTypeMappingForDefaults();
    }

    @Override
    public String getPrimaryTableName() {
        return this.table.getName();
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getPrimaryDbTable() {
        return this.table.getDbTable();
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
        if (this.getDataSource().connectionProfileIsActive()) {
            return this.getDataSource().selectTableForIdentifier(this.getAllAssociatedDbTables(), tableName);
        }
        return null;
    }

    protected Iterable<org.eclipse.jpt.jpa.db.Table> getAllAssociatedDbTables() {
        return IterableTools.removeNulls(this.getAllAssociatedDbTables_());
    }

    protected Iterable<org.eclipse.jpt.jpa.db.Table> getAllAssociatedDbTables_() {
        return new TransformationIterable(this.getAllAssociatedTables(), Table.DB_TABLE_TRANSFORMER);
    }

    @Override
    public Schema getDbSchema() {
        return this.table.getDbSchema();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return MappingTools.getPrimaryKeyColumnName(this);
    }

    @Override
    public SpecifiedPersistentAttribute getIdAttribute() {
        Iterator<AttributeMapping> idAttributeMappings = this.getAllAttributeMappings("id").iterator();
        if (idAttributeMappings.hasNext()) {
            SpecifiedPersistentAttribute attribute = idAttributeMappings.next().getPersistentAttribute();
            return idAttributeMappings.hasNext() ? null : attribute;
        }
        return null;
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public int getXmlSequence() {
        return 1;
    }

    @Override
    public void addXmlTypeMappingTo(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().add((Object)((XmlEntity)this.xmlTypeMapping));
    }

    @Override
    public void removeXmlTypeMappingFrom(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().remove((Object)this.xmlTypeMapping);
    }

    @Override
    public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
        OrmSpecifiedAttributeOverride override;
        int dotIndex;
        if (this.isJpa2_0Compatible() && (dotIndex = attributeName.indexOf(46)) != -1 && (override = this.attributeOverrideContainer.getSpecifiedOverrideNamed(attributeName.substring(dotIndex + 1))) != null) {
            return override.getColumn();
        }
        return super.resolveOverriddenColumn(attributeName);
    }

    @Override
    public Iterable<String> getOverridableAttributeNames() {
        return this.isTablePerClass() ? super.getOverridableAttributeNames() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getOverridableAssociationNames() {
        return this.isTablePerClass() ? super.getOverridableAssociationNames() : EmptyIterable.instance();
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        for (AttributeMapping attributeMapping : this.getAllAttributeMappings()) {
            AttributeMapping resolvedMapping = attributeMapping.resolveAttributeMapping(name);
            if (resolvedMapping == null) continue;
            return resolvedMapping;
        }
        return null;
    }

    @Override
    public Entity getParentEntity() {
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return this == this.rootEntity;
    }

    protected boolean isDescendant() {
        return !this.isRootEntity();
    }

    protected boolean isSingleTableDescendant() {
        return this.isDescendant() && this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE;
    }

    protected boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRootEntity() && this.descendants.isEmpty() && this.specifiedInheritanceStrategy == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean resourceTableIsSpecified() {
        return this.table.isSpecifiedInResource() || this.javaResourceTableIsSpecified();
    }

    protected boolean javaResourceTableIsSpecified() {
        JavaEntity javaEntity = this.getJavaTypeMapping();
        return javaEntity != null && javaEntity.getTable().isSpecifiedInResource();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isAbstract() {
        JavaResourceType jrt = this.getJavaResourceType();
        return jrt != null && jrt.isAbstract();
    }

    protected boolean isFinal() {
        JavaResourceType jrt = this.getJavaResourceType();
        return jrt != null && jrt.isFinal();
    }

    protected boolean isMember() {
        JavaResourceType jrt = this.getJavaResourceType();
        return jrt != null && jrt.getTypeBinding().isMemberTypeDeclaration();
    }

    protected boolean isStatic() {
        JavaResourceType jrt = this.getJavaResourceType();
        return jrt != null && jrt.isStatic();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createIdClassRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createIdClassRenameTypeEdits(IType originalType, String newName) {
        return this.idClassReference.createRenameTypeEdits(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createIdClassMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createIdClassMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.idClassReference.createMoveTypeEdits(originalType, newPackage);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createIdClassRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createIdClassRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.idClassReference.createRenamePackageEdits(originalPackage, newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validatePrimaryKey(messages, reporter);
        this.validateTable(messages, reporter);
        for (OrmSpecifiedSecondaryTable secondaryTable : this.getSpecifiedSecondaryTables()) {
            secondaryTable.validate(messages, reporter);
        }
        this.validateInheritance(messages, reporter);
        this.validatePrimaryKeyJoinColumns(messages, reporter);
        this.attributeOverrideContainer.validate(messages, reporter);
        this.associationOverrideContainer.validate(messages, reporter);
        this.generatorContainer.validate(messages, reporter);
        this.queryContainer.validate(messages, reporter);
        this.validateEntityName(messages);
        this.idClassReference.validate(messages, reporter);
    }

    protected void validatePrimaryKeyJoinColumns(List<IMessage> messages, IReporter reporter) {
        if (this.getPrimaryKeyJoinColumnsSize() > 0) {
            if (this.getParentEntity() == null) {
                messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.ROOT_ENTITY_HAS_PK_JOIN_COLUMN_DEFINED, this.getPersistentType().getName()));
            } else {
                for (OrmSpecifiedPrimaryKeyJoinColumn pkJoinColumn : this.getSpecifiedPrimaryKeyJoinColumns()) {
                    pkJoinColumn.validate(messages, reporter);
                }
            }
        }
    }

    protected void validateEntityName(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.getName())) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.ENTITY_NAME_MISSING, this.getPersistentType().getClass_()));
        }
    }

    @Override
    public boolean supportsValidationMessages() {
        return true;
    }

    @Override
    public TextRange getNameTextRange() {
        return ((XmlEntity)this.getXmlTypeMapping()).getNameTextRange();
    }

    protected void validatePrimaryKey(List<IMessage> messages, IReporter reporter) {
        this.buildPrimaryKeyValidator().validate(messages, reporter);
    }

    protected JpaValidator buildPrimaryKeyValidator() {
        return new GenericEntityPrimaryKeyValidator(this);
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter) {
        if (this.isAbstractTablePerClass()) {
            if (this.resourceTableIsSpecified()) {
                messages.add(this.buildValidationMessage(this.table.getValidationTextRange(), JptJpaCoreValidationMessages.ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE, this.getName()));
            }
            return;
        }
        if (this.isSingleTableDescendant() && this.getDataSource().connectionProfileIsActive()) {
            if (this.specifiedTableDoesNotMatchRootTable()) {
                messages.add(this.buildValidationMessage(this.table.getValidationTextRange(), JptJpaCoreValidationMessages.ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE, this.getName()));
            }
            return;
        }
        this.table.validate(messages, reporter);
    }

    protected boolean specifiedTableDoesNotMatchRootTable() {
        return this.table.isSpecifiedInResource() && this.table.getDbTable() != this.getRootEntity().getTable().getDbTable();
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter) {
        this.validateInheritanceStrategy(messages);
        this.validateDiscriminatorColumn(messages, reporter);
        this.validateDiscriminatorValue(messages);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter) {
        if (this.specifiedDiscriminatorColumnIsAllowed && !this.discriminatorColumnIsUndefined) {
            this.discriminatorColumn.validate(messages, reporter);
        } else if (!this.discriminatorColumn.isVirtual()) {
            if (this.isDescendant()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorColumnTextRange(), JptJpaCoreValidationMessages.ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED, this.getName()));
            } else if (this.isTablePerClass()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorColumnTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED, this.getName()));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages) {
        if (this.discriminatorValueIsUndefined && this.specifiedDiscriminatorValue != null) {
            if (this.isAbstract()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorValueTextRange(), JptJpaCoreValidationMessages.ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED, this.getName()));
            } else if (this.isTablePerClass()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorValueTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED, this.getName()));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages) {
        JpaPlatformVariation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaPlatformVariation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRootEntity()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.NO) {
                messages.add(this.buildValidationMessage(this.getInheritanceStrategyTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getInheritanceStrategyTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM, this.getName()));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange() {
        return this.getValidationTextRange(((XmlEntity)this.xmlTypeMapping).getDiscriminatorValueTextRange());
    }

    protected TextRange getDiscriminatorColumnTextRange() {
        return this.getValidationTextRange(((XmlEntity)this.xmlTypeMapping).getDiscriminatorColumn().getValidationTextRange());
    }

    protected TextRange getInheritanceStrategyTextRange() {
        return this.getValidationTextRange(((XmlEntity)this.xmlTypeMapping).getInheritanceStrategyTextRange());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.table.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedSecondaryTable secondaryTable : this.getSpecifiedSecondaryTables()) {
            result = secondaryTable.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        for (OrmSpecifiedPrimaryKeyJoinColumn pkJoinColumn : this.getSpecifiedPrimaryKeyJoinColumns()) {
            result = pkJoinColumn.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        result = this.attributeOverrideContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.associationOverrideContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.discriminatorColumn.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.generatorContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.idClassReference.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AssociationOverrideContainerParentAdapter
    extends OverrideContainerParentAdapter
    implements OrmAssociationOverrideContainer2_0.ParentAdapter {
        @Override
        protected JavaOverrideContainer getOverrideContainer(JavaEntity javaEntity) {
            return javaEntity.getAssociationOverrideContainer();
        }

        @Override
        protected Iterable<String> getAllOverridableNames_(TypeMapping typeMapping) {
            return typeMapping.getAllOverridableAssociationNames();
        }

        @Override
        public EList<XmlAssociationOverride> getXmlOverrides() {
            return ((XmlEntity)AbstractOrmEntity.this.xmlTypeMapping).getAssociationOverrides();
        }

        @Override
        public Relationship resolveOverriddenRelationship(String attributeName) {
            JavaEntity javaEntity = this.getJavaOverrideContainerEntity();
            return javaEntity != null ? javaEntity.getAssociationOverrideContainer().getOverrideRelationship(attributeName) : AbstractOrmEntity.this.resolveOverriddenRelationshipForAssociationOverride(attributeName);
        }

        @Override
        public JpaValidator buildOverrideValidator(Override_ override, OverrideContainer container) {
            return new AssociationOverrideValidator((AssociationOverride)override, (AssociationOverrideContainer)container, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JpaValidator buildColumnValidator(Override_ override, BaseColumn column, TableColumn.ParentAdapter parentAdapter) {
            return new AssociationOverrideJoinColumnValidator((AssociationOverride)override, (JoinColumn)column, (JoinColumn.ParentAdapter)parentAdapter, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }

        @Override
        public JpaValidator buildJoinTableJoinColumnValidator(AssociationOverride override, JoinColumn column, JoinColumn.ParentAdapter parentAdapter) {
            return new AssociationOverrideJoinColumnValidator(override, column, parentAdapter, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JpaValidator buildJoinTableInverseJoinColumnValidator(AssociationOverride override, JoinColumn column, JoinColumn.ParentAdapter parentAdapter) {
            return new AssociationOverrideInverseJoinColumnValidator(override, column, parentAdapter, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JpaValidator buildJoinTableValidator(AssociationOverride override, Table t) {
            return new AssociationOverrideJoinTableValidator(override, (JoinTable)t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeOverrideContainerParentAdapter
    extends OverrideContainerParentAdapter
    implements OrmAttributeOverrideContainer.ParentAdapter {
        @Override
        protected JavaOverrideContainer getOverrideContainer(JavaEntity javaEntity) {
            return javaEntity.getAttributeOverrideContainer();
        }

        @Override
        protected Iterable<String> getAllOverridableNames_(TypeMapping overriddenTypeMapping) {
            return IterableTools.filter(overriddenTypeMapping.getAllOverridableAttributeNames(), (Predicate)new OverrideContainer.ParentAdapter.AttributeIsOverridable(this));
        }

        @Override
        public EList<XmlAttributeOverride> getXmlOverrides() {
            return ((XmlEntity)AbstractOrmEntity.this.xmlTypeMapping).getAttributeOverrides();
        }

        @Override
        public JpaValidator buildOverrideValidator(Override_ override, OverrideContainer container) {
            return new AttributeOverrideValidator((AttributeOverride)override, (AttributeOverrideContainer)container, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JpaValidator buildColumnValidator(Override_ override, BaseColumn column, TableColumn.ParentAdapter parentAdapter) {
            return new AttributeOverrideColumnValidator((AttributeOverride)override, column, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }

        @Override
        public Column resolveOverriddenColumn(String attributeName) {
            JavaEntity javaEntity = this.getJavaOverrideContainerEntity();
            return javaEntity != null ? javaEntity.getAttributeOverrideContainer().getOverrideColumn(attributeName) : AbstractOrmEntity.this.resolveOverriddenColumnForAttributeOverride(attributeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DiscriminatorColumnParentAdapter
    extends NamedColumnParentAdapter
    implements OrmSpecifiedDiscriminatorColumn.ParentAdapter {
        @Override
        public String getDefaultColumnName(NamedColumn column) {
            String name;
            JavaEntity javaEntity;
            if (this.getXmlColumn() == null && (javaEntity = this.getJavaEntityForDefaults()) != null && (name = javaEntity.getDiscriminatorColumn().getSpecifiedName()) != null) {
                return name;
            }
            return AbstractOrmEntity.this.isDescendant() ? this.getRootDiscriminatorColumn().getName() : (this.isTablePerClass() ? null : "DTYPE");
        }

        @Override
        public int getDefaultLength() {
            Integer length;
            JavaEntity javaEntity;
            if (this.getXmlColumn() == null && (javaEntity = this.getJavaEntityForDefaults()) != null && (length = javaEntity.getDiscriminatorColumn().getSpecifiedLength()) != null) {
                return length;
            }
            return AbstractOrmEntity.this.isDescendant() ? this.getRootDiscriminatorColumn().getLength() : (this.isTablePerClass() ? 0 : 31);
        }

        @Override
        public DiscriminatorType getDefaultDiscriminatorType() {
            DiscriminatorType dt;
            JavaEntity javaEntity;
            if (this.getXmlColumn() == null && (javaEntity = this.getJavaEntityForDefaults()) != null && (dt = javaEntity.getDiscriminatorColumn().getSpecifiedDiscriminatorType()) != null) {
                return dt;
            }
            return AbstractOrmEntity.this.isDescendant() ? this.getRootDiscriminatorColumn().getDiscriminatorType() : (this.isTablePerClass() ? null : NamedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new DiscriminatorColumnValidator(column);
        }

        @Override
        public XmlDiscriminatorColumn getXmlColumn() {
            return this.getXmlEntity().getDiscriminatorColumn();
        }

        @Override
        public XmlDiscriminatorColumn buildXmlColumn() {
            XmlDiscriminatorColumn xmlColumn = OrmFactory.eINSTANCE.createXmlDiscriminatorColumn();
            this.getXmlEntity().setDiscriminatorColumn(xmlColumn);
            return xmlColumn;
        }

        @Override
        public void removeXmlColumn() {
            this.getXmlEntity().setDiscriminatorColumn(null);
        }

        protected XmlEntity getXmlEntity() {
            return (XmlEntity)AbstractOrmEntity.this.getXmlTypeMapping();
        }

        protected SpecifiedDiscriminatorColumn getRootDiscriminatorColumn() {
            return AbstractOrmEntity.this.rootEntity.getDiscriminatorColumn();
        }

        protected boolean isMetadataComplete() {
            return AbstractOrmEntity.this.isMetadataComplete();
        }

        protected boolean isTablePerClass() {
            return AbstractOrmEntity.this.isTablePerClass();
        }

        protected JavaEntity getJavaEntityForDefaults() {
            return AbstractOrmEntity.this.getJavaTypeMappingForDefaults();
        }
    }

    public abstract class NamedColumnParentAdapter
    implements NamedColumn.ParentAdapter {
        public JpaContextModel getColumnParent() {
            return AbstractOrmEntity.this;
        }

        public String getDefaultTableName() {
            return AbstractOrmEntity.this.getPrimaryTableName();
        }

        public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
            return AbstractOrmEntity.this.resolveDbTable(tableName);
        }

        public TextRange getValidationTextRange() {
            return AbstractOrmEntity.this.getValidationTextRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class OverrideContainerParentAdapter
    implements OrmOverrideContainer.ParentAdapter {
        @Override
        public JpaContextModel getOverrideContainerParent() {
            return AbstractOrmEntity.this;
        }

        @Override
        public AbstractOrmEntity<?> getTypeMapping() {
            return AbstractOrmEntity.this;
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmEntity.this.getValidationTextRange();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmEntity.this.getOverridableTypeMapping();
        }

        @Override
        public Iterable<String> getJavaOverrideNames() {
            JavaEntity javaEntity = this.getJavaOverrideContainerEntity();
            return javaEntity == null ? null : this.getOverrideContainer(javaEntity).getOverrideNames();
        }

        protected JavaEntity getJavaOverrideContainerEntity() {
            return AbstractOrmEntity.this.getJavaOverrideContainerEntity();
        }

        protected abstract JavaOverrideContainer getOverrideContainer(JavaEntity var1);

        @Override
        public Iterable<String> getAllOverridableNames() {
            TypeMapping overriddenTypeMapping = this.getOverridableTypeMapping();
            return overriddenTypeMapping != null ? this.getAllOverridableNames_(overriddenTypeMapping) : IterableTools.emptyIterable();
        }

        protected abstract Iterable<String> getAllOverridableNames_(TypeMapping var1);

        @Override
        public String getDefaultTableName() {
            return AbstractOrmEntity.this.getPrimaryTableName();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractOrmEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
            return AbstractOrmEntity.this.resolveDbTable(tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return AbstractOrmEntity.this.getAllAssociatedTableNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PrimaryKeyJoinColumnParentAdapter
    extends NamedColumnParentAdapter
    implements BaseJoinColumn.ParentAdapter {
        @Override
        public org.eclipse.jpt.jpa.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractOrmEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        @Override
        public int getJoinColumnsSize() {
            return AbstractOrmEntity.this.getPrimaryKeyJoinColumnsSize();
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            if (this.getJoinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = AbstractOrmEntity.this.getParentEntity();
            return parentEntity == null ? AbstractOrmEntity.this.getPrimaryKeyColumnName() : parentEntity.getPrimaryKeyColumnName();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new EntityPrimaryKeyJoinColumnValidator((BaseJoinColumn)column, this);
        }
    }

    public class SecondaryTableParentAdapter
    implements OrmSpecifiedSecondaryTable.ParentAdapter,
    OrmVirtualSecondaryTable.ParentAdapter {
        public OrmEntity getTableParent() {
            return AbstractOrmEntity.this;
        }

        public JpaValidator buildTableValidator(Table t) {
            return new SecondaryTableValidator((SecondaryTable)t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedPrimaryKeyJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedPrimaryKeyJoinColumn, XmlPrimaryKeyJoinColumn> {
        @Override
        public OrmSpecifiedPrimaryKeyJoinColumn buildContextElement(XmlPrimaryKeyJoinColumn resourceElement) {
            return AbstractOrmEntity.this.buildPrimaryKeyJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<XmlPrimaryKeyJoinColumn> getResourceElements() {
            return AbstractOrmEntity.this.getXmlPrimaryKeyJoinColumns();
        }

        @Override
        public XmlPrimaryKeyJoinColumn extractResourceElement(OrmSpecifiedPrimaryKeyJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedSecondaryTableContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedSecondaryTable, XmlSecondaryTable> {
        @Override
        public OrmSpecifiedSecondaryTable buildContextElement(XmlSecondaryTable resourceElement) {
            return AbstractOrmEntity.this.buildSpecifiedSecondaryTable(resourceElement);
        }

        @Override
        public ListIterable<XmlSecondaryTable> getResourceElements() {
            return AbstractOrmEntity.this.getXmlSecondaryTables();
        }

        @Override
        public XmlSecondaryTable extractResourceElement(OrmSpecifiedSecondaryTable contextElement) {
            return contextElement.getXmlTable();
        }
    }

    public class TableParentAdapter
    implements OrmTable.ParentAdapter {
        public OrmEntity getTableParent() {
            return AbstractOrmEntity.this;
        }

        public JpaValidator buildTableValidator(Table t) {
            return new TableValidator(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VirtualPrimaryKeyJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<OrmVirtualPrimaryKeyJoinColumn, JavaSpecifiedPrimaryKeyJoinColumn> {
        @Override
        public Iterable<OrmVirtualPrimaryKeyJoinColumn> getContextElements() {
            return AbstractOrmEntity.this.getVirtualPrimaryKeyJoinColumns();
        }

        @Override
        public Iterable<JavaSpecifiedPrimaryKeyJoinColumn> getResourceElements() {
            return AbstractOrmEntity.this.getJavaPrimaryKeyJoinColumnsForVirtuals();
        }

        @Override
        public JavaSpecifiedPrimaryKeyJoinColumn getResourceElement(OrmVirtualPrimaryKeyJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }

        @Override
        public void moveContextElement(int index, OrmVirtualPrimaryKeyJoinColumn element) {
            AbstractOrmEntity.this.moveVirtualPrimaryKeyJoinColumn(index, element);
        }

        @Override
        public void addContextElement(int index, JavaSpecifiedPrimaryKeyJoinColumn resourceElement) {
            AbstractOrmEntity.this.addVirtualPrimaryKeyJoinColumn(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmVirtualPrimaryKeyJoinColumn element) {
            AbstractOrmEntity.this.removeVirtualPrimaryKeyJoinColumn(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VirtualSecondaryTableContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmVirtualSecondaryTable, JavaSpecifiedSecondaryTable> {
        @Override
        public OrmVirtualSecondaryTable buildContextElement(JavaSpecifiedSecondaryTable resourceElement) {
            return AbstractOrmEntity.this.buildVirtualSecondaryTable(resourceElement);
        }

        @Override
        public ListIterable<JavaSpecifiedSecondaryTable> getResourceElements() {
            return AbstractOrmEntity.this.getJavaSecondaryTablesForVirtuals();
        }

        @Override
        public JavaSpecifiedSecondaryTable extractResourceElement(OrmVirtualSecondaryTable contextElement) {
            return contextElement.getOverriddenTable();
        }
    }
}

