/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.JoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.MappedByRelationship;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaMappingRelationship;
import org.eclipse.jpt.jpa.core.internal.context.java.GenericJavaMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.java.GenericJavaMappingJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaMappingJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.NullJavaJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaOneToManyRelationship
extends AbstractJavaMappingRelationship<JavaOneToManyMapping>
implements JavaOneToManyRelationship2_0 {
    protected final SpecifiedMappedByRelationshipStrategy mappedByStrategy = this.buildMappedByStrategy();
    protected final JavaSpecifiedJoinTableRelationshipStrategy joinTableStrategy;
    protected final boolean supportsJoinColumnStrategy;
    protected final JavaSpecifiedJoinColumnRelationshipStrategy joinColumnStrategy;

    public GenericJavaOneToManyRelationship(JavaOneToManyMapping parent, boolean supportsJoinColumnStrategy) {
        super(parent);
        this.supportsJoinColumnStrategy = supportsJoinColumnStrategy;
        this.joinColumnStrategy = this.buildJoinColumnStrategy();
        this.joinTableStrategy = this.buildJoinTableStrategy();
        this.strategy = this.buildStrategy();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.mappedByStrategy.synchronizeWithResourceModel();
        this.joinColumnStrategy.synchronizeWithResourceModel();
        this.joinTableStrategy.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.mappedByStrategy.update();
        this.joinColumnStrategy.update();
        this.joinTableStrategy.update();
    }

    @Override
    protected SpecifiedRelationshipStrategy buildStrategy() {
        if (this.mappedByStrategy.getMappedByAttribute() != null) {
            return this.mappedByStrategy;
        }
        if (this.supportsJoinColumnStrategy && this.joinColumnStrategy.hasSpecifiedJoinColumns()) {
            return this.joinColumnStrategy;
        }
        return this.joinTableStrategy;
    }

    @Override
    public SpecifiedMappedByRelationshipStrategy getMappedByStrategy() {
        return this.mappedByStrategy;
    }

    @Override
    public boolean strategyIsMappedBy() {
        return this.strategy == this.mappedByStrategy;
    }

    @Override
    public final void setStrategyToMappedBy() {
        this.mappedByStrategy.addStrategy();
        this.joinTableStrategy.removeStrategy();
        this.joinColumnStrategy.removeStrategy();
        this.updateStrategy();
    }

    @Override
    public boolean mayBeMappedBy(AttributeMapping mapping) {
        String key = mapping.getKey();
        if (key == "manyToOne") {
            return true;
        }
        if (this.supportsJoinColumnStrategy) {
            return key == "oneToOne";
        }
        return false;
    }

    protected SpecifiedMappedByRelationshipStrategy buildMappedByStrategy() {
        return new GenericJavaMappedByRelationshipStrategy(this);
    }

    @Override
    public JavaSpecifiedJoinTableRelationshipStrategy getJoinTableStrategy() {
        return this.joinTableStrategy;
    }

    @Override
    public boolean strategyIsJoinTable() {
        return this.strategy == this.joinTableStrategy;
    }

    @Override
    public final void setStrategyToJoinTable() {
        this.mappedByStrategy.removeStrategy();
        this.joinColumnStrategy.removeStrategy();
        this.updateStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinTable() {
        return this.mappedByStrategy.getMappedByAttribute() == null && !this.joinColumnStrategy.hasSpecifiedJoinColumns();
    }

    protected JavaSpecifiedJoinTableRelationshipStrategy buildJoinTableStrategy() {
        return new GenericJavaMappingJoinTableRelationshipStrategy(this);
    }

    @Override
    public JavaSpecifiedJoinColumnRelationshipStrategy getJoinColumnStrategy() {
        return this.joinColumnStrategy;
    }

    @Override
    public boolean strategyIsJoinColumn() {
        return this.strategy == this.joinColumnStrategy;
    }

    @Override
    public void setStrategyToJoinColumn() {
        this.joinColumnStrategy.addStrategy();
        this.mappedByStrategy.removeStrategy();
        this.joinTableStrategy.removeStrategy();
        this.updateStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinColumn() {
        return false;
    }

    protected JavaSpecifiedJoinColumnRelationshipStrategy buildJoinColumnStrategy() {
        return this.supportsJoinColumnStrategy ? new GenericJavaMappingJoinColumnRelationshipStrategy(this, true) : new NullJavaJoinColumnRelationshipStrategy(this);
    }

    @Override
    public void initializeOn(SpecifiedRelationship newRelationship) {
        newRelationship.initializeFromMappedByRelationship(this);
        newRelationship.initializeFromJoinTableRelationship(this);
        newRelationship.initializeFromJoinColumnRelationship(this);
    }

    @Override
    public void initializeFromMappedByRelationship(MappedByRelationship oldRelationship) {
        super.initializeFromMappedByRelationship(oldRelationship);
        this.mappedByStrategy.initializeFrom(oldRelationship.getMappedByStrategy());
    }

    @Override
    public void initializeFromJoinTableRelationship(JoinTableRelationship oldRelationship) {
        super.initializeFromJoinTableRelationship(oldRelationship);
        this.joinTableStrategy.initializeFrom(oldRelationship.getJoinTableStrategy());
    }

    @Override
    public void initializeFromJoinColumnRelationship(JoinColumnRelationship oldRelationship) {
        super.initializeFromJoinColumnRelationship(oldRelationship);
        this.joinColumnStrategy.initializeFrom(oldRelationship.getJoinColumnStrategy());
    }

    @Override
    public OneToManyAnnotation getMappingAnnotation() {
        return ((JavaOneToManyMapping)this.getMapping()).getMappingAnnotation();
    }

    @Override
    public OneToManyAnnotation getMappingAnnotationForUpdate() {
        return ((JavaOneToManyMapping)this.getMapping()).getAnnotationForUpdate();
    }

    @Override
    public boolean isOwner() {
        return this.mappedByStrategy.getMappedByAttribute() == null;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.mappedByStrategy.relationshipIsOwnedBy(mapping);
    }

    @Override
    public boolean isTargetForeignKey() {
        return this.joinColumnStrategy.isTargetForeignKey();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.mappedByStrategy.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.joinTableStrategy.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return this.joinColumnStrategy.getCompletionProposals(pos);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.mappedByStrategy.validate(messages, reporter);
        this.joinTableStrategy.validate(messages, reporter);
        this.joinColumnStrategy.validate(messages, reporter);
    }
}

