/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.parser.ASTArithmeticIfStmtNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class RemoveArithmeticIfRefactoring
extends FortranResourceRefactoring {
    public String getName() {
        return Messages.RemoveArithmeticIfRefactoring_Name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError(Messages.bind((String)Messages.RemoveArithmeticIfRefactoring_Error, (Object)file.getName()));
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) {
        if (ast == null) {
            return;
        }
        List<ASTArithmeticIfStmtNode> nodesToReplace = this.findNodesToReplace(ast);
        if (!nodesToReplace.isEmpty()) {
            for (ASTArithmeticIfStmtNode node : nodesToReplace) {
                this.replaceNode(node, ast);
            }
            this.addChangeFromModifiedAST(file, pm);
        }
    }

    private List<ASTArithmeticIfStmtNode> findNodesToReplace(IFortranAST ast) {
        final LinkedList<ASTArithmeticIfStmtNode> result = new LinkedList<ASTArithmeticIfStmtNode>();
        ast.accept(new GenericASTVisitor(){

            @Override
            public void visitASTArithmeticIfStmtNode(ASTArithmeticIfStmtNode node) {
                result.add(node);
            }
        });
        return result;
    }

    private void replaceNode(ASTArithmeticIfStmtNode node, IFortranAST ast) {
        String first = node.getFirst().getLabel().getText();
        String second = node.getSecond().getLabel().getText();
        String third = node.getThird().getLabel().getText();
        String conditionVariable = node.getExpr().toString();
        String newNodeString = node.findFirstToken().getWhiteBefore();
        if (node.getLabel() != null) {
            newNodeString = String.valueOf(newNodeString) + node.getLabel().getText() + " ";
        }
        newNodeString = String.valueOf(newNodeString) + "if(" + conditionVariable + "< 0) then" + node.findLastToken().getWhiteBefore() + "\ngoto " + first + "\nelse if(" + conditionVariable + " == 0) then " + "\ngoto " + second + "\nelse " + "\ngoto " + third + "\nend if";
        IBodyConstruct newnode = RemoveArithmeticIfRefactoring.parseLiteralStatement(newNodeString);
        node.replaceWith(newnode);
        Reindenter.reindent(newnode, ast, Reindenter.Strategy.REINDENT_EACH_LINE);
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }
}

