/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTElseConstructNode;
import org.eclipse.photran.internal.core.parser.ASTElseIfConstructNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTIfConstructNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class ConvertIfThenElseToSelectCaseRefactoring
extends FortranResourceRefactoring {
    List<ASTIfConstructNode> ifNodes = new LinkedList<ASTIfConstructNode>();
    List<ASTIfConstructNode> removeIfNodes = new LinkedList<ASTIfConstructNode>();
    List<String> varNames = new LinkedList<String>();
    List<String> cases = new LinkedList<String>();
    List<String> bodyCases = new LinkedList<String>();

    public String getName() {
        return "Convert If-Then-Else To Select Case";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                    continue;
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        boolean hasChanged = false;
        List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
        for (ScopingNode scope : scopes) {
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) continue;
            IASTListNode<? extends IASTNode> body = scope.getBody();
            for (IASTNode iASTNode : body) {
                ASTIfConstructNode ifNode;
                if (!(iASTNode instanceof ASTIfConstructNode) || (ifNode = (ASTIfConstructNode)iASTNode).getElseIfConstruct() == null) continue;
                this.ifNodes.add((ASTIfConstructNode)iASTNode);
            }
        }
        for (ASTIfConstructNode ifNode : this.ifNodes) {
            this.parserStmts(ifNode, null);
        }
        this.ifNodes.removeAll(this.removeIfNodes);
        for (ASTIfConstructNode ifNode : this.ifNodes) {
            this.getPairs(ifNode, null);
            if (this.hasSameVars()) {
                void var10_14;
                hasChanged = true;
                String[] tabWithComments = ifNode.findFirstToken().getWhiteBefore().toString().split("\n");
                String string = tabWithComments[tabWithComments.length - 1];
                int i = 0;
                while (i < string.length()) {
                    if (string.charAt(i) != ' ' && string.charAt(i) != '\t') {
                        String string2 = "";
                        break;
                    }
                    ++i;
                }
                String selectCaseNode = "SELECT CASE (" + this.varNames.get(0).trim() + ")\n";
                int i2 = 0;
                while (i2 < this.cases.size()) {
                    String[] body;
                    String casesUnits = String.valueOf(var10_14) + "\tCASE " + this.cases.get(i2).trim() + "\n";
                    String[] stringArray = body = this.bodyCases.get(i2).split("\n");
                    int n = body.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bodyLine = stringArray[n2];
                        casesUnits = String.valueOf(casesUnits) + (String)var10_14 + "\t\t" + bodyLine.trim() + "\n";
                        ++n2;
                    }
                    selectCaseNode = String.valueOf(selectCaseNode) + casesUnits;
                    ++i2;
                }
                selectCaseNode = String.valueOf(selectCaseNode) + (String)var10_14 + "END SELECT\n";
                ifNode.replaceWith(selectCaseNode);
                this.varNames.clear();
                this.cases.clear();
                this.bodyCases.clear();
                continue;
            }
            this.varNames.clear();
            this.cases.clear();
            this.bodyCases.clear();
        }
        if (hasChanged) {
            this.addChangeFromModifiedAST(file, pm);
        }
    }

    private boolean hasSameVars() {
        int i = 0;
        while (i < this.varNames.size() - 1) {
            if (!this.varNames.get(i).equalsIgnoreCase(this.varNames.get(i + 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void getPairs(ASTIfConstructNode ifNode, ASTElseIfConstructNode elseIfNode) {
        if (elseIfNode == null) {
            String[] orSplit;
            String ifExpression = ifNode.getIfThenStmt().getGuardingExpression().toString().trim();
            ifExpression = ifExpression.replaceAll(".OR.", ".or.");
            ifExpression = ifExpression.replaceAll(".Or.", ".or.");
            ifExpression = ifExpression.replaceAll(".oR.", ".or.");
            ifExpression = ifExpression.replaceAll(".EQ.", "==");
            ifExpression = ifExpression.replaceAll(".Eq.", "==");
            ifExpression = ifExpression.replaceAll(".eQ.", "==");
            ifExpression = ifExpression.replaceAll(".eq.", "==");
            String[] stringArray = orSplit = ifExpression.split(".or.");
            int n = orSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String[] eqSplit;
                String s = stringArray[n2];
                s = s.trim();
                String[] stringArray2 = eqSplit = s.split("==");
                int n3 = eqSplit.length;
                int n4 = 0;
                while (n4 < n3) {
                    String seq = stringArray2[n4];
                    seq = seq.trim();
                    ++n4;
                }
                int i = 0;
                while (i < eqSplit.length) {
                    this.varNames.add(eqSplit[i]);
                    this.cases.add("(" + eqSplit[i + 1].trim() + ")");
                    this.bodyCases.add(ifNode.getConditionalBody().toString());
                    i += 2;
                }
                ++n2;
            }
            ASTElseIfConstructNode elseIf = ifNode.getElseIfConstruct();
            if (elseIf != null) {
                this.getPairs(ifNode, elseIf);
            }
        } else {
            String[] orSplit;
            String elseIfExpression = elseIfNode.getElseIfStmt().getGuardingExpression().toString().trim();
            elseIfExpression = elseIfExpression.replaceAll(".OR.", ".or.");
            elseIfExpression = elseIfExpression.replaceAll(".Or.", ".or.");
            elseIfExpression = elseIfExpression.replaceAll(".oR.", ".or.");
            elseIfExpression = elseIfExpression.replaceAll(".EQ.", "==");
            elseIfExpression = elseIfExpression.replaceAll(".Eq.", "==");
            elseIfExpression = elseIfExpression.replaceAll(".eQ.", "==");
            elseIfExpression = elseIfExpression.replaceAll(".eq.", "==");
            String[] stringArray = orSplit = elseIfExpression.split(".or.");
            int n = orSplit.length;
            int n5 = 0;
            while (n5 < n) {
                String[] eqSplit;
                String s = stringArray[n5];
                s = s.trim();
                String[] stringArray3 = eqSplit = s.split("==");
                int n6 = eqSplit.length;
                int n7 = 0;
                while (n7 < n6) {
                    String seq = stringArray3[n7];
                    seq = seq.trim();
                    ++n7;
                }
                int i = 0;
                while (i < eqSplit.length) {
                    this.varNames.add(eqSplit[i]);
                    this.cases.add("(" + eqSplit[i + 1].trim() + ")");
                    this.bodyCases.add(elseIfNode.getConditionalBody().toString());
                    i += 2;
                }
                ++n5;
            }
            ASTElseIfConstructNode elseIf = elseIfNode.getElseIfConstruct();
            if (elseIf != null) {
                this.getPairs(ifNode, elseIf);
            } else {
                ASTElseConstructNode elseDefault = elseIfNode.getElseConstruct();
                if (elseDefault != null) {
                    String elseDefaultExpression = elseDefault.getConditionalBody().toString();
                    this.cases.add("DEFAULT");
                    this.bodyCases.add(elseDefaultExpression);
                }
            }
        }
    }

    private void parserStmts(ASTIfConstructNode ifNode, ASTElseIfConstructNode elseIfNode) {
        String[] not_aloowed = new String[]{">", ".GT.", "<", ".LT.", ">=", ".GE.", "<=", ".LE.", "/=", ".NE.", ".AND.", ".EQV.", ".NEQV.", ".gt.", ".lt.", ".ge.", ".le.", ".ne.", ".and.", ".eqv.", ".neqv."};
        if (elseIfNode == null) {
            String ifExpression = ifNode.getIfThenStmt().getGuardingExpression().toString().trim();
            String[] stringArray = not_aloowed;
            int n = not_aloowed.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (ifExpression.contains(s)) {
                    this.removeIfNodes.add(ifNode);
                    return;
                }
                ++n2;
            }
            ASTElseIfConstructNode elseIf = ifNode.getElseIfConstruct();
            if (elseIf != null) {
                this.parserStmts(ifNode, elseIf);
            }
        } else {
            String elseIfExpression = elseIfNode.getElseIfStmt().getGuardingExpression().toString().trim();
            String[] stringArray = not_aloowed;
            int n = not_aloowed.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                if (elseIfExpression.contains(s)) {
                    this.removeIfNodes.add(ifNode);
                    return;
                }
                ++n3;
            }
            ASTElseIfConstructNode elseIf = elseIfNode.getElseIfConstruct();
            if (elseIf != null) {
                this.parserStmts(ifNode, elseIf);
            }
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }
}

