/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.photran.internal.core.analysis.types.DerivedType;
import org.eclipse.photran.internal.core.analysis.types.FunctionType;
import org.eclipse.photran.internal.core.analysis.types.TypeProcessor;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

public abstract class Type
implements IPhotranSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Type INTEGER = new PrimitiveType(){

        @Override
        public String toString() {
            return "integer";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "int";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifInteger(this);
        }

        @Override
        public Type getCommonType(Type other) {
            return this.processUsing(new TypeProcessor<Type>(){

                @Override
                public Type ifComplex(Type type) {
                    return COMPLEX;
                }

                @Override
                public Type ifDoublePrecision(Type type) {
                    return DOUBLEPRECISION;
                }

                @Override
                public Type ifInteger(Type type) {
                    return INTEGER;
                }

                @Override
                public Type ifReal(Type type) {
                    return REAL;
                }
            });
        }
    };
    public static Type REAL = new PrimitiveType(){

        @Override
        public String toString() {
            return "real";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "rea";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifReal(this);
        }

        @Override
        public Type getCommonType(Type other) {
            return this.processUsing(new TypeProcessor<Type>(){

                @Override
                public Type ifComplex(Type type) {
                    return COMPLEX;
                }

                @Override
                public Type ifDoublePrecision(Type type) {
                    return DOUBLEPRECISION;
                }

                @Override
                public Type ifInteger(Type type) {
                    return REAL;
                }

                @Override
                public Type ifReal(Type type) {
                    return REAL;
                }
            });
        }
    };
    public static Type DOUBLEPRECISION = new PrimitiveType(){

        @Override
        public String toString() {
            return "double precision";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "dbl";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifDoublePrecision(this);
        }

        @Override
        public Type getCommonType(Type other) {
            return this.processUsing(new TypeProcessor<Type>(){

                @Override
                public Type ifComplex(Type type) {
                    return COMPLEX;
                }

                @Override
                public Type ifDoublePrecision(Type type) {
                    return DOUBLEPRECISION;
                }

                @Override
                public Type ifInteger(Type type) {
                    return DOUBLEPRECISION;
                }

                @Override
                public Type ifReal(Type type) {
                    return DOUBLEPRECISION;
                }
            });
        }
    };
    public static Type COMPLEX = new PrimitiveType(){

        @Override
        public String toString() {
            return "complex";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "cpx";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifComplex(this);
        }

        @Override
        public Type getCommonType(Type other) {
            return this.processUsing(new TypeProcessor<Type>(){

                @Override
                public Type ifComplex(Type type) {
                    return COMPLEX;
                }

                @Override
                public Type ifDoublePrecision(Type type) {
                    return COMPLEX;
                }

                @Override
                public Type ifInteger(Type type) {
                    return COMPLEX;
                }

                @Override
                public Type ifReal(Type type) {
                    return COMPLEX;
                }
            });
        }
    };
    public static Type DOUBLECOMPLEX = new PrimitiveType(){

        @Override
        public String toString() {
            return "doublecomplex";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "dcx";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifDoubleComplex(this);
        }

        @Override
        public Type getCommonType(Type other) {
            return this.processUsing(new TypeProcessor<Type>(){

                @Override
                public Type ifComplex(Type type) {
                    return DOUBLECOMPLEX;
                }

                @Override
                public Type ifDoublePrecision(Type type) {
                    return DOUBLECOMPLEX;
                }

                @Override
                public Type ifInteger(Type type) {
                    return DOUBLECOMPLEX;
                }

                @Override
                public Type ifReal(Type type) {
                    return DOUBLECOMPLEX;
                }
            });
        }
    };
    public static Type LOGICAL = new PrimitiveType(){

        @Override
        public String toString() {
            return "logical";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "log";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifLogical(this);
        }
    };
    public static Type CHARACTER = new PrimitiveType(){

        @Override
        public String toString() {
            return "character";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "chr";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifCharacter(this);
        }
    };
    public static Type UNKNOWN = new PrimitiveType(){

        @Override
        public String toString() {
            return "(unknown)";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "unk";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifUnknown(this);
        }
    };
    public static Type VOID = new PrimitiveType(){

        @Override
        public String toString() {
            return "(unclassified)";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "voi";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifUnclassified(this);
        }
    };
    public static Type TYPE_ERROR = new PrimitiveType(){

        @Override
        public String toString() {
            return "(type error)";
        }

        @Override
        public String getThreeLetterTypeSerializationCode() {
            return "err";
        }

        @Override
        public <T> T processUsing(TypeProcessor<T> p) {
            return p.ifError(this);
        }
    };
    private static Map<String, Object> threeLetterTypeSerializationCodes = new HashMap<String, Object>();

    static {
        Type.setThreeLetterTypeSerializationCode(INTEGER);
        Type.setThreeLetterTypeSerializationCode(REAL);
        Type.setThreeLetterTypeSerializationCode(DOUBLEPRECISION);
        Type.setThreeLetterTypeSerializationCode(COMPLEX);
        Type.setThreeLetterTypeSerializationCode(DOUBLECOMPLEX);
        Type.setThreeLetterTypeSerializationCode(LOGICAL);
        Type.setThreeLetterTypeSerializationCode(CHARACTER);
        Type.setThreeLetterTypeSerializationCode(UNKNOWN);
        Type.setThreeLetterTypeSerializationCode(VOID);
        Type.setThreeLetterTypeSerializationCode(TYPE_ERROR);
        Type.setThreeLetterSerializationCode(DerivedType.class);
        Type.setThreeLetterSerializationCode(FunctionType.class);
    }

    public abstract String toString();

    public abstract String getThreeLetterTypeSerializationCode();

    abstract void finishWriteTo(OutputStream var1) throws IOException;

    public abstract <T> T processUsing(TypeProcessor<T> var1);

    public Type getCommonType(Type another) {
        return this.equals(another) ? this : null;
    }

    public boolean equals(Object other) {
        return other instanceof Type && ((Type)other).toString().equals(this.toString());
    }

    public static Type parse(ASTTypeSpecNode node) {
        if (node.isInteger()) {
            return INTEGER;
        }
        if (node.isReal()) {
            return REAL;
        }
        if (node.isDouble()) {
            return DOUBLEPRECISION;
        }
        if (node.isComplex()) {
            return COMPLEX;
        }
        if (node.isDblComplex()) {
            return DOUBLECOMPLEX;
        }
        if (node.isLogical()) {
            return LOGICAL;
        }
        if (node.isCharacter()) {
            return CHARACTER;
        }
        if (node.isDerivedType()) {
            return node.getTypeName() == null ? new DerivedType("") : new DerivedType(node.getTypeName().getText());
        }
        throw new Error("Unexpected case parsing <TypeSpec> node");
    }

    private static void setThreeLetterTypeSerializationCode(Type type) {
        String code = type.getThreeLetterTypeSerializationCode();
        Type.checkCode(code);
        threeLetterTypeSerializationCodes.put(code, type);
    }

    private static void setThreeLetterSerializationCode(Class<? extends Type> typeClass) {
        threeLetterTypeSerializationCodes.put((String)Type.invokeStatic("getStaticThreeLetterTypeSerializationCode", typeClass, new Class[0], new Object[0]), typeClass);
    }

    private static void checkCode(String code) {
        if (code == null || code.length() != 3) {
            throw new IllegalArgumentException("Invalid three-letter code for Type serialization: " + code);
        }
        if (threeLetterTypeSerializationCodes.containsKey(code)) {
            throw new IllegalArgumentException("Duplicate three-letter code for Type serialization: " + code);
        }
    }

    public static Type readFrom(InputStream in) throws IOException {
        String code = (String)PhotranVPGSerializer.deserialize(in);
        if (!threeLetterTypeSerializationCodes.containsKey(code)) {
            throw new IOException("Unrecognized type code: " + code);
        }
        Object o = threeLetterTypeSerializationCodes.get(code);
        if (o instanceof Type) {
            return (Type)o;
        }
        if (o instanceof Class) {
            return (Type)Type.invokeStatic("finishReadFrom", (Class)o, new Class[]{InputStream.class}, in);
        }
        throw new IOException();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.getThreeLetterTypeSerializationCode(), out);
        this.finishWriteTo(out);
    }

    @Override
    public char getSerializationCode() {
        return 'Y';
    }

    private static <T> T invokeStatic(String method, Class<?> o, Class<?>[] argTypes, Object ... args) {
        try {
            return (T)o.getMethod(method, argTypes).invoke(null, args);
        }
        catch (Exception e) {
            throw new Error(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage());
        }
    }

    private static abstract class PrimitiveType
    extends Type {
        private PrimitiveType() {
        }

        @Override
        final void finishWriteTo(OutputStream out) throws IOException {
        }
    }
}

