/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.analysis.types.FunctionType;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAcImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTAllocateObjectNode;
import org.eclipse.photran.internal.core.parser.ASTArrayElementNode;
import org.eclipse.photran.internal.core.parser.ASTAssignStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignedGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCPrimaryNode;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCaseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockObjectNode;
import org.eclipse.photran.internal.core.parser.ASTCommonStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCycleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDataImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTDataRefNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtValueNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEditElementNode;
import org.eclipse.photran.internal.core.parser.ASTElseIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTElseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTElseWhereStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndBlockDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndForallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndInterfaceStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSelectStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndWhereStmtNode;
import org.eclipse.photran.internal.core.parser.ASTExitStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFieldSelectorNode;
import org.eclipse.photran.internal.core.parser.ASTFinalBindingNode;
import org.eclipse.photran.internal.core.parser.ASTForallTripletSpecListNode;
import org.eclipse.photran.internal.core.parser.ASTFormatStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionArgListNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionArgNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionParNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTGenericBindingNode;
import org.eclipse.photran.internal.core.parser.ASTInputImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTIoControlSpecNode;
import org.eclipse.photran.internal.core.parser.ASTLoopControlNode;
import org.eclipse.photran.internal.core.parser.ASTMaskedElseWhereStmtNode;
import org.eclipse.photran.internal.core.parser.ASTModuleProcedureStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNamedConstantUseNode;
import org.eclipse.photran.internal.core.parser.ASTNamelistGroupsNode;
import org.eclipse.photran.internal.core.parser.ASTNamelistStmtNode;
import org.eclipse.photran.internal.core.parser.ASTOutputImpliedDoNode;
import org.eclipse.photran.internal.core.parser.ASTPointerFieldNode;
import org.eclipse.photran.internal.core.parser.ASTPointerObjectNode;
import org.eclipse.photran.internal.core.parser.ASTProcedureNameListNode;
import org.eclipse.photran.internal.core.parser.ASTSFDataRefNode;
import org.eclipse.photran.internal.core.parser.ASTSFDummyArgNameListNode;
import org.eclipse.photran.internal.core.parser.ASTSFExprListNode;
import org.eclipse.photran.internal.core.parser.ASTSFVarNameNode;
import org.eclipse.photran.internal.core.parser.ASTScalarVariableNode;
import org.eclipse.photran.internal.core.parser.ASTSectionSubscriptNode;
import org.eclipse.photran.internal.core.parser.ASTSpecificBindingNode;
import org.eclipse.photran.internal.core.parser.ASTStmtFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTStructureComponentNode;
import org.eclipse.photran.internal.core.parser.ASTStructureConstructorNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineArgNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeAttrSpecNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.ASTUFPrimaryNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.ASTVariableNode;
import org.eclipse.photran.internal.core.parser.ASTWaitSpecNode;
import org.eclipse.photran.internal.core.parser.ASTWaitStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.util.Pair;

class ReferenceCollector
extends BindingCollector {
    ReferenceCollector() {
    }

    private void markAccess(Token ident, VariableAccess access) {
        this.vpgProvider.markAccess(ident, access);
    }

    @Override
    public void visitASTFormatStmtNode(ASTFormatStmtNode node) {
    }

    @Override
    public void visitASTSFDataRefNode(ASTSFDataRefNode node) {
        super.traverseChildren(node);
        Token ident = node.getName();
        if (ident != null) {
            this.bind(ident);
            this.markAccess(ident, VariableAccess.READ);
        }
    }

    @Override
    public void visitASTCPrimaryNode(ASTCPrimaryNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            Token ident = node.getName().getName();
            this.bind(ident);
            this.markAccess(ident, VariableAccess.RW);
        }
    }

    @Override
    public void visitASTUFPrimaryNode(ASTUFPrimaryNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            Token ident = node.getName().getName();
            this.bind(ident);
            this.markAccess(ident, VariableAccess.RW);
        }
    }

    @Override
    public void visitASTNamedConstantUseNode(ASTNamedConstantUseNode node) {
        super.traverseChildren(node);
        Token ident = node.getName();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.READ);
    }

    @Override
    public void visitASTEndTypeStmtNode(ASTEndTypeStmtNode node) {
        super.traverseChildren(node);
        if (node.getTypeName() != null) {
            this.bind(node.getTypeName().getTypeName());
        }
    }

    @Override
    public void visitASTStructureConstructorNode(ASTStructureConstructorNode node) {
        super.traverseChildren(node);
        this.bind(node.getTypeName());
    }

    @Override
    public void visitASTAcImpliedDoNode(ASTAcImpliedDoNode node) {
        super.traverseChildren(node);
        Token ident = node.getImpliedDoVariable().getImpliedDoVariable();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.IMPLIED_DO);
    }

    @Override
    public void visitASTTypeSpecNode(ASTTypeSpecNode node) {
        super.traverseChildren(node);
        if (node.getTypeName() != null) {
            this.bind(node.getTypeName());
        }
    }

    @Override
    public void visitASTDataImpliedDoNode(ASTDataImpliedDoNode node) {
        super.traverseChildren(node);
        Token ident = node.getImpliedDoVariable();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.IMPLIED_DO);
    }

    @Override
    public void visitASTDataStmtValueNode(ASTDataStmtValueNode node) {
        super.traverseChildren(node);
        if (node.getNamedConstKind() != null) {
            Token ident = node.getNamedConstKind().getName();
            this.bind(ident);
            this.markAccess(ident, VariableAccess.READ);
        }
    }

    @Override
    public void visitASTNamelistStmtNode(ASTNamelistStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTNamelistGroupsNode> groups = node.getNamelistGroups();
        int i = 0;
        while (i < groups.size()) {
            this.bind(((ASTNamelistGroupsNode)groups.get(i)).getVariableName());
            ++i;
        }
    }

    @Override
    public void visitASTCommonStmtNode(ASTCommonStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTCommonBlockNode> list = node.getCommonBlockList();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            IASTListNode<ASTCommonBlockObjectNode> objects = ((ASTCommonBlockNode)list.get(i)).getCommonBlockObjectList();
            int j = 0;
            while (j < objects.size()) {
                ASTCommonBlockObjectNode obj = (ASTCommonBlockObjectNode)objects.get(j);
                List<PhotranTokenRef> bindings = this.bind(obj.getVariableName());
                if (obj.getArraySpec() != null) {
                    try {
                        for (PhotranTokenRef tr : bindings) {
                            Definition def = this.vpg.getDefinitionFor(tr);
                            def.setArraySpec(obj.getArraySpec());
                            this.vpgProvider.setDefinitionFor(tr, def);
                        }
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void visitASTScalarVariableNode(ASTScalarVariableNode node) {
        super.traverseChildren(node);
        Token ident = node.getVariableName();
        if (ident != null) {
            this.bind(ident);
            this.markAccess(ident, VariableAccess.WRITE);
        }
    }

    @Override
    public void visitASTDataRefNode(ASTDataRefNode node) {
        super.traverseChildren(node);
        Token ident = node.getName();
        if (ident != null) {
            if (!node.hasDerivedTypeComponentName() && node.getParent().getParent() instanceof ASTVariableNode) {
                this.bind(ident);
            } else if (!node.hasDerivedTypeComponentName() && node.getParent().getParent() instanceof ASTCallStmtNode) {
                this.bind(ident);
            } else {
                this.dontbind(ident);
            }
        }
        if (node.getName() != null) {
            this.dontbind(node.getName());
        }
    }

    @Override
    public void visitASTStructureComponentNode(ASTStructureComponentNode node) {
        super.traverseChildren(node);
        if (node.getVariableName() != null) {
            Token ident = node.getVariableName().getVariableName();
            this.bind(ident);
            this.markAccess(ident, VariableAccess.READ);
        }
    }

    @Override
    public void visitASTFieldSelectorNode(ASTFieldSelectorNode node) {
        super.traverseChildren(node);
        this.dontbind(node.getName());
    }

    @Override
    public void visitASTArrayElementNode(ASTArrayElementNode node) {
        super.traverseChildren(node);
        Token ident = node.getVariableName();
        if (ident != null) {
            this.bind(ident);
            this.markAccess(ident, VariableAccess.READ);
        }
    }

    @Override
    public void visitASTAllocateObjectNode(ASTAllocateObjectNode node) {
        super.traverseChildren(node);
        if (node.getVariableName() != null) {
            Token ident = node.getVariableName().getVariableName();
            this.bind(ident);
            this.markAccess(ident, VariableAccess.WRITE);
        }
    }

    @Override
    public void visitASTPointerObjectNode(ASTPointerObjectNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            Token ident = node.getName().getName();
            this.bind(ident);
            this.markAccess(ident, VariableAccess.WRITE);
        } else {
            IASTListNode<ASTPointerFieldNode> list = node.getPointerField();
            int i = 0;
            while (i < list.size()) {
                if (((ASTPointerFieldNode)list.get(i)).getName() != null) {
                    Token ident = ((ASTPointerFieldNode)list.get(i)).getName().getName();
                    this.bind(ident);
                    this.markAccess(ident, VariableAccess.WRITE);
                }
                if (((ASTPointerFieldNode)list.get(i)).getComponentName() != null) {
                    this.dontbind(((ASTPointerFieldNode)list.get(i)).getComponentName().getName());
                }
                if (((ASTPointerFieldNode)list.get(i)).getSFDummyArgNameList() != null) {
                    int j = 0;
                    while (j < ((ASTPointerFieldNode)list.get(i)).getSFDummyArgNameList().size()) {
                        Token ident = ((ASTSFDummyArgNameListNode)((ASTPointerFieldNode)list.get(i)).getSFDummyArgNameList().get(j)).getName();
                        this.bind(ident);
                        this.markAccess(ident, VariableAccess.READ);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
        IASTListNode<ASTFunctionArgListNode> list;
        super.traverseChildren(node);
        if (node.getName() != null && node.getName().getName() != null && node.getName().getName().getText().trim().length() > 0) {
            this.bind(node.getName().getName());
            this.markAccess(node.getName().getName(), this.determineAccess(node));
        }
        if ((list = node.getFunctionArgList()) != null) {
            int i = 0;
            while (i < list.size()) {
                if (((ASTFunctionArgListNode)list.get(i)).getFunctionArg() != null) {
                    this.dontbind(((ASTFunctionArgListNode)list.get(i)).getFunctionArg().getName());
                }
                ++i;
            }
        }
    }

    private VariableAccess determineAccess(ASTVarOrFnRefNode node) {
        if (this.isVariableExpr(node) && this.isSubprogramInvocationArg(node)) {
            return this.getSubprogramArgIntent(this.getSubprogramArgInfo(node));
        }
        return VariableAccess.READ;
    }

    private boolean isVariableExpr(ASTVarOrFnRefNode node) {
        return node.getName() != null && node.getFunctionArgList() == null && node.getPrimarySectionSubscriptList() == null && node.getSubstringRange() == null && node.getDerivedTypeComponentRef() == null && node.getComponentSectionSubscriptList() == null && node.getSubstringRange2() == null;
    }

    private boolean isSubprogramInvocationArg(ASTVarOrFnRefNode node) {
        return this.getSubprogramArgInfo(node) != null;
    }

    private Pair<Token, ? extends Object> getSubprogramArgInfo(ASTVarOrFnRefNode node) {
        Pair<Token, ? extends Object> result = this.getSubroutineArgInfo(node);
        if (result != null) {
            return result;
        }
        result = this.getFunctionArgInfo(node);
        if (result != null) {
            return result;
        }
        result = this.getPrimarySectionSubcriptInfo(node);
        return result;
    }

    private Pair<Token, ? extends Object> getSubroutineArgInfo(ASTVarOrFnRefNode node) {
        IASTNode parent = node.getParent();
        IASTNode grandparent = parent.getParent();
        if (grandparent == null) {
            return null;
        }
        IASTNode greatGrandparent = grandparent.getParent();
        if (greatGrandparent == null) {
            return null;
        }
        if (parent instanceof ASTSubroutineArgNode && greatGrandparent instanceof ASTCallStmtNode) {
            ASTCallStmtNode callStmt = (ASTCallStmtNode)greatGrandparent;
            ASTSubroutineArgNode argNode = (ASTSubroutineArgNode)parent;
            if (argNode.getName() != null) {
                return new Pair((Object)callStmt.getSubroutineName(), (Object)argNode.getName().getText());
            }
            return new Pair((Object)callStmt.getSubroutineName(), (Object)callStmt.getArgList().indexOf(parent));
        }
        return null;
    }

    private Pair<Token, String> getFunctionArgInfo(ASTVarOrFnRefNode node) {
        ASTVarOrFnRefNode fnCall;
        IASTNode parent = node.getParent();
        IASTNode grandparent = parent.getParent();
        if (grandparent == null) {
            return null;
        }
        IASTNode greatGrandparent = grandparent.getParent();
        if (greatGrandparent == null) {
            return null;
        }
        IASTNode greatGreatGrandparent = greatGrandparent.getParent();
        if (greatGreatGrandparent == null) {
            return null;
        }
        if (node.getParent() instanceof ASTFunctionArgNode && grandparent instanceof ASTFunctionArgListNode && greatGreatGrandparent instanceof ASTVarOrFnRefNode && (fnCall = (ASTVarOrFnRefNode)greatGreatGrandparent).getFunctionArgList() != null) {
            return new Pair((Object)fnCall.getName().getName(), (Object)((ASTFunctionArgNode)parent).getName().getText());
        }
        return null;
    }

    private Pair<Token, Integer> getPrimarySectionSubcriptInfo(ASTVarOrFnRefNode node) {
        ASTVarOrFnRefNode fnCall;
        IASTNode parent = node.getParent();
        IASTNode grandparent = parent.getParent();
        if (grandparent == null) {
            return null;
        }
        IASTNode greatGrandparent = grandparent.getParent();
        if (greatGrandparent == null) {
            return null;
        }
        if (parent instanceof ASTSectionSubscriptNode && greatGrandparent instanceof ASTVarOrFnRefNode && (fnCall = (ASTVarOrFnRefNode)greatGrandparent).getPrimarySectionSubscriptList() != null && fnCall.getPrimarySectionSubscriptList().contains(parent)) {
            return new Pair((Object)fnCall.getName().getName(), (Object)fnCall.getPrimarySectionSubscriptList().indexOf(parent));
        }
        return null;
    }

    private VariableAccess getSubprogramArgIntent(Pair<Token, ? extends Object> subprogramArgInfo) {
        List<PhotranTokenRef> bindings;
        Token subprogramName = (Token)subprogramArgInfo.fst;
        if (subprogramName != null && (bindings = this.bind(subprogramName)).size() >= 1) {
            return this.getSubprogramArgIntentFromDef(this.vpg.getDefinitionFor(bindings.get(0)), subprogramArgInfo.snd);
        }
        return VariableAccess.RW;
    }

    private VariableAccess getSubprogramArgIntentFromDef(Definition def, Object subprogramArg) {
        if (def != null && def.isSubprogram()) {
            Type fnType = def.getType();
            if (fnType instanceof FunctionType) {
                FunctionType functionType = (FunctionType)fnType;
                if (subprogramArg instanceof Integer) {
                    return functionType.getArgumentAccess((Integer)subprogramArg);
                }
                if (subprogramArg instanceof String) {
                    return functionType.getArgumentAccess((String)subprogramArg);
                }
            }
            return VariableAccess.RW;
        }
        return VariableAccess.READ;
    }

    @Override
    public void visitASTSFExprListNode(ASTSFExprListNode node) {
        super.traverseChildren(node);
        if (node.getSFDummyArgNameList() != null) {
            int j = 0;
            while (j < node.getSFDummyArgNameList().size()) {
                Token ident = ((ASTSFDummyArgNameListNode)node.getSFDummyArgNameList().get(j)).getName();
                this.bind(ident);
                this.markAccess(ident, VariableAccess.READ);
                ++j;
            }
        }
    }

    @Override
    public void visitASTSFVarNameNode(ASTSFVarNameNode node) {
        super.traverseChildren(node);
        Token ident = node.getName().getName();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.READ);
    }

    @Override
    public void visitASTAssignmentStmtNode(ASTAssignmentStmtNode node) {
        super.traverseChildren(node);
        Token lhsIdent = node.getLhsVariable().getName();
        this.bind(lhsIdent);
        this.markAccess(lhsIdent, VariableAccess.WRITE);
        if (node.getLhsNameList() != null) {
            int j = 0;
            while (j < node.getLhsNameList().size()) {
                Token ident = ((ASTSFDummyArgNameListNode)node.getLhsNameList().get(j)).getName();
                this.bind(ident);
                this.markAccess(ident, VariableAccess.READ);
                ++j;
            }
        }
    }

    @Override
    public void visitASTMaskedElseWhereStmtNode(ASTMaskedElseWhereStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTElseWhereStmtNode(ASTElseWhereStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndWhereStmtNode(ASTEndWhereStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTForallTripletSpecListNode(ASTForallTripletSpecListNode node) {
        super.traverseChildren(node);
        Token ident = node.getName().getName();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.FORALL);
    }

    @Override
    public void visitASTEndForallStmtNode(ASTEndForallStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTElseIfStmtNode(ASTElseIfStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTElseStmtNode(ASTElseStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndIfStmtNode(ASTEndIfStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTCaseStmtNode(ASTCaseStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName().getName());
        }
    }

    @Override
    public void visitASTEndSelectStmtNode(ASTEndSelectStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTLoopControlNode(ASTLoopControlNode node) {
        super.traverseChildren(node);
        Token ident = node.getVariableName();
        if (ident != null) {
            this.bind(ident);
            this.markAccess(ident, VariableAccess.WRITE);
        }
    }

    @Override
    public void visitASTEndDoStmtNode(ASTEndDoStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTCycleStmtNode(ASTCycleStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName());
        }
    }

    @Override
    public void visitASTExitStmtNode(ASTExitStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.bind(node.getName());
        }
    }

    @Override
    public void visitASTIoControlSpecNode(ASTIoControlSpecNode node) {
        super.traverseChildren(node);
        if (node.getNamelistGroupName() != null) {
            Token ident = node.getNamelistGroupName().getNamelistGroupName();
            this.bind(ident);
            this.markAccess(ident, VariableAccess.WRITE);
        }
    }

    @Override
    public void visitASTInputImpliedDoNode(ASTInputImpliedDoNode node) {
        super.traverseChildren(node);
        Token ident = node.getImpliedDoVariable();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.IMPLIED_DO);
    }

    @Override
    public void visitASTOutputImpliedDoNode(ASTOutputImpliedDoNode node) {
        super.traverseChildren(node);
        Token ident = node.getImpliedDoVariable();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.IMPLIED_DO);
    }

    @Override
    public void visitASTEditElementNode(ASTEditElementNode node) {
        super.traverseChildren(node);
        Token ident = node.getIdentifier();
        if (ident != null) {
            this.bind(ident);
            this.markAccess(ident, VariableAccess.READ);
        }
    }

    @Override
    public void visitASTEndProgramStmtNode(ASTEndProgramStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndModuleStmtNode(ASTEndModuleStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndBlockDataStmtNode(ASTEndBlockDataStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTEndInterfaceStmtNode(ASTEndInterfaceStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName().getEndName());
        }
    }

    @Override
    public void visitASTModuleProcedureStmtNode(ASTModuleProcedureStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTProcedureNameListNode> list = node.getProcedureNameList();
        int i = 0;
        while (i < list.size()) {
            this.bind(((ASTProcedureNameListNode)list.get(i)).getProcedureName());
            ++i;
        }
    }

    @Override
    public void visitASTCallStmtNode(ASTCallStmtNode node) {
        IASTListNode<ASTSubroutineArgNode> list;
        super.traverseChildren(node);
        if (node.getSubroutineName() != null) {
            this.bind(node.getSubroutineName());
        }
        if ((list = node.getArgList()) != null) {
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) != null && ((ASTSubroutineArgNode)list.get(i)).getName() != null) {
                    this.dontbind(((ASTSubroutineArgNode)list.get(i)).getName());
                }
                ++i;
            }
        }
    }

    @Override
    public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTFunctionParNode> list = node.getFunctionPars();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                this.bindAsParam(((ASTFunctionParNode)list.get(i)).getVariableName());
                ++i;
            }
        }
        if (node.hasResultClause()) {
            this.bind(node.getName());
        }
    }

    @Override
    public void visitASTEndFunctionStmtNode(ASTEndFunctionStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
        super.traverseChildren(node);
        if (node.getSubroutinePars() != null) {
            IASTListNode<ASTSubroutineParNode> list = node.getSubroutinePars();
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) != null && !((ASTSubroutineParNode)list.get(i)).isAsterisk()) {
                    this.bindAsParam(((ASTSubroutineParNode)list.get(i)).getVariableName());
                }
                ++i;
            }
        }
    }

    @Override
    public void visitASTEndSubroutineStmtNode(ASTEndSubroutineStmtNode node) {
        super.traverseChildren(node);
        if (node.getEndName() != null) {
            this.bind(node.getEndName());
        }
    }

    @Override
    public void visitASTStmtFunctionStmtNode(ASTStmtFunctionStmtNode node) {
        super.traverseChildren(node);
        Token functionName = node.getName().getName();
        this.bind(functionName);
        if (node.getSFDummyArgNameList() != null) {
            int j = 0;
            while (j < node.getSFDummyArgNameList().size()) {
                Token argName = ((ASTSFDummyArgNameListNode)node.getSFDummyArgNameList().get(j)).getName();
                this.bind(argName);
                this.markAccess(functionName, VariableAccess.STMT_FUNCTION_ARG);
                ++j;
            }
        }
    }

    @Override
    public void visitASTAssignStmtNode(ASTAssignStmtNode node) {
        super.traverseChildren(node);
        Token ident = node.getVariableName();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.WRITE);
    }

    @Override
    public void visitASTAssignedGotoStmtNode(ASTAssignedGotoStmtNode node) {
        super.traverseChildren(node);
        Token ident = node.getVariableName();
        this.bind(ident);
        this.markAccess(ident, VariableAccess.READ);
    }

    @Override
    public void visitASTDerivedTypeStmtNode(ASTDerivedTypeStmtNode node) {
        super.traverseChildren(node);
        if (node.getTypeAttrSpecList() != null) {
            for (ASTTypeAttrSpecNode spec : node.getTypeAttrSpecList()) {
                if (!spec.isExtends()) continue;
                this.bind(spec.getParentTypeName());
            }
        }
    }

    @Override
    public void visitASTSpecificBindingNode(ASTSpecificBindingNode node) {
        super.visitASTSpecificBindingNode(node);
        if (node.getInterfaceName() != null) {
            this.bind(node.getInterfaceName());
        }
        if (node.getProcedureName() != null) {
            this.setTypeBoundProcedureAttribInDefinition(this.bind(node.getProcedureName()), true);
        } else {
            this.setTypeBoundProcedureAttribInDefinition(this.bind(node.getBindingName()), false);
        }
    }

    private void setTypeBoundProcedureAttribInDefinition(List<PhotranTokenRef> definitionTokenRefs, boolean renamed) {
        for (PhotranTokenRef tokenRef : definitionTokenRefs) {
            Definition def = PhotranVPG.getInstance().getDefinitionFor(tokenRef);
            def.markAsTypeBoundProcedure(renamed);
            this.vpgProvider.setDefinitionFor(tokenRef, def);
        }
    }

    @Override
    public void visitASTGenericBindingNode(ASTGenericBindingNode node) {
        super.visitASTGenericBindingNode(node);
        for (Token name : node.getBindingNameList()) {
            this.bind(name);
        }
    }

    @Override
    public void visitASTFinalBindingNode(ASTFinalBindingNode node) {
        super.visitASTFinalBindingNode(node);
        for (Token name : node.getFinalSubroutineNameList()) {
            this.bind(name);
        }
    }

    @Override
    public void visitASTWaitStmtNode(ASTWaitStmtNode node) {
        super.traverseChildren(node);
        for (ASTWaitSpecNode waitSpec : node.getWaitSpecList()) {
            Token variable;
            String keyword;
            if (waitSpec.getKeyword() == null || !(keyword = waitSpec.getKeyword().getText().toLowerCase()).equals("id") && !keyword.equals("iomsg") && !keyword.equals("iostat") || (variable = waitSpec.getExpr().findFirstToken()) == null || variable.getTerminal() != Terminal.T_IDENT) continue;
            this.bind(variable);
            this.markAccess(variable, VariableAccess.WRITE);
        }
    }
}

