/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.sourcelookup;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.sourcelookup.PDESourceLookupDirector;

public class PDESourceLookupQuery
implements ISafeRunnable {
    protected static String OSGI_CLASSLOADER = "org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader";
    protected static String OSGI_CLASSLOADER2 = "org.eclipse.osgi.internal.loader.ModuleClassLoader";
    private static String LEGACY_ECLIPSE_CLASSLOADER = "org.eclipse.core.runtime.adaptor.EclipseClassLoader";
    private static String MAIN_CLASS = "org.eclipse.core.launcher.Main";
    private static String MAIN_PLUGIN = "org.eclipse.platform";
    private Object fElement;
    private Object fResult;
    private PDESourceLookupDirector fDirector;

    public PDESourceLookupQuery(PDESourceLookupDirector director, Object object) {
        this.fElement = object;
        this.fDirector = director;
    }

    public void handleException(Throwable exception) {
    }

    public void run() throws Exception {
        IJavaReferenceType declaringType = null;
        String sourcePath = null;
        if (this.fElement instanceof IJavaStackFrame) {
            IJavaStackFrame stackFrame = (IJavaStackFrame)this.fElement;
            declaringType = stackFrame.getReferenceType();
            sourcePath = stackFrame.getSourcePath();
        } else if (this.fElement instanceof IJavaObject) {
            IJavaType javaType = ((IJavaObject)this.fElement).getJavaType();
            if (javaType instanceof IJavaReferenceType) {
                declaringType = (IJavaReferenceType)javaType;
            }
        } else if (this.fElement instanceof IJavaReferenceType) {
            declaringType = (IJavaReferenceType)this.fElement;
        }
        if (declaringType != null) {
            IJavaObject classLoaderObject = declaringType.getClassLoaderObject();
            String declaringTypeName = declaringType.getName();
            if (sourcePath == null) {
                String[] sourcePaths = declaringType.getSourcePaths(null);
                if (sourcePaths != null) {
                    sourcePath = sourcePaths[0];
                }
                if (sourcePath == null) {
                    sourcePath = PDESourceLookupQuery.generateSourceName(declaringTypeName);
                }
            }
            if (classLoaderObject != null) {
                IPluginModelBase model;
                IJavaClassType type = (IJavaClassType)classLoaderObject.getJavaType();
                if (OSGI_CLASSLOADER.equals(type.getName())) {
                    this.fResult = this.fDirector.getOSGiRuntimeVersion() < 3.5 ? this.findSourceElement34(classLoaderObject, sourcePath) : this.findSourceElement(classLoaderObject, sourcePath);
                } else if (OSGI_CLASSLOADER2.equals(type.getName())) {
                    this.fResult = this.findSourceElement(classLoaderObject, sourcePath);
                } else if (LEGACY_ECLIPSE_CLASSLOADER.equals(type.getName())) {
                    this.fResult = this.findSourceElement_legacy(classLoaderObject, sourcePath);
                } else if (MAIN_CLASS.equals(declaringTypeName) && (model = PDECore.getDefault().getModelManager().findModel(MAIN_PLUGIN)) != null) {
                    this.fResult = this.getSourceElement(model.getInstallLocation(), MAIN_PLUGIN, sourcePath, true);
                }
            }
        }
    }

    protected Object getResult() {
        return this.fResult;
    }

    private String getValue(IJavaObject object, String variable) throws DebugException {
        IJavaFieldVariable var = object.getField(variable, false);
        return var == null ? null : var.getValue().getValueString();
    }

    protected Object findSourceElement34(IJavaObject object, String typeName) throws CoreException {
        IJavaObject data;
        IJavaObject manager = this.getObject(object, "manager", false);
        if (manager != null && (data = this.getObject(manager, "data", false)) != null) {
            String location = this.getValue(data, "fileName");
            String id = this.getValue(data, "symbolicName");
            return this.getSourceElement(location, id, typeName, true);
        }
        return null;
    }

    protected Object findSourceElement(IJavaObject object, String typeName) throws CoreException {
        IJavaObject manager = this.getObject(object, "manager", false);
        if (manager != null) {
            Object result = this.searchClasspathEntries(manager, typeName);
            if (result != null) {
                return result;
            }
            IJavaObject frgArray = this.getObject(manager, "fragments", false);
            if (frgArray instanceof IJavaArray) {
                IJavaArray fragments = (IJavaArray)frgArray;
                int i = 0;
                while (i < fragments.getLength()) {
                    IJavaObject fragment = (IJavaObject)fragments.getValue(i);
                    if (!fragment.isNull() && (result = this.searchClasspathEntries(fragment, typeName)) != null) {
                        return result;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private Object searchClasspathEntries(IJavaObject entriesOwner, String typeName) throws CoreException {
        IJavaObject cpeArray = this.getObject(entriesOwner, "entries", false);
        if (cpeArray instanceof IJavaArray) {
            IJavaArray entries = (IJavaArray)cpeArray;
            int i = 0;
            while (i < entries.getLength()) {
                String symbolicName;
                String location;
                Object el;
                IJavaObject fileName;
                IJavaObject baseData;
                IJavaObject entry = (IJavaObject)entries.getValue(i);
                if (!(entry.isNull() || (baseData = this.getObject(entry, "data", false)) == null || baseData.isNull() || (fileName = this.getObject(baseData, "fileName", false)) == null || fileName.isNull() || (el = this.getSourceElement(location = fileName.getValueString(), symbolicName = this.getValue(baseData, "symbolicName"), typeName, false)) == null)) {
                    return el;
                }
                ++i;
            }
        }
        return null;
    }

    private IJavaObject getObject(IJavaObject object, String field, boolean superfield) throws DebugException {
        IValue value;
        IJavaFieldVariable variable = object.getField(field, superfield);
        if (variable != null && (value = variable.getValue()) instanceof IJavaObject) {
            return (IJavaObject)value;
        }
        return null;
    }

    private Object findSourceElement_legacy(IJavaObject object, String typeName) throws CoreException {
        IJavaObject hostdata = this.getObject(object, "hostdata", true);
        if (hostdata != null) {
            String location = this.getValue(hostdata, "fileName");
            String id = this.getValue(hostdata, "symbolicName");
            return this.getSourceElement(location, id, typeName, true);
        }
        return null;
    }

    private Object getSourceElement(String location, String id, String typeName, boolean checkFragments) throws CoreException {
        if (location != null && id != null) {
            State state;
            BundleDescription desc;
            Object result = this.findSourceElement(this.getSourceContainers(location, id), typeName);
            if (result != null) {
                return result;
            }
            if (checkFragments && (desc = (state = TargetPlatformHelper.getState()).getBundle(id, null)) != null) {
                BundleDescription[] fragments = desc.getFragments();
                int i = 0;
                while (i < fragments.length) {
                    location = fragments[i].getLocation();
                    result = this.findSourceElement(this.getSourceContainers(location, id = fragments[i].getSymbolicName()), typeName);
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private Object findSourceElement(ISourceContainer[] containers, String typeName) throws CoreException {
        int i = 0;
        while (i < containers.length) {
            Object[] result = containers[i].findSourceElements(typeName);
            if (result.length > 0) {
                return result[0];
            }
            ++i;
        }
        return null;
    }

    protected ISourceContainer[] getSourceContainers(String location, String id) throws CoreException {
        return this.fDirector.getSourceContainers(location, id);
    }

    private static String generateSourceName(String qualifiedTypeName) {
        int index = qualifiedTypeName.indexOf(36);
        if (index >= 0) {
            qualifiedTypeName = qualifiedTypeName.substring(0, index);
        }
        return String.valueOf(qualifiedTypeName.replace('.', File.separatorChar)) + ".java";
    }
}

