/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class WorkingSetGroup {
    static final List<String> WORKING_SET_IDS = Arrays.asList("org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage");
    ComboViewer workingsetComboViewer;
    Button addToWorkingSetButton;
    final List<IWorkingSet> workingSets;
    final Shell shell;

    public WorkingSetGroup(Composite container, List<IWorkingSet> workingSets, Shell shell) {
        this.workingSets = workingSets;
        this.shell = shell;
        this.createControl(container);
    }

    private void createControl(Composite container) {
        this.addToWorkingSetButton = new Button(container, 32);
        GridData gd_addToWorkingSetButton = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_addToWorkingSetButton.verticalIndent = 12;
        this.addToWorkingSetButton.setLayoutData((Object)gd_addToWorkingSetButton);
        this.addToWorkingSetButton.setSelection(true);
        this.addToWorkingSetButton.setData("name", (Object)"addToWorkingSetButton");
        this.addToWorkingSetButton.setText(Messages.WorkingSetGroup_btnAddSet);
        this.addToWorkingSetButton.setSelection(false);
        final Label workingsetLabel = new Label(container, 0);
        GridData gd_workingsetLabel = new GridData();
        gd_workingsetLabel.horizontalIndent = 10;
        workingsetLabel.setLayoutData((Object)gd_workingsetLabel);
        workingsetLabel.setEnabled(false);
        workingsetLabel.setData("name", (Object)"workingsetLabel");
        workingsetLabel.setText(Messages.WorkingSetGroup_lblSet);
        Combo workingsetCombo = new Combo(container, 8);
        workingsetCombo.setEnabled(false);
        workingsetCombo.setData("name", (Object)"workingsetCombo");
        workingsetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.workingsetComboViewer = new ComboViewer(workingsetCombo);
        this.workingsetComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                if (input instanceof IWorkingSet[]) {
                    return (IWorkingSet[])input;
                }
                if (input instanceof List) {
                    return new Object[]{input};
                }
                if (input instanceof Set) {
                    return ((Set)input).toArray();
                }
                return new IWorkingSet[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.workingsetComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private ResourceManager images = new LocalResourceManager(JFaceResources.getResources());

            public Image getImage(Object element) {
                ImageDescriptor imageDescriptor;
                if (element instanceof IWorkingSet && (imageDescriptor = ((IWorkingSet)element).getImage()) != null) {
                    try {
                        return (Image)this.images.create((DeviceResourceDescriptor)imageDescriptor);
                    }
                    catch (DeviceResourceException deviceResourceException) {
                        return null;
                    }
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IWorkingSet) {
                    return ((IWorkingSet)element).getLabel();
                }
                if (element instanceof List) {
                    StringBuffer sb = new StringBuffer();
                    for (Object o : (List)element) {
                        if (!(o instanceof IWorkingSet)) continue;
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(((IWorkingSet)o).getLabel());
                    }
                    return sb.toString();
                }
                return super.getText(element);
            }

            public void dispose() {
                this.images.dispose();
                super.dispose();
            }
        });
        this.workingsetComboViewer.setComparator(new ViewerComparator());
        final Button newWorkingSetButton = new Button(container, 0);
        newWorkingSetButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        newWorkingSetButton.setData("name", (Object)"configureButton");
        newWorkingSetButton.setText(Messages.WorkingSetGroup_btnMore);
        newWorkingSetButton.setEnabled(false);
        newWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(WorkingSetGroup.this.shell, true, WORKING_SET_IDS.toArray(new String[0]));
                if (dialog.open() == 0) {
                    IWorkingSet[] workingSets = dialog.getSelection();
                    WorkingSetGroup.this.selectWorkingSets(Arrays.asList(workingSets));
                }
            }
        });
        if (this.selectWorkingSets(this.workingSets)) {
            this.addToWorkingSetButton.setSelection(true);
            workingsetLabel.setEnabled(true);
            this.workingsetComboViewer.getCombo().setEnabled(true);
            newWorkingSetButton.setEnabled(true);
        }
        this.addToWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean addToWorkingingSet = WorkingSetGroup.this.addToWorkingSetButton.getSelection();
                workingsetLabel.setEnabled(addToWorkingingSet);
                WorkingSetGroup.this.workingsetComboViewer.getCombo().setEnabled(addToWorkingingSet);
                newWorkingSetButton.setEnabled(addToWorkingingSet);
                if (addToWorkingingSet) {
                    WorkingSetGroup.this.updateConfiguration();
                } else {
                    WorkingSetGroup.this.workingSets.clear();
                }
            }
        });
        this.workingsetComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkingSetGroup.this.updateConfiguration();
            }
        });
    }

    protected void updateConfiguration() {
        IStructuredSelection selection;
        Object o;
        if (this.addToWorkingSetButton.getSelection() && (o = (selection = (IStructuredSelection)this.workingsetComboViewer.getSelection()).getFirstElement()) != null) {
            this.workingSets.clear();
            if (o instanceof IWorkingSet) {
                this.workingSets.add((IWorkingSet)o);
            } else if (o instanceof List) {
                List l = (List)o;
                this.workingSets.addAll(l);
            }
        }
    }

    Set<IWorkingSet> getWorkingSets() {
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (!workingSet.isEmpty()) {
                IAdaptable[] elements = workingSet.getElements();
                IResource resource = (IResource)elements[0].getAdapter(IResource.class);
                if (resource != null) {
                    workingSets.add(workingSet);
                }
            } else if (WORKING_SET_IDS.contains(workingSet.getId())) {
                workingSets.add(workingSet);
            }
            ++n2;
        }
        return workingSets;
    }

    public void dispose() {
        this.workingsetComboViewer.getLabelProvider().dispose();
    }

    protected boolean selectWorkingSets(List<IWorkingSet> workingSets) {
        Set<IWorkingSet> defaultSets = this.getWorkingSets();
        this.workingsetComboViewer.setInput(defaultSets);
        if (workingSets != null && workingSets.size() > 0) {
            if (workingSets.size() == 1) {
                IWorkingSet workingSet = workingSets.get(0);
                if (defaultSets.contains(workingSet)) {
                    this.workingsetComboViewer.setSelection((ISelection)new StructuredSelection((Object)workingSet));
                }
            } else {
                this.workingsetComboViewer.add(workingSets);
                this.workingsetComboViewer.setSelection((ISelection)new StructuredSelection(workingSets));
            }
            return true;
        }
        return false;
    }
}

