/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import practicallymacro.commands.EclipseCommand;
import practicallymacro.commands.FindCommand;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.commands.InsertStringCommand;
import practicallymacro.editormacros.Activator;
import practicallymacro.model.MacroManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static Map<Integer, Command> mFillInCommands = new HashMap<Integer, Command>();
    public static final String FillInPrefix = "practicallyMacro.styledTextCommand";
    private static Set<String> mEditCategories = new HashSet<String>();

    static {
        mEditCategories.add("practicallymacro.category.usermacros");
        mEditCategories.add("org.eclipse.ui.category.edit");
        mEditCategories.add("org.eclipse.ui.category.textEditor");
        mEditCategories.add("org.eclipse.jdt.ui.category.source");
        mEditCategories.add("org.eclipse.jdt.ui.category.refactoring");
        mEditCategories.add("practicallymacro.category.utility.command");
        mEditCategories.add("eclipse.ui.category.navigate");
        mEditCategories.add(FillInPrefix);
    }

    public static IEditorPart getActiveEditor() {
        IPartService partService;
        IWorkbenchPart part;
        IEditorPart editor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (part = (partService = window.getPartService()).getActivePart()) instanceof IEditorPart) {
            editor = (IEditorPart)part;
        }
        return editor;
    }

    public static ISourceViewer getSourceViewer(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        return viewer;
    }

    public static String getSelectedText(IEditorPart editor) {
        Point viewerSelection = Utilities.getUndirectedSelection(editor);
        IDocument doc = Utilities.getIDocumentForEditor(editor);
        try {
            if (doc.getLength() > viewerSelection.x) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
                if (page != null) {
                    Utilities.getUndirectedSelection(page.getActiveEditor());
                }
                return doc.get(viewerSelection.x, viewerSelection.y - viewerSelection.x);
            }
            return "";
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getSelectionAnchor(IEditorPart editor) {
        Point viewerSelection = Utilities.getUndirectedSelection(editor);
        int caretPos = Utilities.getCaretPos(editor);
        if (caretPos == viewerSelection.x) {
            return viewerSelection.y;
        }
        return viewerSelection.x;
    }

    public static int getCaretPos(IEditorPart editor) {
        Point viewerSelection = Utilities.getUndirectedSelection(editor);
        StyledText styled = Utilities.getStyledText(editor);
        int caretPos = styled.getCaretOffset();
        Point styledSel = styled.getSelection();
        if (caretPos == styledSel.x) {
            return viewerSelection.x;
        }
        return viewerSelection.y;
    }

    public static Point getUndirectedSelection(ISourceViewer viewer) {
        Point result = viewer.getSelectedRange();
        if (result.y >= 0) {
            return new Point(result.x, result.x + result.y);
        }
        return new Point(result.x + result.y, result.x);
    }

    public static Point getUndirectedSelection(IEditorPart editor) {
        ISourceViewer viewer = Utilities.getSourceViewer(editor);
        return Utilities.getUndirectedSelection(viewer);
    }

    public static StyledText getStyledText(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        StyledText styledText = null;
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        if (viewer != null) {
            styledText = viewer.getTextWidget();
        }
        return styledText;
    }

    private static Command getStyledTextCommand(int styledTextCode) {
        if (mFillInCommands.size() == 0) {
            Utilities.createStyledTextCommands();
        }
        return mFillInCommands.get(styledTextCode);
    }

    public static List<IMacroCommand> getMacroSupportCommands() {
        ArrayList<IMacroCommand> commands = new ArrayList<IMacroCommand>();
        commands.add(new InsertStringCommand(null));
        commands.addAll(MacroManager.getManager().getCanonicalScriptCommands());
        commands.add(new FindCommand(""));
        return commands;
    }

    public static void createStyledTextCommands() {
        if (mFillInCommands.size() > 0) {
            return;
        }
        int[] styledTextConstants = new int[]{8, 0x1000002, 17170435, 17039363, 16908291, 0x1000003, 17170436, 0x1040004, 16908292, 0x1000004, 0x1000001, 17170439, 17039367, 16908295, 0x1000007, 17170440, 17039368, 16908296, 0x1000008, 0x1060006, 17039366, 16908294, 0x1000006, 17170437, 17039365, 16908293, 0x1000005, 262271, 131199, 127, 17039369, 16908297, 0x1000009, 0x1020001, 0x1020002, 262152};
        ICommandService cs = MacroManager.getOldCommandService();
        Category cat = cs.getCategory(FillInPrefix);
        cat.define("Styled Text Commands", "");
        int i = 0;
        while (i < styledTextConstants.length) {
            int constant = styledTextConstants[i];
            Command newCommand = cs.getCommand("practicallyMacro.styledTextCommand." + Integer.toString(constant));
            newCommand.define(Utilities.getNameForStyledTextConstant(constant), "", cat);
            newCommand.setHandler((IHandler)new StyledTextHandler(constant));
            mFillInCommands.put(constant, newCommand);
            ++i;
        }
    }

    public static IMacroCommand getCommandForKeyEvent(Event event) {
        int key = 0x100FFFF & event.keyCode;
        if (key != 0 && !Character.isISOControl(event.character)) {
            return new InsertStringCommand(new String(new char[]{event.character}));
        }
        boolean isCtrl = (event.stateMask & SWT.MOD1) > 0;
        boolean isShift = (event.stateMask & SWT.MOD2) > 0;
        switch (key) {
            case 8: {
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(262152).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(8).getId());
            }
            case 0x1000002: {
                if (isShift && !isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1020002).getId());
                }
                if (!isCtrl && !isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1000002).getId());
                }
            }
            case 0x1000003: {
                if (isCtrl && isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170435).getId());
                }
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039363).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908291).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000003).getId());
            }
            case 0x1000004: {
                if (isCtrl && isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170436).getId());
                }
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1040004).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908292).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000004).getId());
            }
            case 0x1000001: {
                if (isShift && !isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1020001).getId());
                }
                if (!isCtrl && !isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1000001).getId());
                }
            }
            case 0x1000007: {
                if (isCtrl && isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170439).getId());
                }
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039367).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908295).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000007).getId());
            }
            case 0x1000008: {
                if (isCtrl && isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170440).getId());
                }
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039368).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908296).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000008).getId());
            }
            case 0x1000006: {
                if (isCtrl && isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1060006).getId());
                }
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039366).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908294).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000006).getId());
            }
            case 0x1000005: {
                if (isCtrl && isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170437).getId());
                }
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039365).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908293).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000005).getId());
            }
            case 127: {
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(262271).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(131199).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(127).getId());
            }
            case 0x1000009: {
                if (isCtrl) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039369).getId());
                }
                if (isShift) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908297).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000009).getId());
            }
        }
        if (key == 13 || key == 10) {
            return new InsertStringCommand(new String(new char[]{(char)key}));
        }
        if (key == 9) {
            return new InsertStringCommand(new String(new char[]{(char)key}));
        }
        return null;
    }

    public static String getNameForStyledTextConstant(int constant) {
        switch (constant) {
            case 8: {
                return "Delete previous character";
            }
            case 0x1000002: {
                return "Move cursor down";
            }
            case 17170435: {
                return "Select previous word";
            }
            case 17039363: {
                return "Move cursor to previous word";
            }
            case 16908291: {
                return "Select previous character";
            }
            case 0x1000003: {
                return "Move cursor left";
            }
            case 17170436: {
                return "Select next word";
            }
            case 0x1040004: {
                return "Move cursor to next word";
            }
            case 16908292: {
                return "Select next character";
            }
            case 0x1000004: {
                return "Move cursor right";
            }
            case 0x1000001: {
                return "Move cursor up";
            }
            case 17170439: {
                return "Select to start of document";
            }
            case 17039367: {
                return "Move cursor to start of document";
            }
            case 16908295: {
                return "Select to line start";
            }
            case 0x1000007: {
                return "Move cursor to line start";
            }
            case 17170440: {
                return "Select to end of document";
            }
            case 17039368: {
                return "Move cursor to end of document";
            }
            case 16908296: {
                return "Select to end of line";
            }
            case 0x1000008: {
                return "Move cursor to end of line";
            }
            case 0x1060006: {
                return "Select to window end";
            }
            case 17039366: {
                return "Move cursor to window end";
            }
            case 16908294: {
                return "Select page down";
            }
            case 0x1000006: {
                return "Move cursor down a page";
            }
            case 17170437: {
                return "Select to window start";
            }
            case 17039365: {
                return "Move cursor to window start";
            }
            case 16908293: {
                return "Select page up";
            }
            case 0x1000005: {
                return "Move cursor up a page";
            }
            case 262271: {
                return "Delete next word";
            }
            case 262152: {
                return "Delete previous word";
            }
            case 131199: {
                return "Cut";
            }
            case 127: {
                return "Delete next character";
            }
            case 17039369: {
                return "Copy";
            }
            case 16908297: {
                return "Paste";
            }
            case 0x1000009: {
                return "Toggle overwrite mode";
            }
            case 0x1020002: {
                return "Select line down";
            }
            case 0x1020001: {
                return "Select line up";
            }
        }
        return "Unknown constant";
    }

    public static boolean isEditCategory(String categoryID) {
        System.out.println("category test:" + categoryID);
        return mEditCategories.contains(categoryID);
    }

    public static IFindReplaceTarget getFindReplaceTarget(IEditorPart editor) {
        IFindReplaceTarget target = (IFindReplaceTarget)editor.getAdapter(IFindReplaceTarget.class);
        return target;
    }

    public static void persistCommand(Document doc, Element commandElement, String type, Map<String, String> attrs, Map<String, String> data) {
        commandElement.setAttribute("type", type);
        if (attrs != null) {
            for (String attr : attrs.keySet()) {
                commandElement.setAttribute(attr, attrs.get(attr));
            }
        }
        if (data != null) {
            for (String dataTag : data.keySet()) {
                String dataContent = data.get(dataTag);
                Element dataChild = doc.createElement(dataTag);
                CDATASection cdataContent = doc.createCDATASection(dataContent);
                commandElement.appendChild(dataChild);
                dataChild.appendChild(cdataContent);
            }
        }
    }

    public static void getCommandData(Element commandElement, Set<String> attrKeys, Set<String> dataKeys, Map<String, String> attrMap, Map<String, String> dataMap) {
        if (attrMap != null) {
            for (String attrName : attrKeys) {
                String attrValue = commandElement.getAttribute(attrName);
                attrMap.put(attrName, attrValue);
            }
        }
        if (dataMap != null) {
            NodeList children = commandElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                String tagName = children.item(i).getNodeName();
                if (dataKeys.contains(tagName)) {
                    String data = children.item(i).getTextContent();
                    dataMap.put(tagName, data);
                }
                ++i;
            }
        }
    }

    public static IDocument getIDocumentForEditor(IEditorPart editor) {
        try {
            AbstractTextEditor activeEd = (AbstractTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IDocument document = activeEd.getDocumentProvider().getDocument((Object)activeEd.getEditorInput());
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSupportCategory(String categoryID) {
        return categoryID.equals("practicallymacro.category.utility.command");
    }

    public static boolean isUserMacroCategory(String categoryID) {
        return categoryID.equals("practicallymacro.category.usermacros");
    }

    public static boolean isUserMacro(IMacroCommand macroCommand) {
        return Utilities.isUserMacroCategory(macroCommand.getCategoryID());
    }

    public static IPreferenceStore getMainPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    static class StyledTextHandler
    implements IHandler {
        private int mStyledTextAction;

        public StyledTextHandler(int styledTextConstant) {
            this.mStyledTextAction = styledTextConstant;
        }

        public void addHandlerListener(IHandlerListener handlerListener) {
        }

        public void dispose() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            IEditorPart target = Utilities.getActiveEditor();
            Utilities.getStyledText(target).invokeAction(this.mStyledTextAction);
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isHandled() {
            return true;
        }

        public void removeHandlerListener(IHandlerListener handlerListener) {
        }
    }
}

