/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import practicallymacro.actions.RecordCommandAction;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.commands.IMacroScriptSupport;
import practicallymacro.commands.MacroHandler;
import practicallymacro.commands.MacroScriptCommand;
import practicallymacro.editormacros.Activator;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroRecorder;
import practicallymacro.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroManager {
    public static final String MacroCommandCategory = "PracticallyMacro utility command";
    public static final String MacroCommandCategoryID = "practicallymacro.category.utility.command";
    public static final String UserMacroCategoryID = "practicallymacro.category.usermacros";
    public static final String UserMacroCategoryName = "User defined editor macros";
    private static MacroManager mManager;
    private Map<String, EditorMacro> mMacroMap;
    private List<EditorMacro> mTemporaryMacros;
    private Map<String, IMacroCommand> mXMLCommandHandlerMap = new HashMap<String, IMacroCommand>();
    private List<EditorMacro> mMacroStack;
    private int mCommandsExecuted;
    private int[] mRecordingMarks = new int[2];
    private String mCurrentMacroState = "MACROSTATE_IDLE";
    private static int mUniqueSessionMacroID;
    private boolean mMacroDebugMode = false;
    private Map<String, IMacroScriptSupport> mScriptSupportMap;
    private static int mNextTempMacroIndex;
    private int mLastUsedMacroSessionID = 0;
    public static final String State_Idle = "MACROSTATE_IDLE";
    public static final String State_Recording = "MACROSTATE_RECORDING";
    public static final String State_Playing = "MACROSTATE_PLAYING";
    public static final String XML_Macros_Tag = "EditorMacros";
    public static final String XML_Macro_Tag = "Macro";
    public static final String XML_Name_Tag = "name";
    public static final String XML_LastUsed_Attr = "lastUsed";
    public static final String XML_Compound_Attr = "runAsCompound";
    public static final String XML_ID_Tag = "id";
    public static final String XML_Description_Tag = "description";
    public static final String XML_Command_Tag = "Command";
    public static final String XML_CommandType_ATTR = "type";
    public static final String PREF_USER_MACRO_DEFINITIONS = "Preference_UserMacroDefinitions";
    public static final int Macro_Event = 2345;

    static {
        mUniqueSessionMacroID = 1;
        mNextTempMacroIndex = 1;
    }

    private MacroManager() {
        this.mMacroMap = new HashMap<String, EditorMacro>();
        this.mTemporaryMacros = new ArrayList<EditorMacro>();
        this.mMacroStack = new ArrayList<EditorMacro>();
        this.mScriptSupportMap = new HashMap<String, IMacroScriptSupport>();
    }

    public static boolean isNull() {
        return mManager == null;
    }

    public int getNextMacroSessionID() {
        int id = mUniqueSessionMacroID++;
        return id;
    }

    public static MacroManager getManager() {
        if (mManager == null) {
            IConfigurationElement configurationElement;
            int j;
            IConfigurationElement[] elements;
            IExtension extension;
            int i;
            IExtension[] extensions;
            mManager = new MacroManager();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("PracticallyMacro", "scriptingSupport");
            if (point != null) {
                extensions = point.getExtensions();
                i = 0;
                while (i < extensions.length) {
                    extension = extensions[i];
                    elements = extension.getConfigurationElements();
                    j = 0;
                    while (j < elements.length) {
                        String supportClass;
                        configurationElement = elements[j];
                        if (configurationElement.getName().equals("scriptSupport") && (supportClass = configurationElement.getAttribute("class")) != null) {
                            try {
                                IMacroScriptSupport scriptSupport = (IMacroScriptSupport)configurationElement.createExecutableExtension("class");
                                if (scriptSupport != null) {
                                    MacroManager.mManager.mScriptSupportMap.put(scriptSupport.getID(), scriptSupport);
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if ((point = Platform.getExtensionRegistry().getExtensionPoint("PracticallyMacro", "xmlCommandHandlers")) != null) {
                extensions = point.getExtensions();
                i = 0;
                while (i < extensions.length) {
                    extension = extensions[i];
                    elements = extension.getConfigurationElements();
                    j = 0;
                    while (j < elements.length) {
                        configurationElement = elements[j];
                        if (configurationElement.getName().equals("XMLCommandHandler")) {
                            String handlerType = configurationElement.getAttribute(XML_CommandType_ATTR);
                            String handlerClass = configurationElement.getAttribute("class");
                            if (handlerClass != null && handlerType != null) {
                                try {
                                    IMacroCommand macroCommand = (IMacroCommand)configurationElement.createExecutableExtension("class");
                                    if (macroCommand != null) {
                                        MacroManager.mManager.mXMLCommandHandlerMap.put(handlerType, macroCommand);
                                    }
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            mManager.loadMacros();
        }
        return mManager;
    }

    public List<EditorMacro> getUsedMacros(int count) {
        ArrayList<EditorMacro> list = new ArrayList<EditorMacro>();
        list.addAll(this.mMacroMap.values());
        Collections.sort(list, new AgeSorter());
        if (count < 0) {
            return list;
        }
        return list.subList(0, Math.min(count, list.size()));
    }

    protected Set<String> getMacroNames() {
        HashSet<String> results = new HashSet<String>();
        for (EditorMacro macro : this.mMacroMap.values()) {
            results.add(macro.getName());
        }
        for (EditorMacro macro : this.mTemporaryMacros) {
            results.add(macro.getName());
        }
        return results;
    }

    public String getUniqueMacroName() {
        Set<String> macroNames = MacroManager.getManager().getMacroNames();
        int num = mNextTempMacroIndex;
        while (true) {
            String name;
            if (!macroNames.contains(name = "User-defined macro " + num)) {
                mNextTempMacroIndex = num + 1;
                return name;
            }
            ++num;
        }
    }

    public EditorMacro getMacro(String id) {
        return this.mMacroMap.get(id);
    }

    public void addMacro(EditorMacro macro) {
        if (macro.getSessionID() <= 0) {
            macro.setSessionID(this.getNextMacroSessionID());
        }
        if (macro.getID().length() > 0) {
            this.mMacroMap.put(macro.getID(), macro);
            ICommandService cs = MacroManager.getOldCommandService();
            Category category = cs.getCategory(UserMacroCategoryID);
            Command newCommand = cs.getCommand(macro.getID());
            newCommand.define(macro.getName(), macro.getDescription(), category);
            MacroHandler handler = new MacroHandler(macro.getID());
            IHandlerService hs = MacroManager.getOldHandlerService();
            if (hs != null) {
                hs.activateHandler(newCommand.getId(), (IHandler)handler);
            }
            newCommand.setHandler((IHandler)handler);
            try {
                Class<?> e4Helper = Class.forName("practicallymacro.model.E4CommandHelper");
                Method helperMethod = e4Helper.getMethod("addMCommandToSystem", Command.class);
                helperMethod.invoke(e4Helper, newCommand);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            int maxTempCount = Activator.getDefault().getPreferenceStore().getInt("PracticallyMacro_MaxTempMacroCount");
            if (this.mTemporaryMacros.size() >= maxTempCount) {
                Collections.sort(this.mTemporaryMacros, new AgeSorter());
                this.mTemporaryMacros.subList(maxTempCount - 1, this.mTemporaryMacros.size()).clear();
            }
            this.mTemporaryMacros.add(macro);
        }
    }

    public static ICommandService getOldCommandService() {
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        return cs;
    }

    public static IHandlerService getOldHandlerService() {
        IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        return hs;
    }

    public void deleteMacro(EditorMacro macro) {
        this.mMacroMap.remove(macro.getID());
        ICommandService cs = MacroManager.getOldCommandService();
        Command c = cs.getCommand(macro.getID());
        if (c != null && c.isDefined()) {
            c.undefine();
        }
    }

    public EditorMacro getCurrentMacro() {
        if (this.mMacroStack.size() == 0) {
            return null;
        }
        return this.mMacroStack.get(this.mMacroStack.size() - 1);
    }

    public boolean incrementCommandExecutedCount() {
        ++this.mCommandsExecuted;
        return this.mCommandsExecuted < 1000;
    }

    public void pushMacro(EditorMacro currentMacro) {
        this.mMacroStack.add(currentMacro);
    }

    public void popMacro() {
        if (this.mMacroStack.size() > 0) {
            this.mMacroStack.remove(this.mMacroStack.size() - 1);
        }
        if (this.mMacroStack.size() == 0) {
            this.mCommandsExecuted = 0;
        }
    }

    public static Document createDocument(Collection<EditorMacro> macros) {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement(XML_Macros_Tag);
            doc.appendChild(root);
            for (EditorMacro macro : macros) {
                Element child = doc.createElement(XML_Macro_Tag);
                child.setAttribute(XML_Name_Tag, macro.getName());
                child.setAttribute(XML_ID_Tag, macro.getID());
                child.setAttribute(XML_LastUsed_Attr, Long.toString(macro.getLastUse()));
                child.setAttribute(XML_Compound_Attr, Boolean.toString(macro.isRunAsCompoundEvent()));
                Element descNode = doc.createElement(XML_Description_Tag);
                child.appendChild(descNode);
                descNode.setTextContent(macro.getDescription());
                macro.persist(doc, child);
                root.appendChild(child);
            }
            return doc;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String outputXML(Document doc) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String persistMacros(Collection<EditorMacro> macros) {
        Document doc = MacroManager.createDocument(macros);
        return MacroManager.outputXML(doc);
    }

    public void saveMacros() {
        ArrayList<EditorMacro> filteredMacros = new ArrayList<EditorMacro>();
        for (EditorMacro macro : this.mMacroMap.values()) {
            if (macro.isContributed()) continue;
            filteredMacros.add(macro);
        }
        String xmlString = MacroManager.persistMacros(filteredMacros);
        if (xmlString != null) {
            IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
            prefStore.setValue(PREF_USER_MACRO_DEFINITIONS, xmlString);
            System.out.println("Macro defs:" + xmlString);
        }
    }

    public Collection<EditorMacro> readMacros(Reader xmlReader) {
        ArrayList<EditorMacro> results = new ArrayList<EditorMacro>();
        Utilities.createStyledTextCommands();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder loader = factory.newDocumentBuilder();
            Document document = loader.parse(new InputSource(xmlReader));
            Element macros = document.getDocumentElement();
            NodeList macroList = macros.getChildNodes();
            int i = 0;
            while (i < macroList.getLength()) {
                Node macroNode = macroList.item(i);
                if (macroNode instanceof Element) {
                    Element macroEl = (Element)macroNode;
                    String name = macroEl.getAttribute(XML_Name_Tag);
                    String id = macroEl.getAttribute(XML_ID_Tag);
                    boolean runAsCompound = Boolean.parseBoolean(macroEl.getAttribute(XML_Compound_Attr));
                    String timeString = macroEl.getAttribute(XML_LastUsed_Attr);
                    String desc = "";
                    NodeList macroChildren = macroNode.getChildNodes();
                    int k = 0;
                    while (k < macroChildren.getLength()) {
                        Node testNode = macroChildren.item(k);
                        if (testNode.getNodeName().equals(XML_Description_Tag)) {
                            desc = testNode.getTextContent();
                            break;
                        }
                        ++k;
                    }
                    if (id.length() > 0 && name.length() > 0) {
                        ArrayList<IMacroCommand> commands = new ArrayList<IMacroCommand>();
                        int k2 = 0;
                        while (k2 < macroChildren.getLength()) {
                            IMacroCommand newCommand;
                            String typeString;
                            IMacroCommand macroCommand;
                            NamedNodeMap commandAttrs;
                            Node typeNode;
                            Node commandNode = macroChildren.item(k2);
                            if (commandNode.getNodeName().equals(XML_Command_Tag) && (typeNode = (commandAttrs = commandNode.getAttributes()).getNamedItem(XML_CommandType_ATTR)) != null && (macroCommand = this.mXMLCommandHandlerMap.get(typeString = typeNode.getNodeValue())) != null && (newCommand = macroCommand.createFrom((Element)commandNode)) != null) {
                                commands.add(newCommand);
                            }
                            ++k2;
                        }
                        EditorMacro newMacro = new EditorMacro(commands, id, name, desc);
                        newMacro.setRunAsCompoundEvent(runAsCompound);
                        if (timeString.length() > 0) {
                            try {
                                newMacro.setLastUse(Long.parseLong(timeString));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        results.add(newMacro);
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }

    public void loadMacros() {
        IExtensionPoint point;
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        String xmlString = prefStore.getString(PREF_USER_MACRO_DEFINITIONS);
        if (xmlString != null && xmlString.length() > 0) {
            Collection<EditorMacro> readCommands = this.readMacros(new StringReader(xmlString));
            for (EditorMacro editorMacro : readCommands) {
                this.addMacro(editorMacro);
            }
            final IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            if (bindingService != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            bindingService.savePreferences(bindingService.getActiveScheme(), bindingService.getBindings());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        if ((point = Platform.getExtensionRegistry().getExtensionPoint("PracticallyMacro", "defineMacro")) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String rawXML;
                    IConfigurationElement configurationElement = elements[j];
                    if (configurationElement.getName().equals("macroDefinition") && (rawXML = configurationElement.getValue()) != null) {
                        Collection<EditorMacro> readCommands = this.readMacros(new StringReader(rawXML));
                        for (EditorMacro editorMacro : readCommands) {
                            if (!this.mMacroMap.containsKey(editorMacro.getID())) {
                                editorMacro.setContributed(true);
                                this.addMacro(editorMacro);
                                continue;
                            }
                            System.out.println("Skipping duplicate macro id: " + editorMacro.getID());
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public Map<Integer, EditorMacro> getUniqueMacroMap() {
        HashMap<Integer, EditorMacro> map = new HashMap<Integer, EditorMacro>();
        for (EditorMacro macro : this.mMacroMap.values()) {
            map.put(macro.getSessionID(), macro);
        }
        for (EditorMacro macro : this.mTemporaryMacros) {
            map.put(macro.getSessionID(), macro);
        }
        return map;
    }

    public List<EditorMacro> getAllMacros() {
        ArrayList<EditorMacro> allMacros = new ArrayList<EditorMacro>();
        allMacros.addAll(this.mMacroMap.values());
        return allMacros;
    }

    public List<EditorMacro> getUsedTempMacros(int count) {
        ArrayList<EditorMacro> list = new ArrayList<EditorMacro>();
        list.addAll(this.mTemporaryMacros);
        Collections.sort(list, new AgeSorter());
        if (count < 0) {
            return list;
        }
        return list.subList(0, Math.min(count, list.size()));
    }

    public void replaceDefinedMacros(Map<Integer, EditorMacro> updatedMacros) {
        HashSet<EditorMacro> currentKeys = new HashSet<EditorMacro>();
        currentKeys.addAll(this.mMacroMap.values());
        ArrayList<EditorMacro> newTempMacros = new ArrayList<EditorMacro>();
        HashMap<String, EditorMacro> newMacroMap = new HashMap<String, EditorMacro>();
        for (Map.Entry<Integer, EditorMacro> entry : updatedMacros.entrySet()) {
            EditorMacro newMacro = entry.getValue();
            if (newMacro.getID().length() == 0) {
                newTempMacros.add(newMacro);
                continue;
            }
            this.addMacro(newMacro);
            newMacroMap.put(newMacro.getID(), newMacro);
        }
        ICommandService cs = MacroManager.getOldCommandService();
        for (EditorMacro existingMacro : currentKeys) {
            EditorMacro newMacro = (EditorMacro)newMacroMap.get(existingMacro.getID());
            if (newMacro != null) continue;
            try {
                Command commandToDelete = cs.getCommand(existingMacro.getID());
                commandToDelete.undefine();
                this.mMacroMap.remove(existingMacro.getID());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mTemporaryMacros = newTempMacros;
    }

    public void setLastMacro(EditorMacro macro) {
        if (macro.getSessionID() > 0) {
            this.mLastUsedMacroSessionID = macro.getSessionID();
        }
    }

    public EditorMacro getLastMacro() {
        if (this.mLastUsedMacroSessionID > 0) {
            Map<Integer, EditorMacro> map = this.getUniqueMacroMap();
            return map.get(this.mLastUsedMacroSessionID);
        }
        return null;
    }

    public boolean isRecordingRawKeystrokes() {
        return Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_RecordRawCharacterKeys");
    }

    public MacroRecorder getRecorder() {
        return RecordCommandAction.getRecorder();
    }

    public void clearMacroStack() {
        this.mMacroStack.clear();
        this.mCommandsExecuted = 0;
    }

    public int getRecordingMark(int index) {
        if (index < this.mRecordingMarks.length) {
            return this.mRecordingMarks[index];
        }
        return 0;
    }

    public void setRecordingMark(int mark, int index) {
        if (index < this.mRecordingMarks.length) {
            this.mRecordingMarks[index] = mark;
        }
    }

    public void moveMarkOnDelete(boolean recordMode, int offset, int length) {
        if (recordMode) {
            int i = 0;
            while (i < this.mRecordingMarks.length) {
                this.mRecordingMarks[i] = EditorMacro.moveMarkOnDelete(this.mRecordingMarks[i], offset, length);
                ++i;
            }
        } else {
            for (EditorMacro macro : this.mMacroStack) {
                macro.moveMarkOnDelete(offset, length);
            }
        }
    }

    public void moveMarkOnInsert(boolean recordMode, int offset, int length) {
        if (recordMode) {
            int i = 0;
            while (i < this.mRecordingMarks.length) {
                this.mRecordingMarks[i] = EditorMacro.moveMarkOnInsert(this.mRecordingMarks[i], offset, length);
                ++i;
            }
        } else {
            for (EditorMacro macro : this.mMacroStack) {
                macro.moveMarkOnInsert(offset, length);
            }
        }
    }

    public List<IMacroCommand> getCanonicalScriptCommands() {
        ArrayList<IMacroCommand> results = new ArrayList<IMacroCommand>();
        for (IMacroScriptSupport supportObj : this.mScriptSupportMap.values()) {
            MacroScriptCommand command = new MacroScriptCommand(supportObj, null);
            results.add(command);
        }
        return results;
    }

    public IMacroScriptSupport getScriptProxy(String proxyID) {
        return this.mScriptSupportMap.get(proxyID);
    }

    public String getMacroState() {
        return this.mCurrentMacroState;
    }

    public void setMacroState(String newState) {
        this.mCurrentMacroState = newState;
    }

    public boolean isMacroDebugMode() {
        return this.mMacroDebugMode;
    }

    public void setMacroDebugMode(boolean macroDebugMode) {
        this.mMacroDebugMode = macroDebugMode;
    }

    public void clearMarks() {
        int i = 0;
        while (i < this.mRecordingMarks.length) {
            this.mRecordingMarks[i] = 0;
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AgeSorter
    implements Comparator<EditorMacro> {
        private AgeSorter() {
        }

        @Override
        public int compare(EditorMacro o1, EditorMacro o2) {
            long t2;
            long t1 = o1.getLastUse();
            if (t1 < (t2 = o2.getLastUse())) {
                return 1;
            }
            if (t1 > t2) {
                return -1;
            }
            return 0;
        }
    }
}

