/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import practicallymacro.editormacros.Activator;

public class OptionsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button mRecordRawChars;
    private Button mShowMacroConsole;
    private Button mWriteToMacroConsole;
    private Button mShowSaveDialog;
    private Button mCompressCharInserts;
    private Button mExecuteMacrosAtomically;
    private Spinner mMaxTempMacroSpinner;

    public OptionsPage() {
    }

    public OptionsPage(String title) {
        super(title);
    }

    public OptionsPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "PracticallyMacro.overallHelp");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.mRecordRawChars = new Button(comp, 32);
        this.mRecordRawChars.setText("Record raw character events (not recommended)");
        this.mRecordRawChars.setToolTipText("If set, raw keyup/down events will be recorded into the macro.\n  This allows the capturing of processing of special events like adding matching quotes.\nNote: Many options on this page will be ignored for macros containing raw character events.");
        this.mRecordRawChars.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_RecordRawCharacterKeys"));
        this.mCompressCharInserts = new Button(comp, 32);
        this.mCompressCharInserts.setText("Compress character insertions into String insertions while recording");
        this.mCompressCharInserts.setToolTipText("If set, String events will be created in place of individual character inserts when recording.");
        this.mCompressCharInserts.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_CompressCharInsertsWhenRecording"));
        this.mExecuteMacrosAtomically = new Button(comp, 32);
        this.mExecuteMacrosAtomically.setText("Execute macros atomically");
        this.mExecuteMacrosAtomically.setToolTipText("If set, execute macros as an atomic editor command.  This can be overridden per macro.  This is the recommended behavior for most editor macros since undo/redo will treat the macro as one event.");
        this.mExecuteMacrosAtomically.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_ExecuteMacrosAtomically"));
        this.mShowMacroConsole = new Button(comp, 32);
        this.mShowMacroConsole.setText("Show macro console");
        this.mShowMacroConsole.setToolTipText("If set, make the macro console visible during command record/play.");
        this.mShowMacroConsole.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_ShowMacroConsole"));
        this.mWriteToMacroConsole = new Button(comp, 32);
        this.mWriteToMacroConsole.setText("Write to macro console");
        this.mWriteToMacroConsole.setToolTipText("If set, write normal macro execution trace statements to the macro console during command record/play.");
        this.mWriteToMacroConsole.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_WriteToMacroConsole"));
        this.mShowSaveDialog = new Button(comp, 32);
        this.mShowSaveDialog.setText("Show save dialog");
        this.mShowSaveDialog.setToolTipText("If set, bring up the save dialog each time a macro is recorded.  If not checked, each macro will be automatically saved to a unique (but meaningless) name.");
        this.mShowSaveDialog.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_ShowSaveDialog"));
        Composite spincomp = new Composite(comp, 0);
        spincomp.setLayout((Layout)new GridLayout(2, false));
        spincomp.setLayoutData((Object)new GridData(1808));
        Label l = new Label(spincomp, 0);
        l.setText("Maximum number of temporary macros");
        this.mMaxTempMacroSpinner = new Spinner(spincomp, 2048);
        this.mMaxTempMacroSpinner.setMinimum(2);
        this.mMaxTempMacroSpinner.setMaximum(500);
        this.mMaxTempMacroSpinner.setSelection(Activator.getDefault().getPreferenceStore().getInt("PracticallyMacro_MaxTempMacroCount"));
        return comp;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_RecordRawCharacterKeys", this.mRecordRawChars.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_ShowMacroConsole", this.mShowMacroConsole.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_WriteToMacroConsole", this.mWriteToMacroConsole.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_ShowSaveDialog", this.mShowSaveDialog.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_CompressCharInsertsWhenRecording", this.mCompressCharInserts.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_ExecuteMacrosAtomically", this.mExecuteMacrosAtomically.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("PracticallyMacro_MaxTempMacroCount", this.mMaxTempMacroSpinner.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.mRecordRawChars.setSelection(Activator.getDefault().getPreferenceStore().getDefaultBoolean("PracticallyMacro_RecordRawCharacterKeys"));
        this.mShowMacroConsole.setSelection(Activator.getDefault().getPreferenceStore().getDefaultBoolean("PracticallyMacro_ShowMacroConsole"));
        this.mWriteToMacroConsole.setSelection(Activator.getDefault().getPreferenceStore().getDefaultBoolean("PracticallyMacro_WriteToMacroConsole"));
        this.mCompressCharInserts.setSelection(Activator.getDefault().getPreferenceStore().getDefaultBoolean("PracticallyMacro_CompressCharInsertsWhenRecording"));
        this.mExecuteMacrosAtomically.setSelection(Activator.getDefault().getPreferenceStore().getDefaultBoolean("PracticallyMacro_ExecuteMacrosAtomically"));
        this.mShowSaveDialog.setSelection(Activator.getDefault().getPreferenceStore().getDefaultBoolean("PracticallyMacro_ShowSaveDialog"));
        this.mMaxTempMacroSpinner.setSelection(Activator.getDefault().getPreferenceStore().getDefaultInt("PracticallyMacro_MaxTempMacroCount"));
        super.performDefaults();
    }
}

