/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import practicallymacro.commands.EclipseCommand;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.dialogs.EditMacroDialog;
import practicallymacro.dialogs.ExportMacroDialog;
import practicallymacro.dialogs.ImportMacroDialog;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroDefinitionsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected static final String KEY_SESSIONID = "SessionID";
    private Table mMacroTable;
    private Text mDescriptionText;
    private Button mNewButton;
    private Button mDeleteButton;
    private Button mEditButton;
    private Button mCopyButton;
    private Button mExportButton;
    private Button mImportButton;
    private Map<Integer, EditorMacro> mAllMacros;
    private int mNextUniqueID = 999999999;

    public MacroDefinitionsPage() {
    }

    public MacroDefinitionsPage(String title) {
        super(title);
    }

    public MacroDefinitionsPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    private int getNextUniqueID() {
        return this.mNextUniqueID++;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "PracticallyMacro.managingMacrosHelp");
        this.getShell().setText("Editor Macros");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayout((Layout)new GridLayout());
        tableComp.setLayoutData((Object)new GridData(1808));
        this.mMacroTable = new Table(tableComp, 67586);
        this.mMacroTable.setHeaderVisible(true);
        GridData tableData = new GridData(768);
        GC gc = new GC((Drawable)this.mMacroTable);
        tableData.heightHint = gc.getFontMetrics().getHeight() * 25;
        this.mMacroTable.setLayoutData((Object)tableData);
        this.mMacroTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MacroDefinitionsPage.this.updateDescription();
                MacroDefinitionsPage.this.updateButtons();
            }
        });
        TableColumn nameColumn = new TableColumn(this.mMacroTable, 0);
        nameColumn.setText("Command Name");
        nameColumn.setWidth(200);
        TableColumn idColumn = new TableColumn(this.mMacroTable, 0);
        idColumn.setText("Command ID");
        idColumn.setWidth(200);
        TableColumn contributedColumn = new TableColumn(this.mMacroTable, 0);
        contributedColumn.setText("From Plug-in");
        contributedColumn.setWidth(200);
        this.mDescriptionText = new Text(tableComp, 2634);
        GridData descData = new GridData(768);
        gc = new GC((Drawable)this.mDescriptionText);
        descData.heightHint = gc.getFontMetrics().getHeight() * 5;
        this.mDescriptionText.setLayoutData((Object)descData);
        this.mAllMacros = MacroManager.getManager().getUniqueMacroMap();
        this.rebuildMacroTable();
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        this.mNewButton = new Button(buttonComp, 8);
        this.mNewButton.setText("New...");
        this.mNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMacroDialog dlg = new EditMacroDialog(MacroDefinitionsPage.this.getShell(), null, MacroDefinitionsPage.this.getIDSet(), true, false);
                if (dlg.open() == 0) {
                    EditorMacro newMacro = dlg.getMacro();
                    MacroDefinitionsPage.this.mAllMacros.put(MacroDefinitionsPage.this.getNextUniqueID(), newMacro);
                    MacroDefinitionsPage.this.rebuildMacroTable();
                }
            }
        });
        this.mDeleteButton = new Button(buttonComp, 8);
        this.mDeleteButton.setText("Delete");
        this.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<EditorMacro> deletedItems = new ArrayList<EditorMacro>();
                ArrayList<EditorMacro> failedToDeleteForKeyBindings = new ArrayList<EditorMacro>();
                ArrayList<EditorMacro> failedToDeletedContributed = new ArrayList<EditorMacro>();
                HashMap<MacroHolder, Set<MacroHolder>> inUseMap = new HashMap<MacroHolder, Set<MacroHolder>>();
                TableItem[] selItems = MacroDefinitionsPage.this.mMacroTable.getSelection();
                int i = 0;
                while (i < selItems.length) {
                    TableItem tableItem = selItems[i];
                    EditorMacro macro = (EditorMacro)tableItem.getData();
                    boolean bl = MacroDefinitionsPage.this.hasBinding(macro.getID());
                    Set<MacroHolder> uses = MacroDefinitionsPage.getUsageOfMacro(MacroDefinitionsPage.this.mAllMacros, macro);
                    if (macro.isContributed()) {
                        failedToDeletedContributed.add(macro);
                    } else if (bl) {
                        failedToDeleteForKeyBindings.add(macro);
                    } else if (uses.size() > 0) {
                        inUseMap.put(new MacroHolder((Integer)tableItem.getData(MacroDefinitionsPage.KEY_SESSIONID), macro), uses);
                    } else {
                        MacroDefinitionsPage.this.mAllMacros.remove(tableItem.getData(MacroDefinitionsPage.KEY_SESSIONID));
                        deletedItems.add(macro);
                    }
                    ++i;
                }
                if (failedToDeletedContributed.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    boolean first = true;
                    for (EditorMacro editorMacro : failedToDeletedContributed) {
                        if (!first) {
                            buffer.append(", ");
                        }
                        first = false;
                        buffer.append(editorMacro.getName());
                    }
                    MessageDialog.openError((Shell)MacroDefinitionsPage.this.getShell(), (String)"Failed to delete some macros", (String)("The following macros cannot be deleted because they are contributed by a plug-in.\n" + buffer.toString()));
                }
                if (failedToDeleteForKeyBindings.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    boolean first = true;
                    for (EditorMacro editorMacro : failedToDeleteForKeyBindings) {
                        if (!first) {
                            buffer.append(", ");
                        }
                        first = false;
                        buffer.append(editorMacro.getName());
                    }
                    MessageDialog.openError((Shell)MacroDefinitionsPage.this.getShell(), (String)"Failed to delete some macros", (String)("The following macros cannot be deleted because they have keys mapped to them.  You must first remove the key mappings.\n" + buffer.toString()));
                }
                HashMap<Object, Set> stillInUse = new HashMap<Object, Set>();
                boolean madeChange = true;
                while (madeChange) {
                    madeChange = false;
                    for (Map.Entry entry : inUseMap.entrySet()) {
                        Object holder = (MacroHolder)entry.getKey();
                        Set inUseSet = (Set)inUseMap.get(holder);
                        for (EditorMacro deletedMacro : deletedItems) {
                            inUseSet.remove(deletedMacro);
                        }
                        if (inUseSet.size() > 0) {
                            stillInUse.put(holder, inUseSet);
                            continue;
                        }
                        deletedItems.add(((MacroHolder)holder).mMacro);
                        madeChange = true;
                        MacroDefinitionsPage.this.mAllMacros.remove(((MacroHolder)holder).mSessionMacroID);
                    }
                    inUseMap = stillInUse;
                }
                if (inUseMap.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Some macros are used by other macros.  Continue with delete?\n");
                    for (Map.Entry entry : inUseMap.entrySet()) {
                        EditorMacro macro = ((MacroHolder)entry.getKey()).mMacro;
                        buffer.append(macro.getName());
                        buffer.append(" is used by: ");
                        Set usingMacros = (Set)entry.getValue();
                        boolean first = true;
                        for (MacroHolder usingMacro : usingMacros) {
                            if (!first) {
                                buffer.append(", ");
                            }
                            first = false;
                            buffer.append(usingMacro.mMacro.getName());
                        }
                        buffer.append("\n");
                    }
                    boolean bl = MessageDialog.openQuestion((Shell)MacroDefinitionsPage.this.getShell(), (String)"Macros in use", (String)buffer.toString());
                    if (bl) {
                        for (Object holder : inUseMap.keySet()) {
                            MacroDefinitionsPage.this.mAllMacros.remove(((MacroHolder)holder).mSessionMacroID);
                        }
                    }
                }
                MacroDefinitionsPage.this.rebuildMacroTable();
            }
        });
        this.mEditButton = new Button(buttonComp, 8);
        this.mEditButton.setText("Edit...");
        this.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selItems = MacroDefinitionsPage.this.mMacroTable.getSelection();
                if (selItems.length > 0) {
                    EditorMacro macro = (EditorMacro)selItems[0].getData();
                    EditMacroDialog dlg = new EditMacroDialog(MacroDefinitionsPage.this.getShell(), macro, MacroDefinitionsPage.this.getIDSet(), MacroDefinitionsPage.getUsageOfMacro(MacroDefinitionsPage.this.mAllMacros, macro).size() == 0, macro.isContributed());
                    if (dlg.open() == 0) {
                        Integer sessionID = (Integer)selItems[0].getData(MacroDefinitionsPage.KEY_SESSIONID);
                        macro = dlg.getMacro();
                        MacroDefinitionsPage.this.mAllMacros.put(sessionID, macro);
                        MacroDefinitionsPage.this.rebuildMacroTable();
                    }
                }
            }
        });
        this.mCopyButton = new Button(buttonComp, 8);
        this.mCopyButton.setText("Copy");
        this.mCopyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selItems = MacroDefinitionsPage.this.mMacroTable.getSelection();
                if (selItems.length > 0) {
                    int i = 0;
                    while (i < selItems.length) {
                        TableItem tableItem = selItems[i];
                        EditorMacro oldMacro = (EditorMacro)tableItem.getData();
                        List<IMacroCommand> oldCommands = oldMacro.getCommands();
                        ArrayList<IMacroCommand> newCommands = new ArrayList<IMacroCommand>();
                        for (IMacroCommand macroCommand : oldCommands) {
                            newCommands.add(macroCommand.copy());
                        }
                        EditorMacro copiedMacro = new EditorMacro(newCommands, String.valueOf(oldMacro.getID()) + ".copy", String.valueOf(oldMacro.getName()) + " (copy)", oldMacro.getDescription());
                        MacroDefinitionsPage.this.mAllMacros.put(MacroDefinitionsPage.this.getNextUniqueID(), copiedMacro);
                        ++i;
                    }
                    MacroDefinitionsPage.this.rebuildMacroTable();
                }
            }
        });
        this.mExportButton = new Button(buttonComp, 8);
        this.mExportButton.setText("Export...");
        this.mExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selItems = MacroDefinitionsPage.this.mMacroTable.getSelection();
                if (selItems.length > 0) {
                    ArrayList<EditorMacro> macros = new ArrayList<EditorMacro>();
                    int i = 0;
                    while (i < selItems.length) {
                        TableItem tableItem = selItems[i];
                        macros.add((EditorMacro)tableItem.getData());
                        ++i;
                    }
                    ExportMacroDialog dlg = new ExportMacroDialog(MacroDefinitionsPage.this.getShell(), macros);
                    dlg.open();
                }
            }
        });
        this.mImportButton = new Button(buttonComp, 8);
        this.mImportButton.setText("Import...");
        this.mImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportMacroDialog dlg = new ImportMacroDialog(MacroDefinitionsPage.this.getShell());
                if (dlg.open() == 0) {
                    HashMap<String, EditorMacro> idMap = new HashMap<String, EditorMacro>();
                    for (EditorMacro existingMacro : MacroDefinitionsPage.this.mAllMacros.values()) {
                        idMap.put(existingMacro.getID(), existingMacro);
                    }
                    Collection<EditorMacro> macros = dlg.getMacros();
                    for (EditorMacro newMacro : macros) {
                        if (!idMap.containsKey(newMacro.getID())) {
                            MacroDefinitionsPage.this.mAllMacros.put(MacroDefinitionsPage.this.getNextUniqueID(), newMacro);
                            continue;
                        }
                        MessageBox mb = new MessageBox(MacroDefinitionsPage.this.getShell(), 32);
                        mb.setText("Import macro");
                        mb.setMessage("Skipping macro because the id is already in use: " + newMacro.getID());
                        mb.open();
                    }
                    MacroDefinitionsPage.this.rebuildMacroTable();
                }
            }
        });
        this.updateButtons();
        return comp;
    }

    protected Set<String> getIDSet() {
        HashSet<String> currentIDs = new HashSet<String>();
        for (EditorMacro macro : this.mAllMacros.values()) {
            if (macro.getID().length() <= 0) continue;
            currentIDs.add(macro.getID());
        }
        ICommandService cs = MacroManager.getOldCommandService();
        Collection allCommands = cs.getDefinedCommandIds();
        for (String commandID : allCommands) {
            if (commandID.length() <= 0) continue;
            currentIDs.add(commandID);
        }
        return currentIDs;
    }

    protected boolean hasBinding(String commandId) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        Binding[] bindings = bindingService.getBindings();
        int i = 0;
        while (i < bindings.length) {
            String id;
            Binding binding = bindings[i];
            ParameterizedCommand command = binding.getParameterizedCommand();
            if (command != null && commandId.equals(id = command.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Set<MacroHolder> getUsageOfMacro(Map<Integer, EditorMacro> allMacros, EditorMacro macro) {
        HashSet<MacroHolder> usingMacros = new HashSet<MacroHolder>();
        block0: for (Map.Entry<Integer, EditorMacro> entry : allMacros.entrySet()) {
            EditorMacro editorMacro = entry.getValue();
            List<IMacroCommand> commands = editorMacro.getCommands();
            for (IMacroCommand macroCommand : commands) {
                if (!(macroCommand instanceof EclipseCommand) || !((EclipseCommand)macroCommand).getCommandID().equals(macro.getID())) continue;
                usingMacros.add(new MacroHolder(entry.getKey(), editorMacro));
                continue block0;
            }
        }
        return usingMacros;
    }

    protected void rebuildMacroTable() {
        this.mMacroTable.removeAll();
        ArrayList<MacroHolder> allMacros = new ArrayList<MacroHolder>();
        for (Map.Entry<Integer, EditorMacro> entry : this.mAllMacros.entrySet()) {
            MacroHolder holder = new MacroHolder(entry.getKey(), entry.getValue());
            allMacros.add(holder);
        }
        Collections.sort(allMacros, new Comparator<MacroHolder>(){

            @Override
            public int compare(MacroHolder o1, MacroHolder o2) {
                return o1.mMacro.getName().compareTo(o2.mMacro.getName());
            }
        });
        for (MacroHolder holder : allMacros) {
            TableItem t = new TableItem(this.mMacroTable, 0);
            EditorMacro macro = holder.mMacro;
            t.setText(0, macro.getName());
            t.setText(1, macro.getID());
            if (macro.isContributed()) {
                t.setText(2, "true");
            }
            t.setData((Object)macro);
            t.setData(KEY_SESSIONID, (Object)holder.mSessionMacroID);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void updateDescription() {
        this.mDescriptionText.setText("");
        TableItem[] selItems = this.mMacroTable.getSelection();
        if (selItems.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < selItems.length) {
                buffer.append(((EditorMacro)selItems[i].getData()).getDescription());
                if (i + 1 < selItems.length) {
                    buffer.append("\n");
                }
                ++i;
            }
            this.mDescriptionText.setText(buffer.toString());
        }
    }

    private void updateButtons() {
        int selCount = this.mMacroTable.getSelectionCount();
        this.mEditButton.setEnabled(selCount == 1);
        this.mDeleteButton.setEnabled(selCount > 0);
        this.mExportButton.setEnabled(selCount > 0);
    }

    public boolean performOk() {
        MacroManager.getManager().replaceDefinedMacros(this.mAllMacros);
        return super.performOk();
    }

    private static class MacroHolder {
        Integer mSessionMacroID;
        EditorMacro mMacro;

        public MacroHolder(Integer id, EditorMacro macro) {
            this.mSessionMacroID = id;
            this.mMacro = macro;
        }

        public boolean equals(Object arg0) {
            return this.mSessionMacroID.equals(arg0);
        }

        public int hashCode() {
            return this.mSessionMacroID.hashCode();
        }
    }
}

