/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import practicallymacro.dialogs.MacroCommandDebugInfo;
import practicallymacro.editormacros.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroDebugDialog
extends Dialog {
    public static final int ACTION_NEXT = 4;
    public static final int ACTION_CONTINUETOEND = 5;
    public static final int ACTION_CANCELEXECUTION = 6;
    private List<MacroCommandDebugInfo> mCommands;
    private int mSelectedAction;

    public MacroDebugDialog(Shell shell, List<MacroCommandDebugInfo> commands) {
        super(shell);
        this.mCommands = commands;
        this.setShellStyle(2096);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Macro debug console");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Table t = new Table(comp, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 200;
        t.setLayoutData((Object)gd);
        t.setHeaderVisible(true);
        TableColumn commandCol = new TableColumn(t, 0);
        commandCol.setText("Command");
        commandCol.setWidth(300);
        TableColumn cursorCol = new TableColumn(t, 0);
        cursorCol.setText("Cursor Position");
        cursorCol.setWidth(100);
        TableColumn selectionCol = new TableColumn(t, 0);
        selectionCol.setText("Selection end");
        selectionCol.setWidth(200);
        int nextCommandIndex = 0;
        for (MacroCommandDebugInfo commandInfo : this.mCommands) {
            TableItem item = new TableItem(t, 0);
            item.setText(0, commandInfo.getCommand().getName());
            Point cursorPos = commandInfo.getCursorPos();
            if (cursorPos != null) {
                ++nextCommandIndex;
                item.setText(1, "Line: " + cursorPos.x + " Col: " + cursorPos.y);
                Point selEndPos = commandInfo.getSelEnd();
                if (selEndPos == null) {
                    item.setText(2, "No selection");
                    continue;
                }
                item.setText(2, "Selection from Line: " + selEndPos.x + " Col: " + selEndPos.y);
                continue;
            }
            item.setText(1, "Not run yet");
        }
        if (nextCommandIndex < t.getItemCount()) {
            t.select(nextCommandIndex);
        }
        t.showSelection();
        final Table finalT = t;
        final int selIndex = nextCommandIndex;
        t.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int itemsPerScreen = finalT.getBounds().height / finalT.getItemHeight() - 1;
                finalT.setTopIndex(Math.max(0, selIndex - (itemsPerScreen - 1)));
            }
        });
        return comp;
    }

    protected void buttonPressed(int buttonId) {
        this.mSelectedAction = buttonId;
        super.okPressed();
    }

    public int getSelectedAction() {
        return this.mSelectedAction;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 4, "Next", true);
        this.createButton(parent, 5, "Continue w/o stepping", false);
        this.createButton(parent, 6, "Cancel execution", false);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return Activator.getDefault().getDialogSettings();
    }
}

