/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import practicallymacro.commands.FindCommand;

public class FindConfigureDialog
extends Dialog {
    private FindCommand mSourceCommand;
    private Button mSearchStringRadio;
    private Text mSearchText;
    private Button mSearchSelectionRadio;
    private Button mReplaceButton;
    private Text mReplaceText;
    private Button mReplaceAll;
    private Button mCaseSensitive;
    private Button mSearchForward;
    private Button mRegExpMode;
    private Button mMatchWord;
    private Button mWrap;
    private Button mSelectionScope;
    private String mInitialSearchString;

    public FindConfigureDialog(Shell shell, FindCommand sourceCommand, String initialSearchString) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mSourceCommand = sourceCommand;
        this.mInitialSearchString = initialSearchString;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Find/Replace settings");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Group stringComp = new Group(comp, 0);
        stringComp.setText("Search terms");
        stringComp.setLayout((Layout)new GridLayout(2, false));
        stringComp.setLayoutData((Object)new GridData(1808));
        Composite searchStringComp = new Composite((Composite)stringComp, 0);
        searchStringComp.setLayout((Layout)new GridLayout());
        searchStringComp.setLayoutData((Object)new GridData(768));
        this.mSearchStringRadio = new Button(searchStringComp, 16);
        this.mSearchStringRadio.setText("Search String");
        this.mSearchStringRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindConfigureDialog.this.enableWidgets();
            }
        });
        this.mSearchText = new Text(searchStringComp, 2052);
        this.mSearchText.setLayoutData((Object)new GridData(768));
        this.mSearchSelectionRadio = new Button(searchStringComp, 16);
        this.mSearchSelectionRadio.setText("Use clipboard (or selection)");
        this.mSearchSelectionRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindConfigureDialog.this.enableWidgets();
            }
        });
        Composite replaceStringComp = new Composite((Composite)stringComp, 0);
        replaceStringComp.setLayout((Layout)new GridLayout());
        replaceStringComp.setLayoutData((Object)new GridData(768));
        this.mReplaceButton = new Button(replaceStringComp, 32);
        this.mReplaceButton.setText("Replace");
        this.mReplaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindConfigureDialog.this.enableWidgets();
            }
        });
        this.mReplaceText = new Text(replaceStringComp, 2052);
        this.mReplaceText.setLayoutData((Object)new GridData(768));
        this.mReplaceAll = new Button(replaceStringComp, 32);
        this.mReplaceAll.setText("Replace All");
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        this.mCaseSensitive = new Button(buttonComp, 32);
        this.mCaseSensitive.setText("Case Sensitive");
        this.mSearchForward = new Button(buttonComp, 32);
        this.mSearchForward.setText("Search Forward");
        this.mRegExpMode = new Button(buttonComp, 32);
        this.mRegExpMode.setText("Regular Expression mode");
        this.mMatchWord = new Button(buttonComp, 32);
        this.mMatchWord.setText("Match Whole Word");
        this.mWrap = new Button(buttonComp, 32);
        this.mWrap.setText("Wrap Search");
        this.mSelectionScope = new Button(buttonComp, 32);
        this.mSelectionScope.setText("Search in selection");
        this.mCaseSensitive.setSelection(this.mSourceCommand.isCaseSensitive());
        this.mSearchForward.setSelection(this.mSourceCommand.isSearchForward());
        this.mRegExpMode.setSelection(this.mSourceCommand.isRegExpMode());
        this.mMatchWord.setSelection(this.mSourceCommand.isMatchWholeWord());
        this.mWrap.setSelection(this.mSourceCommand.isWrapSearch());
        this.mSelectionScope.setSelection(this.mSourceCommand.isScopeIsSelection());
        if (this.mSourceCommand.getSearchString() != null) {
            this.mSearchStringRadio.setSelection(true);
            this.mSearchText.setText(this.mSourceCommand.getSearchString());
        } else if (this.mInitialSearchString != null) {
            this.mSearchStringRadio.setSelection(true);
            this.mSearchText.setText(this.mInitialSearchString);
        } else {
            this.mSearchSelectionRadio.setSelection(true);
        }
        if (this.mSourceCommand.getReplaceString() == null) {
            this.mReplaceButton.setSelection(false);
        } else {
            this.mReplaceText.setText(this.mSourceCommand.getReplaceString());
            this.mReplaceButton.setSelection(true);
        }
        this.mReplaceAll.setSelection(this.mSourceCommand.isReplaceAll());
        this.enableWidgets();
        return comp;
    }

    private void enableWidgets() {
        this.mReplaceAll.setEnabled(this.mReplaceButton.getSelection());
        this.mReplaceText.setEnabled(this.mReplaceButton.getSelection());
        this.mSearchText.setEnabled(this.mSearchStringRadio.getSelection());
        this.mSelectionScope.setEnabled(this.mSearchStringRadio.getSelection());
        if (!this.mSearchStringRadio.getSelection()) {
            this.mSelectionScope.setSelection(false);
        }
    }

    protected void okPressed() {
        this.mSourceCommand.setCaseSensitive(this.mCaseSensitive.getSelection());
        this.mSourceCommand.setMatchWholeWord(this.mMatchWord.getSelection());
        this.mSourceCommand.setRegExpMode(this.mRegExpMode.getSelection());
        this.mSourceCommand.setReplaceAll(this.mReplaceAll.getSelection());
        this.mSourceCommand.setSearchForward(this.mSearchForward.getSelection());
        this.mSourceCommand.setWrapSearch(this.mWrap.getSelection());
        if (this.mSearchSelectionRadio.getSelection()) {
            this.mSourceCommand.setSearchString(null);
        } else {
            this.mSourceCommand.setSearchString(this.mSearchText.getText());
        }
        this.mSourceCommand.setScopeIsSelection(this.mSelectionScope.getSelection());
        if (this.mReplaceButton.getSelection()) {
            this.mSourceCommand.setReplaceString(this.mReplaceText.getText());
            this.mSourceCommand.setReplaceAll(this.mReplaceAll.getSelection());
        } else {
            this.mSourceCommand.setReplaceString(null);
        }
        super.okPressed();
    }
}

