/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMacroDialog
extends Dialog {
    private List<EditorMacro> mMacros = new ArrayList<EditorMacro>();
    private Text mFileText;
    private Text mExportText;

    public ExportMacroDialog(Shell shell, List<EditorMacro> macros) {
        super(shell);
        this.mMacros = macros;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Export Macros");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Composite fileComp = new Composite(comp, 0);
        fileComp.setLayout((Layout)new GridLayout(3, false));
        fileComp.setLayoutData((Object)new GridData(768));
        Label l = new Label(fileComp, 0);
        l.setText("Export file name:");
        this.mFileText = new Text(fileComp, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.mFileText.setLayoutData((Object)gd);
        Button browse = new Button(fileComp, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ExportMacroDialog.this.getShell());
                String filePath = fd.open();
                if (filePath != null) {
                    ExportMacroDialog.this.mFileText.setText(filePath);
                }
            }
        });
        this.mExportText = new Text(comp, 2570);
        gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 300;
        this.mExportText.setLayoutData((Object)gd);
        String macroXML = MacroManager.persistMacros(this.mMacros);
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element masterElement = doc.createElement("macroDefinition");
            doc.appendChild(masterElement);
            CDATASection cdataContent = doc.createCDATASection(macroXML);
            masterElement.appendChild(cdataContent);
            String xmlData = MacroManager.outputXML(doc);
            this.mExportText.setText(xmlData);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return comp;
    }

    protected void okPressed() {
        block14: {
            Writer w = null;
            try {
                try {
                    String filePath = this.mFileText.getText();
                    File outputFile = new File(filePath);
                    w = new FileWriter(outputFile);
                    String data = MacroManager.persistMacros(this.mMacros);
                    w.write(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (w != null) {
                        try {
                            w.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        super.okPressed();
    }
}

