/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.commands.ICommandService;
import practicallymacro.model.MacroManager;
import practicallymacro.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseCommandsDlg
extends Dialog {
    private Button mFilterNonEditorCommands;
    private Button mFilterNonMacroCommands;
    private Table mCommandTable;
    private TableColumn mAvailNameColumn;
    private TableColumn mAvailcategoryColumn;
    private Text mDescription;
    private List<Command> mFilteredCommands;
    private List<Command> mAvailableCommands;
    private List<String> mOutputSelectedCommands;

    protected ChooseCommandsDlg(Shell parentShell, List<Command> filteredCommands) {
        super(parentShell);
        this.mFilteredCommands = filteredCommands;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Add command(s) to the Quick Execute list");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.mFilterNonEditorCommands = new Button(comp, 32);
        this.mFilterNonEditorCommands.setText("Filter out non-editor commands");
        this.mFilterNonEditorCommands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCommandsDlg.this.populateCommandTable();
            }
        });
        this.mFilterNonEditorCommands.setSelection(true);
        this.mFilterNonMacroCommands = new Button(comp, 32);
        GridData gd = new GridData();
        gd.horizontalIndent = 15;
        this.mFilterNonMacroCommands.setLayoutData((Object)gd);
        this.mFilterNonMacroCommands.setText("Show only user defined macros and macro support commands");
        this.mFilterNonMacroCommands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCommandsDlg.this.populateCommandTable();
            }
        });
        this.mCommandTable = new Table(comp, 2050);
        gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.mCommandTable.setLayoutData((Object)gd);
        this.mAvailableCommands = new ArrayList<Command>();
        this.mAvailNameColumn = new TableColumn(this.mCommandTable, 0);
        this.mAvailNameColumn.setText("Name");
        this.mAvailNameColumn.setWidth(150);
        this.mAvailcategoryColumn = new TableColumn(this.mCommandTable, 0);
        this.mAvailcategoryColumn.setText("Category");
        this.mAvailcategoryColumn.setWidth(150);
        this.mCommandTable.setHeaderVisible(true);
        this.mCommandTable.setSortDirection(128);
        this.mCommandTable.setSortColumn(this.mAvailNameColumn);
        this.mCommandTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCommandsDlg.this.mDescription.setText("");
                TableItem[] selItems = ChooseCommandsDlg.this.mCommandTable.getSelection();
                StringBuffer buffer = new StringBuffer();
                TableItem[] tableItemArray = selItems;
                int n = selItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    Command c = (Command)tableItem.getData();
                    try {
                        buffer.append(c.getDescription());
                    }
                    catch (NotDefinedException e1) {
                        e1.printStackTrace();
                    }
                    buffer.append('\n');
                    ++n2;
                }
                ChooseCommandsDlg.this.mDescription.setText(buffer.toString());
            }
        });
        this.mAvailNameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCommandsDlg.this.mCommandTable.setSortColumn(ChooseCommandsDlg.this.mAvailNameColumn);
                ChooseCommandsDlg.this.populateCommandTable();
            }
        });
        this.mAvailcategoryColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCommandsDlg.this.mCommandTable.setSortColumn(ChooseCommandsDlg.this.mAvailcategoryColumn);
                ChooseCommandsDlg.this.populateCommandTable();
            }
        });
        ICommandService cs = MacroManager.getOldCommandService();
        Command[] allCommands = cs.getDefinedCommands();
        HashSet<String> filteredIDs = new HashSet<String>();
        for (Command c : this.mFilteredCommands) {
            filteredIDs.add(c.getId());
        }
        Command[] commandArray = allCommands;
        int n = allCommands.length;
        int n2 = 0;
        while (n2 < n) {
            Command command = commandArray[n2];
            if (!filteredIDs.contains(command.getId())) {
                this.mAvailableCommands.add(command);
            }
            ++n2;
        }
        Label l = new Label(comp, 0);
        l.setText("Description:");
        this.mDescription = new Text(comp, 770);
        gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 50;
        this.mDescription.setLayoutData((Object)gd);
        this.populateCommandTable();
        return comp;
    }

    private void populateCommandTable() {
        this.mCommandTable.removeAll();
        List<Object> filteredCommands = new ArrayList();
        if (this.mFilterNonEditorCommands.getSelection()) {
            for (Command command : this.mAvailableCommands) {
                String catID = "";
                try {
                    catID = command.getCategory().getId();
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
                if (!Utilities.isEditCategory(catID)) continue;
                if (!this.mFilterNonMacroCommands.getSelection()) {
                    filteredCommands.add(command);
                    continue;
                }
                if (!Utilities.isUserMacroCategory(catID) && !Utilities.isSupportCategory(catID)) continue;
                filteredCommands.add(command);
            }
        } else {
            filteredCommands = this.mAvailableCommands;
        }
        Collections.sort(filteredCommands, new Comparator<Command>(){

            @Override
            public int compare(Command o1, Command o2) {
                TableColumn column = ChooseCommandsDlg.this.mCommandTable.getSortColumn();
                if (column == ChooseCommandsDlg.this.mAvailNameColumn) {
                    return ChooseCommandsDlg.getName(o1).compareToIgnoreCase(ChooseCommandsDlg.getName(o2));
                }
                return ChooseCommandsDlg.getCategory(o1).compareToIgnoreCase(ChooseCommandsDlg.getCategory(o2));
            }
        });
        this.mCommandTable.removeAll();
        for (Command command : filteredCommands) {
            TableItem t = new TableItem(this.mCommandTable, 0);
            t.setText(0, ChooseCommandsDlg.getName(command));
            t.setText(1, ChooseCommandsDlg.getCategory(command));
            t.setData((Object)command);
        }
    }

    private static String getCategory(Command c) {
        try {
            return c.getCategory().getName();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getName(Command c) {
        try {
            return c.getName();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
            return "";
        }
    }

    public List<String> getCommands() {
        return this.mOutputSelectedCommands;
    }

    protected void okPressed() {
        TableItem[] selItems;
        this.mOutputSelectedCommands = new ArrayList<String>();
        TableItem[] tableItemArray = selItems = this.mCommandTable.getSelection();
        int n = selItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Command c = (Command)tableItem.getData();
            this.mOutputSelectedCommands.add(c.getId());
            ++n2;
        }
        super.okPressed();
    }
}

