/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.commands;

import java.util.HashMap;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.util.Utilities;

public class StyledTextCommand
implements IMacroCommand {
    public static final String XML_StyledTextCommandID_Attr = "styledTextCommandID";
    public static final String XML_StyledTextType = "styledTextCommand";
    private int mStyledTextAction;
    private String mName;

    public StyledTextCommand(int styledTextActionConstant) {
        this.mStyledTextAction = styledTextActionConstant;
        this.mName = Utilities.getNameForStyledTextConstant(this.mStyledTextAction);
    }

    public StyledTextCommand() {
    }

    public void dump() {
        System.out.println("Styled text action: " + this.mStyledTextAction);
    }

    public boolean execute(IEditorPart target) {
        Utilities.getStyledText(target).invokeAction(this.mStyledTextAction);
        return true;
    }

    public void persist(Document doc, Element commandElement) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_StyledTextCommandID_Attr, Integer.toString(this.mStyledTextAction));
        Utilities.persistCommand(doc, commandElement, "type", attrMap, null);
    }

    public IMacroCommand createFrom(Element commandElement) {
        String codeString = commandElement.getAttribute(XML_StyledTextCommandID_Attr);
        StyledTextCommand newCommand = new StyledTextCommand(Integer.parseInt(codeString));
        return newCommand;
    }

    public String getDescription() {
        return "";
    }

    public String getName() {
        return this.mName;
    }

    public String getCategory() {
        return "PracticallyMacro utility command";
    }

    public void configure(Shell shell) {
    }

    public boolean isConfigurable() {
        return false;
    }

    public IMacroCommand copy() {
        return new StyledTextCommand(this.mStyledTextAction);
    }

    public String getCategoryID() {
        return "practicallymacro.category.utility.command";
    }

    public boolean requiresPost() {
        return false;
    }
}

