/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.commands;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.commands.IMacroScriptSupport;
import practicallymacro.model.MacroManager;
import practicallymacro.util.MacroConsole;
import practicallymacro.util.Utilities;

public class MacroScriptCommand
implements IMacroCommand {
    private String mScript;
    private IMacroScriptSupport mScriptLanguageProxy;
    public static final String XML_Script_Tag = "script";
    public static final String XML_ScriptType_Attr = "scriptType";
    public static final String XML_MacroScriptType = "MacroScriptCommand";

    public MacroScriptCommand(IMacroScriptSupport supportObject, String script) {
        this.mScript = script;
        this.mScriptLanguageProxy = supportObject;
    }

    public MacroScriptCommand() {
        this.mScript = null;
    }

    public void configure(Shell shell) {
        this.mScript = this.mScriptLanguageProxy.editScript(this.mScript, shell);
    }

    public IMacroCommand copy() {
        MacroScriptCommand command = new MacroScriptCommand(this.mScriptLanguageProxy, this.mScript);
        return command;
    }

    public void dump() {
        System.out.println("Macro Script(" + this.mScriptLanguageProxy.getIDDisplayString() + "): " + this.mScript);
    }

    public boolean execute(IEditorPart target) {
        final Thread mainThread = Thread.currentThread();
        Thread scriptTimeoutThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                MacroConsole.getConsole().writeln("Script took too long to run; attempting to kill");
                mainThread.interrupt();
            }
        });
        scriptTimeoutThread.start();
        try {
            boolean returnVal;
            boolean bl = returnVal = this.mScriptLanguageProxy.evaluate(this.mScript, target);
            return bl;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                MacroConsole.getConsole().writeln("Script took too much time");
            } else {
                MacroConsole.getConsole().write(e);
            }
            return false;
        }
        finally {
            try {
                scriptTimeoutThread.interrupt();
                scriptTimeoutThread.join();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public String getCategory() {
        return "PracticallyMacro utility command";
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Script of editor functionality");
        if (this.mScript != null) {
            buffer.append(": \n" + this.mScript);
        } else {
            buffer.append(": No script provided");
        }
        return buffer.toString();
    }

    public String getName() {
        return "Editor Macro script (" + this.mScriptLanguageProxy.getIDDisplayString() + "):" + (this.mScript == null ? "no script" : "script provided");
    }

    public boolean isConfigurable() {
        return true;
    }

    public void persist(Document doc, Element commandElement) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.mScript != null) {
            dataMap.put(XML_Script_Tag, this.mScript);
        }
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_ScriptType_Attr, this.mScriptLanguageProxy.getID());
        Utilities.persistCommand(doc, commandElement, XML_MacroScriptType, attrMap, dataMap);
    }

    public IMacroCommand createFrom(Element commandElement) {
        IMacroScriptSupport proxy;
        HashMap<String, String> attrMap = new HashMap<String, String>();
        HashSet<String> attrKeys = new HashSet<String>();
        attrKeys.add(XML_ScriptType_Attr);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashSet<String> dataKeys = new HashSet<String>();
        dataKeys.add(XML_Script_Tag);
        Utilities.getCommandData(commandElement, attrKeys, dataKeys, attrMap, dataMap);
        String scriptType = (String)attrMap.get(XML_ScriptType_Attr);
        String script = (String)dataMap.get(XML_Script_Tag);
        if (scriptType != null && (proxy = MacroManager.getManager().getScriptProxy(scriptType)) != null) {
            return new MacroScriptCommand(proxy, script);
        }
        return null;
    }

    public String getCategoryID() {
        return "practicallymacro.category.utility.command";
    }

    public boolean requiresPost() {
        return false;
    }
}

