/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.commands;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.dialogs.FindConfigureDialog;
import practicallymacro.util.Utilities;

public class FindCommand
implements IMacroCommand {
    private boolean mReplaceAll = false;
    private boolean mScopeIsSelection = false;
    private boolean mWrapSearch = false;
    private boolean mSearchForward = true;
    private boolean mCaseSensitive = false;
    private boolean mMatchWholeWord = false;
    private boolean mRegExpMode = false;
    private String mSearchString = null;
    private String mReplaceString = null;
    public static final String XML_ReplaceAll_Attr = "replaceAll";
    public static final String XML_SelectionScope_Attr = "selectionScope";
    public static final String XML_WrapSearch_Attr = "wrapSearch";
    public static final String XML_Forward_Attr = "forward";
    public static final String XML_CaseSensitive_Attr = "caseSensitive";
    public static final String XML_MatchWord_Attr = "matchWord";
    public static final String XML_RegExp_Attr = "regexp";
    public static final String XML_SearchString_Tag = "searchString";
    public static final String XML_ReplaceString_Tag = "replaceString";
    public static final String XML_MacroFindType = "MacroFindCommand";

    public FindCommand() {
    }

    public FindCommand(String findString) {
        this();
        this.mSearchString = findString;
    }

    public void configure(Shell shell) {
        this.configureWithSearchTerm(shell, null);
    }

    private void configureWithSearchTerm(Shell shell, String initialSearchString) {
        FindConfigureDialog dlg = new FindConfigureDialog(shell, this, initialSearchString);
        dlg.open();
    }

    public void configureNew(Shell shell) {
        String initialSearchString = null;
        IEditorPart editor = Utilities.getActiveEditor();
        if (editor != null && (initialSearchString = Utilities.getSelectedText(editor)).length() == 0) {
            initialSearchString = null;
        }
        this.configureWithSearchTerm(shell, initialSearchString);
    }

    public IMacroCommand copy() {
        FindCommand newCopy = new FindCommand(this.mSearchString);
        newCopy.mCaseSensitive = this.mCaseSensitive;
        newCopy.mMatchWholeWord = this.mMatchWholeWord;
        newCopy.mRegExpMode = this.mRegExpMode;
        newCopy.mReplaceAll = this.mReplaceAll;
        newCopy.mReplaceString = this.mReplaceString;
        newCopy.mSearchForward = this.mSearchForward;
        newCopy.mScopeIsSelection = this.mScopeIsSelection;
        newCopy.mWrapSearch = this.mWrapSearch;
        return newCopy;
    }

    public void dump() {
        System.out.println(this.getDescription());
    }

    public boolean execute(IEditorPart target) {
        block19: {
            ISourceViewer viewer = Utilities.getSourceViewer(target);
            IFindReplaceTarget findTarget = Utilities.getFindReplaceTarget(target);
            if (findTarget != null && viewer != null && findTarget instanceof IFindReplaceTargetExtension) {
                IFindReplaceTargetExtension findTarget1 = (IFindReplaceTargetExtension)findTarget;
                findTarget1.beginSession();
                try {
                    boolean inRange;
                    int findPos;
                    StyledText widget = Utilities.getStyledText(target);
                    if (!(findTarget instanceof IFindReplaceTargetExtension3)) break block19;
                    IFindReplaceTargetExtension3 findTarget3 = (IFindReplaceTargetExtension3)findTarget;
                    int widgetBoundaryStart = 0;
                    int widgetBoundaryEnd = widget.getCharCount() - 1;
                    int boundaryStart = 0;
                    int boundaryEnd = viewer.getDocument().getLength() - 1;
                    if (this.mScopeIsSelection) {
                        Point sel = Utilities.getUndirectedSelection(target);
                        boundaryStart = sel.x;
                        boundaryEnd = sel.y;
                        Point widgetSel = widget.getSelectionRange();
                        widgetBoundaryStart = widgetSel.x;
                        widgetBoundaryEnd = widgetSel.x + widgetSel.y;
                        findTarget1.setScope((IRegion)new Region(boundaryStart, boundaryEnd - boundaryStart));
                    } else {
                        findTarget1.setScope(null);
                    }
                    if (this.mReplaceString != null && this.mReplaceAll) {
                        this.doReplaceAll(findTarget3, viewer, target);
                        return true;
                    }
                    String searchString = this.mSearchString;
                    if (searchString == null) {
                        try {
                            Clipboard cb = new Clipboard(widget.getDisplay());
                            TextTransfer transfer = TextTransfer.getInstance();
                            searchString = (String)cb.getContents((Transfer)transfer);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (searchString == null) {
                            searchString = Utilities.getSelectedText(target);
                        }
                    }
                    if (searchString == null || searchString.length() == 0) {
                        return false;
                    }
                    int startPos = widget.getCaretOffset() - 1;
                    if (this.mScopeIsSelection) {
                        startPos = this.mSearchForward ? widgetBoundaryStart : widgetBoundaryEnd;
                    }
                    if ((findPos = ((IFindReplaceTargetExtension3)findTarget).findAndSelect(startPos, searchString, this.mSearchForward, this.mCaseSensitive, this.mMatchWholeWord, this.mRegExpMode)) >= 0) {
                        findPos = Utilities.getUndirectedSelection((IEditorPart)target).x;
                    }
                    if (!this.isInRange(searchString, boundaryStart, boundaryEnd, findPos) && this.mWrapSearch && !this.mScopeIsSelection && (findPos = ((IFindReplaceTargetExtension3)findTarget).findAndSelect(startPos = this.mSearchForward ? widgetBoundaryStart : widgetBoundaryEnd, searchString, this.mSearchForward, this.mCaseSensitive, this.mMatchWholeWord, this.mRegExpMode)) >= 0) {
                        findPos = Utilities.getUndirectedSelection((IEditorPart)target).x;
                    }
                    if ((inRange = this.isInRange(searchString, boundaryStart, boundaryEnd, findPos)) && this.mReplaceString != null) {
                        findTarget3.replaceSelection(this.mReplaceString, this.mRegExpMode);
                    }
                    boolean bl = inRange;
                    return bl;
                }
                finally {
                    ((IFindReplaceTargetExtension)findTarget).endSession();
                }
            }
        }
        return false;
    }

    private boolean isInRange(String searchString, int boundaryStart, int boundaryEnd, int foundPos) {
        return foundPos >= boundaryStart && foundPos + searchString.length() <= boundaryEnd;
    }

    private void doReplaceAll(IFindReplaceTargetExtension3 findTarget, ISourceViewer sourceViewer, IEditorPart target) {
        int widgetPos = 0;
        int endBoundary = 0;
        if (this.mScopeIsSelection) {
            Point currentSel = Utilities.getUndirectedSelection(sourceViewer);
            endBoundary = currentSel.y;
            Point widgetSel = sourceViewer.getTextWidget().getSelectionRange();
            widgetPos = widgetSel.x;
        }
        while (true) {
            int foundPos;
            int docPos;
            if ((docPos = (foundPos = findTarget.findAndSelect(widgetPos, this.mSearchString, this.mSearchForward, this.mCaseSensitive, this.mMatchWholeWord, this.mRegExpMode))) >= 0) {
                docPos = Utilities.getUndirectedSelection((IEditorPart)target).x;
            }
            if (docPos < 0 || this.mScopeIsSelection && docPos >= endBoundary) break;
            int oldDocLength = sourceViewer.getDocument().getLength();
            int foundStringSize = sourceViewer.getSelectedRange().y;
            findTarget.replaceSelection(this.mReplaceString, this.mRegExpMode);
            int newDocLength = sourceViewer.getDocument().getLength();
            int amtAdded = newDocLength - oldDocLength;
            widgetPos = foundPos + foundStringSize + amtAdded;
            endBoundary += amtAdded;
        }
    }

    public String getCategory() {
        return "PracticallyMacro utility command";
    }

    public String getCategoryID() {
        return "practicallymacro.category.utility.command";
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Perform Find with the following parameters:\n");
        buffer.append("Search String: " + this.mSearchString + "\n");
        buffer.append("Case Sensitive: " + this.mCaseSensitive + "\n");
        buffer.append("Search Forward: " + this.mSearchForward + "\n");
        buffer.append("Match whole word: " + this.mMatchWholeWord + "\n");
        buffer.append("Selection scope: " + this.mScopeIsSelection + "\n");
        buffer.append("Wrap Search: " + this.mWrapSearch + "\n");
        buffer.append("Reg Exp Mode: " + this.mRegExpMode + "\n");
        buffer.append("Replace All: " + this.mReplaceAll + "\n");
        buffer.append("Replace String: " + this.mReplaceString + "\n");
        return buffer.toString();
    }

    public String getName() {
        return "Find " + (this.mSearchString != null ? this.mSearchString : "<clipboard/selection>");
    }

    public boolean isConfigurable() {
        return true;
    }

    public void persist(Document doc, Element commandElement) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_Forward_Attr, Boolean.toString(this.mSearchForward));
        attrMap.put(XML_CaseSensitive_Attr, Boolean.toString(this.mCaseSensitive));
        attrMap.put(XML_RegExp_Attr, Boolean.toString(this.mRegExpMode));
        attrMap.put(XML_MatchWord_Attr, Boolean.toString(this.mMatchWholeWord));
        attrMap.put(XML_ReplaceAll_Attr, Boolean.toString(this.mReplaceAll));
        attrMap.put(XML_SelectionScope_Attr, Boolean.toString(this.mScopeIsSelection));
        attrMap.put(XML_WrapSearch_Attr, Boolean.toString(this.mWrapSearch));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.mSearchString != null) {
            dataMap.put(XML_SearchString_Tag, this.mSearchString);
        }
        if (this.mReplaceString != null) {
            dataMap.put(XML_ReplaceString_Tag, this.mReplaceString);
        }
        Utilities.persistCommand(doc, commandElement, XML_MacroFindType, attrMap, dataMap);
    }

    public IMacroCommand createFrom(Element commandElement) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        HashSet<String> attrKeys = new HashSet<String>();
        attrKeys.add(XML_Forward_Attr);
        attrKeys.add(XML_CaseSensitive_Attr);
        attrKeys.add(XML_RegExp_Attr);
        attrKeys.add(XML_MatchWord_Attr);
        attrKeys.add(XML_ReplaceAll_Attr);
        attrKeys.add(XML_WrapSearch_Attr);
        attrKeys.add(XML_SelectionScope_Attr);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashSet<String> dataKeys = new HashSet<String>();
        dataKeys.add(XML_SearchString_Tag);
        dataKeys.add(XML_ReplaceString_Tag);
        Utilities.getCommandData(commandElement, attrKeys, dataKeys, attrMap, dataMap);
        FindCommand newCommand = new FindCommand((String)dataMap.get(XML_SearchString_Tag));
        String value = (String)attrMap.get(XML_Forward_Attr);
        if (value != null) {
            newCommand.mSearchForward = Boolean.parseBoolean(value);
        }
        if ((value = (String)attrMap.get(XML_CaseSensitive_Attr)) != null) {
            newCommand.mCaseSensitive = Boolean.parseBoolean(value);
        }
        if ((value = (String)attrMap.get(XML_MatchWord_Attr)) != null) {
            newCommand.mMatchWholeWord = Boolean.parseBoolean(value);
        }
        if ((value = (String)attrMap.get(XML_RegExp_Attr)) != null) {
            newCommand.mRegExpMode = Boolean.parseBoolean(value);
        }
        if ((value = (String)attrMap.get(XML_ReplaceAll_Attr)) != null) {
            newCommand.mReplaceAll = Boolean.parseBoolean(value);
        }
        newCommand.mReplaceString = (String)dataMap.get(XML_ReplaceString_Tag);
        value = (String)attrMap.get(XML_SelectionScope_Attr);
        if (value != null) {
            newCommand.mScopeIsSelection = Boolean.parseBoolean(value);
        }
        if ((value = (String)attrMap.get(XML_WrapSearch_Attr)) != null) {
            newCommand.mWrapSearch = Boolean.parseBoolean(value);
        }
        return newCommand;
    }

    public void setSearchForward(boolean forward) {
        this.mSearchForward = forward;
    }

    public boolean isReplaceAll() {
        return this.mReplaceAll;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.mReplaceAll = replaceAll;
    }

    public boolean isCaseSensitive() {
        return this.mCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.mCaseSensitive = caseSensitive;
    }

    public boolean isMatchWholeWord() {
        return this.mMatchWholeWord;
    }

    public void setMatchWholeWord(boolean matchWholeWord) {
        this.mMatchWholeWord = matchWholeWord;
    }

    public boolean isRegExpMode() {
        return this.mRegExpMode;
    }

    public void setRegExpMode(boolean regExpMode) {
        this.mRegExpMode = regExpMode;
    }

    public String getSearchString() {
        return this.mSearchString;
    }

    public void setSearchString(String searchString) {
        this.mSearchString = searchString;
    }

    public String getReplaceString() {
        return this.mReplaceString;
    }

    public void setReplaceString(String replaceString) {
        this.mReplaceString = replaceString;
    }

    public boolean isSearchForward() {
        return this.mSearchForward;
    }

    public boolean isScopeIsSelection() {
        return this.mScopeIsSelection;
    }

    public void setScopeIsSelection(boolean scopeIsSelection) {
        this.mScopeIsSelection = scopeIsSelection;
    }

    public boolean isWrapSearch() {
        return this.mWrapSearch;
    }

    public void setWrapSearch(boolean wrapSearch) {
        this.mWrapSearch = wrapSearch;
    }

    public boolean requiresPost() {
        return false;
    }
}

