/*
 * Decompiled with CFR 0.152.
 */
package practicallymacro.actions;

import java.util.List;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import practicallymacro.actions.MacroFindAction;
import practicallymacro.commands.IMacroCommand;
import practicallymacro.dialogs.SaveMacroDialog;
import practicallymacro.editormacros.Activator;
import practicallymacro.model.EditorMacro;
import practicallymacro.model.MacroManager;
import practicallymacro.model.MacroRecorder;
import practicallymacro.util.MacroConsole;
import practicallymacro.util.Utilities;

public class RecordCommandAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static MacroRecorder mRecorder = null;
    private static ContributionItem mRecordingWidget = null;
    private static DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            RecordCommandAction.shutDownRecorder();
        }
    };
    private static IHandlerActivation mFindReplaceHandler = null;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        String state = MacroManager.getManager().getMacroState();
        if (state == "MACROSTATE_IDLE") {
            IEditorPart editor = Utilities.getActiveEditor();
            StyledText styledText = Utilities.getStyledText(editor);
            if (styledText == null) {
                return;
            }
            styledText.addDisposeListener(mDisposeListener);
            IStatusLineManager statusLineManager = editor.getEditorSite().getActionBars().getStatusLineManager();
            this.addStatusBarWidget(statusLineManager);
            mRecorder = new MacroRecorder(editor);
            mRecorder.start();
            styledText.addListener(1, (Listener)mRecorder);
            styledText.addListener(2, (Listener)mRecorder);
            IDocument document = Utilities.getIDocumentForEditor(mRecorder.getEditor());
            document.addDocumentListener((IDocumentListener)mRecorder);
            document.addDocumentListener(mRecorder.getMarkUpdater());
            ICommandService cs = MacroManager.getOldCommandService();
            cs.addExecutionListener((IExecutionListener)mRecorder);
            this.registerFindAction();
            MacroManager.getManager().setMacroState("MACROSTATE_RECORDING");
        } else if (state == "MACROSTATE_RECORDING") {
            RecordCommandAction.shutDownRecorder();
        }
    }

    private static void shutDownRecorder() {
        if (mRecorder == null) {
            return;
        }
        try {
            IEditorPart editor = mRecorder.getEditor();
            IEditorPart currentEditor = Utilities.getActiveEditor();
            try {
                if (currentEditor != null) {
                    IStatusLineManager statusLineManager = currentEditor.getEditorSite().getActionBars().getStatusLineManager();
                    RecordCommandAction.removeStatusBarWidget(statusLineManager);
                }
                try {
                    StyledText styledText = Utilities.getStyledText(editor);
                    if (styledText != null) {
                        styledText.removeListener(1, (Listener)mRecorder);
                        styledText.removeListener(2, (Listener)mRecorder);
                        styledText.removeDisposeListener(mDisposeListener);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    IDocument document = Utilities.getIDocumentForEditor(editor);
                    if (document != null) {
                        document.removeDocumentListener((IDocumentListener)mRecorder);
                        document.removeDocumentListener(mRecorder.getMarkUpdater());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ICommandService cs = MacroManager.getOldCommandService();
                cs.removeExecutionListener((IExecutionListener)mRecorder);
                try {
                    RecordCommandAction.unregisterFindAction();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mRecorder.stop();
            List<IMacroCommand> commands = mRecorder.getMacroCommands();
            if (commands.size() > 0) {
                if (Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_CompressCharInsertsWhenRecording")) {
                    commands = EditorMacro.compressStringInsertions(commands);
                }
                EditorMacro newMacro = null;
                if (Activator.getDefault().getPreferenceStore().getBoolean("PracticallyMacro_ShowSaveDialog")) {
                    Shell shell = Display.getDefault().getActiveShell();
                    SaveMacroDialog dlg = new SaveMacroDialog(shell, commands);
                    if (dlg.open() == 0) {
                        newMacro = dlg.getMacro();
                    }
                } else {
                    newMacro = new EditorMacro(commands, "", MacroManager.getManager().getUniqueMacroName(), "");
                }
                if (newMacro != null) {
                    MacroManager.getManager().addMacro(newMacro);
                    MacroManager.getManager().setLastMacro(newMacro);
                    newMacro.dump();
                }
            } else {
                MacroConsole.getConsole().writeln("No commands recorded; no macro defined", 3);
            }
        }
        finally {
            mRecorder = null;
            MacroManager.getManager().setMacroState("MACROSTATE_IDLE");
        }
    }

    private void addStatusBarWidget(IStatusLineManager statusLineManager) {
        if (mRecordingWidget == null) {
            mRecordingWidget = new RecordingWidget();
        }
        statusLineManager.add((IContributionItem)mRecordingWidget);
        statusLineManager.update(true);
    }

    private static void removeStatusBarWidget(IStatusLineManager statusLineManager) {
        if (mRecordingWidget != null) {
            statusLineManager.remove((IContributionItem)mRecordingWidget);
        }
        statusLineManager.update(true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void registerFindAction() {
        MacroFindAction macroFindAction = new MacroFindAction(mRecorder);
        IHandlerService hs = MacroManager.getOldHandlerService();
        ActionHandler actionHandler = new ActionHandler((IAction)macroFindAction);
        HighPriorityExpression expr = new HighPriorityExpression();
        mFindReplaceHandler = hs.activateHandler("org.eclipse.ui.edit.findReplace", (IHandler)actionHandler, (Expression)expr);
    }

    private static void unregisterFindAction() {
        if (mFindReplaceHandler != null) {
            mFindReplaceHandler.getHandlerService().deactivateHandler(mFindReplaceHandler);
        }
    }

    public static AbstractTextEditor findTextEditor(IEditorPart editor) {
        if (editor instanceof AbstractTextEditor) {
            return (AbstractTextEditor)editor;
        }
        if (editor instanceof MultiPageEditorPart) {
            IEditorPart[] parts;
            MultiPageEditorPart mpe = (MultiPageEditorPart)editor;
            IEditorPart[] iEditorPartArray = parts = mpe.findEditors(editor.getEditorInput());
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editorPart = iEditorPartArray[n2];
                if (editorPart instanceof AbstractTextEditor) {
                    return (AbstractTextEditor)editorPart;
                }
                ++n2;
            }
        }
        return null;
    }

    public static MacroRecorder getRecorder() {
        return mRecorder;
    }

    static class HighPriorityExpression
    extends Expression {
        public void collectExpressionInfo(ExpressionInfo info) {
            info.addVariableNameAccess("activeContexts");
            info.addVariableNameAccess("activePartId");
            info.addVariableNameAccess("activeSite");
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            return EvaluationResult.TRUE;
        }

        public boolean equals(Object obj) {
            return obj instanceof HighPriorityExpression;
        }

        public int hashCode() {
            return 20;
        }
    }

    private static class RecordingWidget
    extends ContributionItem {
        private static int DRAW_FLAGS = 15;
        CLabel mStatus;
        public static final String ID = "Recording_STATUS";

        public RecordingWidget() {
            super(ID);
        }

        public void fill(Composite parent) {
            Label sep = new Label(parent, 2);
            Composite comp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.horizontalSpacing = 1;
            gl.verticalSpacing = 0;
            comp.setLayout((Layout)gl);
            String recordingString = "Recording";
            this.mStatus = new CLabel(comp, 0x1000020);
            this.mStatus.setBackground(new Color[]{parent.getDisplay().getSystemColor(10), parent.getDisplay().getSystemColor(13)}, new int[]{100}, true);
            GridData lgd = new GridData(1808);
            int widthHint = -1;
            int heightHint = -1;
            GC gc = new GC((Drawable)this.mStatus);
            gc.setFont(this.mStatus.getFont());
            FontMetrics fm = gc.getFontMetrics();
            widthHint = gc.textExtent((String)recordingString, (int)RecordingWidget.DRAW_FLAGS).x + 6;
            heightHint = fm.getHeight();
            gc.dispose();
            lgd.widthHint = widthHint;
            this.mStatus.setLayoutData((Object)lgd);
            StatusLineLayoutData data = new StatusLineLayoutData();
            data.heightHint = heightHint;
            sep.setLayoutData((Object)data);
            StatusLineLayoutData overallData = new StatusLineLayoutData();
            overallData.heightHint = heightHint;
            overallData.widthHint = widthHint;
            comp.setLayoutData((Object)overallData);
            this.mStatus.setText(recordingString);
        }
    }
}

