/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogFederatedProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.ILUWModuleDdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlBuilder9;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlBuilder95;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlBuilder97;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlMessages;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlScript;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.FederatedProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWArrayDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPool;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWCursorDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDataPartition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabasePackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWGlobalVariable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWMaterializedQueryTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModule;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleArrayDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleCondition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleCursorDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleDistinctType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleFunction;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleGlobalVariable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleRowDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWNickname;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionGroup;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWRowDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWStorageTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWUserMapping;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWView;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWWrapper;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PLSQLPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PLSQLPackageBody;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Alias;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Index;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IndexType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2OLAPObject;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Procedure;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Trigger;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2UserDefinedFunction;
import org.eclipse.datatools.enablement.ibm.ddl.CoreDdlGenerator;
import org.eclipse.datatools.enablement.ibm.ddl.DdlBuilder;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.ddl.ExtendDdlBuilder;
import org.eclipse.datatools.enablement.ibm.ddl.OlapDdlBuilder;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactAnalyst;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactDescription;
import org.eclipse.datatools.enablement.ibm.util.EngineeringOptionID;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.RoleAuthorization;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LUWDdlGenerator
extends CoreDdlGenerator
implements IExecutableExtension {
    private static ILUWModuleDdlBuilder moduleBuilder = null;
    private String product;
    private String version;
    private EngineeringOption[] options = null;
    private EngineeringOption[] defaultOptions = null;
    private EngineeringOptionCategory[] categories = null;
    private LUWDdlBuilder builder = null;
    private static boolean isNickname = false;
    private OptionDependency optionDependency = null;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
        this.builder = "V8.1".equals(this.version) || "V8.2".equals(this.version) ? new LUWDdlBuilder(this) : ("V9.1".equals(this.version) ? new LUWDdlBuilder9(this) : ("V9.5".equals(this.version) ? new LUWDdlBuilder95(this) : new LUWDdlBuilder97(this)));
    }

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        String[] statements = new String[]{};
        String[] create = new String[]{};
        String[] drop = new String[]{};
        String[] comment = new String[]{};
        String[] statistics = new String[]{};
        EngineeringOption[] options = this.getSelectedOptions(elements);
        if (!this.checkModel(elements, options)) {
            this.builder.getEngineeringCallBack().writeMessage(LUWDdlMessages.FE_INVALID_MODEL);
            return statements;
        }
        create = this.createSQLObjects(elements, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])options), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])options), progressMonitor, callback);
        if (EngineeringOptionID.generateDropStatement((EngineeringOption[])options)) {
            drop = this.dropSQLObjects(elements, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])options), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])options), progressMonitor, callback);
        }
        if (EngineeringOptionID.generateCommentStatement((EngineeringOption[])options)) {
            comment = this.commentSQLObjects(elements, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])options), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])options), progressMonitor, callback);
        }
        if (EngineeringOptionID.generateStatistics((EngineeringOption[])options)) {
            statistics = this.updateStatisticsStatements(elements, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])options), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])options), progressMonitor, callback);
        }
        statements = new String[create.length + drop.length + comment.length + statistics.length];
        int i = 0;
        int j = 0;
        while (j < drop.length) {
            statements[i] = drop[j];
            ++i;
            ++j;
        }
        j = 0;
        while (j < create.length) {
            statements[i] = create[j];
            ++i;
            ++j;
        }
        j = 0;
        while (j < comment.length) {
            statements[i] = comment[j];
            ++i;
            ++j;
        }
        j = 0;
        while (j < statistics.length) {
            statements[i] = statistics[j];
            ++i;
            ++j;
        }
        return statements;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        OlapDdlBuilder olapBuilder;
        this.builder.setEngineeringCallBack(callback);
        String[] statements = this.createStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])this.options) && (olapBuilder = DdlGenerationUtility.getOlapDdlBuilder((String)this.product, (String)this.version)) != null && EngineeringOptionID.getOptionValue((String)olapBuilder.getOption(), (EngineeringOption[])this.getSelectedOptions(elements))) {
            String[] olap = olapBuilder.buildCreateStatement(elements, quoteIdentifiers, qualifyNames);
            String[] temp = statements;
            statements = new String[temp.length + olap.length];
            int i = 0;
            while (i < temp.length) {
                statements[i] = temp[i];
                ++i;
            }
            i = 0;
            while (i < olap.length) {
                statements[i + temp.length] = olap[i];
                ++i;
            }
        }
        return statements;
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        String[] statements = this.dropStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        String[] olap = null;
        OlapDdlBuilder olapBuilder = DdlGenerationUtility.getOlapDdlBuilder((String)this.product, (String)this.version);
        if (olapBuilder != null && EngineeringOptionID.getOptionValue((String)olapBuilder.getOption(), (EngineeringOption[])this.getSelectedOptions(elements)) && (olap = olapBuilder.buildDropStatement(elements, quoteIdentifiers, qualifyNames)) != null) {
            String[] temp = statements;
            statements = new String[temp.length + olap.length];
            int i = 0;
            while (i < olap.length) {
                statements[i] = olap[i];
                ++i;
            }
            i = 0;
            while (i < temp.length) {
                statements[i + olap.length] = temp[i];
                ++i;
            }
        }
        return statements;
    }

    public String[] commentSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        String[] statements = this.commentStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    private String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        Map patternMap = DdlGenerationUtility.getCodetemplatePatterns();
        long exclusiveType = 0L;
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof Column)) {
                exclusiveType |= EngineeringOptionID.COLUMN;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof User || elements[i] instanceof Group) {
                ((AuthorizationIdentifier)elements[i]).getDatabase().getPrivileges();
                break;
            }
            ++i;
        }
        new Vector();
        LUWDdlScript script = new LUWDdlScript();
        Set set = null;
        if (this.optionDependency != null) {
            set = this.optionDependency.getElementsToUse();
        }
        Iterator it = null;
        it = set != null && set.size() > 0 ? this.optionDependency.getElementsToUse().iterator() : LUWDdlGenerator.getAllContainedDisplayableElementSet(elements).iterator();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        ArrayList<UserDefinedType> userDefinedTypes = new ArrayList<UserDefinedType>();
        ArrayList<UserDefinedType> sortedUserDefinedTypes = new ArrayList<UserDefinedType>();
        while (it.hasNext()) {
            String statement;
            ExtendDdlBuilder extendDdlBuilder;
            String[] grantStatements;
            Object o = it.next();
            if (o instanceof LUWDatabasePackage) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((LUWDatabasePackage)o, quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof LUWNickname) {
                String statement2;
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options)) continue;
                extendDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder != null && EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) && (statement2 = this.builder.createNickname((LUWNickname)o, quoteIdentifiers, qualifyNames)) != null) {
                    script.addCreateNicknameStatement(statement2);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                String[] grantStatements2 = this.builder.grantOn((Table)((LUWNickname)o), quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements2.length) {
                    script.addGrantStatement(grantStatements2[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof LUWServer) {
                String statement3;
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options)) continue;
                LUWServer luwServer = (LUWServer)o;
                ExtendDdlBuilder extendDdlBuilder2 = DdlGenerationUtility.getRemoteServerDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder2 == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder2.getOption(), (EngineeringOption[])options) || (statement3 = this.builder.createRemoteServer(luwServer, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRemoteServerStatement(statement3);
                continue;
            }
            if (o instanceof LUWWrapper) {
                String statement4;
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options)) continue;
                LUWWrapper wrapper = (LUWWrapper)o;
                ExtendDdlBuilder extendDdlBuilder3 = DdlGenerationUtility.getWrapperDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder3 == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder3.getOption(), (EngineeringOption[])options) || (statement4 = this.builder.createWrapper(wrapper, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateWrapperStatement(statement4);
                continue;
            }
            if (o instanceof LUWUserMapping) {
                String statement5;
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || (extendDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder((String)this.product, (String)this.version)) == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) || (statement5 = this.builder.createUserMapping((LUWUserMapping)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateUserMappingStatement(statement5);
                continue;
            }
            if (o instanceof LUWMaterializedQueryTable) {
                if (!EngineeringOptionID.generateMQTs((EngineeringOption[])options)) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createMQT((LUWMaterializedQueryTable)o, quoteIdentifiers, qualifyNames)) != null) {
                    script.addCreateViewStatement(statement);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((Table)((LUWMaterializedQueryTable)o), quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof LUWTable) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options)) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createTable((BaseTable)((LUWTable)o), quoteIdentifiers, qualifyNames)) != null) {
                    String prolog = this.builder.createTableCodetemplate((Table)((LUWTable)o), 2, true, patternMap);
                    String postlog = this.builder.createTableCodetemplate((Table)((LUWTable)o), 2, false, patternMap);
                    script.addCreateTableStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((Table)((LUWTable)o), quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof LUWTableSpace) {
                if (!EngineeringOptionID.generateTablespaces((EngineeringOption[])options)) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createTablespace((LUWTableSpace)o, quoteIdentifiers)) != null) {
                    script.addCreateTablespaceStatement(statement);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((LUWTableSpace)o, quoteIdentifiers);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof LUWView) {
                if (!EngineeringOptionID.generateViews((EngineeringOption[])options)) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createView((LUWView)o, quoteIdentifiers, qualifyNames)) != null) {
                    String prolog = this.builder.createViewCodetemplate((ViewTable)((LUWView)o), 2, true, patternMap);
                    String postlog = this.builder.createViewCodetemplate((ViewTable)((LUWView)o), 2, false, patternMap);
                    script.addCreateViewStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((Table)((LUWView)o), quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof DB2Alias) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateAliases((EngineeringOption[])options) || (statement = this.builder.createAlias((DB2Alias)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof DB2Procedure) {
                statement = "";
                if (o instanceof FederatedProcedure) {
                    ExtendDdlBuilder extendDdlBuilder4;
                    if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || (extendDdlBuilder4 = DdlGenerationUtility.getFederatedProcedureDdlBuilder((String)this.product, (String)this.version)) == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder4.getOption(), (EngineeringOption[])options) || (statement = this.builder.createFederatedProcedure((FederatedProcedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addCreateFederatedProcedureStatement(statement);
                    continue;
                }
                if (o instanceof LUWModuleProcedure) {
                    if (!EngineeringOptionID.generateStoredProcedures((EngineeringOption[])options) || !EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || (statement = this.builder.createProcedure((DB2Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addCreateModuleRoutineStatement(statement);
                    continue;
                }
                if (!EngineeringOptionID.generateStoredProcedures((EngineeringOption[])options)) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createProcedure((DB2Procedure)o, quoteIdentifiers, qualifyNames)) != null) {
                    String prolog = this.builder.createRoutineCodetemplate((Routine)((DB2Procedure)o), 2, true, patternMap);
                    String postlog = this.builder.createRoutineCodetemplate((Routine)((DB2Procedure)o), 2, false, patternMap);
                    script.addCreateRoutineStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                String[] grantStatements3 = this.builder.grantOn((Procedure)((DB2Procedure)o), quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements3.length) {
                    script.addGrantStatement(grantStatements3[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof DB2UserDefinedFunction) {
                if (!EngineeringOptionID.generateFunctions((EngineeringOption[])options)) continue;
                if (o instanceof LUWModuleFunction) {
                    if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || (statement = this.builder.createUserDefinedFunction((DB2UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addCreateModuleRoutineStatement(statement);
                    continue;
                }
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createUserDefinedFunction((DB2UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) != null) {
                    String prolog = this.builder.createRoutineCodetemplate((Routine)((DB2UserDefinedFunction)o), 2, true, patternMap);
                    String postlog = this.builder.createRoutineCodetemplate((Routine)((DB2UserDefinedFunction)o), 2, false, patternMap);
                    script.addCreateRoutineStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((UserDefinedFunction)((DB2UserDefinedFunction)o), quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof DB2Trigger) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateTriggers((EngineeringOption[])options) || (statement = this.builder.createTrigger((DB2Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateCKConstraints((EngineeringOption[])options) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                String prolog = this.builder.createConstraintCodetemplate((TableConstraint)((CheckConstraint)o), 2, true, patternMap);
                String postlog = this.builder.createConstraintCodetemplate((TableConstraint)((CheckConstraint)o), 2, false, patternMap);
                script.addAlterTableAddConstraintStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generatePKConstraints((EngineeringOption[])options) || this.builder.isImplicitPK((TableConstraint)((UniqueConstraint)o)) || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                String prolog = this.builder.createConstraintCodetemplate((TableConstraint)((UniqueConstraint)o), 2, true, patternMap);
                String postlog = this.builder.createConstraintCodetemplate((TableConstraint)((UniqueConstraint)o), 2, false, patternMap);
                script.addAlterTableAddConstraintStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateFKConstraints((EngineeringOption[])options) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                String prolog = this.builder.createConstraintCodetemplate((TableConstraint)((ForeignKey)o), 2, true, patternMap);
                String postlog = this.builder.createConstraintCodetemplate((TableConstraint)((ForeignKey)o), 2, false, patternMap);
                script.addAlterTableAddForeignKeyStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof DB2Index) {
                if (!EngineeringOptionID.generateIndexes((EngineeringOption[])options) || ((DB2Index)o).isSystemGenerated() || ((DB2Index)o).getIndexType() != DB2IndexType.REGULAR_LITERAL) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createIndex((Index)((DB2Index)o), quoteIdentifiers, qualifyNames)) != null) {
                    if (((DB2Index)o).getTable() instanceof LUWTable) {
                        script.addCreateIndexStatement(statement);
                    } else {
                        script.addCreateViewIndexStatement(statement);
                    }
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((Index)((DB2Index)o), quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof Sequence) {
                if (!EngineeringOptionID.generateSequences((EngineeringOption[])options)) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createSequence((Sequence)o, quoteIdentifiers, qualifyNames)) != null) {
                    script.addCreateSequenceStatement(statement);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((Sequence)o, quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof Column) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options) || !EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || (exclusiveType & EngineeringOptionID.COLUMN) == EngineeringOptionID.COLUMN || (statement = this.builder.alterTableAddColumn((Column)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddColumnStatement(statement);
                continue;
            }
            if (o instanceof LUWBufferPool) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateBufferPool((EngineeringOption[])options) || (statement = this.builder.createBufferPool((LUWBufferPool)o, quoteIdentifiers)) == null) continue;
                script.addCreateBufferPoolStatement(statement);
                continue;
            }
            if (o instanceof LUWPartitionGroup) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generatePartitionGroup((EngineeringOption[])options) || (statement = this.builder.createPartitionGroup((LUWPartitionGroup)o, quoteIdentifiers)) == null) continue;
                script.addCreatePartitionGroupStatement(statement);
                continue;
            }
            if (o instanceof Schema) {
                if (!EngineeringOptionID.generateSchemas((EngineeringOption[])options)) continue;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && (statement = this.builder.createSchema((Schema)o, quoteIdentifiers, qualifyNames)) != null) {
                    script.addCreateSchemaStatement(statement);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((Schema)o, quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof Database) {
                if (!EngineeringOptionID.generateDatabase((EngineeringOption[])options) || !EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                grantStatements = this.builder.grantOn((Database)o, quoteIdentifiers);
                int igrant = 0;
                while (igrant < grantStatements.length) {
                    script.addGrantStatement(grantStatements[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof Privilege) {
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options) || (statement = this.builder.getGrantPrivilegeStatement((Privilege)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addGrantStatement(statement);
                continue;
            }
            if (o instanceof Role) {
                if (!EngineeringOptionID.generateRoles((EngineeringOption[])options) || !EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || (statement = this.builder.createRole((Role)o, quoteIdentifiers)) == null) continue;
                script.addCreateRoleStatement(statement);
                continue;
            }
            if (o instanceof RoleAuthorization) {
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options) || (statement = this.builder.getGrantRoleAuthorizationStatement((RoleAuthorization)o, quoteIdentifiers)) == null) continue;
                script.addGrantStatement(statement);
                continue;
            }
            if (o instanceof PLSQLPackage) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generatePacakges((EngineeringOption[])options)) continue;
                statement = this.builder.createPlsqlPackage((PLSQLPackage)o, quoteIdentifiers, qualifyNames);
                if (statement != null) {
                    script.addCreatePlsqlPackageStatement(statement);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                String[] grantStatements4 = this.builder.grantOn((PLSQLPackage)o, quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements4.length) {
                    script.addGrantStatement(grantStatements4[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof PLSQLPackageBody) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generatePacakgeBodys((EngineeringOption[])options) || (statement = this.builder.createPlsqlPackageBody((PLSQLPackageBody)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreatePlsqlPackageBodyStatement(statement);
                continue;
            }
            if (o instanceof LUWModule) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateModules((EngineeringOption[])options)) continue;
                statement = this.builder.createModule((LUWModule)o, quoteIdentifiers, qualifyNames);
                if (statement != null) {
                    script.addCreateModuleStatement(statement);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                String[] grantStatements5 = this.builder.grantOn((LUWModule)o, quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements5.length) {
                    script.addGrantStatement(grantStatements5[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (o instanceof LUWModuleCondition) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateModuleConditions((EngineeringOption[])options) || (statement = this.builder.createModuleCondition((LUWModuleCondition)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateModuleConditionStatement(statement);
                continue;
            }
            if (o instanceof LUWGlobalVariable) {
                if (!EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) || !EngineeringOptionID.generateGlobalVariables((EngineeringOption[])options)) continue;
                if (o instanceof LUWModuleGlobalVariable) {
                    statement = this.builder.createModuleGlobalVariable((LUWModuleGlobalVariable)o, quoteIdentifiers, qualifyNames);
                    if (statement == null) continue;
                    script.addCreateModuleGlobalVariableStatement(statement);
                    continue;
                }
                statement = this.builder.createGlobalVariable((LUWGlobalVariable)o, quoteIdentifiers, qualifyNames);
                if (statement != null) {
                    script.addCreateGlobalVariableStatement(statement);
                }
                if (!EngineeringOptionID.generateGrantStatement((EngineeringOption[])options)) continue;
                String[] grantStatements6 = this.builder.grantOn((LUWGlobalVariable)o, quoteIdentifiers, qualifyNames);
                int igrant = 0;
                while (igrant < grantStatements6.length) {
                    script.addGrantStatement(grantStatements6[igrant]);
                    ++igrant;
                }
                continue;
            }
            if (!(o instanceof UserDefinedType)) continue;
            userDefinedTypes.add((UserDefinedType)o);
        }
        this.sortUDTS(sortedUserDefinedTypes, userDefinedTypes);
        int j = 0;
        while (j < sortedUserDefinedTypes.size()) {
            UserDefinedType type = (UserDefinedType)sortedUserDefinedTypes.toArray()[j];
            if (type instanceof StructuredUserDefinedType) {
                String statement;
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options) && (statement = this.builder.createStructuredUserDefinedType((StructuredUserDefinedType)type, quoteIdentifiers, qualifyNames)) != null) {
                    script.addCreateUserDefinedTypeStatement(statement);
                }
            } else if (type instanceof DistinctUserDefinedType) {
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options)) {
                    if (type instanceof LUWModuleDistinctType) {
                        String statement = this.builder.createModuleDistinctType((LUWModuleDistinctType)type, quoteIdentifiers, qualifyNames);
                        if (statement != null) {
                            script.addCreateModuleTypeStatement(statement);
                        }
                    } else {
                        String statement = this.builder.createDistinctUserDefinedType((DistinctUserDefinedType)type, quoteIdentifiers, qualifyNames);
                        if (statement != null) {
                            script.addCreateUserDefinedTypeStatement(statement);
                        }
                    }
                }
            } else if (type instanceof LUWArrayDataType) {
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options)) {
                    String statement = this.builder.createArrayDataType((LUWArrayDataType)type, quoteIdentifiers, qualifyNames);
                    if (type instanceof LUWModuleArrayDataType) {
                        if (statement != null) {
                            script.addCreateModuleTypeStatement(statement);
                        }
                    } else if (statement != null) {
                        script.addCreateUserDefinedTypeStatement(statement);
                    }
                }
            } else if (type instanceof LUWRowDataType) {
                if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options)) {
                    String statement = this.builder.createRowDataType((LUWRowDataType)type, quoteIdentifiers, qualifyNames);
                    if (type instanceof LUWModuleRowDataType) {
                        if (statement != null) {
                            script.addCreateModuleTypeStatement(statement);
                        }
                    } else if (statement != null) {
                        script.addCreateUserDefinedTypeStatement(statement);
                    }
                }
            } else if (type instanceof LUWCursorDataType && EngineeringOptionID.generateCreateStatement((EngineeringOption[])options) && EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options)) {
                String statement = this.builder.createCursorDataType((LUWCursorDataType)type, quoteIdentifiers, qualifyNames);
                if (type instanceof LUWModuleCursorDataType) {
                    if (statement != null) {
                        script.addCreateModuleTypeStatement(statement);
                    }
                } else if (statement != null) {
                    script.addCreateUserDefinedTypeStatement(statement);
                }
            }
            ++j;
        }
        return script.getStatements();
    }

    private void sortUDTS(List<UserDefinedType> sortedUserDefinedTypes, List<UserDefinedType> selectedUserDefinedTypes) {
        int i = 0;
        while (i < selectedUserDefinedTypes.size()) {
            UserDefinedType type = selectedUserDefinedTypes.get(i);
            if (type instanceof DistinctUserDefinedType) {
                if (!sortedUserDefinedTypes.contains(type)) {
                    sortedUserDefinedTypes.add(type);
                }
            } else {
                List<Object> dependency = new ArrayList();
                dependency = this.getDependency(type, selectedUserDefinedTypes);
                if (dependency != null && dependency.size() > 0) {
                    int j = 0;
                    while (j < dependency.size()) {
                        UserDefinedType dependType = (UserDefinedType)dependency.get(j);
                        if (!sortedUserDefinedTypes.contains(dependType)) {
                            sortedUserDefinedTypes.add(dependType);
                        }
                        ++j;
                    }
                }
                if (!sortedUserDefinedTypes.contains(type)) {
                    sortedUserDefinedTypes.add(type);
                }
            }
            ++i;
        }
    }

    private List<UserDefinedType> getDependency(UserDefinedType type, List<UserDefinedType> selectTypes) {
        ArrayList<UserDefinedType> dependency = new ArrayList<UserDefinedType>();
        ArrayList<UserDefinedType> dependencyAll = new ArrayList<UserDefinedType>();
        ArrayList<UserDefinedType> accessList = new ArrayList<UserDefinedType>();
        this.getDependency(type, dependencyAll, accessList);
        int i = 0;
        while (i < dependencyAll.size()) {
            UserDefinedType dependType = (UserDefinedType)dependencyAll.get(i);
            if (selectTypes.contains(dependType)) {
                dependency.add(dependType);
            }
            ++i;
        }
        return dependency;
    }

    private void getDependency(UserDefinedType type, List<UserDefinedType> dependencyList, List<UserDefinedType> accessList) {
        if (type != null && !accessList.contains(type)) {
            DependencyImpactAnalyst m_DepAnalayst;
            DependencyImpactDescription[] array;
            StructuredUserDefinedType structureType;
            accessList.add(type);
            if (type instanceof StructuredUserDefinedType && (structureType = (StructuredUserDefinedType)type).getSuper() != null) {
                this.getDependency((UserDefinedType)structureType.getSuper(), dependencyList, accessList);
            }
            if ((array = (m_DepAnalayst = DependencyImpactAnalyst.getInstance()).getDirectDependencies((EObject)type, -1)) != null && array.length > 0) {
                int i = array.length - 1;
                while (i >= 0) {
                    DependencyImpactDescription depend = array[i];
                    EObject targetType = depend.getTarget();
                    if (!accessList.contains(targetType) && targetType instanceof UserDefinedType) {
                        if (targetType instanceof StructuredUserDefinedType) {
                            StructuredUserDefinedType superType = ((StructuredUserDefinedType)targetType).getSuper();
                            if (targetType != null && superType != null) {
                                this.getDependency((UserDefinedType)((StructuredUserDefinedType)depend.getTarget()).getSuper(), dependencyList, accessList);
                            }
                        }
                        dependencyList.add((UserDefinedType)targetType);
                    }
                    --i;
                }
            }
            if (!dependencyList.contains(type)) {
                dependencyList.add(type);
            }
        }
    }

    private String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        Map patternMap = DdlGenerationUtility.getCodetemplatePatterns();
        LUWDdlScript script = new LUWDdlScript();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        for (Object o : this.getAllContainedDisplayableElements(elements)) {
            String postlog;
            String prolog;
            String statement;
            String statement2;
            ExtendDdlBuilder extendDdlBuilder;
            if (o instanceof LUWNickname) {
                extendDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) || (statement2 = this.builder.dropNickname((LUWNickname)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropNicknameStatement(statement2);
                continue;
            }
            if (o instanceof LUWServer) {
                extendDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) || (statement2 = this.builder.dropRemoteServer((LUWServer)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRemoteServerStatement(statement2);
                continue;
            }
            if (o instanceof LUWWrapper) {
                extendDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) || (statement2 = this.builder.dropWrapper((LUWWrapper)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropWrapperStatement(statement2);
                continue;
            }
            if (o instanceof LUWUserMapping) {
                extendDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) || (statement2 = this.builder.dropUserMapping((LUWUserMapping)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropUserMappingStatement(statement2);
                continue;
            }
            if (o instanceof LUWMaterializedQueryTable) {
                if (!EngineeringOptionID.generateMQTs((EngineeringOption[])options) || (statement = this.builder.dropMQT((LUWMaterializedQueryTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof LUWDatabasePackage) {
                if (!EngineeringOptionID.generatePacakges((EngineeringOption[])options) || (statement = this.builder.dropPackage((LUWDatabasePackage)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropPackageStatement(statement);
                continue;
            }
            if (o instanceof LUWTable) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options) || (statement = this.builder.dropTable((BaseTable)((LUWTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                prolog = this.builder.createTableCodetemplate((Table)((LUWTable)o), 4, true, patternMap);
                postlog = this.builder.createTableCodetemplate((Table)((LUWTable)o), 4, false, patternMap);
                script.addDropTableStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof LUWView) {
                if (!EngineeringOptionID.generateViews((EngineeringOption[])options) || (statement = this.builder.dropView((ViewTable)((LUWView)o), quoteIdentifiers, qualifyNames)) == null) continue;
                prolog = this.builder.createViewCodetemplate((ViewTable)((LUWView)o), 4, true, patternMap);
                postlog = this.builder.createViewCodetemplate((ViewTable)((LUWView)o), 4, false, patternMap);
                script.addDropViewStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof DB2Alias) {
                if (!EngineeringOptionID.generateAliases((EngineeringOption[])options) || (statement = this.builder.dropAlias((DB2Alias)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof DB2Procedure) {
                if (!EngineeringOptionID.generateStoredProcedures((EngineeringOption[])options)) continue;
                statement = "";
                if (o instanceof FederatedProcedure) {
                    statement = this.builder.dropProcedure((Procedure)((DB2Procedure)o), quoteIdentifiers, qualifyNames);
                    if (statement == null) continue;
                    script.addDropRoutineStatement(statement);
                    continue;
                }
                if (o instanceof LUWModuleProcedure) {
                    statement = this.builder.dropProcedure((Procedure)((DB2Procedure)o), quoteIdentifiers, qualifyNames);
                    if (statement == null) continue;
                    script.addDropModuleRoutineStatement(statement);
                    continue;
                }
                statement = this.builder.dropProcedure((Procedure)((DB2Procedure)o), quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                prolog = this.builder.createRoutineCodetemplate((Routine)((DB2Procedure)o), 4, true, patternMap);
                postlog = this.builder.createRoutineCodetemplate((Routine)((DB2Procedure)o), 4, false, patternMap);
                script.addDropRoutineStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof DB2UserDefinedFunction) {
                if (!EngineeringOptionID.generateFunctions((EngineeringOption[])options) || (statement = this.builder.dropFunction((UserDefinedFunction)((DB2UserDefinedFunction)o), quoteIdentifiers, qualifyNames)) == null) continue;
                if (o instanceof LUWModuleFunction) {
                    statement = this.builder.dropFunction((UserDefinedFunction)((DB2UserDefinedFunction)o), quoteIdentifiers, qualifyNames);
                    script.addDropModuleRoutineStatement(statement);
                    continue;
                }
                prolog = this.builder.createRoutineCodetemplate((Routine)((DB2UserDefinedFunction)o), 4, true, patternMap);
                postlog = this.builder.createRoutineCodetemplate((Routine)((DB2UserDefinedFunction)o), 4, false, patternMap);
                script.addDropRoutineStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof DB2Trigger) {
                if (!EngineeringOptionID.generateTriggers((EngineeringOption[])options) || (statement = this.builder.dropTrigger((Trigger)((DB2Trigger)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!EngineeringOptionID.generateCKConstraints((EngineeringOption[])options) || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                prolog = this.builder.createConstraintCodetemplate((TableConstraint)((CheckConstraint)o), 4, true, patternMap);
                postlog = this.builder.createConstraintCodetemplate((TableConstraint)((CheckConstraint)o), 4, false, patternMap);
                script.addAlterTableDropConstraintStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!EngineeringOptionID.generatePKConstraints((EngineeringOption[])options) || this.builder.isImplicitPK((TableConstraint)((UniqueConstraint)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                prolog = this.builder.createConstraintCodetemplate((TableConstraint)((UniqueConstraint)o), 4, true, patternMap);
                postlog = this.builder.createConstraintCodetemplate((TableConstraint)((UniqueConstraint)o), 4, false, patternMap);
                script.addAlterTableDropConstraintStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!EngineeringOptionID.generateFKConstraints((EngineeringOption[])options) || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                prolog = this.builder.createConstraintCodetemplate((TableConstraint)((ForeignKey)o), 4, true, patternMap);
                postlog = this.builder.createConstraintCodetemplate((TableConstraint)((ForeignKey)o), 4, false, patternMap);
                script.addAlterTableDropForeignKeyStatements(statement, script.combineTemplateStatements(prolog, statement, postlog));
                continue;
            }
            if (o instanceof DB2Index) {
                if (!EngineeringOptionID.generateIndexes((EngineeringOption[])options) || ((DB2Index)o).isSystemGenerated() || ((DB2Index)o).getIndexType() != DB2IndexType.REGULAR_LITERAL || (statement = this.builder.dropIndex((Index)((DB2Index)o), quoteIdentifiers, qualifyNames)) == null) continue;
                if (((DB2Index)o).getTable() instanceof LUWTable) {
                    script.addDropIndexStatement(statement);
                    continue;
                }
                script.addDropViewIndexStatement(statement);
                continue;
            }
            if (o instanceof LUWTableSpace) {
                if (!EngineeringOptionID.generateTablespaces((EngineeringOption[])options) || (statement = this.builder.dropTablespace((LUWTableSpace)o, quoteIdentifiers)) == null) continue;
                script.addDropTablespaceStatement(statement);
                continue;
            }
            if (o instanceof Sequence) {
                if (!EngineeringOptionID.generateSequences((EngineeringOption[])options) || (statement = this.builder.dropSequence((Sequence)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropSequenceStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedType) {
                if (!EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options)) continue;
                statement = this.builder.dropUserDefinedType((UserDefinedType)o, quoteIdentifiers, qualifyNames);
                if (o instanceof LUWModuleObject) {
                    if (statement == null) continue;
                    script.addDropModuleTypeStatement(statement);
                    continue;
                }
                if (statement == null) continue;
                script.addDropUserDefinedTypeStatement(statement);
                continue;
            }
            if (o instanceof LUWBufferPool) {
                if (!EngineeringOptionID.generateBufferPool((EngineeringOption[])options) || (statement = this.builder.dropBufferPool((LUWBufferPool)o, quoteIdentifiers)) == null) continue;
                script.addDropBufferPoolStatement(statement);
                continue;
            }
            if (o instanceof LUWPartitionGroup) {
                if (!EngineeringOptionID.generatePartitionGroup((EngineeringOption[])options) || (statement = this.builder.dropPartitionGroup((LUWPartitionGroup)o, quoteIdentifiers)) == null) continue;
                script.addDropPartitionStatement(statement);
                continue;
            }
            if (o instanceof Schema) {
                if (!EngineeringOptionID.generateSchemas((EngineeringOption[])options) || (statement = this.builder.dropSchema((Schema)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropSchemaStatement(statement);
                continue;
            }
            if (o instanceof Privilege) {
                if (!EngineeringOptionID.generateRevokeStatement((EngineeringOption[])options) || (statement = this.builder.getRevokePrivilegeStatement((Privilege)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addRevokeStatement(statement);
                continue;
            }
            if (o instanceof RoleAuthorization) {
                if (!EngineeringOptionID.generateRevokeStatement((EngineeringOption[])options) || (statement = this.builder.getRevokeRoleAuthorizationStatement((RoleAuthorization)o, quoteIdentifiers)) == null) continue;
                script.addRevokeStatement(statement);
                continue;
            }
            if (o instanceof AuthorizationIdentifier) {
                ((AuthorizationIdentifier)o).getDatabase().getPrivileges();
                if (EngineeringOptionID.generateRevokeStatement((EngineeringOption[])options)) {
                    Iterator pIt = ((AuthorizationIdentifier)o).getReceivedPrivilege().iterator();
                    while (pIt.hasNext()) {
                        statement2 = this.builder.getRevokePrivilegeStatement((Privilege)pIt.next(), quoteIdentifiers, qualifyNames);
                        if (statement2 == null) continue;
                        script.addRevokeStatement(statement2);
                    }
                }
                if (!(o instanceof Role) || !EngineeringOptionID.generateRoles((EngineeringOption[])options) || (statement = this.builder.dropRole((Role)o, quoteIdentifiers)) == null) continue;
                script.addDropRoleStatement(statement);
                continue;
            }
            if (o instanceof PLSQLPackage) {
                if (!EngineeringOptionID.generatePacakges((EngineeringOption[])options) || (statement = this.builder.dropPlsqlPackage((PLSQLPackage)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropPlsqlPackageStatement(statement);
                continue;
            }
            if (o instanceof PLSQLPackageBody) {
                if (!EngineeringOptionID.generatePacakgeBodys((EngineeringOption[])options) || (statement = this.builder.dropPlsqlPackageBody((PLSQLPackageBody)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropPlsqlPackageBodyStatement(statement);
                continue;
            }
            if (o instanceof LUWModule) {
                if (!EngineeringOptionID.generateModules((EngineeringOption[])options) || (statement = this.builder.dropModule((LUWModule)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropModuleStatement(statement);
                continue;
            }
            if (o instanceof LUWModuleCondition) {
                if (!EngineeringOptionID.generateModuleConditions((EngineeringOption[])options) || (statement = this.builder.dropModuleCondition((LUWModuleCondition)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropModuleConditionStatement(statement);
                continue;
            }
            if (!(o instanceof LUWGlobalVariable) || !EngineeringOptionID.generateGlobalVariables((EngineeringOption[])options)) continue;
            if (o instanceof LUWModuleGlobalVariable) {
                statement = this.builder.dropModuleGlobalVariable((LUWModuleGlobalVariable)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addDropModuleGlobalVariableStatement(statement);
                continue;
            }
            statement = this.builder.dropGlobalVariable((LUWGlobalVariable)o, quoteIdentifiers, qualifyNames);
            if (statement == null) continue;
            script.addDropGlobalVariableStatement(statement);
        }
        return script.getStatements();
    }

    protected Collection getAllContainedDisplayableElements(SQLObject[] elements) {
        ArrayList<SQLObject> temp = new ArrayList<SQLObject>();
        SQLObject nullid = null;
        SQLObject[] sQLObjectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            SQLObject sqlobj = sQLObjectArray[n2];
            if (!(sqlobj instanceof Schema) || !"NULLID".equals(sqlobj.getName())) {
                temp.add(sqlobj);
            } else {
                nullid = sqlobj;
            }
            ++n2;
        }
        if (nullid == null) {
            return DdlGenerationUtility.getAllContainedDisplayableElementSet((SQLObject[])elements);
        }
        SQLObject[] elementsWithoutNullId = new SQLObject[temp.size()];
        temp.toArray(elementsWithoutNullId);
        ArrayList<SQLObject> temp2 = new ArrayList<SQLObject>();
        temp2.addAll(DdlGenerationUtility.getAllContainedDisplayableElementSet((SQLObject[])elementsWithoutNullId));
        temp2.add(nullid);
        return temp2;
    }

    public String[] alterTableDropColumn(SQLObject[] columns, SQLObject[] impacts, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        LUWDdlScript script = new LUWDdlScript();
        int col = 0;
        while (col < columns.length) {
            Column o = (Column)columns[col];
            String statement = this.builder.alterTableDropColumn(o, true, true);
            if (statement != null) {
                script.addAlterTableDropColumnStatement(statement);
                script.addAlterTableDropColumnStatement(this.builder.reorgTable(o, true, true));
            }
            ++col;
        }
        return script.getStatements();
    }

    private String[] commentStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        new Vector();
        LUWDdlScript script = new LUWDdlScript();
        Iterator it = LUWDdlGenerator.getAllContainedDisplayableElementSet(elements).iterator();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        while (it.hasNext()) {
            String statement;
            String statement2;
            ExtendDdlBuilder extendDdlBuilder;
            Object o = it.next();
            if (o instanceof LUWNickname) {
                String statement3;
                ExtendDdlBuilder extendDdlBuilder2 = DdlGenerationUtility.getNicknameDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder2 == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder2.getOption(), (EngineeringOption[])options) || (statement3 = this.builder.commentOn((LUWNickname)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement3);
                continue;
            }
            if (o instanceof LUWServer) {
                LUWServer luwServer = (LUWServer)o;
                extendDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) || (statement2 = this.builder.commentOn(luwServer, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement2);
                continue;
            }
            if (o instanceof LUWWrapper) {
                LUWWrapper wrapper = (LUWWrapper)o;
                extendDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder((String)this.product, (String)this.version);
                if (extendDdlBuilder == null || !EngineeringOptionID.getOptionValue((String)extendDdlBuilder.getOption(), (EngineeringOption[])options) || (statement2 = this.builder.commentOn(wrapper, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement2);
                continue;
            }
            if (o instanceof LUWMaterializedQueryTable) {
                if (!EngineeringOptionID.generateMQTs((EngineeringOption[])options) || (statement = this.builder.commentOn((Table)((LUWMaterializedQueryTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof LUWTable) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options) || (statement = this.builder.commentOn((Table)((LUWTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof LUWTableSpace) {
                if (!EngineeringOptionID.generateTablespaces((EngineeringOption[])options) || (statement = this.builder.commentOn((LUWTableSpace)o, quoteIdentifiers)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof LUWView) {
                if (!EngineeringOptionID.generateViews((EngineeringOption[])options) || (statement = this.builder.commentOn((Table)((LUWView)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof DB2Alias) {
                if (!EngineeringOptionID.generateAliases((EngineeringOption[])options) || (statement = this.builder.commentOn((DB2Alias)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof DB2Procedure) {
                if (!EngineeringOptionID.generateStoredProcedures((EngineeringOption[])options) || (statement = this.builder.commentOn((Procedure)((DB2Procedure)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof DB2UserDefinedFunction) {
                if (!EngineeringOptionID.generateFunctions((EngineeringOption[])options) || (statement = this.builder.commentOn((UserDefinedFunction)((DB2UserDefinedFunction)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof DB2Trigger) {
                if (!EngineeringOptionID.generateTriggers((EngineeringOption[])options) || (statement = this.builder.commentOn((Trigger)((DB2Trigger)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!EngineeringOptionID.generateCKConstraints((EngineeringOption[])options) || (statement = this.builder.commentOn((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!EngineeringOptionID.generatePKConstraints((EngineeringOption[])options) || this.builder.isImplicitPK((TableConstraint)((UniqueConstraint)o)) || (statement = this.builder.commentOn((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!EngineeringOptionID.generateFKConstraints((EngineeringOption[])options) || (statement = this.builder.commentOn((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof DB2Index) {
                if (!EngineeringOptionID.generateIndexes((EngineeringOption[])options) || ((DB2Index)o).isSystemGenerated() || ((DB2Index)o).getIndexType() != DB2IndexType.REGULAR_LITERAL || (statement = this.builder.commentOn((Index)((DB2Index)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof DistinctUserDefinedType) {
                if (!EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options) || (statement = this.builder.commentOn((DistinctUserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof StructuredUserDefinedType) {
                if (!EngineeringOptionID.generateUserDefinedTypes((EngineeringOption[])options) || (statement = this.builder.commentOn((StructuredUserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof Column) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options) || (statement = this.builder.commentOn((Column)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof LUWPartitionGroup) {
                if (!EngineeringOptionID.generatePartitionGroup((EngineeringOption[])options) || (statement = this.builder.commentOn((LUWPartitionGroup)o, quoteIdentifiers)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof Schema) {
                if (!EngineeringOptionID.generateSchemas((EngineeringOption[])options) || (statement = this.builder.commentOn((Schema)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof Role) {
                if (!EngineeringOptionID.generateRoles((EngineeringOption[])options) || (statement = this.builder.commentOn((Role)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof LUWModule) {
                if (!EngineeringOptionID.generateModules((EngineeringOption[])options) || (statement = this.builder.commentOn((LUWModule)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (o instanceof LUWModuleCondition) {
                if (!EngineeringOptionID.generateModuleConditions((EngineeringOption[])options) || (statement = this.builder.commentOn((LUWModuleCondition)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCommentOnStatement(statement);
                continue;
            }
            if (!(o instanceof Sequence) || !EngineeringOptionID.generateSequences((EngineeringOption[])options) || (statement = this.builder.commentOn((Sequence)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCommentOnStatement(statement);
        }
        return script.getStatements();
    }

    private String[] updateStatisticsStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        new Vector();
        LUWDdlScript script = new LUWDdlScript();
        Iterator it = LUWDdlGenerator.getAllContainedDisplayableElementSet(elements).iterator();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        while (it.hasNext()) {
            int iStat;
            String[] statements;
            Object o = it.next();
            if (o instanceof LUWNickname) {
                statements = this.builder.updateStatistics((Table)((LUWNickname)o), quoteIdentifiers, qualifyNames);
                if (statements == null) continue;
                iStat = 0;
                while (iStat < statements.length) {
                    script.addUpdateStatisticsStatement(statements[iStat]);
                    ++iStat;
                }
                continue;
            }
            if (o instanceof LUWMaterializedQueryTable) {
                if (!EngineeringOptionID.generateMQTs((EngineeringOption[])options) || (statements = this.builder.updateStatistics((Table)((LUWMaterializedQueryTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                iStat = 0;
                while (iStat < statements.length) {
                    script.addUpdateStatisticsStatement(statements[iStat]);
                    ++iStat;
                }
                continue;
            }
            if (o instanceof LUWTable) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options) || (statements = this.builder.updateStatistics((Table)((LUWTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                iStat = 0;
                while (iStat < statements.length) {
                    script.addUpdateStatisticsStatement(statements[iStat]);
                    ++iStat;
                }
                continue;
            }
            if (o instanceof DB2Procedure) {
                if (!EngineeringOptionID.generateStoredProcedures((EngineeringOption[])options) || (statements = this.builder.updateStatistics((Routine)((DB2Procedure)o), quoteIdentifiers, qualifyNames)) == null) continue;
                iStat = 0;
                while (iStat < statements.length) {
                    script.addUpdateStatisticsStatement(statements[iStat]);
                    ++iStat;
                }
                continue;
            }
            if (o instanceof DB2UserDefinedFunction) {
                if (!EngineeringOptionID.generateFunctions((EngineeringOption[])options) || (statements = this.builder.updateStatistics((Routine)((DB2UserDefinedFunction)o), quoteIdentifiers, qualifyNames)) == null) continue;
                iStat = 0;
                while (iStat < statements.length) {
                    script.addUpdateStatisticsStatement(statements[iStat]);
                    ++iStat;
                }
                continue;
            }
            if (o instanceof DB2Index) {
                if (!EngineeringOptionID.generateIndexes((EngineeringOption[])options) || (statements = this.builder.updateStatistics((Index)((DB2Index)o), quoteIdentifiers, qualifyNames)) == null) continue;
                iStat = 0;
                while (iStat < statements.length) {
                    script.addUpdateStatisticsStatement(statements[iStat]);
                    ++iStat;
                }
                continue;
            }
            if (!(o instanceof Column) || !EngineeringOptionID.generateTables((EngineeringOption[])options) || (statements = this.builder.updateStatistics((Column)o, quoteIdentifiers, qualifyNames)) == null) continue;
            iStat = 0;
            while (iStat < statements.length) {
                script.addUpdateStatisticsStatement(statements[iStat]);
                ++iStat;
            }
        }
        return script.getStatements();
    }

    private static Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        LinkedHashSet<Object> s = new LinkedHashSet<Object>();
        int i = 0;
        while (i < elements.length) {
            PLSQLPackage plsqlPkg;
            PLSQLPackageBody pkgBody;
            LUWUserMapping userMapping;
            Iterator itUserMapping;
            LUWWrapper wrapper;
            LUWServer luwServer;
            if (!s.contains(elements[i])) {
                s.add(elements[i]);
            }
            if (elements[i] instanceof LUWNickname) {
                luwServer = ((LUWNickname)elements[i]).getServer();
                if (luwServer != null) {
                    s.add(luwServer);
                    wrapper = luwServer.getWrapper();
                    if (wrapper != null) {
                        s.add(wrapper);
                    }
                    if ((itUserMapping = luwServer.getUserMappings().iterator()).hasNext()) {
                        userMapping = (LUWUserMapping)itUserMapping.next();
                        s.add(userMapping);
                    }
                }
            } else if (elements[i] instanceof FederatedProcedure) {
                luwServer = ((LUWCatalogFederatedProcedure)elements[i]).getFederatedServer();
                if (luwServer != null) {
                    s.add(luwServer);
                    wrapper = luwServer.getWrapper();
                    if (wrapper != null) {
                        s.add(wrapper);
                    }
                    if ((itUserMapping = luwServer.getUserMappings().iterator()).hasNext()) {
                        userMapping = (LUWUserMapping)itUserMapping.next();
                        s.add(userMapping);
                    }
                }
            } else if (elements[i] instanceof LUWStorageTable) {
                LUWStorageTable lst = (LUWStorageTable)elements[i];
                if (!s.contains(lst.getLOBDataTableSpace())) {
                    s.add(lst.getLOBDataTableSpace());
                }
                if (!s.contains(lst.getIndexDataTableSpace())) {
                    s.add(lst.getIndexDataTableSpace());
                }
                if (!s.contains(lst.getRegularDataTableSpace())) {
                    s.add(lst.getRegularDataTableSpace());
                }
                if (lst.getDataPartitions().size() != 0) {
                    for (LUWDataPartition dp : lst.getDataPartitions()) {
                        if (!s.contains(dp.getRegularDataTableSpace())) {
                            s.add(dp.getRegularDataTableSpace());
                        }
                        if (s.contains(dp.getLOBDataTableSpace())) continue;
                        s.add(dp.getLOBDataTableSpace());
                    }
                }
            } else if (elements[i] instanceof LUWServer) {
                luwServer = (LUWServer)elements[i];
                wrapper = luwServer.getWrapper();
                if (wrapper != null) {
                    s.add(wrapper);
                }
                if ((itUserMapping = luwServer.getUserMappings().iterator()).hasNext()) {
                    userMapping = (LUWUserMapping)itUserMapping.next();
                    s.add(userMapping);
                }
                for (LUWNickname nickame : luwServer.getNicknames()) {
                    s.add(nickame);
                }
            } else if (elements[i] instanceof LUWWrapper) {
                LUWWrapper luwWrapper = (LUWWrapper)elements[i];
                for (LUWServer luwServer2 : luwWrapper.getServers()) {
                    s.add(luwServer2);
                    Iterator itUserMapping2 = luwServer2.getUserMappings().iterator();
                    if (itUserMapping2.hasNext()) {
                        LUWUserMapping userMapping2 = (LUWUserMapping)itUserMapping2.next();
                        s.add(userMapping2);
                    }
                    for (LUWNickname nickame : luwServer2.getNicknames()) {
                        s.add(nickame);
                    }
                }
            } else if (elements[i] instanceof PLSQLPackage && (pkgBody = (plsqlPkg = (PLSQLPackage)elements[i]).getPackageBody()) != null) {
                s.add(pkgBody);
            }
            Iterator iter = null;
            iter = elements[i] instanceof AuthorizationIdentifier ? ContainmentServiceImpl.INSTANCE.getAllContainedElements((EObject)elements[i]).iterator() : ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]).iterator();
            while (iter.hasNext()) {
                LUWUserMapping userMapping3;
                Iterator itUserMapping3;
                LUWWrapper wrapper2;
                LUWServer luwServer2;
                Object element = iter.next();
                if (!s.contains(element)) {
                    s.add(element);
                }
                if (element instanceof LUWNickname) {
                    luwServer2 = ((LUWNickname)element).getServer();
                    if (luwServer2 == null) continue;
                    s.add(luwServer2);
                    wrapper2 = luwServer2.getWrapper();
                    if (wrapper2 != null) {
                        s.add(wrapper2);
                    }
                    if (!(itUserMapping3 = luwServer2.getUserMappings().iterator()).hasNext()) continue;
                    userMapping3 = (LUWUserMapping)itUserMapping3.next();
                    s.add(userMapping3);
                    continue;
                }
                if (element instanceof LUWStorageTable) {
                    LUWStorageTable lst = (LUWStorageTable)element;
                    if (!s.contains(lst.getLOBDataTableSpace())) {
                        s.add(lst.getLOBDataTableSpace());
                    }
                    if (!s.contains(lst.getIndexDataTableSpace())) {
                        s.add(lst.getIndexDataTableSpace());
                    }
                    if (!s.contains(lst.getRegularDataTableSpace())) {
                        s.add(lst.getRegularDataTableSpace());
                    }
                    if (lst.getDataPartitions().size() == 0) continue;
                    for (LUWDataPartition dp : lst.getDataPartitions()) {
                        if (!s.contains(dp.getRegularDataTableSpace())) {
                            s.add(dp.getRegularDataTableSpace());
                        }
                        if (s.contains(dp.getLOBDataTableSpace())) continue;
                        s.add(dp.getLOBDataTableSpace());
                    }
                    continue;
                }
                if (element instanceof LUWServer) {
                    luwServer2 = (LUWServer)element;
                    wrapper2 = luwServer2.getWrapper();
                    if (wrapper2 != null) {
                        s.add(wrapper2);
                    }
                    if ((itUserMapping3 = luwServer2.getUserMappings().iterator()).hasNext()) {
                        userMapping3 = (LUWUserMapping)itUserMapping3.next();
                        s.add(userMapping3);
                    }
                    for (LUWNickname nickame : luwServer2.getNicknames()) {
                        s.add(nickame);
                    }
                    continue;
                }
                if (!(element instanceof LUWWrapper)) continue;
                LUWWrapper luwWrapper = (LUWWrapper)element;
                for (LUWServer luwServer3 : luwWrapper.getServers()) {
                    s.add(luwServer3);
                    Iterator itUserMapping4 = luwServer3.getUserMappings().iterator();
                    if (itUserMapping4.hasNext()) {
                        LUWUserMapping userMapping4 = (LUWUserMapping)itUserMapping4.next();
                        s.add(userMapping4);
                    }
                    for (LUWNickname nickame : luwServer3.getNicknames()) {
                        s.add(nickame);
                    }
                }
            }
            ++i;
        }
        return s;
    }

    private static void discover(Set result, Data element) {
        Set childs = element.childs;
        while (childs != null && childs.size() > 0) {
            result.addAll(element.sOptions);
            Iterator it = childs.iterator();
            while (it.hasNext()) {
                LUWDdlGenerator.discover(result, (Data)it.next());
            }
        }
    }

    private static Set getAllContainedDisplayableElementSetDepedency(SQLObject[] elements) {
        SingletonOptionDependency sod = SingletonOptionDependency.getSingletonObject();
        TreeSet s = new TreeSet();
        int i = 0;
        while (i < elements.length) {
            Class key = null;
            if (elements[i] instanceof LUWDatabase) {
                key = Database.class;
            } else if (elements[i] instanceof Schema) {
                key = Schema.class;
            } else if (elements[i] instanceof LUWTable) {
                if (elements[i] instanceof LUWNickname) {
                    key = LUWNickname.class;
                    isNickname = true;
                } else {
                    key = Table.class;
                }
            } else if (elements[i] instanceof LUWServer) {
                key = LUWServer.class;
            } else if (elements[i] instanceof LUWWrapper) {
                key = LUWWrapper.class;
            } else if (elements[i] instanceof LUWUserMapping) {
                key = LUWUserMapping.class;
            } else if (elements[i] instanceof DB2OLAPObject) {
                key = DB2OLAPObject.class;
            } else if (elements[i] instanceof LUWTableSpace) {
                key = LUWTableSpace.class;
            } else if (elements[i] instanceof DB2Index) {
                key = Index.class;
            } else if (elements[i] instanceof DB2Procedure) {
                key = elements[i] instanceof FederatedProcedure ? FederatedProcedure.class : Procedure.class;
            } else if (elements[i] instanceof DB2UserDefinedFunction) {
                key = UserDefinedFunction.class;
            } else if (elements[i] instanceof LUWView) {
                key = ViewTable.class;
            } else if (elements[i] instanceof DB2Trigger) {
                key = Trigger.class;
            } else if (elements[i] instanceof Sequence) {
                key = Sequence.class;
            } else if (elements[i] instanceof UserDefinedType) {
                key = UserDefinedType.class;
            } else if (elements[i] instanceof UniqueConstraint) {
                key = UniqueConstraint.class;
            } else if (elements[i] instanceof LUWMaterializedQueryTable) {
                key = LUWMaterializedQueryTable.class;
            } else if (elements[i] instanceof DB2Alias) {
                key = DB2Alias.class;
            } else if (elements[i] instanceof CheckConstraint) {
                key = CheckConstraint.class;
            } else if (elements[i] instanceof ForeignKey) {
                key = ForeignKey.class;
            } else if (elements[i] instanceof LUWBufferPool) {
                key = LUWBufferPool.class;
            } else if (elements[i] instanceof LUWPartitionGroup) {
                key = LUWPartitionGroup.class;
            } else if (elements[i] instanceof Column) {
                key = Column.class;
            } else if (elements[i] instanceof Role) {
                key = Role.class;
            } else if (elements[i] instanceof RoleAuthorization) {
                key = RoleAuthorization.class;
            } else if (elements[i] instanceof User) {
                key = User.class;
            } else if (elements[i] instanceof Group) {
                key = Group.class;
            } else if (elements[i] instanceof Privilege) {
                key = Privilege.class;
            } else if (elements[i] instanceof LUWDatabasePackage) {
                key = LUWDatabasePackage.class;
            } else if (elements[i] instanceof PLSQLPackage) {
                key = PLSQLPackage.class;
            } else if (elements[i] instanceof PLSQLPackageBody) {
                key = PLSQLPackageBody.class;
            } else if (elements[i] instanceof LUWModule) {
                key = LUWModule.class;
            } else if (elements[i] instanceof LUWModuleCondition) {
                key = LUWModuleCondition.class;
            } else if (elements[i] instanceof LUWGlobalVariable) {
                key = LUWGlobalVariable.class;
            }
            try {
                Data d = sod.getData(key);
                EngineeringOptionID.populateOptions(s, (long)d.mask);
            }
            catch (Exception exception) {}
            ++i;
        }
        return s;
    }

    public EngineeringOption[] getOptions() {
        if (this.options == null) {
            ExtendDdlBuilder userMappingDdlBuilder;
            ExtendDdlBuilder wrapperDdlBuilder;
            ExtendDdlBuilder remoteServerDdlBuilder;
            ExtendDdlBuilder federatedProcedureDdlBuilder;
            ExtendDdlBuilder nicknameDdlBuilder;
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.datatools.enablement.internal.core.util.DdlGeneration");
            EngineeringOptionCategory[] categories = this.getOptionCategories();
            EngineeringOptionCategory general_options = null;
            EngineeringOptionCategory additional_element = null;
            int i = 0;
            while (i < categories.length) {
                if (categories[i].getId().equals("GENERATE_OPTIONS")) {
                    general_options = categories[i];
                } else if (categories[i].getId().equals("GENERATE_ELEMENTS")) {
                    additional_element = categories[i];
                }
                ++i;
            }
            Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
            optionVec.add(new EngineeringOption("GENERATE_FULLY_QUALIFIED_NAME", resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), DdlGenerationUtility.getQualifyNamesDefault(), general_options));
            optionVec.add(new EngineeringOption("GENERATE_QUOTED_IDENTIFIER", resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), DdlGenerationUtility.getQuoteIdentifiersDefault(), general_options));
            optionVec.add(new EngineeringOption("GENERATE_DROP_STATEMENTS", resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"), false, general_options));
            optionVec.add(new EngineeringOption("GENERATE_CREATE_STATEMENTS", resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"), true, general_options));
            optionVec.add(new EngineeringOption("GENERATE_COMMENTS", resource.getString("GENERATE_COMMENTS"), resource.getString("GENERATE_COMMENTS_DES"), true, general_options));
            optionVec.add(new EngineeringOption("GENERATE_PRIVILEGE", resource.getString("GENERATE_PRIVILEGE"), resource.getString("GENERATE_PRIVILEGE_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_IN_TABLESPACE_CLAUSE", resource.getString("GENERATE_IN_TABLESPACE_CLAUSE"), resource.getString("GENERATE_IN_TABLESPACE_CLAUSE_DES"), true, general_options));
            optionVec.add(new EngineeringOption("USE_DOMAIN_IF_EXIST", resource.getString("GENERATE_USE_DOMAIN_IF_EXIST"), resource.getString("GENERATE_USE_DOMAIN_IF_EXIST_DES"), false, general_options));
            optionVec.add(new EngineeringOption("GENERATE_TABLES", resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_TABLESPACES", resource.getString("GENERATE_TABLESPACES"), resource.getString("GENERATE_TABLESPACES_DES"), false, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_INDICES", resource.getString("GENERATE_INDEX"), resource.getString("GENERATE_INDEX_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_STOREDPROCEDURES", resource.getString("GENERATE_STOREDPROCEDURE"), resource.getString("GENERATE_STOREDPROCEDURE_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_FUNCTIONS", resource.getString("GENERATE_FUNCTION"), resource.getString("GENERATE_FUNCTION_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_VIEWS", resource.getString("GENERATE_VIEW"), resource.getString("GENERATE_VIEW_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_TRIGGERS", resource.getString("GENERATE_TRIGGER"), resource.getString("GENERATE_TRIGGER_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_PACKAGE", resource.getString("GENERATE_PACKAGE"), resource.getString("GENERATE_PACKAGE_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_SEQUENCES", resource.getString("GENERATE_SEQUENCE"), resource.getString("GENERATE_SEQUENCE_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_USER_DEFINED_TYPE", resource.getString("GENERATE_USER_DEFINED_TYPE"), resource.getString("GENERATE_USER_DEFINED_TYPE_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_PK_CONSTRAINTS", resource.getString("GENERATE_PK_CONSTRAINTS"), resource.getString("GENERATE_PK_CONSTRAINTS_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_FK_CONSTRAINTS", resource.getString("GENERATE_FK_CONSTRAINTS"), resource.getString("GENERATE_FK_CONSTRAINTS_DES"), true, additional_element));
            OlapDdlBuilder olapDdlBuilder = DdlGenerationUtility.getOlapDdlBuilder((String)this.product, (String)this.version);
            if (olapDdlBuilder != null) {
                optionVec.add(new EngineeringOption(null, olapDdlBuilder.getOption(), olapDdlBuilder.getOptionDescription(), true, additional_element));
            }
            if ((nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder((String)this.product, (String)this.version)) != null) {
                optionVec.add(new EngineeringOption(null, nicknameDdlBuilder.getOption(), nicknameDdlBuilder.getOptionDescription(), true, additional_element));
            }
            if ((federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder((String)this.product, (String)this.version)) != null) {
                optionVec.add(new EngineeringOption(null, federatedProcedureDdlBuilder.getOption(), federatedProcedureDdlBuilder.getOptionDescription(), true, additional_element));
            }
            if ((remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder((String)this.product, (String)this.version)) != null) {
                optionVec.add(new EngineeringOption(null, remoteServerDdlBuilder.getOption(), remoteServerDdlBuilder.getOptionDescription(), true, additional_element));
            }
            if ((wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder((String)this.product, (String)this.version)) != null) {
                optionVec.add(new EngineeringOption(null, wrapperDdlBuilder.getOption(), wrapperDdlBuilder.getOptionDescription(), true, additional_element));
            }
            if ((userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder((String)this.product, (String)this.version)) != null) {
                optionVec.add(new EngineeringOption(null, userMappingDdlBuilder.getOption(), userMappingDdlBuilder.getOptionDescription(), true, additional_element));
            }
            this.options = new EngineeringOption[optionVec.size()];
            optionVec.copyInto(this.options);
        }
        return this.options;
    }

    public EngineeringOption[] getOptions(SQLObject[] elements) {
        return this.getOptions(elements, false);
    }

    public EngineeringOption[] getOptions(SQLObject[] elements, boolean autoDiscovery) {
        isNickname = false;
        EngineeringOptionCategory[] categories_new = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        int i = 0;
        while (i < categories_new.length) {
            if (categories_new[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories_new[i];
            } else if (categories_new[i].getId().equals("GENERATE_ELEMENTS")) {
                additional_element = categories_new[i];
            }
            ++i;
        }
        this.optionDependency = new OptionDependency(elements, autoDiscovery);
        Set sOptions = this.optionDependency.getOptions();
        int size = 0;
        EngineeringOption currentOption = null;
        Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
        Iterator it = sOptions.iterator();
        while (it.hasNext()) {
            String id;
            EngineeringOption ddlOption = DdlGenerationUtility.getEngineeringOption((String)((String)it.next()), (String)this.product, (String)this.version, (EngineeringOptionCategory)general_options, (EngineeringOptionCategory)additional_element, (SQLObject[])elements);
            if (ddlOption == null) continue;
            optionVec.add(ddlOption);
            if (!ddlOption.getCategory().getId().equals("GENERATE_ELEMENTS")) continue;
            ++size;
            currentOption = ddlOption;
            if (!isNickname || (id = ddlOption.getId()) == null || !id.equalsIgnoreCase("GENERATE_INDICES") && !id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS") && !id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS") && !id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) continue;
            ddlOption.setBoolean(false);
        }
        if (size == 1) {
            currentOption.setBoolean(true);
        }
        this.options = new EngineeringOption[optionVec.size()];
        optionVec.copyInto(this.options);
        return this.options;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = DdlGenerationUtility.createDDLGenerationOptionCategories((String)this.product, (String)this.version);
        }
        return this.categories;
    }

    public EngineeringOption[] getSelectedOptions() {
        if (this.options == null) {
            this.getOptions();
        }
        return this.options;
    }

    public EngineeringOption[] getSelectedOptions(SQLObject[] elements) {
        if (this.options == null) {
            if (this.optionDependency == null) {
                this.getOptions(elements);
            } else {
                this.getOptions();
            }
        }
        return this.options;
    }

    public static ILUWModuleDdlBuilder getModuleDdlBuilder() {
        IExtension[] extensions;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2.luw", "moduleDdlBuilder");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length == 1) {
            IConfigurationElement[] configElements = extensions[0].getConfigurationElements();
            try {
                moduleBuilder = (ILUWModuleDdlBuilder)configElements[0].createExecutableExtension("class");
            }
            catch (Exception exception) {}
        }
        return moduleBuilder;
    }

    public DdlBuilder getDdlBuilder() {
        return this.builder;
    }

    public EngineeringOption[] getDefaultOptions(SQLObject[] elements) {
        isNickname = false;
        EngineeringOptionCategory[] categories_new = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        int i = 0;
        while (i < categories_new.length) {
            if (categories_new[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories_new[i];
            } else if (categories_new[i].getId().equals("GENERATE_ELEMENTS")) {
                additional_element = categories_new[i];
            }
            ++i;
        }
        this.optionDependency = new OptionDependency(elements, false);
        Set sOptions = this.optionDependency.getOptions();
        int size = 0;
        EngineeringOption currentOption = null;
        Vector<EngineeringOption> defaultOptionVec = new Vector<EngineeringOption>();
        Iterator it = sOptions.iterator();
        while (it.hasNext()) {
            String id;
            EngineeringOption ddlOption = DdlGenerationUtility.getDefaultEngineeringOption((String)((String)it.next()), (String)this.product, (String)this.version, (EngineeringOptionCategory)general_options, (EngineeringOptionCategory)additional_element);
            if (ddlOption == null) continue;
            defaultOptionVec.add(ddlOption);
            if (!ddlOption.getCategory().getId().equals("GENERATE_ELEMENTS")) continue;
            ++size;
            currentOption = ddlOption;
            if (!isNickname || (id = ddlOption.getId()) == null || !id.equalsIgnoreCase("GENERATE_INDICES") && !id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS") && !id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS") && !id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) continue;
            ddlOption.setBoolean(false);
        }
        if (size == 1) {
            currentOption.setBoolean(true);
        }
        this.defaultOptions = new EngineeringOption[defaultOptionVec.size()];
        defaultOptionVec.copyInto(this.defaultOptions);
        return this.defaultOptions;
    }

    public static class Data {
        private Class selectedObject = null;
        private Set parents = new HashSet();
        private Set childs = new HashSet();
        private long mask = 0L;
        private ArrayList sOptions = new ArrayList();
    }

    public class OptionDependency {
        private SQLObject[] elements = null;
        private Set sOptions = new LinkedHashSet();
        private Set sElementsToUse = null;

        public OptionDependency(SQLObject[] elements, boolean autoDiscovery) {
            this.elements = elements;
            this.sElementsToUse = new LinkedHashSet();
            this.doDiscovery(autoDiscovery);
        }

        private void doDiscovery(boolean autoDiscovery) {
            boolean hasStorage = LUWCatalogDatabase.getCatalogStorageProvider() != null;
            this.setOption("CHECK_MODEL");
            this.setOption("GENERATE_FULLY_QUALIFIED_NAME");
            this.setOption("GENERATE_QUOTED_IDENTIFIER");
            this.setOption("GENERATE_DROP_STATEMENTS");
            this.setOption("GENERATE_CREATE_STATEMENTS");
            this.setOption("GENERATE_COMMENTS");
            this.setOption("GENERATE_STATISTICS");
            TreeSet<String> additionalOptions = new TreeSet<String>();
            if (autoDiscovery) {
                for (Object o : LUWDdlGenerator.getAllContainedDisplayableElementSet(this.elements)) {
                    this.sElementsToUse.add(o);
                    if (o instanceof LUWTable) {
                        if (o instanceof LUWNickname) {
                            additionalOptions.add("GENERATE_NICKNAME");
                            continue;
                        }
                        additionalOptions.add("GENERATE_TABLES");
                        continue;
                    }
                    if (o instanceof LUWServer) {
                        additionalOptions.add("GENERATE_REMOTESERVER");
                        continue;
                    }
                    if (o instanceof LUWWrapper) {
                        additionalOptions.add("GENERATE_WRAPPER");
                        continue;
                    }
                    if (o instanceof LUWUserMapping) {
                        additionalOptions.add("GENERATE_USERMAPPING");
                        continue;
                    }
                    if (o instanceof DB2OLAPObject) {
                        additionalOptions.add("GENERATE_OLAP");
                        continue;
                    }
                    if (o instanceof LUWTableSpace) {
                        additionalOptions.add("GENERATE_TABLESPACES");
                        continue;
                    }
                    if (o instanceof LUWDatabasePackage) {
                        additionalOptions.add("GENERATE_PACKAGE");
                        continue;
                    }
                    if (o instanceof DB2Index) {
                        additionalOptions.add("GENERATE_INDICES");
                        continue;
                    }
                    if (o instanceof DB2Procedure) {
                        if (o instanceof FederatedProcedure) {
                            additionalOptions.add("GENERATE_FEDERATEDPROCEDURES");
                            continue;
                        }
                        additionalOptions.add("GENERATE_STOREDPROCEDURES");
                        continue;
                    }
                    if (o instanceof DB2UserDefinedFunction) {
                        additionalOptions.add("GENERATE_FUNCTIONS");
                        continue;
                    }
                    if (o instanceof LUWView) {
                        additionalOptions.add("GENERATE_VIEWS");
                        continue;
                    }
                    if (o instanceof DB2Trigger) {
                        additionalOptions.add("GENERATE_TRIGGERS");
                        continue;
                    }
                    if (o instanceof Sequence) {
                        additionalOptions.add("GENERATE_SEQUENCES");
                        continue;
                    }
                    if (o instanceof UserDefinedType) {
                        additionalOptions.add("GENERATE_USER_DEFINED_TYPE");
                        continue;
                    }
                    if (o instanceof UniqueConstraint) {
                        additionalOptions.add("GENERATE_PK_CONSTRAINTS");
                        continue;
                    }
                    if (o instanceof LUWDatabase) {
                        additionalOptions.add("GENERATE_DATABASE");
                        continue;
                    }
                    if (o instanceof LUWMaterializedQueryTable) {
                        additionalOptions.add("GENERATE_MQT");
                        continue;
                    }
                    if (o instanceof DB2Alias) {
                        additionalOptions.add("GENERATE_ALIAS");
                        continue;
                    }
                    if (o instanceof CheckConstraint) {
                        additionalOptions.add("GENERATE_CK_CONSTRAINTS");
                        continue;
                    }
                    if (o instanceof ForeignKey) {
                        additionalOptions.add("GENERATE_FK_CONSTRAINTS");
                        continue;
                    }
                    if (o instanceof LUWBufferPool) {
                        additionalOptions.add("GENERATE_BUFFERPOOL");
                        continue;
                    }
                    if (o instanceof LUWPartitionGroup) {
                        additionalOptions.add("GENERATE_PARTITIONGROUP");
                        continue;
                    }
                    if (o instanceof Schema) {
                        additionalOptions.add("GENERATE_SCHEMAS");
                        continue;
                    }
                    if (o instanceof Column) {
                        if (additionalOptions.contains("GENERATE_TABLES")) continue;
                        additionalOptions.add("GENERATE_TABLES");
                        continue;
                    }
                    if (o instanceof Role) {
                        additionalOptions.add("GENERATE_ROLE");
                        continue;
                    }
                    if (o instanceof RoleAuthorization) {
                        additionalOptions.add("GENERATE_PRIVILEGE");
                        continue;
                    }
                    if (!(o instanceof Privilege)) continue;
                    additionalOptions.add("GENERATE_PRIVILEGE");
                }
                Iterator it = additionalOptions.iterator();
                while (it.hasNext()) {
                    this.setOption((String)it.next());
                }
            } else {
                this.sOptions.addAll(LUWDdlGenerator.getAllContainedDisplayableElementSetDepedency(this.elements));
            }
            if (hasStorage) {
                this.setOption("GENERATE_IN_TABLESPACE_CLAUSE");
            }
            this.setOption("USE_DOMAIN_IF_EXIST");
        }

        public Set getOptions() {
            return this.sOptions;
        }

        public void setOption(String option) {
            this.sOptions.add(option);
        }

        public Set getElementsToUse() {
            return this.sElementsToUse;
        }
    }

    public static class SingletonOptionDependency {
        private Map data = new HashMap();
        private static SingletonOptionDependency ref;

        private SingletonOptionDependency() {
        }

        public static SingletonOptionDependency getSingletonObject() {
            if (ref == null) {
                boolean hasStorage = LUWCatalogDatabase.getCatalogStorageProvider() != null;
                boolean hasModule = LUWDdlGenerator.getModuleDdlBuilder() != null;
                ref = new SingletonOptionDependency();
                Data d = new Data();
                d.selectedObject = LUWDatabase.class;
                d.parents = null;
                d.childs.add(Schema.class);
                d.childs.add(LUWTableSpace.class);
                d.childs.add(LUWBufferPool.class);
                d.childs.add(LUWPartitionGroup.class);
                d.sOptions.add("GENERATE_DATABASE");
                d.mask = 0x1CFBFFFL | EngineeringOptionID.ROLE | 0x8000000L;
                if (hasStorage) {
                    d.mask = d.mask | 0x80L | 0x100000L | 0x200000L;
                }
                if (hasModule) {
                    d.mask = d.mask | EngineeringOptionID.MODULE | EngineeringOptionID.MODULE_CONDITION | 0x20000000L | 0x40000000L;
                }
                SingletonOptionDependency.ref.data.put(Database.class, d);
                d = new Data();
                d.selectedObject = Schema.class;
                d.parents.add(Database.class);
                d.childs.add(LUWTable.class);
                d.childs.add(DB2Alias.class);
                d.childs.add(LUWView.class);
                d.childs.add(LUWWrapper.class);
                d.childs.add(LUWMaterializedQueryTable.class);
                d.childs.add(DB2UserDefinedFunction.class);
                d.childs.add(DB2Procedure.class);
                d.childs.add(UserDefinedType.class);
                d.childs.add(Sequence.class);
                d.childs.add(LUWModule.class);
                d.sOptions.add("GENERATE_SCHEMAS");
                d.mask = 164609918L;
                if (hasStorage) {
                    d.mask = d.mask | 0x80L;
                }
                if (hasModule) {
                    d.mask = d.mask | EngineeringOptionID.MODULE | EngineeringOptionID.MODULE_CONDITION | 0x20000000L | 0x40000000L;
                }
                SingletonOptionDependency.ref.data.put(Schema.class, d);
                d = new Data();
                d.selectedObject = LUWTable.class;
                d.parents.add(Schema.class);
                d.childs.add(DB2Index.class);
                d.childs.add(DB2Trigger.class);
                d.childs.add(LUWTableSpace.class);
                d.childs.add(UniqueConstraint.class);
                d.childs.add(ForeignKey.class);
                d.childs.add(CheckConstraint.class);
                d.sOptions.add("GENERATE_TABLES");
                d.mask = 135041346L;
                if (hasStorage) {
                    d.mask = d.mask | 0x80L;
                }
                SingletonOptionDependency.ref.data.put(Table.class, d);
                d = new Data();
                d.selectedObject = LUWStorageTable.class;
                d.parents.add(Schema.class);
                d.childs.add(LUWTableSpace.class);
                d.sOptions.add("GENERATE_TABLES");
                d.mask = 135041474L;
                SingletonOptionDependency.ref.data.put(LUWStorageTable.class, d);
                d = new Data();
                d.selectedObject = LUWWrapper.class;
                d.parents.add(Schema.class);
                d.childs.add(LUWServer.class);
                d.sOptions.add("GENERATE_WRAPPER");
                d.mask = 819516L;
                SingletonOptionDependency.ref.data.put(LUWWrapper.class, d);
                d = new Data();
                d.selectedObject = LUWServer.class;
                d.parents.add(LUWWrapper.class);
                d.childs.add(LUWUserMapping.class);
                d.childs.add(LUWNickname.class);
                d.childs.add(LUWWrapper.class);
                d.sOptions.add("GENERATE_REMOTESERVER");
                d.mask = 819516L;
                SingletonOptionDependency.ref.data.put(LUWServer.class, d);
                d = new Data();
                d.selectedObject = LUWUserMapping.class;
                d.parents.add(LUWServer.class);
                d.sOptions.add("GENERATE_USERMAPPING");
                d.mask = 56L;
                SingletonOptionDependency.ref.data.put(LUWUserMapping.class, d);
                d = new Data();
                d.selectedObject = LUWNickname.class;
                d.parents.add(LUWServer.class);
                d.childs.add(UniqueConstraint.class);
                d.childs.add(ForeignKey.class);
                d.childs.add(CheckConstraint.class);
                d.childs.add(LUWServer.class);
                d.sOptions.add("GENERATE_NICKNAME");
                d.mask = 135037244L;
                SingletonOptionDependency.ref.data.put(LUWNickname.class, d);
                d = new Data();
                d.selectedObject = DB2OLAPObject.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_OLAP");
                d.mask = 64L;
                SingletonOptionDependency.ref.data.put(DB2OLAPObject.class, d);
                d = new Data();
                d.selectedObject = LUWTableSpace.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_TABLESPACES");
                d.mask = 0x8000080L;
                SingletonOptionDependency.ref.data.put(LUWTableSpace.class, d);
                d = new Data();
                d.selectedObject = DB2Index.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_INDICES");
                d.mask = 0x8000100L;
                SingletonOptionDependency.ref.data.put(Index.class, d);
                d = new Data();
                d.selectedObject = DB2Procedure.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_STOREDPROCEDURES");
                d.mask = 0x8000200L;
                SingletonOptionDependency.ref.data.put(Procedure.class, d);
                d = new Data();
                d.selectedObject = FederatedProcedure.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_FEDERATEDPROCEDURES");
                d.mask = 268435512L;
                SingletonOptionDependency.ref.data.put(FederatedProcedure.class, d);
                d = new Data();
                d.selectedObject = DB2UserDefinedFunction.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_FUNCTIONS");
                d.mask = 0x8000400L;
                SingletonOptionDependency.ref.data.put(UserDefinedFunction.class, d);
                d = new Data();
                d.selectedObject = LUWView.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_VIEWS");
                d.mask = 0x8001800L;
                SingletonOptionDependency.ref.data.put(ViewTable.class, d);
                d = new Data();
                d.selectedObject = DB2Trigger.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_TRIGGERS");
                d.mask = 4096L;
                SingletonOptionDependency.ref.data.put(Trigger.class, d);
                d = new Data();
                d.selectedObject = Sequence.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_SEQUENCES");
                d.mask = 0x8002000L;
                SingletonOptionDependency.ref.data.put(Sequence.class, d);
                d = new Data();
                d.selectedObject = UserDefinedType.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_USER_DEFINED_TYPE");
                d.mask = 16384L;
                SingletonOptionDependency.ref.data.put(UserDefinedType.class, d);
                d = new Data();
                d.selectedObject = UniqueConstraint.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_PK_CONSTRAINTS");
                d.mask = 32768L;
                SingletonOptionDependency.ref.data.put(UniqueConstraint.class, d);
                d = new Data();
                d.selectedObject = ForeignKey.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_FK_CONSTRAINTS");
                d.mask = 524288L;
                SingletonOptionDependency.ref.data.put(ForeignKey.class, d);
                d = new Data();
                d.selectedObject = CheckConstraint.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_CK_CONSTRAINTS");
                d.mask = 262144L;
                SingletonOptionDependency.ref.data.put(CheckConstraint.class, d);
                d = new Data();
                d.selectedObject = LUWMaterializedQueryTable.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_MQT");
                d.mask = 0x8010100L;
                SingletonOptionDependency.ref.data.put(LUWMaterializedQueryTable.class, d);
                d = new Data();
                d.selectedObject = DB2Alias.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_ALIAS");
                d.mask = 131072L;
                SingletonOptionDependency.ref.data.put(DB2Alias.class, d);
                d = new Data();
                d.selectedObject = LUWBufferPool.class;
                d.parents.add(Database.class);
                d.sOptions.add("GENERATE_BUFFERPOOL");
                d.mask = 0x100000L;
                SingletonOptionDependency.ref.data.put(LUWBufferPool.class, d);
                d = new Data();
                d.selectedObject = LUWPartitionGroup.class;
                d.parents.add(Database.class);
                d.sOptions.add("GENERATE_PARTITIONGROUP");
                d.mask = 0x200000L;
                SingletonOptionDependency.ref.data.put(LUWPartitionGroup.class, d);
                d = new Data();
                d.selectedObject = Column.class;
                d.parents.add(LUWTable.class);
                d.sOptions.add("GENERATE_TABLES");
                d.mask = 2L;
                SingletonOptionDependency.ref.data.put(Column.class, d);
                d = new Data();
                d.selectedObject = Role.class;
                d.parents.add(Database.class);
                d.childs.add(Privilege.class);
                d.sOptions.add("GENERATE_ROLE");
                d.mask = EngineeringOptionID.ROLE | 0x8000000L;
                SingletonOptionDependency.ref.data.put(Role.class, d);
                d = new Data();
                d.selectedObject = User.class;
                d.parents.add(Database.class);
                d.childs.add(Privilege.class);
                d.sOptions.add("GENERATE_PRIVILEGE");
                d.mask = 0x8000000L;
                SingletonOptionDependency.ref.data.put(User.class, d);
                d = new Data();
                d.selectedObject = Group.class;
                d.parents.add(Database.class);
                d.childs.add(Privilege.class);
                d.sOptions.add("GENERATE_PRIVILEGE");
                d.mask = 0x8000000L;
                SingletonOptionDependency.ref.data.put(Group.class, d);
                d = new Data();
                d.selectedObject = RoleAuthorization.class;
                d.parents.add(AuthorizationIdentifier.class);
                d.sOptions.add("GENERATE_PRIVILEGE");
                d.mask = 0x8000000L;
                SingletonOptionDependency.ref.data.put(RoleAuthorization.class, d);
                d = new Data();
                d.selectedObject = Privilege.class;
                d.parents.add(AuthorizationIdentifier.class);
                d.sOptions.add("GENERATE_PRIVILEGE");
                d.mask = 0x8000000L;
                SingletonOptionDependency.ref.data.put(Privilege.class, d);
                d = new Data();
                d.selectedObject = LUWDatabasePackage.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_PACKAGE");
                d.mask = 0x28000000L;
                SingletonOptionDependency.ref.data.put(LUWDatabasePackage.class, d);
                if (hasModule) {
                    d = new Data();
                    d.selectedObject = LUWModule.class;
                    d.parents.add(Schema.class);
                    d.sOptions.add("GENERATE_MODULE");
                    d.mask = EngineeringOptionID.MODULE | EngineeringOptionID.MODULE_CONDITION | EngineeringOptionID.GLOBAL_VARIABLE | 0x4000L | 0x200L | 0x400L | 0x8000000L;
                    SingletonOptionDependency.ref.data.put(LUWModule.class, d);
                    d = new Data();
                    d.selectedObject = LUWModuleCondition.class;
                    d.parents.add(LUWModule.class);
                    d.sOptions.add("GENERATE_CONDITION");
                    d.mask = EngineeringOptionID.MODULE_CONDITION;
                    SingletonOptionDependency.ref.data.put(LUWModuleCondition.class, d);
                    d = new Data();
                    d.selectedObject = PLSQLPackage.class;
                    d.parents.add(Schema.class);
                    d.sOptions.add("GENERATE_PACKAGE");
                    d.mask = 0x68000000L;
                    SingletonOptionDependency.ref.data.put(PLSQLPackage.class, d);
                    d = new Data();
                    d.selectedObject = PLSQLPackageBody.class;
                    d.parents.add(Schema.class);
                    d.sOptions.add("GENERATE_PACKAGE_BODY");
                    d.mask = 0x40000000L;
                    SingletonOptionDependency.ref.data.put(PLSQLPackageBody.class, d);
                }
                d = new Data();
                d.selectedObject = LUWGlobalVariable.class;
                d.parents.add(Schema.class);
                d.sOptions.add("GENERATE_GLOBAL_VARIABLE");
                d.mask = EngineeringOptionID.GLOBAL_VARIABLE | 0x8000000L;
                SingletonOptionDependency.ref.data.put(LUWGlobalVariable.class, d);
            }
            return ref;
        }

        public Data getData(Class key) {
            return (Data)this.data.get(key);
        }
    }
}

