/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LazyGenericTypeProposal
extends LazyJavaTypeCompletionProposal {
    private static final char[] GENERIC_TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', '<', ' '};
    private IRegion fSelectedRegion;
    private TypeArgumentProposal[] fTypeArgumentProposals;
    private boolean fCanUseDiamond;

    public LazyGenericTypeProposal(CompletionProposal typeProposal, JavaContentAssistInvocationContext context) {
        super(typeProposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        boolean onlyAppendArguments;
        try {
            onlyAppendArguments = this.fProposal.getCompletion().length == 0 && offset > 0 && document.getChar(offset - 1) == '<';
        }
        catch (BadLocationException badLocationException) {
            onlyAppendArguments = false;
        }
        if (onlyAppendArguments || this.shouldAppendArguments(document, offset, trigger)) {
            try {
                TypeArgumentProposal[] typeArgumentProposals = this.computeTypeArgumentProposals();
                if (typeArgumentProposals.length > 0) {
                    boolean insertClosingParenthesis;
                    StringBuffer buffer;
                    int[] offsets = new int[typeArgumentProposals.length];
                    int[] lengths = new int[typeArgumentProposals.length];
                    if (this.canUseDiamond()) {
                        buffer = new StringBuffer(this.getReplacementString());
                        buffer.append("<>");
                    } else {
                        buffer = this.createParameterList(typeArgumentProposals, offsets, lengths, onlyAppendArguments);
                    }
                    boolean bl = insertClosingParenthesis = trigger == '(' && this.autocloseBrackets();
                    if (insertClosingParenthesis) {
                        this.updateReplacementWithParentheses(buffer);
                    }
                    super.setReplacementString(buffer.toString());
                    super.apply(document, '\u0000', offset);
                    if (this.getTextViewer() != null) {
                        if (this.hasAmbiguousProposals(typeArgumentProposals)) {
                            this.adaptOffsets(offsets, buffer);
                            this.installLinkedMode(document, offsets, lengths, typeArgumentProposals, insertClosingParenthesis, onlyAppendArguments);
                        } else if (insertClosingParenthesis) {
                            this.setUpLinkedMode(document, ')');
                        } else {
                            this.fSelectedRegion = new Region(this.getReplacementOffset() + this.getReplacementString().length(), 0);
                        }
                    }
                    return;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        super.apply(document, trigger, offset);
    }

    protected char[] computeTriggerCharacters() {
        return GENERIC_TYPE_TRIGGERS;
    }

    private void adaptOffsets(int[] offsets, StringBuffer buffer) {
        String replacementString = this.getReplacementString();
        int delta = buffer.length() - replacementString.length();
        int i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - delta;
        }
    }

    private TypeArgumentProposal[] computeTypeArgumentProposals() throws JavaModelException {
        if (this.fTypeArgumentProposals == null) {
            IType type = (IType)this.getJavaElement();
            if (type == null) {
                return new TypeArgumentProposal[0];
            }
            ITypeParameter[] parameters = type.getTypeParameters();
            if (parameters.length == 0) {
                return new TypeArgumentProposal[0];
            }
            TypeArgumentProposal[] arguments = new TypeArgumentProposal[parameters.length];
            ITypeBinding expectedTypeBinding = this.getExpectedType();
            if (expectedTypeBinding != null && expectedTypeBinding.isParameterizedType()) {
                IType expectedType = (IType)expectedTypeBinding.getJavaElement();
                IType[] path = this.computeInheritancePath(type, expectedType);
                if (path == null) {
                    return new TypeArgumentProposal[0];
                }
                int[] indices = new int[parameters.length];
                int paramIdx = 0;
                while (paramIdx < parameters.length) {
                    indices[paramIdx] = this.mapTypeParameterIndex(path, path.length - 1, paramIdx);
                    ++paramIdx;
                }
                ITypeBinding[] typeArguments = expectedTypeBinding.getTypeArguments();
                int paramIdx2 = 0;
                while (paramIdx2 < parameters.length) {
                    if (indices[paramIdx2] != -1) {
                        ITypeBinding binding = typeArguments[indices[paramIdx2]];
                        arguments[paramIdx2] = this.computeTypeProposal(binding, parameters[paramIdx2]);
                    }
                    ++paramIdx2;
                }
            }
            int i = 0;
            while (i < arguments.length) {
                if (arguments[i] == null) {
                    arguments[i] = this.computeTypeProposal(parameters[i]);
                }
                ++i;
            }
            this.fTypeArgumentProposals = arguments;
        }
        return this.fTypeArgumentProposals;
    }

    private TypeArgumentProposal computeTypeProposal(ITypeParameter parameter) throws JavaModelException {
        String[] bounds = parameter.getBounds();
        String elementName = parameter.getElementName();
        String displayName = this.computeTypeParameterDisplayName(parameter, bounds);
        if (bounds.length == 1 && !"java.lang.Object".equals(bounds[0])) {
            return new TypeArgumentProposal(Signature.getSimpleName((String)bounds[0]), true, displayName);
        }
        return new TypeArgumentProposal(elementName, true, displayName);
    }

    private String computeTypeParameterDisplayName(ITypeParameter parameter, String[] bounds) {
        if (bounds.length == 0 || bounds.length == 1 && "java.lang.Object".equals(bounds[0])) {
            return parameter.getElementName();
        }
        StringBuffer buf = new StringBuffer(parameter.getElementName());
        buf.append(" extends ");
        int i = 0;
        while (i < bounds.length) {
            buf.append(Signature.getSimpleName((String)bounds[i]));
            if (i < bounds.length - 1) {
                buf.append(" & ");
            }
            ++i;
        }
        return buf.toString();
    }

    private TypeArgumentProposal computeTypeProposal(ITypeBinding binding, ITypeParameter parameter) throws JavaModelException {
        String name = Bindings.getTypeQualifiedName(binding);
        if (binding.isWildcardType()) {
            if (binding.isUpperbound()) {
                String contextName = name.replaceFirst("\\?", parameter.getElementName());
                return new TypeArgumentProposal(binding.getBound().getName(), true, contextName);
            }
            return this.computeTypeProposal(parameter);
        }
        return new TypeArgumentProposal(name, false, name);
    }

    private IType[] computeInheritancePath(IType subType, IType superType) throws JavaModelException {
        if (superType == null) {
            return null;
        }
        if (superType.equals(subType)) {
            return new IType[]{subType};
        }
        ITypeHierarchy hierarchy = subType.newSupertypeHierarchy((IProgressMonitor)this.getProgressMonitor());
        if (!hierarchy.contains(superType)) {
            return null;
        }
        LinkedList<IType> path = new LinkedList<IType>();
        path.add(superType);
        do {
            superType = hierarchy.getSubtypes(superType)[0];
            path.add(superType);
        } while (!superType.equals(subType));
        return path.toArray(new IType[path.size()]);
    }

    private NullProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    private int mapTypeParameterIndex(IType[] path, int pathIndex, int paramIndex) throws JavaModelException, ArrayIndexOutOfBoundsException {
        ITypeParameter param;
        if (pathIndex == 0) {
            return paramIndex;
        }
        IType subType = path[pathIndex];
        IType superType = path[pathIndex - 1];
        String superSignature = this.findMatchingSuperTypeSignature(subType, superType);
        int index = this.findMatchingTypeArgumentIndex(superSignature, (param = subType.getTypeParameters()[paramIndex]).getElementName());
        if (index == -1) {
            return -1;
        }
        return this.mapTypeParameterIndex(path, pathIndex - 1, index);
    }

    private String findMatchingSuperTypeSignature(IType subType, IType superType) throws JavaModelException {
        String[] signatures = this.getSuperTypeSignatures(subType, superType);
        int i = 0;
        while (i < signatures.length) {
            String superFQN;
            String signature = signatures[i];
            String qualified = SignatureUtil.qualifySignature(signature, subType);
            String subFQN = SignatureUtil.stripSignatureToFQN(qualified);
            if (subFQN.equals(superFQN = superType.getFullyQualifiedName())) {
                return signature;
            }
            ++i;
        }
        throw new JavaModelException(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Illegal hierarchy", null)));
    }

    private int findMatchingTypeArgumentIndex(String signature, String argument) {
        String[] typeArguments = Signature.getTypeArguments((String)signature);
        int i = 0;
        while (i < typeArguments.length) {
            if (Signature.getSignatureSimpleName((String)typeArguments[i]).equals(argument)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String[] getSuperTypeSignatures(IType subType, IType superType) throws JavaModelException {
        if (superType.isInterface()) {
            return subType.getSuperInterfaceTypeSignatures();
        }
        return new String[]{subType.getSuperclassTypeSignature()};
    }

    private ITypeBinding getExpectedType() {
        char[][] chKeys = this.fInvocationContext.getCoreContext().getExpectedTypesKeys();
        if (chKeys == null || chKeys.length == 0) {
            return null;
        }
        String[] keys = new String[chKeys.length];
        int i = 0;
        while (i < keys.length) {
            keys[i] = String.valueOf(chKeys[0]);
            ++i;
        }
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setProject(this.fCompilationUnit.getJavaProject());
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        final HashMap bindings = new HashMap();
        ASTRequestor requestor = new ASTRequestor(){

            public void acceptBinding(String bindingKey, IBinding binding) {
                bindings.put(bindingKey, binding);
            }
        };
        parser.createASTs(new ICompilationUnit[0], keys, requestor, null);
        if (bindings.size() > 0) {
            return (ITypeBinding)bindings.get(keys[0]);
        }
        return null;
    }

    private boolean shouldAppendArguments(IDocument document, int offset, char trigger) {
        int index;
        String line;
        block6: {
            if (trigger != '\u0000' && trigger != '<' && trigger != '(') {
                return false;
            }
            char[] completion = this.fProposal.getCompletion();
            if (completion.length == 0) {
                return false;
            }
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                line = document.get(region.getOffset(), region.getLength());
                index = offset - region.getOffset();
                while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                    ++index;
                }
                if (index != line.length()) break block6;
                return true;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }
        char ch = line.charAt(index);
        return ch != '<';
    }

    private StringBuffer createParameterList(TypeArgumentProposal[] typeArguments, int[] offsets, int[] lengths, boolean onlyAppendArguments) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getReplacementString());
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (!onlyAppendArguments) {
            if (prefs.beforeOpeningBracket) {
                buffer.append(" ");
            }
            buffer.append('<');
        }
        if (prefs.afterOpeningBracket) {
            buffer.append(" ");
        }
        StringBuffer separator = new StringBuffer(3);
        if (prefs.beforeTypeArgumentComma) {
            separator.append(" ");
        }
        separator.append(",");
        if (prefs.afterTypeArgumentComma) {
            separator.append(" ");
        }
        int i = 0;
        while (i != typeArguments.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            offsets[i] = buffer.length();
            buffer.append(typeArguments[i]);
            lengths[i] = buffer.length() - offsets[i];
            ++i;
        }
        if (prefs.beforeClosingBracket) {
            buffer.append(" ");
        }
        if (!onlyAppendArguments) {
            buffer.append('>');
        }
        return buffer;
    }

    private void installLinkedMode(final IDocument document, int[] offsets, int[] lengths, TypeArgumentProposal[] typeArgumentProposals, boolean withParentheses, boolean onlyAppendArguments) {
        int replacementOffset = this.getReplacementOffset();
        String replacementString = this.getReplacementString();
        try {
            LinkedModeModel model = new LinkedModeModel();
            int i = 0;
            while (i != offsets.length) {
                if (typeArgumentProposals[i].isAmbiguous()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, replacementOffset + offsets[i], lengths[i]));
                    model.addGroup(group);
                }
                ++i;
            }
            if (withParentheses) {
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, replacementOffset + this.getCursorPosition(), 0));
                model.addGroup(group);
            }
            model.forceInstall();
            JavaEditor editor = this.getJavaEditor();
            if (editor != null) {
                model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
            }
            if (!onlyAppendArguments && document instanceof IDocumentExtension) {
                LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
                int firstBracketOffset = replacementOffset + offsets[0] - 1;
                if (prefs.afterOpeningBracket) {
                    --firstBracketOffset;
                }
                final Position firstBracketPosition = new Position(firstBracketOffset, 1);
                document.addPosition(firstBracketPosition);
                int secondBracketOffset = replacementOffset + offsets[offsets.length - 1] + lengths[offsets.length - 1] + 1;
                if (prefs.beforeClosingBracket) {
                    ++secondBracketOffset;
                }
                final Position secondBracketPosition = new Position(secondBracketOffset, 1);
                document.addPosition(secondBracketPosition);
                model.addLinkingListener(new ILinkedModeListener(){

                    public void left(LinkedModeModel environment, int flags) {
                        try {
                            if (LazyGenericTypeProposal.this.getTextViewer().getSelectedRange().y > 1 || flags != 8) {
                                return;
                            }
                            ((IDocumentExtension)document).registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                                public void perform(IDocument d, IDocumentListener owner) {
                                    try {
                                        if ((firstBracketPosition.length == 0 || firstBracketPosition.isDeleted) && !secondBracketPosition.isDeleted) {
                                            d.replace(firstBracketPosition.offset, secondBracketPosition.offset - firstBracketPosition.offset, "");
                                        }
                                    }
                                    catch (BadLocationException e) {
                                        JavaPlugin.log(e);
                                    }
                                }
                            });
                        }
                        finally {
                            document.removePosition(firstBracketPosition);
                            document.removePosition(secondBracketPosition);
                        }
                    }

                    public void suspend(LinkedModeModel environment) {
                    }

                    public void resume(LinkedModeModel environment, int flags) {
                    }
                });
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(withParentheses ? (char)')' : '>', document));
            ui.setExitPosition(this.getTextViewer(), replacementOffset + replacementString.length(), 0, Integer.MAX_VALUE);
            ui.setDoContextInfo(true);
            ui.enter();
            this.fSelectedRegion = ui.getSelectedRegion();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    private boolean hasAmbiguousProposals(TypeArgumentProposal[] typeArgumentProposals) {
        boolean hasAmbiguousProposals = false;
        int i = 0;
        while (i < typeArgumentProposals.length) {
            if (typeArgumentProposals[i].isAmbiguous()) {
                hasAmbiguousProposals = true;
                break;
            }
            ++i;
        }
        return hasAmbiguousProposals;
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return super.getSelection(document);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.FilledArgumentNamesMethodProposal_error_msg, (String)e.getMessage());
    }

    protected IContextInformation computeContextInformation() {
        try {
            TypeArgumentProposal[] proposals;
            if (this.hasParameters() && this.hasAmbiguousProposals(proposals = this.computeTypeArgumentProposals())) {
                return new ContextInformation(this);
            }
        }
        catch (JavaModelException javaModelException) {}
        return super.computeContextInformation();
    }

    protected int computeCursorPosition() {
        if (this.fSelectedRegion != null) {
            return this.fSelectedRegion.getOffset() - this.getReplacementOffset();
        }
        return super.computeCursorPosition();
    }

    private boolean hasParameters() {
        IType type;
        block3: {
            try {
                type = (IType)this.getJavaElement();
                if (type != null) break block3;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return type.getTypeParameters().length > 0;
    }

    void canUseDiamond(boolean canUseDiamond) {
        this.fCanUseDiamond = canUseDiamond;
    }

    protected boolean canUseDiamond() {
        return this.fCanUseDiamond;
    }

    private static class ContextInformation
    implements IContextInformation,
    IContextInformationExtension {
        private final String fInformationDisplayString;
        private final String fContextDisplayString;
        private final Image fImage;
        private final int fPosition;

        ContextInformation(LazyGenericTypeProposal proposal) {
            this.fContextDisplayString = proposal.getDisplayString();
            this.fInformationDisplayString = this.computeContextString(proposal);
            this.fImage = proposal.getImage();
            this.fPosition = proposal.getReplacementOffset() + proposal.getReplacementString().indexOf(60) + 1;
        }

        public String getContextDisplayString() {
            return this.fContextDisplayString;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getInformationDisplayString() {
            return this.fInformationDisplayString;
        }

        private String computeContextString(LazyGenericTypeProposal proposal) {
            TypeArgumentProposal[] proposals;
            block5: {
                proposals = proposal.computeTypeArgumentProposals();
                if (proposals.length != 0) break block5;
                return null;
            }
            try {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < proposals.length) {
                    buf.append(proposals[i].getDisplayName());
                    if (i < proposals.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                return Strings.markJavaElementLabelLTR(buf.toString());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextInformation) {
                ContextInformation ci = (ContextInformation)obj;
                return this.getContextInformationPosition() == ci.getContextInformationPosition() && this.getInformationDisplayString().equals(ci.getInformationDisplayString());
            }
            return false;
        }

        public int hashCode() {
            int low = this.fContextDisplayString != null ? this.fContextDisplayString.hashCode() : 0;
            return this.fPosition << 24 | this.fInformationDisplayString.hashCode() << 16 | low;
        }
    }

    private static final class TypeArgumentProposal {
        private final boolean fIsAmbiguous;
        private final String fProposal;
        private final String fTypeDisplayName;

        TypeArgumentProposal(String proposal, boolean ambiguous, String typeDisplayName) {
            this.fIsAmbiguous = ambiguous;
            this.fProposal = proposal;
            this.fTypeDisplayName = typeDisplayName;
        }

        public String getDisplayName() {
            return this.fTypeDisplayName;
        }

        boolean isAmbiguous() {
            return this.fIsAmbiguous;
        }

        public String toString() {
            return this.fProposal;
        }
    }
}

