/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMRunner
implements IVMRunner {
    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, this.getPluginIdentifier(), code, message, exception));
    }

    protected abstract String getPluginIdentifier();

    protected Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        cmdLine = AbstractVMRunner.quoteWindowsArgs(cmdLine);
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory);
    }

    protected Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        cmdLine = AbstractVMRunner.quoteWindowsArgs(cmdLine);
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envp);
    }

    private static String[] quoteWindowsArgs(String[] cmdLine) {
        if (Platform.getOS().equals("win32")) {
            String[] winCmdLine = new String[cmdLine.length];
            int i = 0;
            while (i < cmdLine.length) {
                winCmdLine[i] = AbstractVMRunner.winQuote(cmdLine[i]);
                ++i;
            }
            cmdLine = winCmdLine;
        }
        return cmdLine;
    }

    private static boolean needsQuoting(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            switch (s.charAt(i)) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\\': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String winQuote(String s) {
        if (!AbstractVMRunner.needsQuoting(s)) {
            return s;
        }
        s = s.replaceAll("([\\\\]*)\"", "$1$1\\\\\"");
        s = s.replaceAll("([\\\\]*)\\z", "$1$1");
        return "\"" + s + "\"";
    }

    protected String getCmdLineAsString(String[] cmdLine) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        int numStrings = cmdLine.length;
        while (i < numStrings) {
            buff.append(cmdLine[i]);
            buff.append(' ');
            ++i;
        }
        return buff.toString().trim();
    }

    protected Map<String, String> getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "java");
        return map;
    }

    protected IProcess newProcess(ILaunch launch, Process p, String label, Map<String, String> attributes) throws CoreException {
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, attributes);
        if (process == null) {
            p.destroy();
            this.abort(LaunchingMessages.AbstractVMRunner_0, null, 150);
        }
        return process;
    }

    protected String[] combineVmArgs(VMRunnerConfiguration configuration, IVMInstall vmInstall) {
        String[] launchVMArgs = configuration.getVMArguments();
        String[] vmVMArgs = vmInstall.getVMArguments();
        if (vmVMArgs == null || vmVMArgs.length == 0) {
            return launchVMArgs;
        }
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        int i = 0;
        while (i < vmVMArgs.length) {
            try {
                vmVMArgs[i] = manager.performStringSubstitution(vmVMArgs[i], false);
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e.getStatus());
            }
            ++i;
        }
        String[] allVMArgs = new String[launchVMArgs.length + vmVMArgs.length];
        System.arraycopy(vmVMArgs, 0, allVMArgs, 0, vmVMArgs.length);
        System.arraycopy(launchVMArgs, 0, allVMArgs, vmVMArgs.length, launchVMArgs.length);
        return allVMArgs;
    }
}

