/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.commands;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.wikitext.core.parser.util.MarkupToEclipseToc;
import org.eclipse.mylyn.wikitext.ui.commands.ConvertMarkupToHtml;
import org.eclipse.mylyn.wikitext.ui.commands.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConvertMarkupToEclipseHelp
extends ConvertMarkupToHtml {
    @Override
    protected void handleFile(IFile file, String name) {
        super.handleFile(file, name);
        final IFile newFile = file.getParent().getFile((IPath)new Path(String.valueOf(name) + "-toc.xml"));
        if (newFile.exists() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToEclipseHelp_overwrite, (String)NLS.bind((String)Messages.ConvertMarkupToEclipseHelp_fileExistsOverwrite, (Object[])new Object[]{newFile.getFullPath()}))) {
            return;
        }
        IPath parentFullPath = file.getParent().getFullPath();
        IPath pluginPathToHelp = parentFullPath.removeFirstSegments(1);
        MarkupToEclipseToc markupToEclipseToc = new MarkupToEclipseToc();
        markupToEclipseToc.setMarkupLanguage(this.markupLanguage);
        markupToEclipseToc.setBookTitle(name);
        String htmlFilePath = String.valueOf(name) + ".html";
        if (pluginPathToHelp.segmentCount() > 0) {
            String pathPart = pluginPathToHelp.toString();
            if (!pathPart.endsWith("/")) {
                pathPart = String.valueOf(pathPart) + "/";
            }
            htmlFilePath = String.valueOf(pathPart) + htmlFilePath;
        }
        markupToEclipseToc.setHtmlFile(htmlFilePath);
        try {
            StringWriter w = new StringWriter();
            InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(file.getContents()), file.getCharset());
            try {
                int i;
                while ((i = ((Reader)r).read()) != -1) {
                    w.write((char)i);
                }
            }
            finally {
                ((Reader)r).close();
            }
            final String tocXml = markupToEclipseToc.parse(w.toString());
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (newFile.exists()) {
                            newFile.setContents((InputStream)new ByteArrayInputStream(tocXml.getBytes("utf-8")), false, true, monitor);
                        } else {
                            newFile.create((InputStream)new ByteArrayInputStream(tocXml.getBytes("utf-8")), false, monitor);
                        }
                        newFile.setCharset("utf-8", monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            StringWriter message = new StringWriter();
            PrintWriter out = new PrintWriter(message);
            out.println(String.valueOf(Messages.ConvertMarkupToEclipseHelp_cannotConvert) + e.getMessage());
            out.println(Messages.ConvertMarkupToEclipseHelp_detailsFollow);
            e.printStackTrace(out);
            out.close();
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToEclipseHelp_cannotCompleteOperation, (String)message.toString());
        }
    }
}

