/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewDependenciesOperation;
import org.eclipse.pde.internal.ui.search.dependencies.CalculateUsesOperation;
import org.eclipse.pde.internal.ui.search.dependencies.GatherUnusedDependenciesOperation;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.tools.IOrganizeManifestsSettings;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifest;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizeManifestsProcessor
extends RefactoringProcessor
implements IOrganizeManifestsSettings {
    protected boolean fAddMissing = true;
    protected boolean fMarkInternal = true;
    protected String fPackageFilter = "*.internal*";
    protected boolean fRemoveUnresolved = true;
    protected boolean fCalculateUses = false;
    protected boolean fModifyDep = true;
    protected boolean fRemoveDependencies = true;
    protected boolean fUnusedDependencies = false;
    protected boolean fRemoveLazy = true;
    protected boolean fRemoveUselessFiles = false;
    protected boolean fPrefixIconNL = false;
    protected boolean fUnusedKeys = false;
    protected boolean fAddDependencies = false;
    ArrayList<?> fProjectList;
    private IProject fCurrentProject;

    public OrganizeManifestsProcessor(ArrayList<?> projects) {
        this.fProjectList = projects;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        Iterator<?> i = this.fProjectList.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof IProject) continue;
            status.addFatalError(PDEUIMessages.OrganizeManifestsProcessor_invalidParam);
        }
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange("");
        change.markAsSynthetic();
        pm.beginTask(PDEUIMessages.OrganizeManifestJob_taskName, this.fProjectList.size());
        Iterator<?> i = this.fProjectList.iterator();
        while (i.hasNext() && !pm.isCanceled()) {
            CompositeChange projectChange = this.cleanProject((IProject)i.next(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (projectChange.getChildren().length <= 0) continue;
            change.add((Change)projectChange);
        }
        return change;
    }

    private CompositeChange cleanProject(IProject project, IProgressMonitor monitor) {
        this.fCurrentProject = project;
        CompositeChange change = new CompositeChange(NLS.bind((String)PDEUIMessages.OrganizeManifestsProcessor_rootMessage, (Object[])new String[]{this.fCurrentProject.getName()}));
        monitor.beginTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsProcessor_rootMessage, (Object[])new String[]{this.fCurrentProject.getName()}), this.getTotalTicksPerProject());
        final Change[] result = new Change[2];
        final Exception[] ee = new Exception[1];
        ModelModification modification = new ModelModification(this.fCurrentProject){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    try {
                        OrganizeManifestsProcessor.this.runCleanup(monitor, (IBundlePluginModelBase)model, result);
                    }
                    catch (InvocationTargetException e) {
                        ee[0] = e;
                    }
                    catch (InterruptedException e) {
                        ee[0] = e;
                    }
                }
            }
        };
        TextFileChange[] changes = PDEModelUtility.changesForModelModication(modification, monitor);
        int i = 0;
        while (i < changes.length) {
            change.add((Change)changes[i]);
            ++i;
        }
        if (result[0] != null) {
            change.add(result[0]);
        }
        if (result[1] != null) {
            change.add(result[1]);
        }
        if (ee[0] != null) {
            PDEPlugin.log(ee[0]);
        }
        return change;
    }

    private void runCleanup(IProgressMonitor monitor, IBundlePluginModelBase modelBase, Change[] result) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op;
        IBundle currentBundle = modelBase.getBundleModel().getBundle();
        ISharedExtensionsModel sharedExtensionsModel = modelBase.getExtensionsModel();
        IPluginModelBase currentExtensionsModel = null;
        if (sharedExtensionsModel instanceof IPluginModelBase) {
            currentExtensionsModel = (IPluginModelBase)sharedExtensionsModel;
        }
        String projectName = this.fCurrentProject.getName();
        if (this.fAddMissing || this.fRemoveUnresolved) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_export, (Object)projectName));
            if (!monitor.isCanceled()) {
                OrganizeManifest.organizeExportPackages(currentBundle, this.fCurrentProject, this.fAddMissing, this.fRemoveUnresolved);
            }
            if (this.fAddMissing) {
                monitor.worked(1);
            }
            if (this.fRemoveUnresolved) {
                monitor.worked(1);
            }
        }
        if (this.fMarkInternal) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_filterInternal, (Object)projectName));
            if (!monitor.isCanceled()) {
                OrganizeManifest.markPackagesInternal(currentBundle, this.fPackageFilter);
            }
            monitor.worked(1);
        }
        if (this.fModifyDep) {
            String message = this.fRemoveDependencies ? NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_removeUnresolved, (Object)projectName) : NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_markOptionalUnresolved, (Object)projectName);
            monitor.subTask(message);
            if (!monitor.isCanceled()) {
                OrganizeManifest.organizeImportPackages(currentBundle, this.fRemoveDependencies);
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) {
                OrganizeManifest.organizeRequireBundles(currentBundle, this.fRemoveDependencies);
            }
            monitor.worked(1);
        }
        if (this.fCalculateUses && !monitor.isCanceled()) {
            op = new CalculateUsesOperation(this.fCurrentProject, modelBase);
            op.run((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        if (this.fAddDependencies) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_additionalDeps, (Object)projectName));
            if (!monitor.isCanceled()) {
                op = new AddNewDependenciesOperation(this.fCurrentProject, modelBase);
                op.run((IProgressMonitor)new SubProgressMonitor(monitor, 4));
            }
        }
        if (this.fUnusedDependencies) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_unusedDeps, (Object)projectName));
            if (!monitor.isCanceled()) {
                SubProgressMonitor submon = new SubProgressMonitor(monitor, 4);
                GatherUnusedDependenciesOperation udo = new GatherUnusedDependenciesOperation((IPluginModelBase)modelBase);
                udo.run((IProgressMonitor)submon);
                GatherUnusedDependenciesOperation.removeDependencies((IPluginModelBase)modelBase, udo.getList().toArray());
                submon.done();
            }
        }
        if (this.fRemoveLazy) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_lazyStart, (Object)this.fCurrentProject.getName()));
            if (!monitor.isCanceled()) {
                OrganizeManifest.removeUnneededLazyStart(currentBundle);
            }
            monitor.worked(1);
        }
        if (this.fRemoveUselessFiles) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_uselessPluginFile, (Object)this.fCurrentProject.getName()));
            if (!monitor.isCanceled()) {
                result[1] = OrganizeManifest.deleteUselessPluginFile(this.fCurrentProject, currentExtensionsModel);
            }
            monitor.worked(1);
        }
        if (this.fPrefixIconNL) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_nlIconPath, (Object)projectName));
            if (!monitor.isCanceled()) {
                OrganizeManifest.prefixIconPaths(currentExtensionsModel);
            }
            monitor.worked(1);
        }
        if (this.fUnusedKeys) {
            TextFileChange[] results;
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_unusedKeys, (Object)projectName));
            if (!monitor.isCanceled() && (results = OrganizeManifest.removeUnusedKeys(this.fCurrentProject, currentBundle, currentExtensionsModel)).length > 0) {
                result[0] = results[0];
            }
            monitor.worked(1);
        }
    }

    public Object[] getElements() {
        return this.fProjectList.toArray();
    }

    public String getIdentifier() {
        return this.getClass().getName();
    }

    public String getProcessorName() {
        return PDEUIMessages.OrganizeManifestsWizardPage_title;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    private int getTotalTicksPerProject() {
        int ticks = 0;
        if (this.fAddMissing) {
            ++ticks;
        }
        if (this.fMarkInternal) {
            ++ticks;
        }
        if (this.fRemoveUnresolved) {
            ++ticks;
        }
        if (this.fCalculateUses) {
            ticks += 4;
        }
        if (this.fModifyDep) {
            ticks += 2;
        }
        if (this.fUnusedDependencies) {
            ticks += 4;
        }
        if (this.fAddDependencies) {
            ticks += 4;
        }
        if (this.fRemoveLazy) {
            ++ticks;
        }
        if (this.fRemoveUselessFiles) {
            ++ticks;
        }
        if (this.fPrefixIconNL) {
            ++ticks;
        }
        if (this.fUnusedKeys) {
            ++ticks;
        }
        return ticks;
    }

    public void setAddMissing(boolean addMissing) {
        this.fAddMissing = addMissing;
    }

    public void setMarkInternal(boolean markInternal) {
        this.fMarkInternal = markInternal;
    }

    public void setPackageFilter(String packageFilter) {
        this.fPackageFilter = packageFilter;
    }

    public void setRemoveUnresolved(boolean removeUnresolved) {
        this.fRemoveUnresolved = removeUnresolved;
    }

    public void setCalculateUses(boolean calculateUses) {
        this.fCalculateUses = calculateUses;
    }

    public void setModifyDep(boolean modifyDep) {
        this.fModifyDep = modifyDep;
    }

    public void setRemoveDependencies(boolean removeDependencies) {
        this.fRemoveDependencies = removeDependencies;
    }

    public void setUnusedDependencies(boolean unusedDependencies) {
        this.fUnusedDependencies = unusedDependencies;
    }

    public void setRemoveLazy(boolean removeLazy) {
        this.fRemoveLazy = removeLazy;
    }

    public void setRemoveUselessFiles(boolean removeUselessFiles) {
        this.fRemoveUselessFiles = removeUselessFiles;
    }

    public void setPrefixIconNL(boolean prefixIconNL) {
        this.fPrefixIconNL = prefixIconNL;
    }

    public void setUnusedKeys(boolean unusedKeys) {
        this.fUnusedKeys = unusedKeys;
    }

    public void setAddDependencies(boolean addDependencies) {
        this.fAddDependencies = addDependencies;
    }
}

