/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.Hashtable;
import java.util.Stack;
import org.eclipse.pde.ui.templates.IVariableProvider;

public class PreprocessorParser {
    private static final int T_VAR = 1;
    private static final int T_LBR = 2;
    private static final int T_RBR = 3;
    private static final int T_NOT = 4;
    private static final int T_AND = 5;
    private static final int T_OR = 6;
    private static final int T_EQ = 7;
    private static final int T_NEQ = 8;
    private static final int T_STRING = 9;
    private static final int T_TRUE = 22;
    private static final int T_FALSE = 23;
    private static final int T_ERROR = 99;
    private static final int T_EOF = 10;
    private static final int OP_AND = 1;
    private static final int OP_OR = 2;
    private static final int OP_EQ = 3;
    private static final int OP_NEQ = 4;
    private static final int OP_NOT = 5;
    private IVariableProvider provider;
    private String line;
    private Stack<RootEntry> exprStack;
    private int loc;
    private String tvalue;

    public PreprocessorParser() {
        this(null);
    }

    public PreprocessorParser(IVariableProvider provider) {
        this.provider = provider;
        this.exprStack = new Stack();
    }

    public void setVariableProvider(IVariableProvider provider) {
        this.provider = provider;
    }

    public static void main(String[] args) {
        final Hashtable<String, Object> vars = new Hashtable<String, Object>();
        vars.put("a", Boolean.FALSE);
        vars.put("b", "3");
        vars.put("c", Boolean.TRUE);
        PreprocessorParser parser = new PreprocessorParser(new IVariableProvider(){

            public Object getValue(String variable) {
                return vars.get(variable);
            }
        });
        try {
            boolean value = parser.parseAndEvaluate("!a || (b==\"2\" && c)");
            System.out.println("Result: " + value);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean parseAndEvaluate(String line) throws Exception {
        this.reset();
        this.line = line;
        this.parse();
        return this.evaluate();
    }

    private boolean evaluate() {
        boolean result = false;
        if (!this.exprStack.isEmpty()) {
            Object value;
            RootEntry entry = this.exprStack.peek();
            if (entry.root != null && (value = entry.root.getValue()) != null && value instanceof Boolean && ((Boolean)value).equals(Boolean.TRUE)) {
                result = true;
            }
        }
        return result;
    }

    private void reset() {
        this.loc = 0;
        this.tvalue = null;
        this.exprStack.clear();
    }

    private void parse() throws Exception {
        int token;
        while ((token = this.getNextToken()) != 10) {
            if (token == 1) {
                LeafNode node = new LeafNode(this.provider.getValue(this.tvalue.toString()));
                this.pushNode(node);
                continue;
            }
            if (token == 22 || token == 23) {
                Boolean value = token == 22 ? Boolean.TRUE : Boolean.FALSE;
                LeafNode node = new LeafNode(value);
                this.pushNode(node);
                continue;
            }
            if (token == 9) {
                LeafNode node = new LeafNode(this.tvalue);
                this.pushNode(node);
                continue;
            }
            if (token == 4) {
                this.pushNode(5);
                continue;
            }
            int opcode = 0;
            switch (token) {
                case 5: {
                    opcode = 1;
                    break;
                }
                case 6: {
                    opcode = 2;
                    break;
                }
                case 7: {
                    opcode = 3;
                    break;
                }
                case 8: {
                    opcode = 4;
                }
            }
            if (opcode != 0) {
                this.pushNode(opcode);
                continue;
            }
            if (token == 2) {
                this.pushRoot();
                continue;
            }
            if (token != 3) continue;
            if (this.exprStack.isEmpty()) {
                this.throwUnexpectedToken("not )", token);
            }
            this.popRoot();
        }
    }

    private RootEntry getCurrentRoot() {
        if (this.exprStack.isEmpty()) {
            RootEntry entry = new RootEntry();
            this.exprStack.push(entry);
        }
        return this.exprStack.peek();
    }

    private void replaceRoot(ExpressionNode newRoot) {
        RootEntry entry = this.getCurrentRoot();
        if (entry.root != null) {
            newRoot.left = entry.root;
        }
        entry.root = newRoot;
    }

    private void pushNode(Node node) {
        RootEntry entry = this.getCurrentRoot();
        if (entry.root == null) {
            entry.root = node;
        } else {
            ExpressionNode enode = (ExpressionNode)entry.root;
            if (enode.opcode == 5) {
                enode.right = node;
            } else if (enode.left == null) {
                enode.left = node;
            } else {
                enode.right = node;
            }
        }
    }

    private void pushNode(int opcode) {
        ExpressionNode node = new ExpressionNode(null, null, opcode);
        this.replaceRoot(node);
    }

    private void pushRoot() {
        this.exprStack.push(new RootEntry());
    }

    private void popRoot() {
        RootEntry entry = this.getCurrentRoot();
        this.exprStack.pop();
        this.pushNode(entry.root);
    }

    private void throwUnexpectedToken(String expected, int token) throws Exception {
        String message = "Expected " + expected + ", found " + token;
        throw new Exception(message);
    }

    private int getNextToken() {
        char c;
        boolean string = false;
        boolean variable = false;
        int vloc = this.loc;
        this.tvalue = null;
        while (true) {
            if (this.loc == this.line.length()) {
                if (variable) {
                    this.tvalue = this.line.substring(vloc, this.loc);
                    variable = false;
                    if (this.tvalue.equalsIgnoreCase("false")) {
                        return 23;
                    }
                    if (this.tvalue.equalsIgnoreCase("true")) {
                        return 22;
                    }
                    return 1;
                }
                if (string) {
                    string = false;
                    return 99;
                }
                this.tvalue = "EOF";
                return 10;
            }
            if ((c = this.line.charAt(this.loc++)) == '\"') {
                if (string) {
                    this.tvalue = this.line.substring(vloc, this.loc - 1);
                    string = false;
                    return 9;
                }
                vloc = this.loc;
                string = true;
                continue;
            }
            if (string) continue;
            if (!variable && Character.isJavaIdentifierStart(c)) {
                variable = true;
                vloc = this.loc - 1;
                continue;
            }
            if (variable) {
                if (Character.isJavaIdentifierPart(c)) continue;
                --this.loc;
                this.tvalue = this.line.substring(vloc, this.loc);
                variable = false;
                if (this.tvalue.equalsIgnoreCase("false")) {
                    return 23;
                }
                if (this.tvalue.equalsIgnoreCase("true")) {
                    return 22;
                }
                return 1;
            }
            if (this.testDoubleToken(c, "!=")) {
                return 8;
            }
            if (this.testDoubleToken(c, "==")) {
                return 7;
            }
            if (this.testDoubleToken(c, "&&")) {
                return 5;
            }
            if (this.testDoubleToken(c, "||")) {
                return 6;
            }
            if (this.testSingleToken(c, '!')) {
                return 4;
            }
            if (this.testSingleToken(c, '(')) {
                return 2;
            }
            if (this.testSingleToken(c, ')')) {
                return 3;
            }
            if (c != ' ' && c != '\t' && c != '\n') break;
        }
        this.tvalue = "" + c;
        return 99;
    }

    private boolean testSingleToken(char c, char expected) {
        if (c == expected) {
            this.tvalue = "" + expected;
            return true;
        }
        return false;
    }

    private boolean testDoubleToken(char c1, String pattern) {
        if (c1 != pattern.charAt(0)) {
            return false;
        }
        char c2 = this.line.charAt(this.loc);
        if (c2 == pattern.charAt(1)) {
            ++this.loc;
            this.tvalue = pattern;
            return true;
        }
        return false;
    }

    class ExpressionNode
    extends Node {
        int opcode;
        Node left;
        Node right;

        public ExpressionNode(Node left, Node right, int opcode) {
            this.opcode = opcode;
            this.left = left;
            this.right = right;
        }

        public Object getValue() {
            Boolean rightValue;
            boolean result = false;
            Boolean leftValue = this.left != null ? this.left.getValue() : Boolean.FALSE;
            Boolean bl = rightValue = this.right != null ? this.right.getValue() : Boolean.FALSE;
            if (this.opcode == 5 && rightValue instanceof Boolean) {
                result = !((Object)rightValue).equals(Boolean.TRUE);
            } else {
                if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
                    boolean bleft = leftValue;
                    boolean bright = rightValue;
                    switch (this.opcode) {
                        case 1: {
                            result = bleft && bright;
                            break;
                        }
                        case 2: {
                            result = bleft || bright;
                            break;
                        }
                        case 3: {
                            result = bleft == bright;
                            break;
                        }
                        case 4: {
                            result = bleft ^ bright;
                        }
                    }
                }
                if (leftValue instanceof String && rightValue instanceof String) {
                    switch (this.opcode) {
                        case 3: {
                            result = ((Object)leftValue).equals(rightValue);
                            break;
                        }
                        case 4: {
                            result = ((Object)leftValue).equals(rightValue);
                        }
                    }
                }
            }
            return result ? Boolean.TRUE : Boolean.FALSE;
        }

        public String toString() {
            String lstring = this.left != null ? this.left.toString() : "*";
            String rstring = this.right != null ? this.right.toString() : "*";
            return "(" + lstring + "<" + this.opcode + ">" + rstring + ")";
        }
    }

    class LeafNode
    extends Node {
        Object value;

        LeafNode(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value != null) {
                return "leaf[" + this.value.toString() + "]";
            }
            return "leaf[null]";
        }
    }

    abstract class Node {
        Node() {
        }

        abstract Object getValue();
    }

    class RootEntry {
        Node root;

        RootEntry() {
        }
    }
}

