/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.Comparator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.ElementLabelProvider;
import org.eclipse.pde.internal.ui.nls.ModelChange;
import org.eclipse.swt.graphics.Image;

public class ListUtil {
    private static final Comparator<?> stringComparator = new Comparator<Object>(){

        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof String && arg1 instanceof String) {
                return ((String)arg0).compareToIgnoreCase((String)arg1);
            }
            return Policy.getComparator().compare(arg0, arg1);
        }
    };
    public static final ViewerComparator NAME_COMPARATOR = new NameComparator();
    public static final ViewerComparator PLUGIN_COMPARATOR = new PluginComparator();
    public static final ViewerComparator FEATURE_COMPARATOR = new FeatureComparator();
    public static final ILabelProvider TABLE_LABEL_PROVIDER = new TableLabelProvider();

    static class FeatureComparator
    extends NameComparator {
        FeatureComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IFeatureModel && e2 instanceof IFeatureModel) {
                IFeature feature1 = ((IFeatureModel)e1).getFeature();
                IFeature feature2 = ((IFeatureModel)e2).getFeature();
                int result = this.getComparator().compare(feature1.getId(), feature2.getId());
                if (result != 0) {
                    return result;
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    static class NameComparator
    extends ViewerComparator {
        public NameComparator() {
            super(stringComparator);
        }

        public boolean isSorterProperty(Object element, Object propertyId) {
            return propertyId.equals("org.eclipse.jface.text");
        }
    }

    public static class PluginComparator
    extends NameComparator {
        private static IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("Preferences.MainPage.showObjects".equals(event.getProperty())) {
                    cachedIsFullNameModelEnabled = "useNames".equals(event.getNewValue());
                }
            }
        };
        private static boolean cachedIsFullNameModelEnabled;

        static {
            PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(listener);
            cachedIsFullNameModelEnabled = PDEPlugin.isFullNameModeEnabled();
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            String name1 = this.getName(e1);
            String name2 = this.getName(e2);
            if (name1 != null && name2 != null) {
                result = this.getComparator().compare(name1, name2);
            }
            return result != 0 ? result : super.compare(viewer, e1, e2);
        }

        private String getName(Object object) {
            if (object instanceof IPluginBase) {
                return this.getPluginName((IPluginBase)object);
            }
            if (object instanceof IPluginModelBase) {
                return this.getPluginName(((IPluginModelBase)object).getPluginBase());
            }
            if (object instanceof ModelEntry) {
                return this.getPluginName(((ModelEntry)object).getModel().getPluginBase());
            }
            if (object instanceof ModelChange) {
                return this.getPluginName(((ModelChange)object).getParentModel().getPluginBase());
            }
            return null;
        }

        private String getPluginName(IPluginBase pluginBase) {
            return cachedIsFullNameModelEnabled ? pluginBase.getTranslatedName() : pluginBase.getId();
        }
    }

    static class TableLabelProvider
    extends ElementLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object o, int index) {
            return this.getText(o);
        }

        public Image getColumnImage(Object o, int index) {
            return this.getImage(o);
        }
    }
}

