/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.Identifiable;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.core.service.Marketplace;
import org.eclipse.epp.internal.mpc.core.service.MarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.service.News;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.core.service.NodeListing;
import org.eclipse.epp.internal.mpc.core.service.RemoteMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Search;
import org.eclipse.epp.internal.mpc.core.service.SearchResult;
import org.eclipse.epp.internal.mpc.core.util.HttpUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarketplaceService
extends RemoteMarketplaceService<Marketplace>
implements MarketplaceService {
    public static final String API_FAVORITES_URI = "favorites/top";
    public static final String API_FEATURED_URI = "featured";
    public static final String API_NEWS_URI = "news";
    public static final String API_NODE_CONTENT_URI = "content";
    public static final String API_NODE_URI = "node";
    public static final String API_POPULAR_URI = "popular/top";
    public static final String API_RECENT_URI = "recent";
    public static final String API_SEARCH_URI = "search/apachesolr_search/";
    public static final String API_SEARCH_URI_FULL = "api/p/search/apachesolr_search/";
    public static final String API_TAXONOMY_URI = "taxonomy/term/";
    public static final String DEFAULT_SERVICE_LOCATION = System.getProperty(String.valueOf(MarketplaceService.class.getName()) + ".url", "http://marketplace.eclipse.org");
    public static final String META_PARAM_CLIENT = "client";
    public static final String META_PARAM_WS = "ws";
    public static final String META_PARAM_OS = "os";
    public static final String META_PARAM_NL = "nl";
    public static final String META_PARAM_JAVA_VERSION = "java.version";
    public static final String META_PARAM_RUNTIME_VERSION = "runtime.version";
    public static final String META_PARAM_PLATFORM_VERSION = "platform.version";
    public static final String META_PARAM_PRODUCT_VERSION = "product.version";
    public static final String META_PARAM_PRODUCT = "product";

    public DefaultMarketplaceService(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public DefaultMarketplaceService() {
        try {
            this.baseUrl = new URL(DEFAULT_SERVICE_LOCATION);
        }
        catch (MalformedURLException e) {
            MarketplaceClientCore.error(e);
            this.baseUrl = null;
        }
    }

    @Override
    public List<Market> listMarkets(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = (Marketplace)this.processRequest("api/p", monitor);
        return marketplace.getMarket();
    }

    @Override
    public Market getMarket(Market market, IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = (Marketplace)this.processRequest(market.getUrl(), "api/p", monitor);
        if (marketplace.getMarket().isEmpty()) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_marketNotFound, null));
        }
        if (marketplace.getMarket().size() > 1) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        return marketplace.getMarket().get(0);
    }

    @Override
    public Category getCategory(Category category, IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = (Marketplace)this.processRequest(category.getUrl(), "api/p", monitor);
        if (marketplace.getCategory().isEmpty()) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_categoryNotFound, null));
        }
        if (marketplace.getCategory().size() > 1) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        return marketplace.getCategory().get(0);
    }

    @Override
    public Node getNode(Node node, IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace;
        if (node.getId() != null) {
            String encodedId;
            try {
                encodedId = URLEncoder.encode(node.getId(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            marketplace = (Marketplace)this.processRequest("node/" + encodedId + '/' + "api/p", monitor);
        } else {
            marketplace = (Marketplace)this.processRequest(node.getUrl(), "api/p", monitor);
        }
        if (marketplace.getNode().isEmpty()) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_nodeNotFound, null));
        }
        if (marketplace.getNode().size() > 1) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        return marketplace.getNode().get(0);
    }

    @Override
    public SearchResult search(Market market, Category category, String queryText, IProgressMonitor monitor) throws CoreException {
        SearchResult result = new SearchResult();
        String relativeUrl = this.computeRelativeSearchUrl(market, category, queryText, true);
        if (relativeUrl == null) {
            result.setMatchCount(0);
            result.setNodes(new ArrayList<Node>());
        } else {
            Marketplace marketplace;
            try {
                marketplace = (Marketplace)this.processRequest(relativeUrl, monitor);
            }
            catch (CoreException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof FileNotFoundException) {
                    throw new CoreException(this.createErrorStatus(String.valueOf(Messages.DefaultMarketplaceService_UnsupportedSearchString) + queryText, cause));
                }
                throw ex;
            }
            Search search = marketplace.getSearch();
            if (search == null) {
                throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
            }
            result.setMatchCount(search.getCount());
            result.setNodes(search.getNode());
        }
        return result;
    }

    public String computeRelativeSearchUrl(Market market, Category category, String queryText, boolean api) {
        String relativeUrl;
        try {
            if (queryText != null && queryText.trim().length() > 0) {
                relativeUrl = String.valueOf(api ? API_SEARCH_URI_FULL : API_SEARCH_URI) + URLEncoder.encode(queryText.trim(), "UTF-8");
                String queryString = "";
                if (market != null || category != null) {
                    Identifiable second;
                    queryString = String.valueOf(queryString) + "filters=";
                    Identifiable first = api ? market : category;
                    Identifiable identifiable = second = api ? category : market;
                    if (first != null) {
                        queryString = String.valueOf(queryString) + "tid:" + URLEncoder.encode(first.getId(), "UTF-8");
                        if (second != null) {
                            queryString = String.valueOf(queryString) + "%20";
                        }
                    }
                    if (second != null) {
                        queryString = String.valueOf(queryString) + "tid:" + URLEncoder.encode(second.getId(), "UTF-8");
                    }
                }
                if (queryString.length() > 0) {
                    relativeUrl = String.valueOf(relativeUrl) + '?' + queryString;
                }
            } else if (market != null || category != null) {
                relativeUrl = API_TAXONOMY_URI;
                if (category != null) {
                    relativeUrl = String.valueOf(relativeUrl) + URLEncoder.encode(category.getId(), "UTF-8");
                    if (market != null) {
                        relativeUrl = String.valueOf(relativeUrl) + ',';
                    }
                }
                if (market != null) {
                    relativeUrl = String.valueOf(relativeUrl) + URLEncoder.encode(market.getId(), "UTF-8");
                }
                if (api) {
                    relativeUrl = String.valueOf(relativeUrl) + "/api/p";
                }
            } else {
                relativeUrl = null;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return relativeUrl;
    }

    @Override
    public SearchResult featured(IProgressMonitor monitor) throws CoreException {
        return this.featured(monitor, null, null);
    }

    @Override
    public SearchResult featured(IProgressMonitor monitor, Market market, Category category) throws CoreException {
        String nodePart = "";
        try {
            if (market != null) {
                nodePart = String.valueOf(nodePart) + URLEncoder.encode(market.getId(), "UTF-8");
            }
            if (category != null) {
                if (nodePart.length() > 0) {
                    nodePart = String.valueOf(nodePart) + ",";
                }
                nodePart = String.valueOf(nodePart) + URLEncoder.encode(category.getId(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException();
        }
        String uri = "featured/";
        if (nodePart.length() > 0) {
            uri = String.valueOf(uri) + nodePart + '/';
        }
        Marketplace marketplace = (Marketplace)this.processRequest(String.valueOf(uri) + "api/p", monitor);
        return this.createSearchResult(marketplace.getFeatured());
    }

    @Override
    public SearchResult recent(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = (Marketplace)this.processRequest("recent/api/p", monitor);
        return this.createSearchResult(marketplace.getRecent());
    }

    @Override
    public SearchResult favorites(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = (Marketplace)this.processRequest("favorites/top/api/p", monitor);
        return this.createSearchResult(marketplace.getFavorites());
    }

    @Override
    public SearchResult popular(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = (Marketplace)this.processRequest("popular/top/api/p", monitor);
        return this.createSearchResult(marketplace.getPopular());
    }

    protected SearchResult createSearchResult(NodeListing nodeList) throws CoreException {
        if (nodeList == null) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        SearchResult result = new SearchResult();
        result.setMatchCount(nodeList.getCount());
        result.setNodes(nodeList.getNode());
        return result;
    }

    @Override
    public News news(IProgressMonitor monitor) throws CoreException {
        try {
            Marketplace marketplace = (Marketplace)this.processRequest("news/api/p", monitor);
            return marketplace.getNews();
        }
        catch (CoreException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof FileNotFoundException) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public void reportInstallError(IProgressMonitor monitor, IStatus result, Set<Node> nodes, Set<String> iuIdsAndVersions, String resolutionDetails) throws CoreException {
        HttpPost method;
        HttpClient client;
        URL location;
        try {
            location = new URL(this.baseUrl, "install/error/report");
            String target = location.toURI().toString();
            client = HttpUtil.createHttpClient(target);
            method = new HttpPost(target);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        try {
            try {
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                Map<String, String> requestMetaParameters = this.getRequestMetaParameters();
                for (Map.Entry<String, String> metaParam : requestMetaParameters.entrySet()) {
                    if (metaParam.getKey() == null) continue;
                    parameters.add(new BasicNameValuePair(metaParam.getKey(), metaParam.getValue()));
                }
                parameters.add(new BasicNameValuePair("status", Integer.toString(result.getSeverity())));
                parameters.add(new BasicNameValuePair("statusMessage", result.getMessage()));
                for (Node node : nodes) {
                    parameters.add(new BasicNameValuePair(API_NODE_URI, node.getId()));
                }
                if (iuIdsAndVersions != null && !iuIdsAndVersions.isEmpty()) {
                    for (String iuAndVersion : iuIdsAndVersions) {
                        parameters.add(new BasicNameValuePair("iu", iuAndVersion));
                    }
                }
                parameters.add(new BasicNameValuePair("detailedMessage", resolutionDetails));
                if (!parameters.isEmpty()) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, "UTF-8");
                    method.setEntity((HttpEntity)entity);
                    client.execute((HttpUriRequest)method);
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.DefaultMarketplaceService_cannotCompleteRequest_reason, (Object)location.toString(), (Object)e.getMessage());
                throw new CoreException(this.createErrorStatus(message, e));
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

