/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.db.caching;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.rephraserengine.core.util.Pair;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

public class CachingDB<A, T, R extends IVPGNode<T>>
extends VPGDB<A, T, R> {
    public VPGDB<A, T, R> db;
    private int maxEdgeCacheEntries;
    private int maxAnnotationCacheEntries;
    private HashMap<CacheKey, Iterable<? extends VPGEdge<A, T, R>>> incomingEdgeCache;
    private HashMap<CacheKey, Iterable<? extends VPGEdge<A, T, R>>> outgoingEdgeCache;
    private HashMap<CacheKey, Serializable> annotationCache;
    private long edgeHits = 0L;
    private long edgeMisses = 0L;
    private long totalEdgeListBuildTime = 0L;
    private long annotationHits = 0L;
    private long annotationMisses = 0L;
    private long totalDeserializationTime = 0L;

    public CachingDB(VPGDB<A, T, R> diskDatabase) {
        this(diskDatabase, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public CachingDB(VPGDB<A, T, R> diskDatabase, int maxEdgeCacheEntries, int maxAnnotationCacheEntries) {
        super(diskDatabase);
        Assert.isNotNull(diskDatabase);
        Assert.isTrue((diskDatabase != this ? 1 : 0) != 0);
        Assert.isTrue((maxEdgeCacheEntries > 0 ? 1 : 0) != 0, (String)"maxEdgeCacheEntries must be a positive integer");
        Assert.isTrue((maxAnnotationCacheEntries > 0 ? 1 : 0) != 0, (String)"maxAnnotationCacheEntries must be a positive integer");
        this.db = diskDatabase;
        this.maxEdgeCacheEntries = maxEdgeCacheEntries;
        this.maxAnnotationCacheEntries = maxAnnotationCacheEntries;
        this.incomingEdgeCache = new HashMap();
        this.outgoingEdgeCache = new HashMap();
        this.annotationCache = new HashMap();
    }

    @Override
    public void flush() {
        this.db.flush();
    }

    @Override
    public void close() {
        this.db.close();
    }

    private void clearCache() {
        this.incomingEdgeCache.clear();
        this.outgoingEdgeCache.clear();
        this.annotationCache.clear();
    }

    @Override
    public void clearDatabase() {
        this.clearCache();
        this.db.clearDatabase();
    }

    @Override
    public void enterHypotheticalMode() throws IOException {
        this.clearCache();
        this.db.enterHypotheticalMode();
    }

    @Override
    public void leaveHypotheticalMode() throws IOException {
        this.clearCache();
        this.db.leaveHypotheticalMode();
    }

    @Override
    public boolean isInHypotheticalMode() {
        return this.db.isInHypotheticalMode();
    }

    @Override
    public void updateModificationStamp(String filename) {
        this.db.updateModificationStamp(filename);
    }

    @Override
    public boolean isOutOfDate(String filename) {
        return this.db.isOutOfDate(filename);
    }

    @Override
    public void deleteAllEntriesFor(String filename) {
        this.clearCache();
        this.db.deleteAllEntriesFor(filename);
    }

    @Override
    public void deleteAllEdgesAndAnnotationsFor(String filename) {
        this.clearCache();
        this.db.deleteAllEdgesAndAnnotationsFor(filename);
    }

    @Override
    public void deleteAllIncomingDependenciesFor(String filename) {
        this.db.deleteAllIncomingDependenciesFor(filename);
    }

    @Override
    public void deleteAllOutgoingDependenciesFor(String filename) {
        this.db.deleteAllOutgoingDependenciesFor(filename);
    }

    @Override
    public Iterable<String> listAllFilenames() {
        return this.db.listAllFilenames();
    }

    @Override
    public Iterable<String> listAllFilenamesWithDependents() {
        return this.db.listAllFilenamesWithDependents();
    }

    @Override
    public Iterable<String> listAllDependentFilenames() {
        return this.db.listAllDependentFilenames();
    }

    @Override
    public void ensure(VPGDependency<A, T, R> dependency) {
        this.db.ensure(dependency);
    }

    @Override
    public void delete(VPGDependency<A, T, R> dependency) {
        this.db.delete(dependency);
    }

    @Override
    public Iterable<String> getOutgoingDependenciesFrom(String filename) {
        return this.db.getOutgoingDependenciesFrom(filename);
    }

    @Override
    public Iterable<String> getIncomingDependenciesTo(String filename) {
        return this.db.getIncomingDependenciesTo(filename);
    }

    @Override
    public void ensure(VPGEdge<A, T, R> edge) {
        this.removeFromCache(edge);
        this.db.ensure(edge);
    }

    @Override
    public void delete(VPGEdge<A, T, R> edge) {
        this.removeFromCache(edge);
        this.db.delete(edge);
    }

    private void removeFromCache(VPGEdge<A, T, R> edge) {
        this.incomingEdgeCache.remove(new CacheKey(this, edge.getSink(), edge.getType()));
        this.outgoingEdgeCache.remove(new CacheKey(this, edge.getSource(), edge.getType()));
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getAllEdgesFor(String filename) {
        return this.db.getAllEdgesFor(filename);
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getOutgoingEdgesFrom(R tokenRef, int edgeType) {
        CacheKey key = new CacheKey(this, tokenRef, edgeType);
        if (this.outgoingEdgeCache.containsKey(key)) {
            ++this.edgeHits;
            return this.outgoingEdgeCache.get(key);
        }
        ++this.edgeMisses;
        return this.buildEdgeCache(this.outgoingEdgeCache, key, this.db.getOutgoingEdgesFrom(tokenRef, edgeType));
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getIncomingEdgesTo(R tokenRef, int edgeType) {
        CacheKey key = new CacheKey(this, tokenRef, edgeType);
        if (this.incomingEdgeCache.containsKey(key)) {
            ++this.edgeHits;
            return this.incomingEdgeCache.get(key);
        }
        ++this.edgeMisses;
        return this.buildEdgeCache(this.incomingEdgeCache, key, this.db.getIncomingEdgesTo(tokenRef, edgeType));
    }

    private Iterable<? extends VPGEdge<A, T, R>> buildEdgeCache(HashMap<CacheKey, Iterable<? extends VPGEdge<A, T, R>>> cache, CacheKey key, Iterable<? extends VPGEdge<A, T, R>> iterable) {
        try {
            if (cache.size() > this.maxEdgeCacheEntries) {
                try {
                    cache.remove(cache.keySet().iterator().next());
                }
                catch (NoSuchElementException noSuchElementException) {
                    cache.clear();
                }
            }
            if (this.maxEdgeCacheEntries > 0) {
                long start = System.currentTimeMillis();
                ArrayList<VPGEdge<A, T, R>> list = new ArrayList<VPGEdge<A, T, R>>();
                for (VPGEdge<A, T, R> edge : iterable) {
                    list.add(edge);
                }
                long buildTime = System.currentTimeMillis() - start;
                this.totalEdgeListBuildTime += buildTime;
                cache.put(key, list);
                return list;
            }
            return iterable;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.maxEdgeCacheEntries = cache.size() - 1;
            return iterable;
        }
    }

    @Override
    public void setAnnotation(R token, int annotationID, Serializable annotation) {
        this.removeFromCache(token, annotationID);
        this.db.setAnnotation(token, annotationID, annotation);
    }

    @Override
    public void deleteAnnotation(R token, int annotationID) {
        this.removeFromCache(token, annotationID);
        this.db.deleteAnnotation(token, annotationID);
    }

    private void removeFromCache(R token, int annotationID) {
        this.annotationCache.remove(new CacheKey(this, token, annotationID));
    }

    @Override
    public Serializable getAnnotation(R tokenRef, int annotationID) {
        CacheKey key = new CacheKey(this, tokenRef, annotationID);
        if (this.annotationCache.containsKey(key)) {
            ++this.annotationHits;
            return this.annotationCache.get(key);
        }
        ++this.annotationMisses;
        if (this.annotationCache.size() > this.maxAnnotationCacheEntries) {
            this.annotationCache.remove(this.annotationCache.keySet().iterator().next());
        }
        long start = System.currentTimeMillis();
        Serializable ann = this.db.getAnnotation(tokenRef, annotationID);
        long deserTime = System.currentTimeMillis() - start;
        this.totalDeserializationTime += deserTime;
        this.annotationCache.put(key, ann);
        return ann;
    }

    @Override
    public Iterable<Pair<R, Integer>> getAllAnnotationsFor(String filename) {
        return this.db.getAllAnnotationsFor(filename);
    }

    @Override
    public void printOn(PrintStream out) {
        this.printStatisticsOn(out);
        out.println();
        this.db.printOn(out);
    }

    @Override
    public void printStatisticsOn(PrintStream out) {
        out.println("Database Cache Statistics:");
        long edgeTotal = this.edgeHits + this.edgeMisses;
        float edgeHitRatio = edgeTotal == 0L ? 0.0f : (float)this.edgeHits / (float)edgeTotal * 100.0f;
        out.println("    Edge Cache Hit Ratio:        " + this.edgeHits + "/" + edgeTotal + " (" + (long)Math.round(edgeHitRatio) + "%)");
        long annotationTotal = this.annotationHits + this.annotationMisses;
        float annotationHitRatio = annotationTotal == 0L ? 0.0f : (float)this.annotationHits / (float)annotationTotal * 100.0f;
        out.println("    Annotation Cache Hit Ratio: " + this.annotationHits + "/" + annotationTotal + " (" + (long)Math.round(annotationHitRatio) + "%)");
        if (this.edgeMisses > 0L) {
            out.println("    Average edge list build time: " + this.totalEdgeListBuildTime / this.edgeMisses + " ms");
        }
        if (this.annotationMisses > 0L) {
            out.println("    Average annotation deserialization time: " + this.totalDeserializationTime / this.annotationMisses + " ms");
        }
        this.db.printStatisticsOn(out);
    }

    @Override
    public void resetStatistics() {
        this.totalDeserializationTime = 0L;
        this.totalEdgeListBuildTime = 0L;
        this.annotationMisses = 0L;
        this.annotationHits = 0L;
        this.edgeMisses = 0L;
        this.edgeHits = 0L;
        this.db.resetStatistics();
    }

    private final class CacheKey {
        public final R tokenRef;
        public final int id;
        final /* synthetic */ CachingDB this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CacheKey(R tokenRef, int edgeType) {
            this.this$0 = (CachingDB)n;
            this.tokenRef = tokenRef;
            this.id = edgeType;
        }

        public boolean equals(Object o) {
            block3: {
                try {
                    if (o != null) break block3;
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
            CacheKey other = (CacheKey)o;
            return this.tokenRef.equals(other.tokenRef) && this.id == other.id;
        }

        public int hashCode() {
            return this.tokenRef.hashCode() * 17 + this.id;
        }
    }
}

