/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import java.io.Serializable;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDB;

public abstract class NodeRef<T>
implements IVPGNode<T> {
    private static final long serialVersionUID = 1L;
    protected final String filename;
    protected final int offset;
    protected final int length;

    public NodeRef(String filename, int offset, int length) {
        this.filename = filename;
        this.offset = offset;
        this.length = length;
    }

    public NodeRef(NodeRef<T> copyFrom) {
        this.filename = copyFrom.filename;
        this.offset = copyFrom.offset;
        this.length = copyFrom.length;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public abstract T getASTNode();

    @Override
    public <R extends IVPGNode<T>> Iterable<R> followOutgoing(int edgeType) {
        return this.getDB().getOutgoingEdgeTargets(this, edgeType);
    }

    @Override
    public <R extends IVPGNode<T>> Iterable<R> followIncoming(int edgeType) {
        return this.getDB().getIncomingEdgeSources(this, edgeType);
    }

    @Override
    public <R extends Serializable> R getAnnotation(int annotationID) {
        return (R)this.getDB().getAnnotation(this, annotationID);
    }

    protected abstract <R extends IVPGNode<T>> VPG<?, T, R> getVPG();

    protected <R extends IVPGNode<T>> VPGDB<?, T, R> getDB() {
        return this.getVPG().getDB();
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.length;
    }

    public String toString() {
        return "(Offset " + this.offset + ", length " + this.length + " in " + this.filename + ")";
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof IVPGNode)) {
            return false;
        }
        IVPGNode o = (IVPGNode)other;
        return this.filename.equals(o.getFilename()) && this.offset == o.getOffset() && this.length == o.getLength();
    }

    public int hashCode() {
        return this.offset + this.length + (this.filename == null ? 0 : this.filename.hashCode());
    }

    @Override
    public int compareTo(IVPGNode<?> that) {
        int result = 0;
        if (this.filename != null && that.getFilename() == null) {
            result = -1;
        } else if (this.filename == null && that.getFilename() != null) {
            result = 1;
        } else if (this.filename != null && that.getFilename() != null) {
            result = this.filename.compareTo(that.getFilename());
        }
        if (result != 0) {
            return result;
        }
        result = this.offset - that.getOffset();
        if (result != 0) {
            return result;
        }
        result = this.length - that.getLength();
        return result;
    }
}

