/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.rephraserengine.core.util.Pair;
import org.eclipse.rephraserengine.core.util.SetOfPairs;
import org.eclipse.rephraserengine.core.vpg.ILazyVPGPopulator;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.VPGWriter;

public final class DemandDB<A, T, R extends IVPGNode<T>>
extends VPGDB<A, T, R> {
    private final VPGDB<A, T, R> db;
    private SetOfPairs<String, ILazyVPGPopulator> oldFilesPopulated;
    private SetOfPairs<String, ILazyVPGPopulator> filesPopulated;
    private ILazyVPGPopulator[] lazyPopulators;
    private Map<Integer, ILazyVPGPopulator> edgeTypePopulators;
    private Map<Integer, ILazyVPGPopulator> annotationTypePopulators;
    public boolean lazyComputationEnabled = true;

    public DemandDB(VPGDB<A, T, R> diskDatabase) {
        super(diskDatabase);
        Assert.isNotNull(diskDatabase);
        Assert.isTrue((diskDatabase != this ? 1 : 0) != 0);
        this.db = diskDatabase;
        this.oldFilesPopulated = null;
        this.filesPopulated = new SetOfPairs();
        this.edgeTypePopulators = new HashMap<Integer, ILazyVPGPopulator>();
        this.annotationTypePopulators = new HashMap<Integer, ILazyVPGPopulator>();
    }

    void setContentProvider(VPGWriter<A, T, R> contentProvider) {
        ILazyVPGPopulator[] iLazyVPGPopulatorArray = this.lazyPopulators = contentProvider.getLazyEdgePopulators();
        int n = this.lazyPopulators.length;
        int n2 = 0;
        while (n2 < n) {
            ILazyVPGPopulator populator = iLazyVPGPopulatorArray[n2];
            int[] nArray = populator.edgeTypesPopulated();
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int edgeType = nArray[n4];
                this.edgeTypePopulators.put(edgeType, populator);
                ++n4;
            }
            nArray = populator.annotationTypesPopulated();
            n3 = nArray.length;
            n4 = 0;
            while (n4 < n3) {
                int annotationType = nArray[n4];
                this.annotationTypePopulators.put(annotationType, populator);
                ++n4;
            }
            ++n2;
        }
    }

    private void ensureLazyEdgesAndAnnotations(String targetFile) {
        if (!this.lazyComputationEnabled) {
            return;
        }
        this.runPopulators(this.getPopulatorsThatHaveNotBeenRunOn(targetFile), targetFile);
    }

    private List<ILazyVPGPopulator> getPopulatorsThatHaveNotBeenRunOn(String targetFile) {
        ArrayList<ILazyVPGPopulator> result = new ArrayList<ILazyVPGPopulator>(this.lazyPopulators.length);
        ILazyVPGPopulator[] iLazyVPGPopulatorArray = this.lazyPopulators;
        int n = this.lazyPopulators.length;
        int n2 = 0;
        while (n2 < n) {
            ILazyVPGPopulator populator = iLazyVPGPopulatorArray[n2];
            if (!this.filesPopulated.contains(targetFile, populator)) {
                result.add(populator);
            }
            ++n2;
        }
        return result;
    }

    private void runPopulators(Collection<ILazyVPGPopulator> populators, String targetFile) {
        if (this.somePopulatorRequiresDependentFilesToBePopulated(populators)) {
            ArrayList<String> files = new ArrayList<String>(Collections.singletonList(targetFile));
            for (String filename : this.sortFilesAccordingToDependencies(files)) {
                for (ILazyVPGPopulator populator : populators) {
                    this.filesPopulated.add(filename, populator);
                    populator.populateVPG(filename);
                }
            }
        } else {
            for (ILazyVPGPopulator populator : populators) {
                this.filesPopulated.add(targetFile, populator);
                populator.populateVPG(targetFile);
            }
        }
    }

    private boolean somePopulatorRequiresDependentFilesToBePopulated(Collection<ILazyVPGPopulator> populatorsToRun) {
        for (ILazyVPGPopulator populator : populatorsToRun) {
            if (!populator.dependentFilesMustBePopulated()) continue;
            return true;
        }
        return false;
    }

    private void ensureLazyEdge(String targetFile, int edgeType) {
        ILazyVPGPopulator populator;
        if (!this.lazyComputationEnabled) {
            return;
        }
        if (this.edgeTypePopulators.containsKey(edgeType) && !this.filesPopulated.contains(targetFile, populator = this.edgeTypePopulators.get(edgeType))) {
            this.runPopulators(Collections.singleton(populator), targetFile);
        }
    }

    private void ensureLazyAnnotation(String targetFile, int annotationType) {
        ILazyVPGPopulator populator;
        if (!this.lazyComputationEnabled) {
            return;
        }
        if (this.annotationTypePopulators.containsKey(annotationType) && !this.filesPopulated.contains(targetFile, populator = this.annotationTypePopulators.get(annotationType))) {
            this.runPopulators(Collections.singleton(populator), targetFile);
        }
    }

    @Override
    public void flush() {
        this.db.flush();
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    public void clearDatabase() {
        this.filesPopulated.clear();
        this.db.clearDatabase();
    }

    @Override
    public void enterHypotheticalMode() throws IOException {
        this.oldFilesPopulated = this.filesPopulated.clone();
        this.db.enterHypotheticalMode();
    }

    @Override
    public void leaveHypotheticalMode() throws IOException {
        this.db.leaveHypotheticalMode();
        this.filesPopulated = this.oldFilesPopulated;
        this.oldFilesPopulated = null;
    }

    @Override
    public boolean isInHypotheticalMode() {
        return this.oldFilesPopulated != null;
    }

    @Override
    public void updateModificationStamp(String filename) {
        this.db.updateModificationStamp(filename);
    }

    @Override
    public boolean isOutOfDate(String filename) {
        return this.db.isOutOfDate(filename);
    }

    @Override
    public void deleteAllEntriesFor(String filename) {
        this.filesPopulated.remove(filename);
        this.db.deleteAllEntriesFor(filename);
    }

    @Override
    public void deleteAllEdgesAndAnnotationsFor(String filename) {
        this.filesPopulated.remove(filename);
        this.db.deleteAllEdgesAndAnnotationsFor(filename);
    }

    @Override
    public void deleteAllIncomingDependenciesFor(String filename) {
        this.db.deleteAllIncomingDependenciesFor(filename);
    }

    @Override
    public void deleteAllOutgoingDependenciesFor(String filename) {
        this.db.deleteAllOutgoingDependenciesFor(filename);
    }

    @Override
    public Iterable<String> listAllFilenames() {
        return this.db.listAllFilenames();
    }

    @Override
    public Iterable<String> listAllFilenamesWithDependents() {
        return this.db.listAllFilenamesWithDependents();
    }

    @Override
    public Iterable<String> listAllDependentFilenames() {
        return this.db.listAllDependentFilenames();
    }

    @Override
    public void ensure(VPGDependency<A, T, R> dependency) {
        this.db.ensure(dependency);
    }

    @Override
    public void delete(VPGDependency<A, T, R> dependency) {
        this.db.delete(dependency);
    }

    @Override
    public Iterable<String> getOutgoingDependenciesFrom(String filename) {
        return this.db.getOutgoingDependenciesFrom(filename);
    }

    @Override
    public Iterable<String> getIncomingDependenciesTo(String filename) {
        return this.db.getIncomingDependenciesTo(filename);
    }

    @Override
    public void ensure(VPGEdge<A, T, R> edge) {
        this.db.ensure(edge);
    }

    @Override
    public void delete(VPGEdge<A, T, R> edge) {
        this.db.delete(edge);
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getAllEdgesFor(String filename) {
        this.ensureLazyEdgesAndAnnotations(filename);
        return this.db.getAllEdgesFor(filename);
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getOutgoingEdgesFrom(R tokenRef, int edgeType) {
        this.ensureLazyEdge(tokenRef.getFilename(), edgeType);
        return this.db.getOutgoingEdgesFrom(tokenRef, edgeType);
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getIncomingEdgesTo(R tokenRef, int edgeType) {
        this.ensureLazyEdge(tokenRef.getFilename(), edgeType);
        return this.db.getIncomingEdgesTo(tokenRef, edgeType);
    }

    @Override
    public void setAnnotation(R token, int annotationID, Serializable annotation) {
        this.db.setAnnotation(token, annotationID, annotation);
    }

    @Override
    public void deleteAnnotation(R token, int annotationID) {
        this.db.deleteAnnotation(token, annotationID);
    }

    @Override
    public Serializable getAnnotation(R tokenRef, int annotationID) {
        this.ensureLazyAnnotation(tokenRef.getFilename(), annotationID);
        return this.db.getAnnotation(tokenRef, annotationID);
    }

    @Override
    public Iterable<Pair<R, Integer>> getAllAnnotationsFor(String filename) {
        this.ensureLazyEdgesAndAnnotations(filename);
        return this.db.getAllAnnotationsFor(filename);
    }

    @Override
    public void printOn(PrintStream out) {
        this.db.printOn(out);
    }

    @Override
    public void printStatisticsOn(PrintStream out) {
        this.db.printStatisticsOn(out);
    }

    @Override
    public void resetStatistics() {
        this.db.resetStatistics();
    }
}

