/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.analysis.flow;

import java.util.BitSet;
import java.util.HashMap;
import org.eclipse.rephraserengine.core.analysis.flow.FlowGraph;
import org.eclipse.rephraserengine.core.analysis.flow.FlowGraphNode;

public abstract class ReachingDefsAnalysis<T> {
    protected final FlowGraph<T> flowGraph;
    protected final int numDefs;
    private HashMap<FlowGraphNode<T>, BitSet> in;

    public ReachingDefsAnalysis(FlowGraph<T> flowGraph, int numDefs) {
        this.flowGraph = flowGraph;
        this.numDefs = numDefs;
        this.in = new HashMap();
    }

    public void run() {
        boolean changed;
        do {
            changed = false;
            for (FlowGraphNode<T> node : this.flowGraph.nodesInReversePostOrder()) {
                BitSet newIn = new BitSet(this.numDefs);
                for (FlowGraphNode<T> j : node.getPrecedessors()) {
                    BitSet out = new BitSet(this.numDefs);
                    out.or(this.defsReaching(j));
                    out.andNot(this.kill(j.getData()));
                    out.or(this.gen(j.getData()));
                    newIn.or(out);
                }
                BitSet defs = this.defsReaching(node);
                if (newIn.equals(defs)) continue;
                this.in.put(node, newIn);
                changed = true;
            }
        } while (changed);
    }

    public BitSet defsReaching(FlowGraphNode<T> node) {
        if (this.in.containsKey(node)) {
            return this.in.get(node);
        }
        return new BitSet(this.numDefs);
    }

    protected abstract BitSet gen(T var1);

    protected abstract BitSet kill(T var1);

    public String toString() {
        int nameLen = this.flowGraph.getMaxNameLength();
        StringBuilder sb = new StringBuilder();
        for (FlowGraphNode<T> node : this.flowGraph.nodesInPreOrder()) {
            sb.append(String.format("%" + nameLen + "s: %s\n", node.getName(), this.defsReaching(node).toString()));
        }
        return sb.toString();
    }
}

