/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.analysis.flow;

import org.eclipse.rephraserengine.core.analysis.flow.BasicBlock;
import org.eclipse.rephraserengine.core.analysis.flow.BasicBlockBuilder;
import org.eclipse.rephraserengine.core.analysis.flow.FlowGraphNode;

public class FlowGraph<U> {
    protected FlowGraphNode<U> entryNode;
    protected FlowGraphNode<U> exitNode;

    public FlowGraph(FlowGraphNode<U> entryNode, FlowGraphNode<U> exitNode) {
        this.entryNode = entryNode;
        this.exitNode = exitNode;
    }

    protected FlowGraph() {
        this.entryNode = null;
        this.exitNode = null;
    }

    public FlowGraphNode<U> getEntryNode() {
        return this.entryNode;
    }

    public FlowGraphNode<U> getExitNode() {
        return this.exitNode;
    }

    public Iterable<U> dataInReversePostOrder() {
        return this.entryNode.subgraphDataInReversePostOrder();
    }

    public Iterable<FlowGraphNode<U>> nodesInReversePostOrder() {
        return this.entryNode.subgraphInReversePostOrder();
    }

    public Iterable<U> dataInPreOrder() {
        return this.entryNode.subgraphDataInPreOrder();
    }

    public Iterable<FlowGraphNode<U>> nodesInPreOrder() {
        return this.entryNode.subgraphInPreOrder();
    }

    public FlowGraph<BasicBlock<U>> formBasicBlocks() {
        return new BasicBlockBuilder().buildFlowGraphFrom(this);
    }

    public FlowGraph<BasicBlock<U>> formBasicBlocks(BasicBlockBuilder<U> builder) {
        return builder.buildFlowGraphFrom(this);
    }

    int getMaxNameLength() {
        int nameLen = 0;
        for (FlowGraphNode<U> node : this.nodesInPreOrder()) {
            nameLen = Math.max(nameLen, node.getName().length());
        }
        return nameLen;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nameLen = this.getMaxNameLength();
        String spaces = this.spaces(nameLen);
        for (FlowGraphNode<U> node : this.nodesInPreOrder()) {
            sb.append(String.format("%" + nameLen + "s: %s\n", node.getName(), this.nodeDataAsString(node).replace("\n", "\n" + spaces)));
            for (FlowGraphNode<U> succ : node.getSuccessors()) {
                sb.append(String.format("    => %s\n", succ.getName()));
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String nodeDataAsString(FlowGraphNode<U> node) {
        return String.valueOf(node.getData());
    }

    private String spaces(int count) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < count) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }
}

