/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.analysis.dependence;

import org.eclipse.rephraserengine.core.analysis.dependence.IVariableReference;
import org.eclipse.rephraserengine.core.analysis.dependence.Messages;

public class Dependence {
    public final IVariableReference from;
    public final IVariableReference to;
    public final Type type;

    public Dependence(IVariableReference from, IVariableReference to) {
        assert (from.isRead() != from.isWrite() && to.isRead() != to.isWrite());
        this.from = from;
        this.to = to;
        this.type = Type.of(this);
    }

    public boolean equals(Object o) {
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Dependence that = (Dependence)o;
        return this.from.equals(that.from) && this.to.equals(that.to) && this.type.equals((Object)that.type);
    }

    public int hashCode() {
        return this.from.hashCode() + 13 * this.to.hashCode() + 19 * this.type.hashCode();
    }

    public String toString() {
        return Messages.bind((String)Messages.Dependence_Description, (Object[])new Object[]{this.type, this.from, this.to});
    }

    public static enum Type {
        FLOW_DEPENDENCE(Messages.Dependence_Flow),
        ANTI_DEPENDENCE(Messages.Dependence_Anti),
        OUTPUT_DEPENDENCE(Messages.Dependence_Output);

        private String description;

        private Type(String description) {
            this.description = description;
        }

        public static Type of(Dependence d) {
            if (d.from.isWrite() && d.to.isWrite()) {
                return OUTPUT_DEPENDENCE;
            }
            if (d.from.isRead() && d.to.isWrite()) {
                return ANTI_DEPENDENCE;
            }
            return FLOW_DEPENDENCE;
        }

        public String toString() {
            return this.description;
        }
    }
}

