/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.command;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.common.core.internal.utility.command.RepeatingJobCommandWrapper;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.core.utility.command.JobCommandContext;
import org.eclipse.jpt.common.core.utility.command.NotifyingRepeatingJobCommand;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ListenerList;

public class NotifyingRepeatingJobCommandWrapper
extends RepeatingJobCommandWrapper
implements NotifyingRepeatingJobCommand {
    private final ListenerList<NotifyingRepeatingJobCommand.Listener> listenerList = new ListenerList(NotifyingRepeatingJobCommand.Listener.class);

    public NotifyingRepeatingJobCommandWrapper(JobCommand command, ExceptionHandler exceptionHandler) {
        super(command, exceptionHandler);
    }

    public NotifyingRepeatingJobCommandWrapper(JobCommand command, JobCommandContext startCommandContext, ExceptionHandler exceptionHandler) {
        super(command, startCommandContext, exceptionHandler);
    }

    public void addListener(NotifyingRepeatingJobCommand.Listener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(NotifyingRepeatingJobCommand.Listener listener) {
        this.listenerList.remove((Object)listener);
    }

    IStatus executeCommand(IProgressMonitor monitor) {
        IStatus status = super.executeCommand(monitor);
        if (this.state.isQuiesced()) {
            this.executionQuiesced();
        }
        return status;
    }

    private void executionQuiesced() {
        for (NotifyingRepeatingJobCommand.Listener listener : this.listenerList.getListeners()) {
            this.notifyListener(listener);
        }
    }

    private void notifyListener(NotifyingRepeatingJobCommand.Listener listener) {
        try {
            listener.executionQuiesced(this);
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }
}

