/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.command.ParameterizedCommand;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneIterator<E>
implements Iterator<E> {
    private final Iterator<Object> iterator;
    private E current;
    private final ParameterizedCommand<? super E> removeCommand;
    private boolean removeAllowed;

    public CloneIterator(Collection<? extends E> collection, ParameterizedCommand<? super E> removeCommand) {
        this(collection.toArray(), removeCommand);
    }

    protected CloneIterator(Object[] array, ParameterizedCommand<? super E> removeCommand) {
        if (removeCommand == null) {
            throw new NullPointerException();
        }
        this.iterator = IteratorTools.iterator(array);
        this.current = null;
        this.removeCommand = removeCommand;
        this.removeAllowed = false;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        Object next = this.iterator.next();
        this.current = next;
        this.removeAllowed = true;
        return this.current;
    }

    @Override
    public void remove() {
        if (!this.removeAllowed) {
            throw new IllegalStateException();
        }
        this.removeCommand.execute(this.current);
        this.removeAllowed = false;
    }

    public String toString() {
        return ObjectTools.toString(this);
    }
}

