/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.completion.APIToolsJavadocCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class APIToolsJavadocCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private String fErrorMessage = null;
    private Image fImageHandle = null;
    private ASTParser fParser = null;
    HashMap fExistingTags = null;

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        JavaContentAssistInvocationContext jcontext = null;
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.EMPTY_LIST;
        }
        jcontext = (JavaContentAssistInvocationContext)context;
        IJavaProject project = jcontext.getProject();
        if (project == null || !Util.isApiProject((IJavaProject)project)) {
            return Collections.EMPTY_LIST;
        }
        CompletionContext corecontext = jcontext.getCoreContext();
        if (!corecontext.isInJavadoc()) {
            return Collections.EMPTY_LIST;
        }
        ICompilationUnit cunit = jcontext.getCompilationUnit();
        if (cunit != null) {
            try {
                int offset = jcontext.getInvocationOffset();
                IJavaElement element = cunit.getElementAt(offset);
                if (element == null) {
                    return Collections.EMPTY_LIST;
                }
                ImageDescriptor imagedesc = jcontext.getLabelProvider().createImageDescriptor(CompletionProposal.create((int)19, (int)offset));
                this.fImageHandle = imagedesc == null ? null : imagedesc.createImage();
                int type = this.getType(element);
                int member = 16;
                int elementtype = element.getElementType();
                switch (elementtype) {
                    case 7: {
                        IType itype = (IType)element;
                        if (!this.hasNonVisibleParent(element, itype.isInterface())) break;
                        return Collections.EMPTY_LIST;
                    }
                    case 9: {
                        IMethod method = (IMethod)element;
                        int flags = method.getFlags();
                        boolean inter = method.getDeclaringType().isInterface();
                        if (Flags.isPrivate((int)flags) || !Flags.isDefaultMethod((int)flags) && inter || Flags.isPackageDefault((int)flags) && !inter || this.hasNonVisibleParent(element, inter)) {
                            return Collections.EMPTY_LIST;
                        }
                        member = 4;
                        if (!method.isConstructor()) break;
                        member = 32;
                        break;
                    }
                    case 8: {
                        IField field = (IField)element;
                        int flags = field.getFlags();
                        boolean inter = field.getDeclaringType().isInterface();
                        if (Flags.isFinal((int)flags) || field.isEnumConstant() || Flags.isPrivate((int)flags) || Flags.isPackageDefault((int)flags) && !inter || this.hasNonVisibleParent(element, inter)) {
                            return Collections.EMPTY_LIST;
                        }
                        member = 8;
                    }
                }
                IApiJavadocTag[] tags = ApiPlugin.getJavadocTagManager().getTagsForType(type, member);
                int tagcount = tags.length;
                if (tagcount > 0) {
                    ArrayList<APIToolsJavadocCompletionProposal> list = null;
                    this.collectExistingTags(element, jcontext);
                    String completiontext = null;
                    int tokenstart = corecontext.getTokenStart();
                    int length = offset - tokenstart;
                    int i = 0;
                    while (i < tagcount) {
                        if (this.acceptTag(tags[i], element)) {
                            completiontext = tags[i].getCompleteTag(type, member);
                            if (this.appliesToContext(jcontext.getDocument(), completiontext, tokenstart, length > 0 ? length : 1)) {
                                if (list == null) {
                                    list = new ArrayList<APIToolsJavadocCompletionProposal>(tagcount - i);
                                }
                                list.add(new APIToolsJavadocCompletionProposal(corecontext, completiontext, tags[i].getTagName(), this.fImageHandle));
                            }
                        }
                        ++i;
                    }
                    if (list != null) {
                        return list;
                    }
                }
            }
            catch (JavaModelException e) {
                this.fErrorMessage = e.getMessage();
            }
        }
        return Collections.EMPTY_LIST;
    }

    boolean hasNonVisibleParent(IJavaElement element, boolean isinterface) throws JavaModelException {
        if (element == null) {
            return false;
        }
        boolean isinter = isinterface;
        switch (element.getElementType()) {
            case 7: {
                IType type = (IType)element;
                int flags = type.getFlags();
                IType ptype = type.getDeclaringType();
                if (type.isInterface()) {
                    if (ptype == null) {
                        return false;
                    }
                    if (Flags.isPublic((int)flags) || (isinter &= true)) {
                        return this.hasNonVisibleParent((IJavaElement)ptype, isinter);
                    }
                    if (ptype.isClass() && (Flags.isPrivate((int)flags) || Flags.isPackageDefault((int)flags))) {
                        return true;
                    }
                }
                if (ptype != null && !Flags.isStatic((int)flags) && !Flags.isPublic((int)flags)) {
                    return true;
                }
                if (!Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags)) break;
                return true;
            }
        }
        return this.hasNonVisibleParent(element.getParent(), isinter);
    }

    private boolean acceptTag(IApiJavadocTag tag, IJavaElement element) throws JavaModelException {
        Boolean fragments;
        if (this.fExistingTags != null && (fragments = (Boolean)this.fExistingTags.get(tag.getTagName())) != null && Boolean.FALSE.equals(fragments)) {
            return false;
        }
        switch (element.getElementType()) {
            case 7: {
                IType type = (IType)element;
                int flags = type.getFlags();
                String tagname = tag.getTagName();
                if (Flags.isAbstract((int)flags)) {
                    return !tagname.equals("@noinstantiate");
                }
                if (!Flags.isFinal((int)flags)) break;
                return !tagname.equals("@noextend");
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (Flags.isFinal((int)method.getFlags()) || Flags.isStatic((int)method.getFlags())) {
                    return !tag.getTagName().equals("@nooverride");
                }
                IType type = method.getDeclaringType();
                if (type == null || !Flags.isFinal((int)type.getFlags())) break;
                return !tag.getTagName().equals("@nooverride");
            }
        }
        return true;
    }

    private int getType(IJavaElement element) throws JavaModelException {
        IJavaElement lelement = element;
        while (lelement != null && lelement.getElementType() != 7) {
            lelement = lelement.getParent();
        }
        if (lelement instanceof IType) {
            IType type = (IType)lelement;
            if (type.isAnnotation()) {
                return 128;
            }
            if (type.isInterface()) {
                return 2;
            }
            if (type.isEnum()) {
                return 64;
            }
        }
        return 1;
    }

    private void collectExistingTags(IJavaElement element, JavaContentAssistInvocationContext jcontext) throws JavaModelException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            ICompilationUnit cunit = jcontext.getCompilationUnit();
            if (cunit != null) {
                BodyDeclaration bodyDeclaration;
                Javadoc javadoc;
                TypeDeclaration typeDeclaration;
                List bodyDeclarations;
                if (cunit.isWorkingCopy()) {
                    cunit.reconcile(0, false, false, null, null);
                }
                this.fParser.setSource(member.getSource().toCharArray());
                this.fParser.setKind(4);
                Map options = element.getJavaProject().getOptions(true);
                options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                this.fParser.setCompilerOptions(options);
                this.fParser.setStatementsRecovery(false);
                this.fParser.setResolveBindings(false);
                this.fParser.setBindingsRecovery(false);
                ASTNode ast = this.fParser.createAST(null);
                TagCollector collector = new TagCollector();
                if (ast.getNodeType() == 55 && (bodyDeclarations = (typeDeclaration = (TypeDeclaration)ast).bodyDeclarations()).size() == 1 && (javadoc = (bodyDeclaration = (BodyDeclaration)bodyDeclarations.iterator().next()).getJavadoc()) != null) {
                    javadoc.accept((ASTVisitor)collector);
                }
            }
        }
    }

    private boolean appliesToContext(IDocument document, String completiontext, int tokenstart, int length) {
        if (length > completiontext.length()) {
            return false;
        }
        try {
            String prefix = document.get(tokenstart, length);
            return prefix.equals(completiontext.substring(0, length));
        }
        catch (BadLocationException e) {
            ApiUIPlugin.log(e);
            return false;
        }
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionEnded() {
        if (this.fImageHandle != null) {
            this.fImageHandle.dispose();
        }
        this.fParser = null;
        if (this.fExistingTags != null) {
            this.fExistingTags.clear();
            this.fExistingTags = null;
        }
        this.fErrorMessage = null;
    }

    public void sessionStarted() {
        this.fParser = ASTParser.newParser((int)8);
        this.fErrorMessage = null;
    }

    class TagCollector
    extends ASTVisitor {
        TagCollector() {
        }

        public boolean visit(Javadoc node) {
            Set tagnames = ApiPlugin.getJavadocTagManager().getAllTagNames();
            List tags = node.tags();
            if (APIToolsJavadocCompletionProposalComputer.this.fExistingTags == null) {
                APIToolsJavadocCompletionProposalComputer.this.fExistingTags = new HashMap(tags.size());
            }
            TagElement tag = null;
            String name = null;
            Iterator iter = tags.iterator();
            while (iter.hasNext()) {
                tag = (TagElement)iter.next();
                name = tag.getTagName();
                if (name == null || !tagnames.contains(name)) continue;
                APIToolsJavadocCompletionProposalComputer.this.fExistingTags.put(name, tag.fragments().isEmpty());
            }
            return false;
        }
    }
}

