/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lang.linescanner;

import java.util.regex.Pattern;
import org.eclipse.photran.internal.core.lang.linescanner.FortranLineType;
import org.eclipse.photran.internal.core.lang.linescanner.ILookaheadLineReader;

public final class FortranLineScanner {
    private static final Pattern FIXED_FORM_INCLUDE_LINE = Pattern.compile("[ \t]*[Ii][ \t]*[Nn][ \t]*[Cc][ \t]*[Ll][ \t]*[Uu][ \t]*[Dd][ \t]*[Ee][ \t]*[\"']([^\r\n\"]*)[\"'][ \t]*(![^\r\n]*)?[\r\n]*");
    private static final Pattern FREE_FORM_INCLUDE_LINE = Pattern.compile("[ \t]*[Ii][Nn][Cc][Ll][Uu][Dd][Ee][ \t]+[\"']([^\r\n\"]*)[\"'][ \t]*(![^\r\n]*)?[\r\n]*");
    private static final int INCLUDE_LINE_CAPTURING_GROUP_OF_FILENAME = 1;
    private static final Pattern COMMENT_DIRECTIVE = Pattern.compile("^[ \\t]*[Cc*!][ \\t]*\\$([Oo][Mm][Pp]|[Aa][Cc][Cc])");
    private final boolean fixedForm;
    private final boolean preprocessed;
    private int lineLength = -1;
    private FortranLineType lineType = null;

    public FortranLineScanner(boolean fixedForm, boolean preprocessed) {
        this.fixedForm = fixedForm;
        this.preprocessed = preprocessed;
    }

    public final <X extends Throwable> String scan(ILookaheadLineReader<X> reader) throws X {
        this.lineLength = -1;
        this.lineType = null;
        String line = reader.readNextLine();
        if (line == null) {
            this.lineLength = 0;
            this.lineType = null;
            return null;
        }
        this.lineLength = line.length();
        this.lineType = this.classify(line);
        this.lineLength += this.checkForContinuationLines(line, reader);
        return reader.advanceAndRestart(this.lineLength);
    }

    private <X extends Throwable> int checkForContinuationLines(String line, ILookaheadLineReader<X> reader) throws X {
        if (this.lineType == FortranLineType.PREPROCESSOR_DIRECTIVE) {
            return this.checkForPreprocessorDirectiveContinuation(line, reader);
        }
        if (this.lineType == FortranLineType.STATEMENT) {
            return this.fixedForm ? this.checkForFixedFormContinuation(reader) : this.checkForFreeFormContinuation(line, reader);
        }
        return 0;
    }

    private <X extends Throwable> int checkForPreprocessorDirectiveContinuation(String line, ILookaheadLineReader<X> reader) throws X {
        int numberOfAdditionalCharacters = 0;
        while (FortranLineScanner.findLastNonWhitespaceCharacter(line) == '\\') {
            line = reader.readNextLine();
            numberOfAdditionalCharacters += line.length();
        }
        return numberOfAdditionalCharacters;
    }

    private <X extends Throwable> int checkForFreeFormContinuation(String line, ILookaheadLineReader<X> reader) throws X {
        int numberOfAdditionalCharacters = 0;
        while (this.isContinued(line) || FortranLineScanner.findFirstNonWhitespaceCharacter(line) == '!') {
            line = reader.readNextLine();
            numberOfAdditionalCharacters += line == null ? 0 : line.length();
        }
        return numberOfAdditionalCharacters;
    }

    private <X extends Throwable> int checkForFixedFormContinuation(ILookaheadLineReader<X> reader) throws X {
        int numberOfAdditionalCharacters = 0;
        boolean moreContinuationLinesPossible = true;
        while (moreContinuationLinesPossible) {
            int lengthOfComments = 0;
            String line = reader.readNextLine();
            while (line != null && this.classify(line) == FortranLineType.COMMENT && FortranLineScanner.findFirstNonWhitespaceCharacter(line) != '\u0000') {
                lengthOfComments += line.length();
                line = reader.readNextLine();
            }
            if (line != null && line.length() >= 7 && line.startsWith("     ") && line.charAt(5) != ' ' && line.charAt(5) != '0') {
                numberOfAdditionalCharacters += lengthOfComments + line.length();
                moreContinuationLinesPossible = true;
                continue;
            }
            moreContinuationLinesPossible = false;
        }
        return numberOfAdditionalCharacters;
    }

    private FortranLineType classify(String line) {
        char firstChar = line.isEmpty() ? (char)'\u0000' : line.charAt(0);
        char firstNonSpaceChar = FortranLineScanner.findFirstNonWhitespaceCharacter(line);
        if (firstNonSpaceChar == '\u0000') {
            return FortranLineType.COMMENT;
        }
        if (this.fixedForm && (firstChar == 'C' || firstChar == 'c' || firstChar == '*')) {
            if (line.startsWith("      C") || line.startsWith("      c") || line.startsWith("      *")) {
                return FortranLineType.STATEMENT;
            }
            return this.isCommentDirective(line) ? FortranLineType.COMMENT_DIRECTIVE : FortranLineType.COMMENT;
        }
        if (firstNonSpaceChar == '!') {
            if (this.fixedForm && line.startsWith("      !")) {
                return FortranLineType.STATEMENT;
            }
            return this.isCommentDirective(line) ? FortranLineType.COMMENT_DIRECTIVE : FortranLineType.COMMENT;
        }
        if (this.preprocessed && (firstNonSpaceChar == '#' || firstNonSpaceChar == '?' && line.trim().startsWith("??="))) {
            return FortranLineType.PREPROCESSOR_DIRECTIVE;
        }
        if ((firstNonSpaceChar == 'I' || firstNonSpaceChar == 'i') && this.isIncludeLine(line)) {
            return FortranLineType.INCLUDE_LINE;
        }
        return FortranLineType.STATEMENT;
    }

    private boolean isIncludeLine(String line) {
        if (this.fixedForm) {
            return FIXED_FORM_INCLUDE_LINE.matcher(line).matches();
        }
        return FREE_FORM_INCLUDE_LINE.matcher(line).matches();
    }

    private static final char findFirstNonWhitespaceCharacter(String string) {
        if (string != null) {
            int i = 0;
            int len = string.length();
            while (i < len) {
                char ch = string.charAt(i);
                if (!Character.isWhitespace(ch)) {
                    return ch;
                }
                ++i;
            }
        }
        return '\u0000';
    }

    private boolean isCommentDirective(String line) {
        return COMMENT_DIRECTIVE.matcher(line).find();
    }

    private static final char findLastNonWhitespaceCharacter(String string) {
        if (string != null) {
            int i = string.length() - 1;
            while (i >= 0) {
                char ch = string.charAt(i);
                if (!Character.isWhitespace(ch)) {
                    return ch;
                }
                --i;
            }
        }
        return '\u0000';
    }

    private boolean isContinued(String line) {
        if (line == null) {
            return false;
        }
        boolean inString = false;
        char stringStart = '\u0000';
        int lastNonSpaceChar = 0;
        int i = 0;
        int length = line.length();
        while (i < length) {
            char nextChar;
            char thisChar = line.charAt(i);
            char c = nextChar = i + 1 < length ? line.charAt(i + 1) : (char)'\u0000';
            if (!(thisChar != '\"' && thisChar != '\'' || inString)) {
                stringStart = thisChar;
                inString = true;
            } else if (thisChar == stringStart && inString) {
                if (nextChar != thisChar) {
                    inString = false;
                    stringStart = '\u0000';
                }
            } else if (thisChar == '!' && !inString) {
                return lastNonSpaceChar == 38;
            }
            if (!Character.isWhitespace(thisChar)) {
                lastNonSpaceChar = thisChar;
            }
            ++i;
        }
        return lastNonSpaceChar == 38;
    }

    public final int getLineLength() {
        if (this.lineLength < 0) {
            throw new IllegalStateException("Must call #readNextLine before calling #getLineLength");
        }
        return this.lineLength;
    }

    public final FortranLineType getLineType() {
        if (this.lineType == null) {
            throw new IllegalStateException("Must call #readNextLine before calling #getLineType");
        }
        return this.lineType;
    }
}

