/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.internal.launch.BackgroundResourceRefresher;
import org.eclipse.m2e.internal.launch.MavenLaunchPlugin;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;
import org.eclipse.m2e.internal.launch.MavenLauncherConfigurationHandler;
import org.eclipse.m2e.internal.launch.Messages;

public class MavenRuntimeLaunchSupport {
    private static final String LAUNCH_M2CONF_FILE = "org.eclipse.m2e.internal.launch.M2_CONF";
    private final MavenRuntime runtime;
    private final MavenLauncherConfigurationHandler cwconf;
    private final boolean resolveWorkspaceArtifacts;
    private final File cwconfFile;

    private MavenRuntimeLaunchSupport(MavenRuntime runtime, MavenLauncherConfigurationHandler cwconf, File cwconfFile, boolean resolveWorkspaceArtifacts) {
        this.runtime = runtime;
        this.cwconf = cwconf;
        this.cwconfFile = cwconfFile;
        this.resolveWorkspaceArtifacts = resolveWorkspaceArtifacts;
    }

    public static MavenRuntimeLaunchSupport create(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File cwconfFile;
        MavenRuntime runtime = MavenLaunchUtils.getMavenRuntime(configuration);
        boolean resolveWorkspaceArtifacts = configuration.getAttribute("M2_WORKSPACE_RESOLUTION", false);
        MavenLauncherConfigurationHandler cwconf = new MavenLauncherConfigurationHandler();
        if (resolveWorkspaceArtifacts) {
            cwconf.addArchiveEntry(MavenLaunchUtils.getCliResolver(runtime));
        }
        MavenLaunchUtils.addUserComponents(configuration, cwconf);
        runtime.createLauncherConfiguration((IMavenLauncherConfiguration)cwconf, monitor);
        try {
            File state = MavenLaunchPlugin.getDefault().getStateLocation().toFile();
            File dir = new File(state, "launches");
            dir.mkdirs();
            cwconfFile = File.createTempFile("m2conf", ".tmp", dir);
            launch.setAttribute(LAUNCH_M2CONF_FILE, cwconfFile.getCanonicalPath());
            FileOutputStream os = new FileOutputStream(cwconfFile);
            try {
                cwconf.save(os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.launching", -1, Messages.MavenLaunchDelegate_error_cannot_create_conf, (Throwable)e));
        }
        return new MavenRuntimeLaunchSupport(runtime, cwconf, cwconfFile, resolveWorkspaceArtifacts);
    }

    public static void removeTempFiles(ILaunch launch) {
        String m2confName = launch.getAttribute(LAUNCH_M2CONF_FILE);
        if (m2confName != null) {
            new File(m2confName).delete();
        }
    }

    public String getLocation() {
        return this.runtime.getLocation();
    }

    public File getClassworldConfFile() {
        return this.cwconfFile;
    }

    public List<String> getBootClasspath() {
        return this.cwconf.getRealmEntries("]launcher");
    }

    public String getVersion() {
        return this.runtime.getVersion();
    }

    public VMArguments getVMArguments() {
        String location;
        VMArguments properties = new VMArguments();
        if (this.resolveWorkspaceArtifacts) {
            File state = MavenPluginActivator.getDefault().getMavenProjectManager().getWorkspaceStateFile();
            properties.appendProperty("m2eclipse.workspace.state", MavenLaunchUtils.quote(state.getAbsolutePath()));
        }
        if ((location = this.runtime.getLocation()) != null) {
            properties.appendProperty("maven.home", MavenLaunchUtils.quote(location));
        }
        properties.appendProperty("classworlds.conf", MavenLaunchUtils.quote(this.cwconfFile.getAbsolutePath()));
        properties.appendProperty("maven.bootclasspath", MavenLaunchUtils.quote(MavenLaunchUtils.toPath(this.getBootClasspath())));
        return properties;
    }

    public IVMRunner decorateVMRunner(final IVMRunner runner) {
        return new IVMRunner(){

            public void run(VMRunnerConfiguration runnerConfiguration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
                runner.run(runnerConfiguration, launch, monitor);
                IProcess[] processes = launch.getProcesses();
                if (processes != null && processes.length > 0) {
                    ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                    BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, launch);
                    refresher.init();
                } else {
                    MavenRuntimeLaunchSupport.removeTempFiles(launch);
                }
            }
        };
    }

    public static class VMArguments {
        private final StringBuilder properties = new StringBuilder();

        public void append(String str) {
            if (str != null) {
                str = str.trim();
            }
            if (str != null && str.length() > 0) {
                if (this.properties.length() > 0) {
                    this.properties.append(' ');
                }
                this.properties.append(str);
            }
        }

        public void appendProperty(String key, String value) {
            this.append("-D" + key + "=" + value);
        }

        public String toString() {
            return this.properties.toString();
        }
    }
}

