/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.m2e.internal.launch.MavenLaunchDelegate;
import org.eclipse.m2e.internal.launch.Messages;

class BackgroundResourceRefresher
implements IDebugEventSetListener {
    final ILaunchConfiguration configuration;
    final IProcess process;
    final ILaunch launch;

    public BackgroundResourceRefresher(ILaunchConfiguration configuration, ILaunch launch) {
        this.configuration = configuration;
        this.process = launch.getProcesses()[0];
        this.launch = launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        IProcess iProcess = this.process;
        synchronized (iProcess) {
            if (this.process.isTerminated()) {
                this.processResources();
            } else {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() == this.process && event.getKind() == 8) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                this.processResources();
                break;
            }
            ++i;
        }
    }

    protected void processResources() {
        MavenLaunchDelegate.removeTempFiles(this.launch);
        Job job = new Job(Messages.MavenLaunchDelegate_job_name){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    RefreshTab.refreshResources((ILaunchConfiguration)BackgroundResourceRefresher.this.configuration, (IProgressMonitor)monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MavenLaunchDelegate.log.error(e.getMessage(), (Throwable)e);
                    return e.getStatus();
                }
            }
        };
        job.schedule();
    }
}

