/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lang.linescanner;

import org.eclipse.photran.internal.core.lang.linescanner.ILookaheadLineReader;

public final class StringLookaheadLineReader
implements ILookaheadLineReader<Error> {
    private final String string;
    private int start;
    private int index;

    public StringLookaheadLineReader(String string) {
        this.string = string;
        this.start = 0;
        this.index = 0;
    }

    @Override
    public String readNextLine() {
        if (this.index >= this.string.length()) {
            return null;
        }
        int nextLF = this.string.indexOf(10, this.index) + 1;
        if (nextLF <= 0) {
            nextLF = this.string.length();
        }
        String result = this.string.substring(this.index, nextLF);
        this.index = nextLF;
        return result;
    }

    @Override
    public String advanceAndRestart(int numChars) {
        String result = this.string.substring(this.start, numChars);
        this.start += numChars;
        this.index = this.start;
        return result;
    }

    @Override
    public void close() {
    }
}

