/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class LambdaMethod
extends SourceMethod {
    private int sourceStart;
    private String[] parameterNameStrings;
    private String returnTypeString;
    SourceMethodElementInfo elementInfo;
    private String key;

    public LambdaMethod(JavaElement parent, String name, String key, int sourceStart, String[] parameterTypes, String[] parameterNames, String returnType, SourceMethodElementInfo elementInfo) {
        super(parent, name, parameterTypes);
        this.sourceStart = sourceStart;
        this.parameterNameStrings = parameterNames;
        this.returnTypeString = returnType;
        this.elementInfo = elementInfo;
        this.key = key;
    }

    public static LambdaMethod make(JavaElement parent, org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int length = lambdaExpression.descriptor.parameters.length;
        String[] parameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            parameterTypes[i] = LambdaMethod.getTypeSignature(manager, lambdaExpression.descriptor.parameters[i]);
            ++i;
        }
        String[] parameterNames = new String[length];
        int i2 = 0;
        while (i2 < length) {
            parameterNames[i2] = manager.intern(new String(lambdaExpression.arguments[i2].name));
            ++i2;
        }
        String returnType = LambdaMethod.getTypeSignature(manager, lambdaExpression.descriptor.returnType);
        String selector = manager.intern(new String(lambdaExpression.descriptor.selector));
        String key = new String(lambdaExpression.descriptor.computeUniqueKey());
        LambdaMethod lambdaMethod = LambdaMethod.make(parent, selector, key, lambdaExpression.sourceStart, lambdaExpression.sourceEnd, lambdaExpression.arrowPosition, parameterTypes, parameterNames, returnType);
        length = lambdaExpression.arguments.length;
        ILocalVariable[] parameters = new ILocalVariable[length];
        int i3 = 0;
        while (i3 < length) {
            Argument argument = lambdaExpression.arguments[i3];
            String signature = manager.intern(new String(lambdaExpression.descriptor.parameters[i3].signature()));
            parameters[i3] = new LocalVariable(lambdaMethod, new String(argument.name), argument.declarationSourceStart, argument.declarationSourceEnd, argument.sourceStart, argument.sourceEnd, signature, null, argument.modifiers, true);
            ++i3;
        }
        lambdaMethod.elementInfo.arguments = parameters;
        return lambdaMethod;
    }

    public static LambdaMethod make(JavaElement parent, String selector, String key, int sourceStart, int sourceEnd, int arrowPosition, String[] parameterTypes, String[] parameterNames, String returnType) {
        SourceMethodInfo info = new SourceMethodInfo();
        info.setSourceRangeStart(sourceStart);
        info.setSourceRangeEnd(sourceEnd);
        info.setFlags(0);
        info.setNameSourceStart(sourceStart);
        info.setNameSourceEnd(arrowPosition);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int length = parameterNames.length;
        char[][] argumentNames = new char[length][];
        int i = 0;
        while (i < length) {
            argumentNames[i] = manager.intern(parameterNames[i].toCharArray());
            ++i;
        }
        info.setArgumentNames(argumentNames);
        info.setReturnType(manager.intern(Signature.toCharArray(returnType.toCharArray())));
        info.setExceptionTypeNames(CharOperation.NO_CHAR_CHAR);
        info.arguments = null;
        return new LambdaMethod(parent, selector, key, sourceStart, parameterTypes, parameterNames, returnType, info);
    }

    public static String getTypeSignature(JavaModelManager manager, TypeBinding type) {
        char[] signature = type.genericTypeSignature();
        signature = CharOperation.replaceOnCopy(signature, '/', '.');
        return manager.intern(new String(signature));
    }

    @Override
    public String getReturnType() throws JavaModelException {
        return this.returnTypeString;
    }

    @Override
    public String getSignature() throws JavaModelException {
        return Signature.createMethodSignature(this.parameterTypes, this.returnTypeString);
    }

    @Override
    public boolean isLambdaMethod() {
        return true;
    }

    @Override
    protected void closing(Object info) {
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LambdaMethod)) {
            return false;
        }
        LambdaMethod that = (LambdaMethod)o;
        return super.equals(o) && this.sourceStart == that.sourceStart;
    }

    @Override
    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        return this.elementInfo;
    }

    public void getHandleMemento(StringBuffer buff, boolean serializeParent) {
        if (serializeParent) {
            ((LambdaExpression)this.getParent()).getHandleMemento(buff, true, false);
        }
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
        buff.append('!');
        buff.append(this.parameterTypes.length);
        int i = 0;
        int length = this.parameterTypes.length;
        while (i < length) {
            this.appendEscapedDelimiter(buff, '\"');
            this.escapeMementoName(buff, this.parameterTypes[i]);
            this.appendEscapedDelimiter(buff, '\"');
            this.escapeMementoName(buff, this.parameterNameStrings[i]);
            ++i;
        }
        this.appendEscapedDelimiter(buff, '\"');
        this.escapeMementoName(buff, this.returnTypeString);
        this.appendEscapedDelimiter(buff, '\"');
        this.escapeMementoName(buff, this.key);
        ILocalVariable[] arguments = this.elementInfo.arguments;
        int i2 = 0;
        int length2 = arguments.length;
        while (i2 < length2) {
            LocalVariable local = (LocalVariable)arguments[i2];
            local.getHandleMemento(buff, false);
            ++i2;
        }
    }

    @Override
    public void getHandleMemento(StringBuffer buff) {
        this.getHandleMemento(buff, true);
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '&';
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(super.hashCode(), this.sourceStart);
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public JavaElement resolved(Binding binding) {
        return this;
    }
}

