/*
 * Decompiled with CFR 0.152.
 */
package bscs;

import bscs.ScriptConfigureDialog;
import bsh.EvalError;
import bsh.Interpreter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import practicallymacro.commands.IMacroScriptSupport;
import practicallymacro.util.MacroConsole;
import practicallymacro.util.Utilities;

public class ScriptingSupport
implements IMacroScriptSupport {
    public static final String ID = "bscs.scriptingSupport";
    public static final String DisplayID = "Beanshell Scripting";

    public String editScript(String script, Shell shell) {
        ScriptConfigureDialog dlg = new ScriptConfigureDialog(shell, script);
        if (dlg.open() == 0) {
            return dlg.getScript();
        }
        return script;
    }

    public boolean evaluate(String script, IEditorPart target) {
        if (script != null) {
            Interpreter executor = new Interpreter();
            try {
                executor.set("styledText", (Object)Utilities.getStyledText((IEditorPart)target));
                executor.set("findTarget", (Object)Utilities.getFindReplaceTarget((IEditorPart)target));
                executor.set("console", (Object)MacroConsole.getConsole());
                Object obj = executor.eval(script);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                return true;
            }
            catch (EvalError e) {
                e.printStackTrace();
                MacroConsole.getConsole().write((Exception)((Object)e));
            }
        }
        return false;
    }

    public String getID() {
        return ID;
    }

    public String getIDDisplayString() {
        return DisplayID;
    }
}

