/*
 * Decompiled with CFR 0.152.
 */
package bscs;

import beanshellscriptsupport.Activator;
import bscs.BeanShellSourceViewerConfiguration;
import bscs.BeanshellPartitionScanner;
import bscs.BeanshellScript;
import bscs.epl.DefaultDocumentAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptConfigureDialog
extends TrayDialog {
    private String mScript;
    private ProjectionViewer mTextViewer;
    private static final String UNDO_STACK_Key = "UndoStack";
    private static final String REDO_STACK_Key = "RedoStack";
    private static final String Stack_Edit_Key = "BeanShell_PerformingUndoRedoEdit";

    public ScriptConfigureDialog(Shell shell, String scriptData) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mScript = scriptData;
        this.setHelpAvailable(true);
        ScriptConfigureDialog.setDialogHelpAvailable((boolean)true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "Practicallymacro.BeanShellSupport.scriptHelp");
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit Script");
        Group g = new Group(parent, 0);
        g.setText("Script text");
        g.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 300;
        g.setLayoutData((Object)gd);
        if (this.mScript == null) {
            this.mScript = Activator.getDefault().getPreferenceStore().getDefaultString("PracticallyMacro_DefaultScriptConents");
        }
        this.mTextViewer = ScriptConfigureDialog.createEditorViewer((Composite)g);
        this.mTextViewer.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.mTextViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.mTextViewer.getDocument().set(this.mScript);
        return g;
    }

    public static ProjectionViewer createEditorViewer(Composite comp) {
        boolean showFolding = false;
        boolean showLineNumbers = true;
        boolean showAnnotations = true;
        IVerticalRuler ruler = ScriptConfigureDialog.createVerticalRuler(showFolding, showLineNumbers, showAnnotations);
        ProjectionViewer sourceViewer = new ProjectionViewer(comp, ruler, null, false, 2818);
        Document document = new Document();
        DefaultDocumentAdapter content = new DefaultDocumentAdapter();
        content.setDocument((IDocument)document);
        sourceViewer.setDocument((IDocument)document, (IAnnotationModel)new AnnotationModel());
        sourceViewer.getTextWidget().setContent((StyledTextContent)content);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new BeanshellPartitionScanner(), new String[]{"partition_beanshell_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        sourceViewer.configure((SourceViewerConfiguration)new BeanShellSourceViewerConfiguration(new BeanshellScript((IDocument)document)));
        final StyledText widget = sourceViewer.getTextWidget();
        final ArrayList undoStack = new ArrayList();
        final ArrayList redoStack = new ArrayList();
        widget.setData(UNDO_STACK_Key, undoStack);
        widget.setData(REDO_STACK_Key, redoStack);
        widget.setData(Stack_Edit_Key, (Object)Boolean.FALSE);
        widget.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                if ((Boolean)widget.getData(ScriptConfigureDialog.Stack_Edit_Key) == Boolean.TRUE) {
                    return;
                }
                redoStack.clear();
                String currText = widget.getText();
                ArrayList<AnEdit> edits = new ArrayList<AnEdit>();
                if (event.replacedText.length() > 0) {
                    edits.add(new DeleteEdit(event.start, event.replacedText));
                }
                if (event.length > 0) {
                    String newText = currText.substring(event.start, event.start + event.length);
                    edits.add(new InsertEdit(newText, event.start));
                }
                if (edits.size() > 0) {
                    if (edits.size() == 1) {
                        undoStack.add(0, (AnEdit)edits.get(0));
                    } else {
                        undoStack.add(0, new CompoundEdit(edits));
                    }
                }
            }
        });
        widget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isMod1;
                boolean bl = isMod1 = (e.stateMask & SWT.MOD1) > 0;
                if (!isMod1) {
                    return;
                }
                switch (e.keyCode) {
                    case 122: {
                        ScriptConfigureDialog.undo(undoStack, redoStack, widget);
                        break;
                    }
                    case 121: {
                        ScriptConfigureDialog.redo(undoStack, redoStack, widget);
                    }
                }
            }
        });
        sourceViewer.getTextWidget().setMenu(ScriptConfigureDialog.createStandardMenu(sourceViewer.getTextWidget()));
        return sourceViewer;
    }

    private static Menu createStandardMenu(final StyledText parent) {
        final List undoStack = (List)parent.getData(UNDO_STACK_Key);
        final List redoStack = (List)parent.getData(REDO_STACK_Key);
        Menu menu = new Menu((Control)parent);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Cut");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.cut();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Copy");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.copy();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Paste");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.paste();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Undo");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptConfigureDialog.undo(undoStack, redoStack, parent);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Redo");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptConfigureDialog.redo(undoStack, redoStack, parent);
            }
        });
        return menu;
    }

    private static IVerticalRuler createVerticalRuler(boolean showFolding, boolean showLineNumbers, boolean showAnnotations) {
        CompositeRuler ruler = new CompositeRuler();
        if (showLineNumbers) {
            LineNumberRulerColumn lineNumberColumn = new LineNumberRulerColumn();
            lineNumberColumn.setBackground(Display.getCurrent().getSystemColor(13));
            ruler.addDecorator(0, (IVerticalRulerColumn)lineNumberColumn);
        }
        return ruler;
    }

    protected void okPressed() {
        this.mScript = this.mTextViewer.getDocument().get();
        super.okPressed();
    }

    public String getScript() {
        return this.mScript;
    }

    private static void undo(List<AnEdit> undoStack, List<AnEdit> redoStack, StyledText styledText) {
        if (undoStack.size() > 0) {
            AnEdit lastEdit = undoStack.remove(0);
            styledText.setData(Stack_Edit_Key, (Object)Boolean.TRUE);
            lastEdit.performReverseEdit(styledText);
            styledText.setData(Stack_Edit_Key, (Object)Boolean.FALSE);
            redoStack.add(0, lastEdit);
        }
    }

    private static void redo(List<AnEdit> undoStack, List<AnEdit> redoStack, StyledText styledText) {
        if (redoStack.size() > 0) {
            AnEdit edit = redoStack.remove(0);
            styledText.setData(Stack_Edit_Key, (Object)Boolean.TRUE);
            edit.performEdit(styledText);
            styledText.setData(Stack_Edit_Key, (Object)Boolean.FALSE);
            undoStack.add(0, edit);
        }
    }

    private static interface AnEdit {
        public void performEdit(StyledText var1);

        public void performReverseEdit(StyledText var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundEdit
    implements AnEdit {
        List<AnEdit> mEdits;

        public CompoundEdit(List<AnEdit> edits) {
            this.mEdits = edits;
        }

        @Override
        public void performEdit(StyledText text) {
            for (AnEdit edit : this.mEdits) {
                edit.performEdit(text);
            }
        }

        @Override
        public void performReverseEdit(StyledText text) {
            int i = this.mEdits.size() - 1;
            while (i >= 0) {
                AnEdit edit = this.mEdits.get(i);
                edit.performReverseEdit(text);
                --i;
            }
        }
    }

    public static class DeleteEdit
    implements AnEdit {
        private int mOffset;
        private String mText;

        public DeleteEdit(int offset, String deletedText) {
            this.mOffset = offset;
            this.mText = deletedText;
        }

        public void performEdit(StyledText text) {
            text.replaceTextRange(this.mOffset, this.mText.length(), "");
            text.setCaretOffset(this.mOffset);
        }

        public void performReverseEdit(StyledText text) {
            text.replaceTextRange(this.mOffset, 0, this.mText);
            text.setCaretOffset(this.mOffset + this.mText.length());
        }
    }

    private static class InsertEdit
    implements AnEdit {
        private String mText;
        private int mOffset;

        public InsertEdit(String text, int offset) {
            this.mText = text;
            this.mOffset = offset;
        }

        public void performEdit(StyledText text) {
            text.replaceTextRange(this.mOffset, 0, this.mText);
            text.setCaretOffset(this.mOffset + this.mText.length());
        }

        public void performReverseEdit(StyledText text) {
            text.replaceTextRange(this.mOffset, this.mText.length(), "");
            text.setCaretOffset(this.mOffset);
        }
    }
}

