/*
 * Decompiled with CFR 0.152.
 */
package bscs;

import bscs.ColorConstants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements IColorManager {
    private static ColorManager mSingleton = null;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorManager instance() {
        Class<ColorManager> clazz = ColorManager.class;
        synchronized (ColorManager.class) {
            if (mSingleton == null) {
                mSingleton = new ColorManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mSingleton;
        }
    }

    public Color getColor(String key) {
        return this.getColor(ColorConstants.STRING);
    }
}

