/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.viewer;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.preferences.PreferenceValueConverter;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.ILogFileToolRule;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.RuleComparator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class DynamicRuleBasedScanner
implements ICharacterScanner,
ITokenScanner {
    private static final int UNDEFINED = -1;
    private IToken defaultToken;
    private IDocument document;
    private int offset;
    private int column;
    private int rangeEnd;
    private int tokenOffset;
    private char[][] delimiter;
    private List<ILogFileToolRule> rules;

    public DynamicRuleBasedScanner(String rulesPreferenceString) {
        LogViewerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new PropertyChangeListener());
        this.rules = new Vector<ILogFileToolRule>();
        this.loadRules(rulesPreferenceString);
        this.defaultToken = Token.UNDEFINED;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.offset = offset;
        this.column = -1;
        this.rangeEnd = Math.min(this.document.getLength(), offset + length);
        String[] delimiters = this.document.getLegalLineDelimiters();
        this.delimiter = new char[delimiters.length][];
        int i = 0;
        while (i < delimiters.length) {
            this.delimiter[i] = delimiters[i].toCharArray();
            ++i;
        }
    }

    public char[][] getLegalLineDelimiters() {
        return this.delimiter;
    }

    public int getColumn() {
        if (this.column == -1) {
            try {
                int line = this.document.getLineOfOffset(this.offset);
                int start = this.document.getLineOffset(line);
                this.column = this.offset - start;
            }
            catch (BadLocationException badLocationException) {}
        }
        return this.column;
    }

    /*
     * Unable to fully structure code
     */
    public int read() {
        try {
            if (this.offset < this.rangeEnd) {
                try {
                    var2_1 = this.document.getChar(this.offset);
                    return var2_1;
                }
                catch (BadLocationException v0) {
                    ** try [egrp 2[TRYBLOCK] [2 : 42->43)] { 
                }
            }
lbl8:
            // 3 sources

            return -1;
lbl-1000:
            // 1 sources

            {
                catch (Throwable var1_2) {
                    throw var1_2;
                }
            }
        }
        finally {
            ++this.offset;
            this.column = -1;
        }
    }

    public void unread() {
        --this.offset;
    }

    public IToken nextToken() {
        this.tokenOffset = this.offset;
        this.column = -1;
        Iterator<ILogFileToolRule> ruleIterator = this.rules.iterator();
        while (ruleIterator.hasNext()) {
            IRule rule = (IRule)ruleIterator.next();
            IToken token = rule.evaluate((ICharacterScanner)this);
            if (!token.isUndefined()) {
                return token;
            }
            if (!ruleIterator.hasNext()) continue;
            this.offset = this.tokenOffset;
        }
        if (this.rules.size() <= 0) {
            this.read();
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        this.unread();
        return this.defaultToken;
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        if (this.offset < this.rangeEnd) {
            return this.offset - this.getTokenOffset();
        }
        return this.rangeEnd - this.getTokenOffset();
    }

    private void loadRules(String newRules) {
        List<ILogFileToolRule> newRulesList = PreferenceValueConverter.asRuleArray(newRules);
        this.rules.clear();
        this.rules.addAll(newRulesList);
        Collections.sort(this.rules, new RuleComparator());
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("ITEM_COLORING")) {
                DynamicRuleBasedScanner.this.loadRules((String)event.getNewValue());
            }
        }
    }
}

